spool 04_users.log
set serveroutput on echo on feedback on

-- From Oracle Docs:
-- PASSWORD_REUSE_TIME and PASSWORD_REUSE_MAX 
-- If you specify an integer for either of these parameters and specify UNLIMITED for the other, then the user can never reuse a password.
-- The settings of this profile are required by the Oracle lockdown STIG.
CREATE PROFILE prof_default LIMIT
	FAILED_LOGIN_ATTEMPTS 3
	PASSWORD_LIFE_TIME 60
	PASSWORD_REUSE_TIME UNLIMITED
	PASSWORD_REUSE_MAX 5
	PASSWORD_LOCK_TIME UNLIMITED
	PASSWORD_GRACE_TIME 10
--	PASSWORD_VERIFY_FUNCTION custom_pwd_verifier
	;

CREATE USER HADB
	IDENTIFIED BY &p1
	DEFAULT TABLESPACE encrypted_harepo
	QUOTA UNLIMITED ON encrypted_harepo
  PROFILE prof_default;
GRANT role_app TO hadb;

CREATE USER VETEASDB
  	IDENTIFIED BY &p2
  	DEFAULT TABLESPACE veteasrepo
	QUOTA UNLIMITED on veteasrepo
	PROFILE prof_default;
GRANT role_app to VETEASDB;

CREATE USER VETAUTHDB
  	IDENTIFIED BY &p3
  	DEFAULT TABLESPACE encrypted_vetauthrepo
	QUOTA UNLIMITED on encrypted_vetauthrepo
	PROFILE prof_default;
GRANT role_app to VETAUTHDB;

CREATE USER STAFFEASDB
  	IDENTIFIED BY &p4
  	DEFAULT TABLESPACE staffeasrepo
	QUOTA UNLIMITED on staffeasrepo
	PROFILE prof_default;
GRANT role_app to STAFFEASDB;

CREATE USER STAFFAUTHDB
  	IDENTIFIED BY &p5
  	DEFAULT TABLESPACE encrypted_staffauthrepo
	QUOTA UNLIMITED on encrypted_staffauthrepo
	PROFILE prof_default;
GRANT role_app to STAFFAUTHDB;

spool off


