spool 03_roles.log
set serveroutput on echo on feedback on

-- ROLES for Each Database
CREATE ROLE role_read_only;
GRANT
	CREATE SESSION,
	SELECT ANY TABLE
TO role_read_only;

CREATE ROLE role_app;
GRANT
	CREATE SESSION,
	CREATE ANY TABLE,
	ALTER ANY TABLE,
	DROP ANY TABLE,
	LOCK ANY TABLE,
	INSERT ANY TABLE,
	UPDATE ANY TABLE,
	SELECT ANY TABLE,
	DELETE ANY TABLE
TO role_app;

-- Verification
select * from dba_roles where role in ('ROLE_APP', 'ROLE_READ_ONLY','ROLE_HEALTHADVOCATE_READONLY');

spool off 
