set serveroutput on echo on feedback on

-- Must run these as sys
CREATE OR REPLACE FUNCTION custom_pwd_verifier 
(	username varchar2, 
   new_password varchar2, 
   old_password varchar2) 
   RETURN boolean 
	
	IS
	
	i integer;
	j integer;
	m integer;
	password_length integer;
	differ integer;
	minimum_pwd_length integer;
	minimum_repeat_chars integer;
	minimum_symbol integer;
	minimum_lower integer;
	minimum_upper integer;
	minimum_numeric integer;
	symbol_chars_found integer;
	lower_chars_found integer;
	upper_chars_found integer;
	numeric_chars_found integer; 
	symbol_chars varchar2(25); 
	lower_chars varchar2(30);
	upper_chars varchar2(30);
	numeric_chars varchar2(10); 
	failed_pwd_message varchar2(600); -- extra space for edits

BEGIN
	symbol_chars := '@!"#$%&()``*+,-/:;<=>?_';
	lower_chars := 'abcdefghijklmnopqrstuvwxyz'; 
	upper_chars := 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'; 
	numeric_chars := '0123456789'; 
	
	minimum_pwd_length := 15;
	minimum_repeat_chars := 4;
	minimum_numeric := 1;
	minimum_symbol := 1;
	minimum_lower := 1;
	minimum_upper := 1; 
	failed_pwd_message := 'Failed Complexity Requirements: Passwords must be at least 15 characters long, contain at least one 
		numeric digit, one lower case character, one upper case character, and one symbol/punctuation character. It may not have 
		4 characters in the same position from your previous password.';
	password_length := length(new_password);
		

	-- Validate that it is not the username
	<<USERNAME_VALIDATION>>
	IF UPPER(new_password) = UPPER(username) THEN 
		raise_application_error(-20002, 'The password is the same as username. This is not allowed');
		RETURN(FALSE);
	END IF;

	-- validate length restrictions
	<<LENGTH_VALIDATION>>
	if length(new_password) < minimum_pwd_length then
		raise_application_error(-20002, 'Length Validation Failed. Passwords must be at least 15 characters');
		RETURN(FALSE);
	end if;

	-- Validate password is different by more than 4 characters (positionally)
	<<PWD_REPEAT_VALIDATION>>
	IF old_password is not null THEN
		differ := 0;
		IF length(new_password) <= length(old_password) THEN
			m := length(new_password); 
		ELSE
			m := length(old_password); 
		END IF;
		
		FOR i in 1..m LOOP
			IF substr(new_password,i,1) = substr(old_password,i,1) THEN
				differ := differ + 1;
			END IF; 
		END LOOP;

		IF differ >= 4 THEN
			raise_application_error(-20002, 'Password should differ by more than 4 characters');
			RETURN(FALSE);
		END IF;
	END IF;
	
	-- Looks good
	-- Validate minimum numeric character requirements
	<<NUMERIC_VALIDATION>>
	numeric_chars_found := 0; 
	FOR i IN 1..length(numeric_chars) LOOP  
		FOR j IN 1..password_length LOOP  
			IF substr(new_password,j,1) = substr(numeric_chars,i,1) THEN 
				numeric_chars_found := numeric_chars_found + 1;
			END IF; 
			IF numeric_chars_found = minimum_numeric THEN
				GOTO LOWER_VALIDATION;
			END IF;
		END LOOP; 
	END LOOP;
	
	IF numeric_chars_found < minimum_numeric THEN 
		raise_application_error(-20002, 'Numeric Validation Failed. Passwords must have at least 1 numeric character');
		RETURN(FALSE);
	END IF;
	
	-- Validate minimum lower-case character requirements
	<<LOWER_VALIDATION>>
	lower_chars_found := 0; 
	FOR i IN 1..length(lower_chars) LOOP  
		FOR j IN 1..password_length LOOP  
			IF substr(new_password,j,1) = substr(lower_chars,i,1) THEN 
				lower_chars_found := lower_chars_found + 1;
			END IF; 
			IF lower_chars_found = minimum_lower THEN
				GOTO UPPER_VALIDATION;
			END IF;
		END LOOP; 
	END LOOP;
	
	IF lower_chars_found < minimum_lower THEN 
		raise_application_error(-20002, 'Lowercase Validation Failed. Passwords must have at least 1 lowercase character');
		RETURN(FALSE);
	END IF;
	
	-- Good
	-- Validate minimum upper-case character requirements
	<<UPPER_VALIDATION>>
	upper_chars_found := 0; 
	FOR i IN 1..length(upper_chars) LOOP  
		FOR j IN 1..password_length LOOP  
			IF substr(new_password,j,1) = substr(upper_chars,i,1) THEN 
				upper_chars_found := upper_chars_found + 1;
			END IF; 
			IF upper_chars_found = minimum_upper THEN
				GOTO SYMBOL_VALIDATION;
			END IF;
		END LOOP; 
	END LOOP;
	
	IF upper_chars_found < minimum_upper THEN 
		raise_application_error(-20002, 'Uppercase Validation Failed. Passwords must have at least 1 uppercase character');
		RETURN(FALSE);
	END IF;
	
	-- Validate minimum symbol/punctuation character requirements
	<<SYMBOL_VALIDATION>>
	symbol_chars_found := 0; 
	FOR i IN 1..length(symbol_chars) LOOP  
		FOR j IN 1..password_length LOOP
			IF substr(new_password,j,1) = substr(symbol_chars,i,1) THEN 
				symbol_chars_found := symbol_chars_found + 1;
			END IF; 
			IF symbol_chars_found = minimum_symbol THEN
				GOTO END_CHAR_VALIDATION;
			END IF;
		END LOOP; 
	END LOOP;
	
	IF symbol_chars_found < minimum_symbol THEN 
		raise_application_error(-20002, 'Symbol Validation Failed. Passwords must have at least 1 symbol');
		RETURN(FALSE);
	END IF;
	
	<<END_CHAR_VALIDATION>>
	RETURN(TRUE);
END;
/

