/*
	Author: Ryan Morton
	Date: 08 Feb 2014
	Purpose: Update launchpad links for the release of new applications.
	Notes: The new version of Launchpad is now available in a new location. The application icons
		have also been relocated. This script will update the location of existing applications
	System Administration Notes: Run as 'system'
*/
spool release3_2_dbupdate.log
set serveroutput on echo on feedback on

--
-- Veteran App Links / Icons
--

-- Set Summary of Care link, icon to a new location
UPDATE HADB.LAUNCHPAD_ITEM 
	SET URL = '/summary-of-care', IMAGE_URL = 'img/app-icons/summary-of-care/apple-touch-icon-72x72-precomposed.png' 
WHERE NAME = 'Summary of Care';

-- Set MBB link, icon to a new location
UPDATE HADB.LAUNCHPAD_ITEM 
	SET URL = '/MobileHealthPlatformWeb/mbb', IMAGE_URL = 'img/app-icons/mbb/apple-touch-icon-72x72-precomposed.png' 
WHERE NAME = 'Mobile Blue Button';

-- Set Appointments link, icon to a new location
UPDATE HADB.LAUNCHPAD_ITEM 
	SET URL = '/MobileHealthPlatformWeb/appointments', IMAGE_URL = 'img/app-icons/appointments/apple-touch-icon-72x72-precomposed.png' 
WHERE NAME = 'Appointments';

--
-- Staff App Icons
--

-- Set Patient Viewer link, icon to a new location
UPDATE HADB.LAUNCHPAD_ITEM 
	SET URL = '/MobileHealthPlatformWeb/patient-viewer', IMAGE_URL = 'img/app-icons/patient-viewer/apple-touch-icon-72x72-precomposed.png' 
WHERE NAME = 'Patient Viewer';

-- Set Scheduling link, icon to a new location
UPDATE HADB.LAUNCHPAD_ITEM 
	SET URL = '/MobileHealthPlatformWeb/scheduling', IMAGE_URL = 'img/app-icons/scheduling/apple-touch-icon-72x72-precomposed.png' 
WHERE NAME = 'Scheduling';

commit;

spool off