# Oracle Lockdown

-- Example of creating a tablespace
CREATE TABLESPACE encrypted_ts
	DATAFILE '/u01/app/oracle/oradata/DB11G/encrypted_ts01.dbf' SIZE 128K
	AUTOEXTEND ON NEXT 64K
	ENCRYPTION USING 'AES256'
	DEFAULT STORAGE(ENCRYPT);

-- Create the Oracle Wallet at the defined location in the sqlnet.ora file
alter system set encryption key identified by “password”;

-- Review the existing tablespaces and show whether or not they are encrypted
SELECT tablespace_name, encrypted FROM dba_tablespaces;