-- List all sequences in the system
select * from user_sequences;

-- List all triggers in the system
select * from user_triggers;

-- List all roles in the system (must have permissions)
select * from dba_roles;

-- List all users in the system (permissions required)
select * from all_users;

-- Lock a user's account
alter user {username} ACCOUNT LOCK;

-- Unlock a user's account
ALTER USER {username} ACCOUNT UNLOCK;

-- Force a user to change their password
ALTER USER {username} PASSWORD EXPIRE;

-- Change a user's password
alter user {username} IDENTIFIED BY new_password;

-- List all profiles
select * from dba_profiles;

-- List all functions
SELECT * FROM ALL_OBJECTS WHERE OBJECT_TYPE IN ('FUNCTION')