--------------------------------------------------------
--  File created - Monday-March-19-2012   
--------------------------------------------------------
-- Unable to render TABLE DDL for object SMS.SMS_USER with DBMS_METADATA attempting internal generator.
COMMENT ON TABLE SMS.SMS_USER IS 'The SMSUser is an entity that can be used to represent any of the four types of end users of the SMS application.'ALTER TABLE SMS.SMS_USER
ADD CONSTRAINT SMS_USER_CLINICAL_USER_TY_FK1 FOREIGN KEY
(
  CLINICAL_USER_TYPE_ID 
)
REFERENCES SMS.CLINICAL_USER_TYPE
(
  CLINICAL_USER_TYPE_ID 
)
ENABLE
CREATE TABLE SMS.SMS_USER 
(
  USER_ID NUMBER DEFAULT NULL NOT NULL 
, FIRST_NAME VARCHAR2(50 BYTE) NOT NULL 
, LAST_NAME VARCHAR2(50 BYTE) NOT NULL 
, USER_TYPE VARCHAR2(30 BYTE) NOT NULL 
, STATUS NUMBER DEFAULT 0 NOT NULL 
, EMAIL_ADDRESS VARCHAR2(100 BYTE) 
, OPLOCK NUMBER DEFAULT 0 NOT NULL 
, ACTIVE NUMBER DEFAULT 1 NOT NULL 
, CREATED_DATE DATE DEFAULT SYSDATE NOT NULL 
, MODIFIED_DATE DATE DEFAULT SYSDATE NOT NULL 
, DOB DATE 
, ICN VARCHAR2(50 BYTE) 
, SSN VARCHAR2(15 BYTE) 
, STATION_NO VARCHAR2(10 BYTE) 
, DUZ VARCHAR2(20 BYTE) 
, EMAIL_NOTIFICATION NUMBER DEFAULT 0 NOT NULL 
, DEFAULT_MESSAGE_FILTER NUMBER DEFAULT 0 NOT NULL 
, LAST_EMAIL_NOTIFICATION DATE 
, NSSN VARCHAR2(5 CHAR) 
, PROVIDER NUMBER DEFAULT 0 NOT NULL 
, EXTERNAL_USER_NAME VARCHAR2(50 BYTE) 
, MIDDLE_NAME VARCHAR2(25 CHAR) 
, CLINICAL_USER_TYPE_ID NUMBER 
, RELATIONSHIP_UPDATE TIMESTAMP(6) 
, NATIONAL NUMBER DEFAULT 0 NOT NULL 
, CONSTRAINT SYS_C005616 PRIMARY KEY 
  (
    USER_ID 
  )
  ENABLE 
);
LOGGING 
TABLESPACE "SM_DATA_SYST" 
PCTFREE 10 
INITRANS 1 
STORAGE 
( 
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1 
  MAXEXTENTS 2147483645 
  BUFFER_POOL DEFAULT 
)CREATE INDEX SMS.SMS_USER_01_NUK ON SMS.SMS_USER (CLINICAL_USER_TYPE_ID ASC) 
LOGGING 
TABLESPACE "SM_INDX" 
PCTFREE 10 
INITRANS 2 
STORAGE 
( 
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1 
  MAXEXTENTS 2147483645 
  BUFFER_POOL DEFAULT 
)
CREATE INDEX SMS.SMS_USER_02_NUK ON SMS.SMS_USER (LOWER(LAST_NAME) ASC) 
LOGGING 
TABLESPACE "SM_INDX" 
PCTFREE 10 
INITRANS 2 
STORAGE 
( 
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1 
  MAXEXTENTS 2147483645 
  BUFFER_POOL DEFAULT 
)
CREATE INDEX SMS.SMS_USER_03_NUK ON SMS.SMS_USER (USER_TYPE ASC) 
LOGGING 
TABLESPACE "SM_INDX" 
PCTFREE 10 
INITRANS 2 
STORAGE 
( 
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1 
  MAXEXTENTS 2147483645 
  BUFFER_POOL DEFAULT 
)COMMENT ON COLUMN SMS.SMS_USER.USER_ID IS 'Uniquely identifies the SMSUser';
COMMENT ON COLUMN SMS.SMS_USER.FIRST_NAME IS 'The SMSUser''s first name';
COMMENT ON COLUMN SMS.SMS_USER.LAST_NAME IS 'The SMSUser''s last name';
COMMENT ON COLUMN SMS.SMS_USER.USER_TYPE IS 'One of the following values: patient, clinician, clinician triage, administrator';
COMMENT ON COLUMN SMS.SMS_USER.STATUS IS 'One of three values: opted in, opted out, blocked.';
COMMENT ON COLUMN SMS.SMS_USER.STATION_NO IS 'clinician vista station number';
COMMENT ON COLUMN SMS.SMS_USER.DUZ IS 'clinician vista duz';
COMMENT ON COLUMN SMS.SMS_USER.NATIONAL IS 'When the user is an administrator, indicates whether the user is a national administrator (1) or not (0).';ALTER TABLE SMS.SMS_USER
ADD CONSTRAINT SMS_USER_UK1 UNIQUE 
(
  STATION_NO 
, DUZ 
)
ENABLE
REM INSERTING into SMS.SMS_USER
SET DEFINE OFF;
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (21519,'GENEVA','SAMPLE','1',1,'Anna.Sample@domain',6,0,to_date('22-SEP-09','DD-MON-RR'),to_date('22-SEP-09','DD-MON-RR'),null,null,null,'989','16856',0,0,null,null,1,'VHALINSAMPLA',null,1,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (21766,'TESTAN','MHVSYSTESTAN','0',1,'doug.mcdonald@aquilent.com',24,1,to_date('24-SEP-09','DD-MON-RR'),to_date('24-SEP-09','DD-MON-RR'),to_date('14-MAR-30','DD-MON-RR'),'1011186068V411329','333330114',null,null,0,0,null,'M0114',0,'mhvsystestan',null,null,to_timestamp('08-NOV-10 02.19.22.339000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (22851,'JULIE','JETER','1',1,'Joseph.Jeter@domain',9,0,to_date('29-SEP-09','DD-MON-RR'),to_date('29-SEP-09','DD-MON-RR'),null,null,null,'989','35246',0,0,null,null,0,'VHAWNYJETERJ',null,3,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (24237,'    ','Shope','2',0,null,1,1,to_date('02-FEB-10','DD-MON-RR'),to_date('02-FEB-10','DD-MON-RR'),null,null,null,null,null,0,0,null,null,0,'servershopel',null,null,null,1);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (25242,'MICHAEL','KEEVICAN','1',1,'Michael.Keevican@domain',7,1,to_date('25-FEB-10','DD-MON-RR'),to_date('25-FEB-10','DD-MON-RR'),null,null,null,'979','59839',1,0,to_date('02-JUN-10','DD-MON-RR'),null,0,'serverkeevim',null,2,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (28854,'Srinivasa','Mudireddy','2',0,null,1,1,to_date('04-JUN-10','DD-MON-RR'),to_date('04-JUN-10','DD-MON-RR'),null,null,null,null,null,0,0,null,null,0,'servermudirs',null,null,null,1);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (28892,'Null','MHVSYSTEST','0',0,'Johnnie.boyette@domain',19,1,to_date('10-JUN-10','DD-MON-RR'),to_date('10-JUN-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011218479V397738','708020007',null,null,2,0,to_date('10-JUN-10','DD-MON-RR'),'M0007',0,'mpisynch0118',null,null,to_timestamp('01-JUL-10 07.32.56.513000000 AM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31394,'Prospero','MHVDMWRPNEU','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('18-JUN-50','DD-MON-RR'),'1011218026V872017','721603012',null,null,0,0,null,'M3012',0,'dougtestwr12',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31396,'systest','mhvdsystest','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('14-MAY-80','DD-MON-RR'),'1012581393V253576','705071235',null,null,0,0,null,'M1235',0,'testersyst1',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31398,'DONITA','MHVDTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011165679V820616','411000001',null,null,0,0,null,'M0001',0,'donitatestd',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31400,'test','mhvgendertest','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('05-JUN-15','DD-MON-RR'),'1011230902V946015','705060059',null,null,0,0,null,'M0059',0,'gendertest1',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31402,'test','mhvgendertestb','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('29-SEP-60','DD-MON-RR'),'1011230867V325199','706060061',null,null,0,0,null,'M0061',0,'gendertest3',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31404,'test','mhvgenderteste','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('22-SEP-23','DD-MON-RR'),'1011230879V286669','706060069',null,null,0,0,null,'M0069',0,'gendertest5',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31406,'DSlogeleven','MHVIntCeleven','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-71','DD-MON-RR'),'1012585548V580257','705597876',null,null,0,0,null,'M7876',0,'mhvintc11',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31408,'DSlogthirteen','MHVIntCthirteen','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-94','DD-MON-RR'),'1012585549V292012','705597878',null,null,0,0,null,'M7878',0,'mhvintc13',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31410,'JULIE','MHVJETERONE','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-50','DD-MON-RR'),'1011195152V199401','728444444',null,null,0,0,null,'M4444',0,'julieone',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31412,'JOHNAA','MHVJOHNTESTAA','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-40','DD-MON-RR'),'1011230925V837493','727010001',null,null,0,0,null,'M0001',0,'johntest01',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31414,'test','mhvjtesta','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('03-NOV-68','DD-MON-RR'),'1011231135V894503','705070001',null,null,0,0,null,'M0001',0,'jtesta',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31416,'TESTCC','MHVJTESTAA','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('03-SEP-46','DD-MON-RR'),'1011231944V828149','705070069',null,null,0,0,null,'M0069',0,'testeraa',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31418,'testcal','mhvjtestcal','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('11-AUG-80','DD-MON-RR'),'1011231489V788424','705070026',null,null,0,0,null,'M0026',0,'testercal1',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31420,'TESTER','MHVJTESTER','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('04-JAN-69','DD-MON-RR'),'1011231758V800784','705070042',null,null,0,0,null,'M0042',0,'tester2a',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31422,'testg','mhvjtestg','0',0,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('26-JUN-52','DD-MON-RR'),'1011231191V324672','705070007',null,null,0,0,null,'M0007',0,'testerg',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31424,'testh','mhvjtesth','0',1,null,22,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('18-DEC-46','DD-MON-RR'),'1011231297V466949','705070010',null,null,0,0,null,'m0010',0,'testerh',null,null,to_timestamp('04-OCT-11 09.27.21.514000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31426,'testia','mhvjtestia','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('21-OCT-60','DD-MON-RR'),'1011231757V945899','705070041',null,null,0,0,null,'M0041',0,'testeria',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31428,'TESTK','MHVJTESTK','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('30-MAY-68','DD-MON-RR'),'1011231638V652846','705070031',null,null,0,0,null,'M0031',0,'testerk',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31430,'TESTR','MHVJTESTR','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('13-OCT-50','DD-MON-RR'),'1011231759V582636','705070044',null,null,0,0,null,'M0044',0,'tester1r',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31432,'TESTS','MHVJTESTS','0',3,'johncat@aol.com',4,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('09-SEP-77','DD-MON-RR'),'1011231763V168503','705070046',null,null,0,0,null,'M0046',0,'testers',null,null,to_timestamp('04-FEB-11 02.55.05.149000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31434,'testz','mhvjtestz','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('28-AUG-52','DD-MON-RR'),'1011231825V389961','705070049',null,null,0,0,null,'M0049',0,'testerz',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31436,'TEST','MHVKAMAL','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('28-JAN-38','DD-MON-RR'),'1012585709V036528','333445555',null,null,0,0,null,'M5555',0,'mhvkamaltest',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31438,'Hal','MHVMPILOGCALL','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('20-JUN-27','DD-MON-RR'),'1011192786V532490','100113403',null,null,0,0,null,'M3403',0,'mpilogcall1',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31440,'BRENDAS','MHVMPISYNCHA','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-APR-45','DD-MON-RR'),'1011194330V455431','120012345',null,null,0,0,null,'M2345',0,'mpisyncha1',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31442,'Brenda','MHVMPISYNCHAA','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('21-NOV-22','DD-MON-RR'),'1011231841V853669','100168366',null,null,0,0,null,'M8366',0,'mpisyncha2',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31444,'LARRY','MHVMPISYNCHAA','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('03-MAR-54','DD-MON-RR'),'1011194378V410581','100085827',null,null,0,0,null,'M5827',0,'mpisynchaa',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31446,'DEAN','MHVMPISYNCHAB','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('28-JUL-30','DD-MON-RR'),'1011195128V366619','100076109',null,null,0,0,null,'M6109',0,'mpisynchab',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31448,'ASHTON','MHVMPISYNCHAC','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('16-DEC-36','DD-MON-RR'),'1011195125V225932','100071305',null,null,0,0,null,'M1305',0,'mpisynchac',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31450,'JERRY','MHVMPISYNCHAD','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('03-AUG-30','DD-MON-RR'),'1011195131V672555','100075487',null,null,0,0,null,'M5487',0,'mpisynchad',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31452,'SAM','MHVMPISYNCHAE','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('18-MAY-25','DD-MON-RR'),'1011195132V746917','100103543',null,null,0,0,null,'M3543',0,'mpisynchae',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31454,'JIM','MHVMPISYNCHAF','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('19-NOV-73','DD-MON-RR'),'1011225634V874452','100083973',null,null,0,0,null,'M3973',0,'mpisynchaf',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31456,'AXEL','MHVMPISYNCHAG','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('27-JUL-41','DD-MON-RR'),'1011225635V543311','100095274',null,null,0,0,null,'M5274',0,'mpisynchag',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31458,'RANDY','MHVMPISYNCHAH','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('20-JUL-62','DD-MON-RR'),'1011225633V916167','100033091',null,null,0,0,null,'M3091',0,'mpisynchah',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31460,'WINSTON','MHVMPISYNCHAI','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('29-APR-42','DD-MON-RR'),'1011225639V327946','100346189',null,null,0,0,null,'M6189',0,'mpisynchai',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31462,'BRAD','MHVMPISYNCHAJ','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('22-SEP-33','DD-MON-RR'),'1011225638V191524','100099053',null,null,0,0,null,'M9053',0,'mpisynchaj',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31464,'NEO','MHVMPISYNCHAK','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('28-MAR-18','DD-MON-RR'),'1011225636V209270','100059432',null,null,0,0,null,'M9432',0,'mpisynchak',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31466,'QUINN','MHVMPISYNCHAL','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('13-APR-22','DD-MON-RR'),'1011225637V088009','100158647',null,null,0,0,null,'M8647',0,'mpisynchal',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31468,'Hill','MHVMPISYNCHAM','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-SEP-44','DD-MON-RR'),'1011225640V361204','100079692',null,null,0,0,null,'M9692',0,'mpisyncham',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31470,'MATT','MHVMPISYNCHB','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('22-OCT-32','DD-MON-RR'),'1011194331V630360','100063888',null,null,0,0,null,'M3888',0,'mpisynchb2',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31472,'ROGER','MHVMPISYNCHBB','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('08-NOV-22','DD-MON-RR'),'1011194379V672930','100059852',null,null,0,0,null,'M9852',0,'mpisynchbb',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31474,'BRIAN','MHVMPISYNCHC','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('26-MAR-14','DD-MON-RR'),'1011194332V762259','100090624',null,null,0,0,null,'M0624',0,'mpisynchc3',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31476,'JANE','MHVMPISYNCHCC','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('29-AUG-33','DD-MON-RR'),'1011194384V691829','100094821',null,null,0,0,null,'M4821',0,'mpisynchcc',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31478,'RICK','MHVMPISYNCHDD','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('21-JAN-58','DD-MON-RR'),'1011194382V309571','100073074',null,null,0,0,null,'M3074',0,'mpisynchdd',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31480,'HENRY','MHVMPISYNCHE','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('13-JUL-30','DD-MON-RR'),'1011194342V675982','100054979',null,null,0,0,null,'M4979',0,'mpisynche5',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31482,'REX','MHVMPISYNCHEE','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('18-DEC-54','DD-MON-RR'),'1011194383V488900','100092693',null,null,0,0,null,'M2693',0,'mpisynchee',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31484,'HANK','MHVMPISYNCHF','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('02-JUN-18','DD-MON-RR'),'1011194340V361045','100021351',null,null,0,0,null,'M1351',0,'mpisynchf6',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31486,'LEON','MHVMPISYNCHFF','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('17-APR-72','DD-MON-RR'),'1011194387V830188','100102263',null,null,0,0,null,'M2263',0,'mpisynchff',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31488,'BEN','MHVMPISYNCHG','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('23-APR-18','DD-MON-RR'),'1011194341V417597','100086921',null,null,0,0,null,'M6921',0,'mpisynchg7',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31815,'MANNY','MHVSYS','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-10','DD-MON-RR'),'1012580995V691029','708020210',null,null,0,0,null,'M0210',0,'mpisynch0321',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31817,'MELTON','MHVSYS','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-10','DD-MON-RR'),'1012580982V606149','708020198',null,null,0,0,null,'M0198',0,'mpisynch0313',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31819,'MONA','MHVSYS','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-99','DD-MON-RR'),'1011219015V643898','708020116',null,null,0,0,null,'M0116',0,'mpisynch0196',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31821,'NINA','MHVSYS','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-99','DD-MON-RR'),'1011219017V988635','708020118',null,null,0,0,null,'M0118',0,'mpisynch0197',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (15614,'JOHN','MHVSMITHY','0',2,'douglas.mcdonald@domain',7,1,to_date('08-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),to_date('18-JUN-60','DD-MON-RR'),'1011230107V042431','767221234',null,null,0,0,null,'M1234',0,'dougtest021',null,null,to_timestamp('21-MAY-09 03.27.01.853000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (15619,'JOHN','MHVSMITHY','0',1,'douglas.mcdonald@domain',6,1,to_date('08-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),to_date('01-JAN-50','DD-MON-RR'),'1011230108V106360','767559876',null,null,0,0,null,'M9876',0,'dougtest022',null,null,to_timestamp('21-MAY-09 03.29.57.559000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (13459,'JILL','RESIDES','1',1,'Jill.Resides@domain',1,0,to_date('22-APR-09','DD-MON-RR'),to_date('22-APR-09','DD-MON-RR'),null,null,null,'989','1017',0,0,null,null,0,'VHADAYRESIDJ',null,2,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (13460,'LINDA','REUBER','1',1,'Linda.Reuber@domain',1,0,to_date('22-APR-09','DD-MON-RR'),to_date('22-APR-09','DD-MON-RR'),null,null,null,'989','1307',0,0,null,null,0,'VHADAYREUBEL',null,3,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (13461,'UserFSeven','UserLSeven','1',1,'foo@foo.com',31,1,to_date('22-APR-09','DD-MON-RR'),to_date('22-APR-09','DD-MON-RR'),null,null,null,'989','13907',0,0,null,null,0,'VHADAYHEATHE',null,2,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (13481,'UserFEight','UserLEight','1',1,'foo@foo.com',39,1,to_date('22-APR-09','DD-MON-RR'),to_date('22-APR-09','DD-MON-RR'),null,null,null,'989','12353',0,0,null,null,0,'VHADAYJENKIR',null,3,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (14379,'MARY','SCHMITT','1',1,'Mary.Schmitt@domain',1,0,to_date('28-APR-09','DD-MON-RR'),to_date('28-APR-09','DD-MON-RR'),null,null,null,'989','24183',0,0,null,null,1,'VHADAYSCHMM1',null,3,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (14380,'RICHARD','DEAKIN','1',1,'Richard.Deakin@domain',1,0,to_date('28-APR-09','DD-MON-RR'),to_date('28-APR-09','DD-MON-RR'),null,null,null,'989','32577',0,0,null,null,0,'VHAPTHDeakiR',null,1,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (14511,'LIANA','BUCIUMAN-COMAN','1',1,'Liana.Buciuman-Coman@domain',5,1,to_date('30-APR-09','DD-MON-RR'),to_date('30-APR-09','DD-MON-RR'),null,null,null,'979','59788',0,0,null,null,0,'serverbuciul',null,3,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (14675,'ANTHONY','PREMATTA','1',1,'anthony.prematta@domain',61,1,to_date('04-MAY-09','DD-MON-RR'),to_date('04-MAY-09','DD-MON-RR'),null,null,null,'979','59817',1,0,to_date('29-OCT-10','DD-MON-RR'),null,1,'serverpremaa',null,1,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (14676,'SWETHA','BALASUBRAMANIAN','1',0,'Swethambara.Balasubramanian@domain',31,0,to_date('04-MAY-09','DD-MON-RR'),to_date('04-MAY-09','DD-MON-RR'),null,null,null,'989','35244',0,0,null,null,0,'abcxyz',null,1,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (14697,'MASTAN','KETHA','1',1,'Mastan.Ketha@domain',26,1,to_date('04-MAY-09','DD-MON-RR'),to_date('04-MAY-09','DD-MON-RR'),null,null,null,'979','59802',0,0,null,null,0,'VHAISWKETHAM',null,2,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (14698,'DONITA','SEARCY','1',1,'Donita.Searcy@domain',71,1,to_date('04-MAY-09','DD-MON-RR'),to_date('04-MAY-09','DD-MON-RR'),null,null,null,'979','59823',1,0,to_date('20-OCT-10','DD-MON-RR'),null,1,'serversearcd',null,1,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (14699,'DOUGLAS','MCDONALD','1',1,'Douglas.Mcdonald@domain',67,0,to_date('04-MAY-09','DD-MON-RR'),to_date('04-MAY-09','DD-MON-RR'),null,null,null,'989','35231',2,0,to_date('08-FEB-11','DD-MON-RR'),null,1,'servermcdond',null,1,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (15086,'Aruna','Pamulapati','2',0,null,4,1,to_date('06-MAY-09','DD-MON-RR'),to_date('06-MAY-09','DD-MON-RR'),null,null,null,null,null,0,0,null,null,0,'serverpamula',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (15088,'Rajesh','Manivasagam','2',0,'test@abc.com',86,1,to_date('06-MAY-09','DD-MON-RR'),to_date('06-MAY-09','DD-MON-RR'),null,null,null,null,null,0,0,null,null,0,'servermanivr123',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (16006,'UserFNine','UserLNine','1',0,'Sandra.Baccus@domain',16,1,to_date('11-MAY-09','DD-MON-RR'),to_date('11-MAY-09','DD-MON-RR'),null,null,null,'989','13345',0,0,null,null,0,'VHADAYBACCUS',null,2,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (16008,'UserFTen','UserLTen','1',0,'Erma.Haggerty@domain',6,1,to_date('11-MAY-09','DD-MON-RR'),to_date('11-MAY-09','DD-MON-RR'),null,null,null,'989','1068',0,0,null,null,0,'VHADAYHAGGEE',null,2,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (16990,'UserFEleven','UserLEleven','1',0,'adsadasdasd@b.com',1,1,to_date('20-MAY-09','DD-MON-RR'),to_date('20-MAY-09','DD-MON-RR'),null,null,null,'989','25761',0,0,null,null,1,'VHASDCQAZIM',null,3,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (18134,'TESTDJ','MHVSYSTESTDJ','0',1,null,4,1,to_date('07-JUL-09','DD-MON-RR'),to_date('07-JUL-09','DD-MON-RR'),to_date('18-JUN-60','DD-MON-RR'),'1011214235V222571','721602210',null,null,0,0,null,'M2210',0,'dougtestdj',null,null,to_timestamp('07-JUL-09 02.54.24.044000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (8,'Richard','Maley','0',1,'Joseph.Schmidt@domain',5,1,to_date('23-APR-08','DD-MON-RR'),to_date('23-APR-08','DD-MON-RR'),to_date('21-APR-47','DD-MON-RR'),'1947568937785920','194756893','658','194756893',1,0,to_date('07-AUG-08','DD-MON-RR'),'M6893',0,'Maley',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (18,'Richard','Maleyc','1',1,'Joseph.Schmidt@domain',5,1,to_date('23-APR-08','DD-MON-RR'),to_date('23-APR-08','DD-MON-RR'),to_date('21-APR-47','DD-MON-RR'),null,'194756893','658','1947568937785920',1,0,to_date('07-AUG-08','DD-MON-RR'),'M6893',1,'Maleyc',null,2,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (1,'SM','Mhvsyst','1',1,'douglas.mcdonald@domain',5,1,to_date('24-APR-08','DD-MON-RR'),to_date('24-APR-08','DD-MON-RR'),to_date('21-APR-47','DD-MON-RR'),null,'947568931','658','1947568937785928',1,0,to_date('07-AUG-08','DD-MON-RR'),'M8931',1,'Mhvsyst',null,2,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (24,'testMIKE','testMHVSMDOCONE','1',1,'foo@foo.com',170,0,to_date('01-MAY-08','DD-MON-RR'),to_date('01-MAY-08','DD-MON-RR'),to_date('18-JUN-60','DD-MON-RR'),null,'1721607616','999','135251',0,0,to_date('30-MAY-08','DD-MON-RR'),'M1761',1,'testmhvsmdocone',null,1,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (29,'ALYSSA','MHVSMONE','0',1,'johnnie.boyette@domain',631,1,to_date('01-MAY-08','DD-MON-RR'),to_date('01-MAY-08','DD-MON-RR'),to_date('18-JUN-60','DD-MON-RR'),'1011214436V509639','721607601','989','721607601',1,0,to_date('25-MAY-11','DD-MON-RR'),'M7601',0,'secure01',null,null,to_timestamp('25-MAY-11 10.13.25.383000000 AM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (47,'BRIANNA','MHVSMTWO','0',1,'johnnie.boyette@domain',236,1,to_date('01-MAY-08','DD-MON-RR'),to_date('01-MAY-08','DD-MON-RR'),to_date('18-JUN-60','DD-MON-RR'),'1011214435V843780','721607602','989','721607602',2,0,to_date('09-MAR-10','DD-MON-RR'),'M7602',0,'secure02',null,null,to_timestamp('07-OCT-10 10.28.43.985000000 AM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (49,'CHLOE','MHVSMTHREE','0',1,null,95,1,to_date('01-MAY-08','DD-MON-RR'),to_date('01-MAY-08','DD-MON-RR'),to_date('18-JUN-60','DD-MON-RR'),'1011214437V288164','721607603','989','721607603',0,0,null,'M7603',0,'secure03',null,null,to_timestamp('21-SEP-09 12.00.19.598000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (51,'OLIVIA','MHVSMFOUR','0',1,null,710,1,to_date('01-MAY-08','DD-MON-RR'),to_date('01-MAY-08','DD-MON-RR'),to_date('18-JUN-60','DD-MON-RR'),'1011214434V974891','721607604','989','721607604',0,0,to_date('05-MAR-09','DD-MON-RR'),'M7604',0,'ZZtemp_secure04',null,null,to_timestamp('09-MAR-11 09.35.53.669000000 AM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (53,'EMMA','MHVSMFIVE','0',1,'walter.fatzinger@domain',606,1,to_date('01-MAY-08','DD-MON-RR'),to_date('01-MAY-08','DD-MON-RR'),to_date('18-JUN-60','DD-MON-RR'),'1011214438V091456','721607605','989','721607605',1,0,to_date('07-MAR-12','DD-MON-RR'),'M7605',0,'secure05',null,null,to_timestamp('28-DEC-11 10.12.01.921000000 AM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (55,'Alice','mhvsmsix','0',1,'       .Prematta@domain',66,1,to_date('01-MAY-08','DD-MON-RR'),to_date('01-MAY-08','DD-MON-RR'),to_date('18-JUN-60','DD-MON-RR'),'1011214442V175356','721607606','989','721607606',1,0,to_date('24-FEB-10','DD-MON-RR'),'M7606',0,'mhvsmsix',null,null,to_timestamp('24-FEB-10 11.06.40.931000000 AM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (57,'BERTHA','MHVSMSEVEN','0',1,'test@test.com',503,1,to_date('01-MAY-08','DD-MON-RR'),to_date('01-MAY-08','DD-MON-RR'),to_date('18-JUN-60','DD-MON-RR'),'1011214439V127318','721607607','979','721607607',0,0,to_date('15-OCT-09','DD-MON-RR'),'M7607',0,'secure07',null,null,to_timestamp('23-FEB-10 01.16.03.223000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (59,'CLARA','MHVSMEIGHT','0',1,'       .Prematta@domain',10,1,to_date('01-MAY-08','DD-MON-RR'),to_date('01-MAY-08','DD-MON-RR'),to_date('18-JUN-60','DD-MON-RR'),'1011214443V340218','721607608','989','721607608',1,0,to_date('21-JUL-09','DD-MON-RR'),'M7608',0,'secure08',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (61,'MABEL','MHVSMNINE','0',1,'johnnie.boyette@domain',539,1,to_date('01-MAY-08','DD-MON-RR'),to_date('01-MAY-08','DD-MON-RR'),to_date('18-JUN-60','DD-MON-RR'),'1011214440V261139','721607609','979','721607609',0,0,to_date('27-MAR-09','DD-MON-RR'),'M7609',0,'secure09',null,null,to_timestamp('02-JUN-10 02.39.30.705000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (63,'EDNA','MHVSMTEN','0',1,'       .Prematta@domain',9,1,to_date('01-MAY-08','DD-MON-RR'),to_date('01-MAY-08','DD-MON-RR'),to_date('18-JUN-60','DD-MON-RR'),'1011214445V686505','721607610','979','721607610',1,0,to_date('08-MAY-09','DD-MON-RR'),'M7610',0,'secure10',null,null,to_timestamp('12-MAR-09 01.04.53.714000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (65,'JOHN','MHVSMELEVEN','0',1,'    .Hall4@domain',82,1,to_date('01-MAY-08','DD-MON-RR'),to_date('01-MAY-08','DD-MON-RR'),to_date('18-JUN-60','DD-MON-RR'),'1011214441V017464','721607611','979','721607611',1,0,to_date('02-MAR-10','DD-MON-RR'),'M7611',0,'secure11',null,null,to_timestamp('15-JUN-10 09.50.38.863000000 AM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (67,'    ','mhvsmtwelve','0',1,'       .Prematta@domain',5,1,to_date('01-MAY-08','DD-MON-RR'),to_date('01-MAY-08','DD-MON-RR'),to_date('18-JUN-60','DD-MON-RR'),'1011214446V794927','721607612','979','721607612',1,0,to_date('08-MAY-09','DD-MON-RR'),'m7612',0,'secure12',null,null,to_timestamp('18-APR-11 12.09.22.681000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (69,'GEORGE','MHVSMTHIRTEEN','0',1,'    .Hall4@domain',67,1,to_date('01-MAY-08','DD-MON-RR'),to_date('01-MAY-08','DD-MON-RR'),to_date('18-JUN-60','DD-MON-RR'),'1011214432V662527','721607613','989','721607613',1,0,to_date('02-MAR-10','DD-MON-RR'),'M7613',0,'secure13',null,null,to_timestamp('15-SEP-10 05.19.33.557000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (71,'RINGO','MHVSMFOURTEEN','0',1,'    .Hall4@domain',264,1,to_date('01-MAY-08','DD-MON-RR'),to_date('01-MAY-08','DD-MON-RR'),to_date('18-JUN-60','DD-MON-RR'),'1011214496V822195','721607614','979','721607614',2,0,to_date('25-MAY-11','DD-MON-RR'),'M7614',0,'secure14',null,null,to_timestamp('01-OCT-10 12.02.18.887000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (73,'YOKO','MHVSMFIFTEEN','0',1,'Lhall309@verizon.net',571,1,to_date('01-MAY-08','DD-MON-RR'),to_date('01-MAY-08','DD-MON-RR'),to_date('18-JUN-60','DD-MON-RR'),'1011214431V430005','721607615','989','721607615',0,0,to_date('01-MAR-10','DD-MON-RR'),'M7615',0,'secure15',null,null,to_timestamp('25-MAY-11 10.14.44.290000000 AM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (76,'TESTTESTTESTGREG','TESTMHVSMDOCTWO','1',1,'foo@foo.com',204,1,to_date('01-MAY-08','DD-MON-RR'),to_date('01-MAY-08','DD-MON-RR'),to_date('18-JUN-60','DD-MON-RR'),null,'721607617','989','35252',0,0,null,'M7617',1,'TESTGMHVSMDOCTWO',null,1,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (79,'TESTTESTPETER','TESTMHVSMDOCTHREE','1',1,'foo@foo.com',691,1,to_date('01-MAY-08','DD-MON-RR'),to_date('01-MAY-08','DD-MON-RR'),to_date('18-JUN-60','DD-MON-RR'),null,'721607618','989','35253',1,2,to_date('07-MAR-12','DD-MON-RR'),'M7618',1,'TESTPMHVSMDOCTHREE',null,1,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (80,'TESTTESTBOBBIE','TESTMHVSMDOCFOUR','1',1,'foo@foo.com',35,0,to_date('01-MAY-08','DD-MON-RR'),to_date('01-MAY-08','DD-MON-RR'),to_date('18-JUN-60','DD-MON-RR'),null,'721607619','979','59824',0,0,null,'M7619',1,'TESTBMHVSMDOCFOUR',null,1,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (81,'TESTTESTSAM','TESTMHVSMDOCFIVE','1',0,'foo@foo.com',72,0,to_date('01-MAY-08','DD-MON-RR'),to_date('01-MAY-08','DD-MON-RR'),to_date('18-JUN-60','DD-MON-RR'),null,'721607620','979','59825',1,0,to_date('28-JUL-08','DD-MON-RR'),'M7620',1,'TESTSMHVSMDOCFIVE',null,1,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (82,'TESTTESTCAROL','TESTMHVSMSTAFFONE','1',1,'foo@foo.com',47,1,to_date('01-MAY-08','DD-MON-RR'),to_date('01-MAY-08','DD-MON-RR'),to_date('18-JUN-60','DD-MON-RR'),null,'721607621','979','59826',0,0,to_date('16-JUN-08','DD-MON-RR'),'M7621',0,'TESTCMHVSMSTAFFONE',null,3,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (83,'TESTTESTMARSHA','TESTMHVSMSTAFFTWO','1',1,'johnnie.boyette@domain',53,1,to_date('01-MAY-08','DD-MON-RR'),to_date('01-MAY-08','DD-MON-RR'),to_date('18-JUN-60','DD-MON-RR'),null,'721607622','979','59827',3,0,to_date('30-SEP-11','DD-MON-RR'),'M7622',0,'TESTMMHVSMSTAFFTWO',null,3,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (84,'TESTTESTJAN','TESTMHVSMSTAFFTHREE','1',1,'foo@foo.com',540,1,to_date('01-MAY-08','DD-MON-RR'),to_date('01-MAY-08','DD-MON-RR'),to_date('18-JUN-60','DD-MON-RR'),null,'721607623','989','35254',1,0,to_date('04-OCT-10','DD-MON-RR'),'M7623',0,'TESTJMHVSMSTAFFTHREE',null,3,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (85,'TESTTESTCINDY','TESTMHVSMSTAFFFOUR','1',1,'foo@foo.com',47,1,to_date('01-MAY-08','DD-MON-RR'),to_date('01-MAY-08','DD-MON-RR'),to_date('18-JUN-60','DD-MON-RR'),null,'721607624','989','35255',0,0,null,'M7624',0,'TESTCMHVSMSTAFFFOUR',null,3,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (86,'ALICE','MHVSMSTAFFFIVE','1',1,'foo@foo.com',305,1,to_date('01-MAY-08','DD-MON-RR'),to_date('01-MAY-08','DD-MON-RR'),to_date('18-JUN-60','DD-MON-RR'),null,'721607625','979','59828',1,0,to_date('19-OCT-10','DD-MON-RR'),'M7625',0,'TESTAMHVSMSTAFFFIVE',null,3,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (738,'FN_DONTUSE2','LN_DONTUSE2','0',0,'dontuse@foo.bar',10,0,to_date('28-MAY-08','DD-MON-RR'),to_date('28-MAY-08','DD-MON-RR'),to_date('18-JUN-60','DD-MON-RR'),'9999999999V999991','999999991',null,null,1,0,to_date('11-JUL-08','DD-MON-RR'),'M7602',0,'DONTUSE2',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (802,'FN_DONTUSE1','LN_DONTUSE1','0',0,'dontuse@foo.bar',5,0,to_date('28-MAY-08','DD-MON-RR'),to_date('28-MAY-08','DD-MON-RR'),to_date('18-JUN-60','DD-MON-RR'),'9999999999V999990','999999990',null,null,0,0,null,'M7601',0,'DONTUSE1',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (1150,'       ','Prematta','1',1,'       .Prematta@domain',646,0,to_date('04-JUN-08','DD-MON-RR'),to_date('04-JUN-08','DD-MON-RR'),to_date('01-JAN-50','DD-MON-RR'),null,'112231311','989','35245',2,0,to_date('04-OCT-10','DD-MON-RR'),'A1311',1,'serverpremaa',null,2,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (1152,'Donita','Searcy','1',1,'donita.searcy@domain',719,0,to_date('04-JUN-08','DD-MON-RR'),to_date('04-JUN-08','DD-MON-RR'),to_date('01-JAN-50','DD-MON-RR'),null,'345435345','989','35205',1,0,to_date('04-OCT-10','DD-MON-RR'),'D5345',1,'serversearcd',null,2,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (1154,'Douglas','Mcdonald','1',1,'douglas.mcdonald@domain',373,1,to_date('04-JUN-08','DD-MON-RR'),to_date('04-JUN-08','DD-MON-RR'),to_date('01-JAN-50','DD-MON-RR'),null,'121312323','979','59804',1,0,to_date('20-OCT-10','DD-MON-RR'),'M2323',1,'servermcdond',null,2,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (1156,'Jerome','Kola','1',1,'       .Prematta@domain',243,1,to_date('04-JUN-08','DD-MON-RR'),to_date('04-JUN-08','DD-MON-RR'),to_date('01-JAN-50','DD-MON-RR'),null,'131431414','979','59797',1,0,to_date('20-OCT-10','DD-MON-RR'),'K1414',1,'serverkolaj',null,2,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (1431,'TESTAAA','MHVJEROMEAAA','0',1,'       .Prematta@domain',59,1,to_date('12-JUN-08','DD-MON-RR'),to_date('12-JUN-08','DD-MON-RR'),to_date('01-JAN-40','DD-MON-RR'),'1011190640V913940','777777771',null,null,0,0,null,'M7771',0,'mhvjeromeaaa',null,null,to_timestamp('13-NOV-08 02.15.38.849000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (2196,'Joseph','Schmidt','2',0,null,26,1,to_date('19-JUN-08','DD-MON-RR'),to_date('19-JUN-08','DD-MON-RR'),null,null,null,null,null,0,0,null,null,0,'serverschmij',null,2,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (2197,'Arthur','Adams','2',0,null,1,1,to_date('19-JUN-08','DD-MON-RR'),to_date('19-JUN-08','DD-MON-RR'),null,null,null,null,null,0,0,null,null,0,'serveradamsa',null,2,null,1);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (2198,'     ','Warsaw','2',0,null,3,1,to_date('19-JUN-08','DD-MON-RR'),to_date('19-JUN-08','DD-MON-RR'),null,null,null,null,null,0,0,null,null,0,'serverwarsac',null,2,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (2567,'Jerome','Kola','2',0,null,0,1,to_date('07-JUL-08','DD-MON-RR'),to_date('07-JUL-08','DD-MON-RR'),null,null,null,null,null,0,0,null,null,0,'serverkolaj',null,2,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (2568,'Mastan','Ketha','2',0,null,16,1,to_date('09-JUL-08','DD-MON-RR'),to_date('09-JUL-08','DD-MON-RR'),null,null,null,null,null,0,0,null,null,0,'serverketham',null,2,null,1);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (2593,'      ','Knaster','2',0,null,0,1,to_date('09-JUL-08','DD-MON-RR'),to_date('09-JUL-08','DD-MON-RR'),null,null,null,null,null,0,0,null,null,0,'serverknasta',null,2,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (2656,'       ','Prematta','2',0,null,325,1,to_date('10-JUL-08','DD-MON-RR'),to_date('10-JUL-08','DD-MON-RR'),null,null,null,null,null,0,0,null,null,0,'serverpremaa',null,2,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (2795,'Douglas','McDonald','2',0,null,36,1,to_date('14-JUL-08','DD-MON-RR'),to_date('14-JUL-08','DD-MON-RR'),null,null,null,null,null,0,0,null,null,0,'servermcdond',null,2,null,1);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (2796,'Swetha','Balasubramanian','1',1,'anthony.prematta@domain',209,1,to_date('14-JUL-08','DD-MON-RR'),to_date('14-JUL-08','DD-MON-RR'),null,null,'121231233','979','59816',2,0,to_date('20-OCT-10','DD-MON-RR'),'B1233',1,'serverbalass',null,2,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (3370,'JK','Rowlings','2',0,null,81,1,to_date('07-AUG-08','DD-MON-RR'),to_date('07-AUG-08','DD-MON-RR'),null,null,null,null,null,0,0,null,null,0,'jkr',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (3748,'Swethambara','Balasubramanian','2',0,null,95,1,to_date('08-AUG-08','DD-MON-RR'),to_date('08-AUG-08','DD-MON-RR'),null,null,null,null,null,0,0,null,null,0,'serverbalass',null,null,null,1);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (4846,'Eric','Leap','2',0,null,1,1,to_date('15-AUG-08','DD-MON-RR'),to_date('15-AUG-08','DD-MON-RR'),null,null,null,null,null,0,0,null,null,0,'serverleape',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (4847,'CWELL','MHVSWETHATEST','0',0,'swethab@aquilent.com',9,1,to_date('18-AUG-08','DD-MON-RR'),to_date('18-AUG-08','DD-MON-RR'),to_date('02-OCT-50','DD-MON-RR'),'1011217990V323968','721250010',null,null,0,0,null,'M0010',0,'swetha10',null,null,to_timestamp('17-NOV-08 03.27.10.095000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (5846,'LWELL','MHVSWETHATEST','0',0,'swethab@aquilent.com',20,1,to_date('02-SEP-08','DD-MON-RR'),to_date('02-SEP-08','DD-MON-RR'),to_date('08-JAN-50','DD-MON-RR'),'1011218033V265360','721250019',null,null,0,0,null,'M0019',0,'swetha19',null,null,to_timestamp('13-MAY-09 01.41.51.997000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (5938,'Test','mhvjeromeccc','0',1,'       .Prematta@domain',70,1,to_date('05-SEP-08','DD-MON-RR'),to_date('05-SEP-08','DD-MON-RR'),to_date('16-FEB-60','DD-MON-RR'),'1011218541V080218','522222222',null,null,0,0,null,'m2222',0,'mhvjeromeccc',null,null,to_timestamp('26-JAN-11 12.31.06.306000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (6221,'JWELL','MHVSWETHATEST','0',0,'Satish.Bhamidipaty@domain',11,1,to_date('17-OCT-08','DD-MON-RR'),to_date('17-OCT-08','DD-MON-RR'),to_date('08-OCT-23','DD-MON-RR'),'1011218031V851182','721250017',null,null,0,0,null,'M0017',0,'swetha17',null,null,to_timestamp('27-JUL-09 11.27.34.133000000 AM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (6236,'Polonius','MHVDMWRPNEU','0',1,null,3,1,to_date('21-OCT-08','DD-MON-RR'),to_date('21-OCT-08','DD-MON-RR'),to_date('18-JUN-29','DD-MON-RR'),'1011218043V892199','721603014',null,null,0,0,null,'M3014',0,'dougtestwr14',null,null,to_timestamp('21-OCT-08 11.58.02.236000000 AM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (6240,'Iago','MHVDMWRLDL','0',0,null,2,1,to_date('21-OCT-08','DD-MON-RR'),to_date('21-OCT-08','DD-MON-RR'),to_date('18-JUN-50','DD-MON-RR'),'1011218025V910255','721603009',null,null,0,0,null,'M3009',0,'dougtestwr09',null,null,to_timestamp('21-OCT-08 01.34.23.715000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (6362,'MWELL','MHVSWETHATEST','0',1,'swethab@aquilent.com',33,1,to_date('04-NOV-08','DD-MON-RR'),to_date('04-NOV-08','DD-MON-RR'),to_date('06-JAN-29','DD-MON-RR'),'1011218034V010259','721250020',null,null,0,0,null,'M0020',0,'swetha20',null,null,to_timestamp('23-MAR-09 01.28.06.064000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (6366,'Bhanu','Goparaju','2',0,null,1,1,to_date('04-NOV-08','DD-MON-RR'),to_date('04-NOV-08','DD-MON-RR'),null,null,null,null,null,0,0,null,null,0,'servergoparb',null,null,null,1);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (6384,'GWELL','MHVSWETHATEST','0',1,'swethab@aquilent.com',13,1,to_date('07-NOV-08','DD-MON-RR'),to_date('07-NOV-08','DD-MON-RR'),to_date('06-OCT-76','DD-MON-RR'),'1011217992V638715','721250014',null,null,0,0,null,'M0014',0,'swetha14',null,null,to_timestamp('12-MAY-09 11.26.10.184000000 AM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (6482,'Test','mhvjeromebbb','0',1,'       .Prematta@domain',15,1,to_date('13-NOV-08','DD-MON-RR'),to_date('13-NOV-08','DD-MON-RR'),to_date('13-APR-30','DD-MON-RR'),'1011218560V753989','522222223',null,null,0,0,null,'M2223',0,'mhvjeromebbb',null,null,to_timestamp('04-FEB-09 03.59.31.974000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (6527,'IWELL','MHVSWETHATEST','0',1,'swethab@aquilent.com',20,1,to_date('14-NOV-08','DD-MON-RR'),to_date('14-NOV-08','DD-MON-RR'),to_date('08-OCT-76','DD-MON-RR'),'1011217994V917102','721250016',null,null,0,0,null,'M0016',0,'swetha16',null,null,to_timestamp('14-NOV-08 01.40.57.717000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (6563,'Deepa','Poovaiya','2',0,null,0,1,to_date('17-NOV-08','DD-MON-RR'),to_date('17-NOV-08','DD-MON-RR'),null,null,null,null,null,0,0,null,null,0,'serverpoovad',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (6705,'BHANU','GOPARAJU','1',1,'Bhanu.de3@domain',72,1,to_date('05-DEC-08','DD-MON-RR'),to_date('05-DEC-08','DD-MON-RR'),null,null,null,'979','59800',3,0,to_date('27-APR-09','DD-MON-RR'),null,0,'servergoparb',null,1,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (6782,'JENNY','SAMS','1',1,'douglas.mcdonald@domain',3,0,to_date('11-DEC-08','DD-MON-RR'),to_date('11-DEC-08','DD-MON-RR'),null,null,null,'989','225',0,0,null,null,0,'vhadaysamsj',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (6783,'DONNA','SABIN','1',1,'douglas.mcdonald@domain',1,0,to_date('11-DEC-08','DD-MON-RR'),to_date('11-DEC-08','DD-MON-RR'),null,null,null,'989','11649',0,0,null,null,0,'vhadaysabind',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (6784,'SHARON','SAIN','1',1,'douglas.mcdonald@domain',9,0,to_date('11-DEC-08','DD-MON-RR'),to_date('11-DEC-08','DD-MON-RR'),null,null,null,'989','11474',0,0,null,null,0,'VHADAYSAINS',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (6785,'WISSAM','SABBAGH','1',1,'douglas.mcdonald@domain',37,0,to_date('11-DEC-08','DD-MON-RR'),to_date('11-DEC-08','DD-MON-RR'),null,null,null,'989','13412',0,0,null,null,0,'VHAV01SABBAN',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (6976,'         ','        ','2',0,null,0,1,to_date('14-JAN-09','DD-MON-RR'),to_date('14-JAN-09','DD-MON-RR'),null,null,null,null,null,0,0,null,null,0,'serverwillic',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (6985,'J','Hrubovcak','2',0,null,0,1,to_date('15-JAN-09','DD-MON-RR'),to_date('15-JAN-09','DD-MON-RR'),null,null,null,null,null,0,0,null,null,0,'serverhruboj',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (7405,'Jeffrey','Robinson','2',0,null,1,1,to_date('19-FEB-09','DD-MON-RR'),to_date('19-FEB-09','DD-MON-RR'),null,null,null,null,null,0,0,null,null,0,'serverrobinj',null,null,null,1);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (7549,'Robert','Bell','2',0,null,0,1,to_date('20-FEB-09','DD-MON-RR'),to_date('20-FEB-09','DD-MON-RR'),null,null,null,null,null,0,0,null,null,0,'vhaishbellr',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (7741,'Donita','Searcy','2',0,null,1,1,to_date('25-FEB-09','DD-MON-RR'),to_date('25-FEB-09','DD-MON-RR'),null,null,null,null,null,0,0,null,null,0,'serversearcd',null,null,null,1);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (7909,'BONNIE','RACIN','1',1,'whateveryouwant@domain',12,0,to_date('02-MAR-09','DD-MON-RR'),to_date('02-MAR-09','DD-MON-RR'),null,null,null,'989','3397',0,0,null,null,0,'testsmcraigw',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (8716,'JAMES','WASHINGTON','1',1,'James.Washington3@domain',23,0,to_date('06-MAR-09','DD-MON-RR'),to_date('06-MAR-09','DD-MON-RR'),null,null,null,'989','3274',0,0,null,null,0,'VHADAYWASHIJ',null,1,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (8932,'UserFFourteen','User F u t e ','1',0,null,0,1,to_date('06-MAR-09','DD-MON-RR'),to_date('06-MAR-09','DD-MON-RR'),null,null,null,'989',null,0,0,null,null,0,'servergoudab',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (9077,'UserFTwo','UserLTwo','1',1,'foo@foo.com',28,1,to_date('09-MAR-09','DD-MON-RR'),to_date('09-MAR-09','DD-MON-RR'),null,null,null,'989','10761',0,0,null,null,0,'VHADAYABSHIB',null,2,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (9078,'UserFFifteen','UserLFifteen','1',0,'heather.gerety@domain',33,1,to_date('09-MAR-09','DD-MON-RR'),to_date('09-MAR-09','DD-MON-RR'),null,null,null,'989','33860',0,0,null,null,0,'vahrcgereth',null,3,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (9738,'BERNEECE','SMITH','1',1,'Berneece.     @domain',7,0,to_date('11-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),null,null,null,'989','3482',0,0,null,null,0,'vhadaysmithb',null,1,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (11013,'Liana','Buciuman-Coman','2',0,null,2,1,to_date('24-MAR-09','DD-MON-RR'),to_date('24-MAR-09','DD-MON-RR'),null,null,null,null,null,0,0,null,null,0,'serverbuciul',null,null,null,1);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (11072,'CHARISMA','RAMEY','1',1,'Charisma.Ramey@domain',5,0,to_date('25-MAR-09','DD-MON-RR'),to_date('25-MAR-09','DD-MON-RR'),null,null,null,'989','21647',0,0,null,null,0,'VHADAYRAMEYC',null,3,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (11737,'FLORENCE','DAGOSTINO','1',1,'jessie.dagostino@domain',15,0,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,null,null,'989','33836',0,0,null,null,0,'VHALONDAGOSJ',null,1,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (11738,'JILL','DAY','1',1,'jill.day@domain',1,0,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,null,null,'989','33838',0,0,null,null,0,'vahrcdayjil',null,2,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (12366,'FRANK','VALUE','1',1,'     .Value@domain',1,0,to_date('31-MAR-09','DD-MON-RR'),to_date('31-MAR-09','DD-MON-RR'),null,null,null,'989','4876',0,0,null,null,0,'VHADAYVALUEF',null,1,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (12397,'MASTAN','KETHA','1',1,'Mastan.Ketha@domain',91,0,to_date('02-APR-09','DD-MON-RR'),to_date('02-APR-09','DD-MON-RR'),null,null,null,'989','35230',0,0,null,null,1,'serverketham',null,1,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (12509,'BHANU','GOPARAJU','3',1,'Bhanu.Goparaju3@domain',4,0,to_date('02-APR-09','DD-MON-RR'),to_date('02-APR-09','DD-MON-RR'),null,null,null,'989','35228',0,0,null,null,0,'servergoparb',null,1,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (18186,'Johnnie','Boyette','1',1,'Johnnie.Boyette@domain',915,1,to_date('16-JUL-09','DD-MON-RR'),to_date('16-JUL-09','DD-MON-RR'),null,null,null,'989','35268',3,0,to_date('14-MAR-12','DD-MON-RR'),null,1,'serverboyetj',null,1,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (18188,'KKAA','VVVEEN','1',1,'foo@foo.com',153,0,to_date('16-JUL-09','DD-MON-RR'),to_date('16-JUL-09','DD-MON-RR'),null,null,null,'989','123456',2,0,to_date('08-FEB-11','DD-MON-RR'),null,1,'servervenkakaw12',null,1,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (18222,'EVA','MACK','1',1,'Eva.Mack@domain',7,0,to_date('21-JUL-09','DD-MON-RR'),to_date('21-JUL-09','DD-MON-RR'),null,null,null,'989','11369',0,0,null,null,0,'VHADAYMACKE',null,1,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (18223,'UserFSixteen','UserLSixteen','1',0,'Barbara.Mackey@domain',1,1,to_date('21-JUL-09','DD-MON-RR'),to_date('21-JUL-09','DD-MON-RR'),null,null,null,'989','3159',0,0,null,null,0,'VHAMORMACKEB',null,3,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (18592,'Bhanu','Gouda','2',0,null,1,1,to_date('22-JUL-09','DD-MON-RR'),to_date('22-JUL-09','DD-MON-RR'),null,null,null,null,null,0,0,null,null,0,'servergoudab',null,null,null,1);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (19011,'Kamaleswar','Venkata','2',0,null,75,1,to_date('22-JUL-09','DD-MON-RR'),to_date('22-JUL-09','DD-MON-RR'),null,null,null,null,null,0,0,null,null,0,'servervenkak',null,null,null,1);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (19204,'Johnnie','Boyette','2',0,'johnnie.boyette@domain',209,1,to_date('23-JUL-09','DD-MON-RR'),to_date('23-JUL-09','DD-MON-RR'),null,null,null,null,null,0,0,null,null,0,'mhvsystest2',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (19795,'DANNY','REED','1',1,'Danny.Reed@domain',3,0,to_date('05-AUG-09','DD-MON-RR'),to_date('05-AUG-09','DD-MON-RR'),null,null,null,'989','12897',0,0,null,null,0,'VHAISBREEDD',null,1,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (19797,'MAHMOOD','SAMDANI','1',1,'Mahmood.Samdani@domain',0,0,to_date('11-AUG-09','DD-MON-RR'),to_date('11-AUG-09','DD-MON-RR'),null,null,null,'989','13772',0,0,null,null,1,'VHADAYSAMDAM',null,1,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (19798,'MOHAMMAD','SAKLAYEN','1',1,'Mohammad.Saklayen@domain',0,0,to_date('11-AUG-09','DD-MON-RR'),to_date('11-AUG-09','DD-MON-RR'),null,null,null,'989','868',0,0,null,null,1,'vhadaySaklaM',null,2,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (19806,'User FZero','User LZero','1',1,'foo@foo.com',18,1,to_date('28-AUG-09','DD-MON-RR'),to_date('28-AUG-09','DD-MON-RR'),null,null,null,'989','4349',0,0,null,null,0,'VHAMRNTurneC',null,1,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (36234,'Carmen','Briscoe','2',0,null,29,1,to_date('20-OCT-10','DD-MON-RR'),to_date('20-OCT-10','DD-MON-RR'),null,null,null,null,null,0,0,null,null,0,'serverbriscc',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (36302,'Rajesh','Manivasagam','2',0,'test@abc.com',178,1,to_date('27-OCT-10','DD-MON-RR'),to_date('27-OCT-10','DD-MON-RR'),null,null,null,null,null,0,0,null,null,0,'servermanivr123',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (19815,'UserFThirteen','UserLThirteen','1',0,'Cheryl.      @domain',3,1,to_date('31-AUG-09','DD-MON-RR'),to_date('31-AUG-09','DD-MON-RR'),null,null,null,'989','3266',0,0,null,null,1,'vhaturnerc',null,2,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (24280,'WALTER','ZFATZINGER','1',1,'walter.fatzinger@domain',823,1,to_date('19-FEB-10','DD-MON-RR'),to_date('19-FEB-10','DD-MON-RR'),null,null,null,'989','35272',1,0,to_date('07-MAR-12','DD-MON-RR'),null,1,'serverfatziw',null,2,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (24477,'    ','Hall','1',1,'    .Hall4@domain',265,1,to_date('22-FEB-10','DD-MON-RR'),to_date('22-FEB-10','DD-MON-RR'),null,null,null,'989','14934',3,0,to_date('30-SEP-11','DD-MON-RR'),null,1,'serverhalll',null,3,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (24713,'LISA','HALL','1',1,'    .Hall4@domain',12,1,to_date('23-FEB-10','DD-MON-RR'),to_date('23-FEB-10','DD-MON-RR'),null,null,null,'979','59845',1,0,to_date('30-SEP-11','DD-MON-RR'),null,1,'serverhalll',null,2,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (24719,'TESTCAL','MHVJCAL','0',1,null,8,1,to_date('23-FEB-10','DD-MON-RR'),to_date('23-FEB-10','DD-MON-RR'),to_date('31-MAR-55','DD-MON-RR'),'1011231486V374711','705070025',null,null,0,0,null,'M0025',0,'testercal',null,null,to_timestamp('23-FEB-10 01.23.08.878000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (24748,'Robert','Murtha','2',0,null,1,1,to_date('23-FEB-10','DD-MON-RR'),to_date('23-FEB-10','DD-MON-RR'),null,null,null,null,null,0,0,null,null,0,'servermurthr',null,null,null,1);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (25258,'    ','Hall','2',0,null,41,1,to_date('25-FEB-10','DD-MON-RR'),to_date('25-FEB-10','DD-MON-RR'),null,null,null,null,null,0,0,null,null,0,'serverhalll',null,null,null,1);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (27840,'Testf','mhvjtestf','0',1,'william.mccarty@domain',48,1,to_date('19-MAR-10','DD-MON-RR'),to_date('19-MAR-10','DD-MON-RR'),to_date('09-MAR-12','DD-MON-RR'),'1011231190V196717','705070006',null,null,0,0,null,'m0006',0,'testerf',null,null,to_timestamp('09-MAR-12 02.51.37.524000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (28710,'DSlogone','MHVIntCone','0',3,null,2,1,to_date('14-APR-10','DD-MON-RR'),to_date('14-APR-10','DD-MON-RR'),to_date('25-APR-72','DD-MON-RR'),'1012585551V503867','705597866',null,null,0,0,null,'M7866',0,'mhvintc1',null,null,to_timestamp('14-APR-10 11.51.43.030000000 AM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (28867,'UserFTwele','UserLTwele','1',1,'foo@foo.com',23,1,to_date('08-JUN-10','DD-MON-RR'),to_date('08-JUN-10','DD-MON-RR'),null,null,null,'989','35251',1,0,null,null,0,'MHVSMDOCONE',null,2,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (29514,'BAMY','BVARGAS','0',3,'wan.wmail@aol.om',3,1,to_date('15-JUN-10','DD-MON-RR'),to_date('15-JUN-10','DD-MON-RR'),to_date('26-JAN-57','DD-MON-RR'),'1012585543V469744','705090010',null,null,0,0,null,'B0010',0,'avargas3',null,null,to_timestamp('15-JUN-10 01.19.39.904000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (29780,'RAJ','SAINI-BROWN','1',1,'dummy@foo.com',43,0,to_date('16-JUN-10','DD-MON-RR'),to_date('16-JUN-10','DD-MON-RR'),null,null,null,'989','14828',1,0,to_date('25-MAY-11','DD-MON-RR'),null,0,'rajeshc',null,3,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (29781,'DAVID','SAKAL','1',1,'David.Sakal@domain',312,0,to_date('16-JUN-10','DD-MON-RR'),to_date('16-JUN-10','DD-MON-RR'),null,null,null,'989','23243',1,0,to_date('30-SEP-11','DD-MON-RR'),null,0,'user29781',null,3,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (29782,'Ronald','Mack','1',1,'johnnie.boyette@domain',365,1,to_date('16-JUN-10','DD-MON-RR'),to_date('16-JUN-10','DD-MON-RR'),null,null,null,'989','1610',1,0,to_date('11-JAN-12','DD-MON-RR'),null,0,'MHVSMTESTONE',null,2,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31490,'LEN','MHVMPISYNCHGG','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('07-DEC-28','DD-MON-RR'),'1011194389V216365','100128554',null,null,0,0,null,'M8554',0,'mpisynchgg',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31492,'TED','MHVMPISYNCHHH','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('31-OCT-25','DD-MON-RR'),'1011194386V955696','100089944',null,null,0,0,null,'M9944',0,'mpisynchhh',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31494,'KEITH','MHVMPISYNCHI','0',2,'donita.searcy@domain',5,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('07-SEP-31','DD-MON-RR'),'1011194344V902760','100032733',null,null,0,0,null,'M2733',0,'mpisynchi9',null,null,to_timestamp('25-JAN-11 03.46.07.444000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31496,'DAN','MHVMPISYNCHII','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('02-MAR-15','DD-MON-RR'),'1011194388V562433','100127675',null,null,0,0,null,'M7675',0,'mpisynchii',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31498,'FRED','MHVMPISYNCHJJ','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('02-JUN-21','DD-MON-RR'),'1011195048V362406','100071258',null,null,0,0,null,'M1258',0,'mpisynchjj',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31500,'EARL','MHVMPISYNCHKK','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-NOV-21','DD-MON-RR'),'1011195049V416328','100078317',null,null,0,0,null,'M8317',0,'mpisynchkk',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31502,'WES','MHVMPISYNCHLL','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('09-JAN-52','DD-MON-RR'),'1011195051V678484','100082014',null,null,0,0,null,'M2014',0,'mpisynchll',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31504,'ABE','MHVMPISYNCHMM','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('13-JAN-64','DD-MON-RR'),'1011195052V741336','100133043',null,null,0,0,null,'M3043',0,'mpisynchmm',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31506,'MELVIN','MHVMPISYNCHNN','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('04-FEB-30','DD-MON-RR'),'1011195050V419199','100119926',null,null,0,0,null,'M9926',0,'mpisynchnn',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31508,'OSCAR','MHVMPISYNCHOO','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('07-NOV-36','DD-MON-RR'),'1011195054V885053','100108637',null,null,0,0,null,'M8637',0,'mpisynchoo',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31510,'NICK','MHVMPISYNCHPP','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('25-SEP-17','DD-MON-RR'),'1011195053V907268','100073943',null,null,0,0,null,'M3943',0,'mpisynchpp',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31512,'TOM','MHVMPISYNCHQQ','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('31-DEC-35','DD-MON-RR'),'1011195118V619028','100169792',null,null,0,0,null,'M9792',0,'mpisynchqq',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31514,'KEN','MHVMPISYNCHRR','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('26-OCT-54','DD-MON-RR'),'1011195123V881095','100101355',null,null,0,0,null,'M1355',0,'mpisynchrr',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31516,'IAN','MHVMPISYNCHSS','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('22-NOV-35','DD-MON-RR'),'1011195120V673406','100062067',null,null,0,0,null,'M2067',0,'mpisynchss',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31518,'CLARA','MHVMPISYNCHT','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('05-JUL-53','DD-MON-RR'),'1011194374V228403','100103078',null,null,0,0,null,'M3078',0,'mpisyncht',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31520,'THOR','MHVMPISYNCHTT','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('11-AUG-35','DD-MON-RR'),'1011195122V908243','100087621',null,null,0,0,null,'M7621',0,'mpisynchtt',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31522,'BRET','MHVMPISYNCHUU','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('12-SEP-46','DD-MON-RR'),'1011195121V749328','100110653',null,null,0,0,null,'M0653',0,'mpisynchuu',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31524,'JACK','MHVMPISYNCHVV','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('24-AUG-70','DD-MON-RR'),'1011195127V132750','100109527',null,null,0,0,null,'M9527',0,'mpisynchvv',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31526,'ELLA','MHVMPISYNCHW','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-MAR-31','DD-MON-RR'),'1011194377V365092','100104630',null,null,0,0,null,'M4630',0,'mpisynchw',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31528,'ZACH','MHVMPISYNCHWW','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('30-JUN-21','DD-MON-RR'),'1011195130V410063','100111794',null,null,0,0,null,'M1794',0,'mpisynchww',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31530,'MARK','MHVMPISYNCHX','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('30-MAY-22','DD-MON-RR'),'1011194376V137247','100074496',null,null,0,0,null,'M4496',0,'mpisynchx',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31532,'ED','MHVMPISYNCHXX','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('02-AUG-39','DD-MON-RR'),'1011195129V414174','100113779',null,null,0,0,null,'M3779',0,'mpisynchxx',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31534,'DORA','MHVMPISYNCHY','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('17-NOV-66','DD-MON-RR'),'1011194380V074257','100101037',null,null,0,0,null,'M1037',0,'mpisynchy',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31536,'MORRIS','MHVMPISYNCHYY','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('27-NOV-74','DD-MON-RR'),'1011195126V050861','100098461',null,null,0,0,null,'M8461',0,'mpisynchyy',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31538,'EARL','MHVMPISYNCHZ','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-MAR-26','DD-MON-RR'),'1011194381V143012','100052733',null,null,0,0,null,'M2733',0,'mpisynchz',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31540,'SHANE','MHVMPISYNCHZZ','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('22-APR-70','DD-MON-RR'),'1011195124V597587','100032759',null,null,0,0,null,'M2759',0,'mpisynchzz',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31542,'tester','mhvnametest','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('15-APR-54','DD-MON-RR'),'1011218320V935380','706081234',null,null,0,0,null,'M1234',0,'nametest',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31544,'test','mhvnewuserview','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('18-SEP-56','DD-MON-RR'),'1012580949V030017','705020002',null,null,0,0,null,'M0002',0,'newuserview1',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31546,'test','mhvphrdemoa','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('11-JUL-21','DD-MON-RR'),'1011231172V368217','707030001',null,null,0,0,null,'M0001',0,'phrdemoa',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31548,'test','mhvphrrefresh','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('03-APR-11','DD-MON-RR'),'1011217727V097417','705024477',null,null,0,0,null,'M4477',0,'phrrefresh',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31550,'testtwo','mhvphrrefresh','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('07-AUG-79','DD-MON-RR'),'1011217804V586954','702876543',null,null,0,0,null,'M6543',0,'phrrefresh1',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31552,'test','mhvpratest','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('04-APR-25','DD-MON-RR'),'1011220848V635680','709090900',null,null,0,0,null,'M0900',0,'pratest1',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31554,'Dale','MHVRXACK','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('16-MAY-66','DD-MON-RR'),'1011119195V339757','101010166',null,null,0,0,null,'M0166',0,'refill465',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31556,'Mark','MHVRXADLEY','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('12-NOV-43','DD-MON-RR'),'1011118996V578499','101010116',null,null,0,0,null,'M0116',0,'refill415',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31558,'Bruce','MHVRXAMS','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('30-NOV-52','DD-MON-RR'),'1011118964V034856','101010105',null,null,0,0,null,'M0105',0,'refill404',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31560,'Rex','MHVRXARK','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('15-SEP-67','DD-MON-RR'),'1011119038V697254','101010123',null,null,0,0,null,'M0123',0,'refill422',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31562,'Ken','MHVRXAUS','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('18-AUG-48','DD-MON-RR'),'1011119192V296588','101010163',null,null,0,0,null,'M0163',0,'refill462',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31564,'     ','MHVRXBBARD','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('03-JUN-50','DD-MON-RR'),'1011119057V040777','101010130',null,null,0,0,null,'M0130',0,'refill429',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31566,'Jay','MHVRXBBS','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('17-DEC-39','DD-MON-RR'),'1011119144V916541','101010152',null,null,0,0,null,'M0152',0,'refill451',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31568,'Gilbert','MHVRXBEL','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('20-SEP-40','DD-MON-RR'),'1011119142V630207','101010150',null,null,0,0,null,'M0150',0,'refill449',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31570,'Kevin','MHVRXBERT','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('21-MAR-39','DD-MON-RR'),'1011118965V163718','101010106',null,null,0,0,null,'M0106',0,'refill405',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31572,'Brian','MHVRXBOTT','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('27-JAN-57','DD-MON-RR'),'1011118962V522539','101010103',null,null,0,0,null,'M0103',0,'refill403',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31574,'Lee','MHVRXBSON','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-FEB-38','DD-MON-RR'),'1011119050V494440','101010127',null,null,0,0,null,'M0127',0,'refill426',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31576,'Gray','MHVRXCKER','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('22-APR-59','DD-MON-RR'),'1011119145V874990','101010153',null,null,0,0,null,'M0153',0,'refill452',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (35380,'Shankar','Viswanathan','2',0,null,1,1,to_date('08-OCT-10','DD-MON-RR'),to_date('08-OCT-10','DD-MON-RR'),null,null,null,null,null,0,0,null,null,0,'serverviswas',null,null,null,1);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (35672,'TESTPROD','MHVJTESTPROD','0',2,'joe.joe@aol.com',19,1,to_date('18-OCT-10','DD-MON-RR'),to_date('18-OCT-10','DD-MON-RR'),to_date('29-APR-35','DD-MON-RR'),'1012590857V078530','705072146',null,null,2,0,to_date('03-NOV-10','DD-MON-RR'),'M2146',0,'testerprod',null,null,to_timestamp('22-NOV-10 03.14.54.029000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (19872,'Bret','Corbin','2',0,null,1,1,to_date('11-SEP-09','DD-MON-RR'),to_date('11-SEP-09','DD-MON-RR'),null,null,null,null,null,0,0,null,null,0,'servercorbib',null,null,null,1);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (20084,'Johnnie','BOYETTE','1',1,'Johnnie.boyette@domain',39,1,to_date('15-SEP-09','DD-MON-RR'),to_date('15-SEP-09','DD-MON-RR'),null,null,null,'979','59837',0,0,null,null,1,'serverboyetj',null,2,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (20085,'KAMALESWAR','VENKATA','1',1,'Kamaleswar.Venkata@domain',2,1,to_date('15-SEP-09','DD-MON-RR'),to_date('15-SEP-09','DD-MON-RR'),null,null,null,'979','59838',0,0,null,null,1,'servervenkak',null,1,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (21815,'KRISHNA','MHVRAMA','0',1,'KAMAL@VA.ORG',79,1,to_date('24-SEP-09','DD-MON-RR'),to_date('24-SEP-09','DD-MON-RR'),to_date('01-JAN-71','DD-MON-RR'),'1011231601V189350','111223333',null,null,0,0,null,'M3333',0,'mhvsysrk1',null,null,to_timestamp('03-MAR-10 06.50.41.961000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (21820,'VK','MHVTEST','0',1,'kamal@va.org',7,1,to_date('24-SEP-09','DD-MON-RR'),to_date('24-SEP-09','DD-MON-RR'),to_date('25-APR-26','DD-MON-RR'),'1012580946V891438','111223335',null,null,0,0,null,'M3335',0,'mhvtestvk',null,null,to_timestamp('22-MAR-10 11.35.40.797000000 AM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (23181,'teste','mhvjteste','0',1,'william.mccarty@domain',511,1,to_date('14-OCT-09','DD-MON-RR'),to_date('14-OCT-09','DD-MON-RR'),to_date('01-MAY-32','DD-MON-RR'),'1011231189V935260','705070005',null,null,0,0,null,'m0005',0,'zztestere',null,null,to_timestamp('29-JUN-11 05.14.57.591000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (24223,'Victory','Marasigan','2',0,null,1,1,to_date('21-JAN-10','DD-MON-RR'),to_date('21-JAN-10','DD-MON-RR'),null,null,null,null,null,0,0,null,null,0,'servermarasv',null,null,null,1);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (24285,'Walter','Fatzinger','2',0,null,61,1,to_date('21-FEB-10','DD-MON-RR'),to_date('21-FEB-10','DD-MON-RR'),null,null,null,null,null,0,0,null,null,0,'serverfatziw',null,null,null,1);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (24358,'WALTER','FATZINGER','1',1,'Walter.Fatzinger@domain',26,1,to_date('22-FEB-10','DD-MON-RR'),to_date('22-FEB-10','DD-MON-RR'),null,null,null,'979','59841',1,0,to_date('04-OCT-11','DD-MON-RR'),null,1,'serverfatziw',null,1,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (28445,'Gim','MHVSYSTEST','0',1,null,3,1,to_date('24-MAR-10','DD-MON-RR'),to_date('24-MAR-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011218476V249549','708020006',null,null,0,0,null,'M0006',0,'mpisynch0117',null,null,to_timestamp('24-MAR-10 01.50.17.467000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (28450,'TESTDN','MHVSYSTESTDN','0',1,null,3,1,to_date('24-MAR-10','DD-MON-RR'),to_date('24-MAR-10','DD-MON-RR'),to_date('18-JUN-60','DD-MON-RR'),'1011214273V150031','721602214',null,null,0,0,null,'M2214',0,'systestdn',null,null,to_timestamp('24-MAR-10 01.52.50.790000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (28699,'Mark','Kamensek','2',0,null,6,1,to_date('12-APR-10','DD-MON-RR'),to_date('12-APR-10','DD-MON-RR'),null,null,null,null,null,0,0,null,null,0,'serverkamenm',null,null,null,1);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (28874,'    ','mhvtestlh','0',1,'test@test.com',11,1,to_date('10-JUN-10','DD-MON-RR'),to_date('10-JUN-10','DD-MON-RR'),to_date('13-MAY-51','DD-MON-RR'),'1012586760V715525','705050009',null,null,0,0,null,'M0009',0,'lisatest1',null,null,to_timestamp('10-JUN-10 02.42.12.607000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31048,'TESTNEW','MHVJTESTNEW','0',1,'joe.joe@aol.com',4,1,to_date('28-JUN-10','DD-MON-RR'),to_date('28-JUN-10','DD-MON-RR'),to_date('22-APR-56','DD-MON-RR'),'1012586966V318569','705072010',null,null,0,0,null,'M2010',0,'testernew',null,null,to_timestamp('28-JUN-10 05.55.05.188000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31079,'TESTNEWONE','MHVJTESTNEWONE','0',1,'joejohn@cm.com',4,1,to_date('30-JUN-10','DD-MON-RR'),to_date('30-JUN-10','DD-MON-RR'),to_date('04-NOV-46','DD-MON-RR'),'1012587122V973558','705072011',null,null,0,0,null,'M2011',0,'testernew1a',null,null,to_timestamp('30-JUN-10 11.28.54.907000000 AM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31126,'TESTNEWTWO','MHVJTESTNEWTWO','0',1,'joejohn@cm.com',9,1,to_date('30-JUN-10','DD-MON-RR'),to_date('30-JUN-10','DD-MON-RR'),to_date('25-MAR-45','DD-MON-RR'),'1012587124V508875','705072012',null,null,0,0,null,'M2012',0,'testernew2',null,null,to_timestamp('19-OCT-10 03.25.45.489000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31316,'BCNS','mcwhig','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('26-JUL-20','DD-MON-RR'),'1011182021V092564','100107503',null,null,0,0,null,'M7503',0,'doug02',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31318,'testa','mhvallergy','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('05-MAY-55','DD-MON-RR'),'1011219800V209513','705050001',null,null,0,0,null,'M0001',0,'allergy1',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31320,'antny','mhvantnya','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('05-MAY-55','DD-MON-RR'),'1011195046V055619','702223333',null,null,0,0,null,'M3333',0,'mhvantnya',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31322,'antny','MHVANTNYAAA','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('07-AUG-79','DD-MON-RR'),'1011216133V737908','705055555',null,null,0,0,null,'M5555',0,'mhvantnyaaa',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31324,'antny','mhvantnyc','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('07-AUG-79','DD-MON-RR'),'1011195781V644251','706010003',null,null,0,0,null,'M0003',0,'mhvantnyc',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31326,'ANTNY','MHVANTNYD','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('06-AUG-79','DD-MON-RR'),'1011195976V382774','213946688',null,null,0,0,null,'M6688',0,'mhvantnyd',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31328,'Antny','MHVANTNYE','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('12-JUN-15','DD-MON-RR'),'1011196415V935866','705010004',null,null,0,0,null,'M0004',0,'mhvantnye',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31330,'Antny','MHVANTNYf','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('13-JUL-29','DD-MON-RR'),'1011196416V860758','705010005',null,null,0,0,null,'M0005',0,'mhvantnyf',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31332,'Antny','MHVANTNYg','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('19-DEC-10','DD-MON-RR'),'1011197057V181448','705010007',null,null,0,0,null,'M0007',0,'mhvantnygg',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31334,'Antny','MHVANTNYZZ','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('07-AUG-79','DD-MON-RR'),'1011214409V759852','705010010',null,null,0,0,null,'M0010',0,'mhvantnyzz',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31336,'ALEX','MHVAPPTSORT','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-50','DD-MON-RR'),'1011215920V375628','888888801',null,null,0,0,null,'M8801',0,'mhvapptsort1',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31338,'Ben','mhvapptsort','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('02-JAN-50','DD-MON-RR'),'1011215923V786387','888888802',null,null,0,0,null,'M8802',0,'apptsort11',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31340,'cara','mhvapptsort','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('03-JAN-50','DD-MON-RR'),'1011215925V823061','888888803',null,null,0,0,null,'M8803',0,'apptsort26',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31342,'Eric','mhvapptsort','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('04-JAN-50','DD-MON-RR'),'1011215924V994232','888888804',null,null,0,0,null,'M8804',0,'apptsort101',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31344,'Tester','mhvappttesta','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('11-JAN-59','DD-MON-RR'),'1011219101V137130','777880001',null,null,0,0,null,'M0001',0,'appttesta',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31346,'test','mhvblenmedsa','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('28-DEC-69','DD-MON-RR'),'1011225225V039313','705095502',null,null,0,0,null,'M5502',0,'blenmedsa1',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31348,'test','mhvbmedstesta','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('22-DEC-31','DD-MON-RR'),'1011225224V253458','705095501',null,null,0,0,null,'M5501',0,'bmedsa1',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31350,'FINN','MHVCHANGENAME','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('04-APR-44','DD-MON-RR'),'1011218491V049072','708020013',null,null,0,0,null,'M0013',0,'mpisynch0122',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31352,'Donita','MHVCTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('04-APR-44','DD-MON-RR'),'1011165682V872058','291919191',null,null,0,0,null,'M9191',0,'donitatestc',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31354,'Eight','MHVDEAC','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-10','DD-MON-RR'),'1012581174V825980','445101007',null,null,0,0,null,'M1007',0,'mhvdeaceight',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31356,'One','MHVDEAC','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-10','DD-MON-RR'),'1012581145V989307','445101000',null,null,0,0,null,'M1000',0,'mhvdeacone',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31358,'Three','MHVDEAC','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-10','DD-MON-RR'),'1012581169A000001','445101002',null,null,0,0,null,'M1002',0,'mhvdeacthree',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31360,'antny','mhvdeact','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('17-FEB-28','DD-MON-RR'),'1011216117A000001','705088888',null,null,0,0,null,'M8888',0,'mhvdeact',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31362,'Aaron','MHVDISCLAIMERA','0',0,'donita.searcy@domain',3,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('07-NOV-15','DD-MON-RR'),'1011191238V314562','100104209',null,null,0,0,null,'M4209',0,'disclaimera',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31364,'Bob','MHVDISCLAIMERB','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('15-APR-48','DD-MON-RR'),'1011191240V478281','100047732',null,null,0,0,null,'M7732',0,'disclaimerb',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31366,'Chris','MHVDISCLAIMERC','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('16-MAY-52','DD-MON-RR'),'1011191239V473951','100037856',null,null,0,0,null,'M7856',0,'disclaimerc',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31368,'Dave','MHVDISCLAIMERD','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('23-DEC-42','DD-MON-RR'),'1011191242V707569','100083643',null,null,0,0,null,'M3643',0,'disclaimerd',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31370,'Ed','MHVDISCLAIMERE','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('15-MAR-55','DD-MON-RR'),'1011191241V641030','100056813',null,null,0,0,null,'M6813',0,'disclaimere',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31372,'Fred','MHVDISCLAIMERF','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('02-OCT-69','DD-MON-RR'),'1011191245V522778','100071512',null,null,0,0,null,'M1512',0,'disclaimerf',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31374,'Gil','MHVDISCLAIMERG','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('14-FEB-45','DD-MON-RR'),'1011191244V890816','100010640',null,null,0,0,null,'M0640',0,'disclaimerg',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31376,'Harry','MHVDISCLAIMERH','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('21-JUL-48','DD-MON-RR'),'1011191247V034125','100209122',null,null,0,0,null,'M9122',0,'twohunesr1',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31378,'Ian','MHVDISCLAIMERI','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('06-JUN-49','DD-MON-RR'),'1011191246V256603','100095823',null,null,0,0,null,'M5823',0,'twohunesr2',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31380,'Adriano','MHVDMWRBMI','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('18-JUN-50','DD-MON-RR'),'1011218042V980640','721603013',null,null,0,0,null,'M3013',0,'dougtestwr13',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31382,'Alonso','MHVDMWRBMI','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('18-JUN-50','DD-MON-RR'),'1011218021V328694','721603001',null,null,0,0,null,'M3001',0,'dougtestwr01',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31384,'Cassio','MHVDMWRCOLO','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('18-JUN-50','DD-MON-RR'),'1011218023V637438','721603003',null,null,0,0,null,'M3003',0,'dougtestwr03',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31386,'Hamlet','MHVDMWRFLU','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('18-JUN-50','DD-MON-RR'),'1011218024V765363','721603008',null,null,0,0,null,'M3008',0,'dougtestwr08',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31388,'Lennox','MHVDMWRLIPID','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('18-JUN-50','DD-MON-RR'),'1011218027V546572','721603010',null,null,0,0,null,'M3010',0,'dougtestwr10',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31390,'Ophelia','MHVDMWRMAM','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('18-JUN-50','DD-MON-RR'),'1011218028V204901','721603011',null,null,0,0,null,'M3011',0,'dougtestwr11',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31392,'Baptista','MHVDMWRPAP','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('18-JUN-50','DD-MON-RR'),'1011218022V451186','721603002',null,null,0,0,null,'M3002',0,'dougtestwr02',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (40084,'LAMAR','MHVSYSTEST','0',3,'donita.searcy@domain',5,1,to_date('17-FEB-11','DD-MON-RR'),to_date('17-FEB-11','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011218886V351780','708020064',null,null,2,0,null,'M0064',0,'mpisynch0161',null,null,to_timestamp('18-FEB-11 01.04.06.113000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (21493,'AMY','SANTO','1',1,'Melody.Santo@domain',0,0,to_date('22-SEP-09','DD-MON-RR'),to_date('22-SEP-09','DD-MON-RR'),null,null,null,'989','34074',0,0,null,null,0,'VSCMSANT317',null,2,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (21494,'ANNA','SCHMIDT','1',1,'Anne.Schmidt@domain',0,0,to_date('22-SEP-09','DD-MON-RR'),to_date('22-SEP-09','DD-MON-RR'),null,null,null,'989','420',0,0,null,null,0,'VHAALNSCHMIA',null,1,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (21518,'JOHN','SARA','1',1,'John.Sara@domain',0,0,to_date('22-SEP-09','DD-MON-RR'),to_date('22-SEP-09','DD-MON-RR'),null,null,null,'989','13064',0,0,null,null,0,'VHADAYSARAJ',null,1,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31745,'TESTWELL','MHVSWETHATEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('29-SEP-76','DD-MON-RR'),'1011218456V393174','722250007',null,null,0,0,null,'M0007',0,'swetha7',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31747,'ALPHA','MHVSYS','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-10','DD-MON-RR'),'1012581058V083980','708020222',null,null,0,0,null,'M0222',0,'mpisynch0239',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31749,'ANNA','MHVSYS','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-99','DD-MON-RR'),'1011218973V205137','708020092',null,null,0,0,null,'M0092',0,'mpisynch0181',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31751,'Beano','MHVSYS','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-99','DD-MON-RR'),'1011230322V426060','708020152',null,null,0,0,null,'M0152',0,'mpisynch0223',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31753,'BENNY','MHVSYS','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-10','DD-MON-RR'),'1012580997V955996','708020214',null,null,0,0,null,'M0214',0,'mpisynch0323',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31755,'BETA','MHVSYS','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-10','DD-MON-RR'),'1012581060V247650','708020224',null,null,0,0,null,'M0224',0,'mpisynch0329',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31757,'CATT','MHVSYS','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-10','DD-MON-RR'),'1012581062V180474','708020226',null,null,0,0,null,'M0226',0,'mpisynch0330',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31759,'CHINO','MHVSYS','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-99','DD-MON-RR'),'1011230323V654559','708020153',null,null,0,0,null,'M0153',0,'mpisynch0224',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31761,'Cindy','MHVSYS','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-99','DD-MON-RR'),'1011218977V454079','708020096',null,null,0,0,null,'M0096',0,'mpisynch0183',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31763,'DEB','MHVSYS','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-99','DD-MON-RR'),'1011218979V769926','708020098',null,null,0,0,null,'M0098',0,'mpisynch0185',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31765,'DINOSPLIT','MHVSYS','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-88','DD-MON-RR'),'1011230328V247145','708020158',null,null,0,0,null,'M0158',0,'mpisynch0227',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31767,'DRANO','MHVSYS','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-10','DD-MON-RR'),'1012581064V426228','708020228',null,null,0,0,null,'M0228',0,'mpisynch0332',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31769,'EGO','MHVSYS','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-10','DD-MON-RR'),'1012581066V733595','708020230',null,null,0,0,null,'M0230',0,'mpisynch0333',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31773,'FARRAH','MHVSYS','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-99','DD-MON-RR'),'1011218983V872963','708020102',null,null,0,0,null,'M0102',0,'mpisynch0187',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31775,'FIDO','MHVSYS','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-10','DD-MON-RR'),'1012581243V368922','708020245',null,null,0,0,null,'M0245',0,'mpisynch0345',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31777,'FIG','MHVSYS','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-10','DD-MON-RR'),'1012581068V818832','708020232',null,null,0,0,null,'M0232',0,'mpisynch0334',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31779,'GEENA','MHVSYS','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-99','DD-MON-RR'),'1011218985V204717','708020104',null,null,0,0,null,'M0104',0,'mpisynch0189',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31781,'GLEE','MHVSYS','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-10','DD-MON-RR'),'1012581070V572811','708020234',null,null,0,0,null,'M0234',0,'mpisynch0336',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31783,'HAM','MHVSYS','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-10','DD-MON-RR'),'1012581072V004609','708020236',null,null,0,0,null,'M0236',0,'mpisynch0337',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31785,'HODA','MHVSYS','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-99','DD-MON-RR'),'1011218987V199101','708020106',null,null,0,0,null,'M0106',0,'mpisynch0190',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31787,'IGLOO','MHVSYS','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-10','DD-MON-RR'),'1012581074V399446','708020238',null,null,0,0,null,'M0238',0,'mpisynch0338',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31789,'INGA','MHVSYS','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-99','DD-MON-RR'),'1011218989V451349','708020108',null,null,0,0,null,'M0108',0,'mpisynch0191',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31791,'Jan','MHVSYS','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-99','DD-MON-RR'),'1011218991V686429','708020110',null,null,0,0,null,'M0110',0,'mpisynch0193',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31793,'JAVIN','MHVSYS','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-10','DD-MON-RR'),'1012580991V074157','708020206',null,null,0,0,null,'M0206',0,'mpisynch0318',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31795,'JERRIE','MHVSYS','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-10','DD-MON-RR'),'1012581002V298027','708020216',null,null,0,0,null,'M0216',0,'mpisynch0325',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31797,'Jingle','MHVSYS','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-10','DD-MON-RR'),'1012581141V312766','708020240',null,null,0,0,null,'M0240',0,'mpisynch0340',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31799,'Kem','MHVSYS','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-99','DD-MON-RR'),'1011218993V923296','708020112',null,null,0,0,null,'M0112',0,'mpisynch0194',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31801,'KENTE','MHVSYS','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-10','DD-MON-RR'),'1012581004V157991','708020218',null,null,0,0,null,'M0218',0,'mpisynch0326',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31803,'KING','MHVSYS','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('04-APR-44','DD-MON-RR'),'1012581144V703475','708020241',null,null,0,0,null,'M0241',0,'mpisynch0342',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31805,'KINOTWO','MHVSYS','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-99','DD-MON-RR'),'1011230325V969876','708020155',null,null,0,0,null,'M0155',0,'mpisynch0228',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31807,'KWAMI','MHVSYS','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-10','DD-MON-RR'),'1012581007V612664','708020221',null,null,0,0,null,'M0221',0,'mpisynch0327',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31809,'LANDO','MHVSYS','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-10','DD-MON-RR'),'1012580986V558063','708020202',null,null,0,0,null,'M0202',0,'mpisynch0315',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31811,'LENOAFOURTHREE','MHVSYS','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011230327V571623','708020157',null,null,0,0,null,'M0157',0,'mpisynch0226',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31813,'LIV','MHVSYS','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-99','DD-MON-RR'),'1011219013V316524','708020114',null,null,0,0,null,'M0114',0,'mpisynch0195',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31823,'Null','MHVSYS','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-99','DD-MON-RR'),'1011218975V192351',null,null,null,0,0,null,'MNULL',0,'mpisynch0182',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31825,'SANTINO','MHVSYS','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-10','DD-MON-RR'),'1012580993V309371','708020208',null,null,0,0,null,'M0208',0,'mpisynch0319',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31827,'Terrie','MHVSYS','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-10','DD-MON-RR'),'1012580985V829238','708020201',null,null,0,0,null,'M0201',0,'mpisynch0314',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31829,'TRENTON','MHVSYS','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-10','DD-MON-RR'),'1012580989V115872','708020204',null,null,0,0,null,'M0204',0,'mpisynch0317',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31831,'YOYO','MHVSYS','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-99','DD-MON-RR'),'1011230434V863177','708020161',null,null,0,0,null,'M0161',0,'mpisynch0229',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31833,'AARON','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-12','DD-MON-RR'),'1011214243V902583','705114444',null,null,0,0,null,'M4444',0,'mpisynch0014',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31835,'ALMA','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011217530V648384','707117777',null,null,0,0,null,'M7777',0,'mpisynch0078',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31837,'AMBER','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011216136V572697','705158889',null,null,0,0,null,'M8889',0,'mpisynch0053',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31839,'AMRO','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011217859V635893','706118888',null,null,0,0,null,'M8888',0,'mpisynch0095',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31841,'ANN','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011215150V061436','705144445',null,null,0,0,null,'M4445',0,'mpisynch0037',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31843,'ARN','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011218338V379277','708010009',null,null,0,0,null,'M0009',0,'mpisynch0106',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31845,'Arnold','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011218880V972318','708020058',null,null,0,0,null,'M0058',0,'mpisynch0157',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31847,'ASHTON','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011214301V283709','705129999',null,null,0,0,null,'M9999',0,'mpisynch0022',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31849,'BENSOURCE','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011217865V711062','706112020',null,null,0,0,null,'M2020',0,'mpisynch0099',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31851,'BENTARGET','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011217866V977551','706112020',null,null,0,0,null,'M2020',0,'mpisynch0100',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31853,'BHANU','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011226059V107439','708020126',null,null,0,0,null,'M0126',0,'mpisynch0203',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31855,'BHAVIN','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011226055V863827','708020124',null,null,0,0,null,'M0124',0,'mpisynch0201',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31857,'BINGO','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011218876V833998','708020054',null,null,0,0,null,'M0054',0,'mpisynch0155',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31859,'BRANDON','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011214498V234332','705125555',null,null,0,0,null,'M5555',0,'mpisynch0024',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31861,'BREE','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011216138V004431','705159990',null,null,0,0,null,'M9990',0,'mpisynch0054',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31863,'Breed','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011226367V807873','708020146',null,null,0,0,null,'M0146',0,'mpisynch0218',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31865,'BRODY','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011214153V858893','705110044',null,null,0,0,null,'M0044',0,'mpisynch0011',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31867,'Brody','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011214154V531785','705110045',null,null,0,0,null,'M0045',0,'mpisynch0012',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31869,'Carlos','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011218884V099942','708020063',null,null,0,0,null,'M0063',0,'mpisynch0160',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31871,'CAROL','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011215165V315650','705141234',null,null,0,0,null,'M1234',0,'mpisynch0042',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31873,'CARRIE','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011217472V617274','707111111',null,null,0,0,null,'M1111',0,'mpisynch0070',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31875,'CGHAZARIANA','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('08-OCT-76','DD-MON-RR'),'1011195844V215742','789124567',null,null,0,0,null,'M4567',0,'mhvsystestga',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31877,'CGHAZARIANB','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('09-OCT-76','DD-MON-RR'),'1011195848V484364','789124568',null,null,0,0,null,'M4568',0,'mhvsystestgb',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31879,'CGHAZARIANC','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-OCT-76','DD-MON-RR'),'1011195846V142180','789124569',null,null,0,0,null,'M4569',0,'mhvsystestgc',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31881,'CGHAZARIAND','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('11-OCT-76','DD-MON-RR'),'1011195849V693256','789124570',null,null,0,0,null,'M4570',0,'mhvsystestgd',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31883,'CGHAZARIANE','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('12-OCT-76','DD-MON-RR'),'1011195847V306439','789124571',null,null,0,0,null,'M4571',0,'mhvsystestge',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31885,'CHARLENE','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011217534V520915',null,null,null,0,0,null,'MNULL',0,'mpisynch0079',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31887,'Chazz','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011226362V334380','708020142',null,null,0,0,null,'M0142',0,'mpisynch0214',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31889,'CHEMA','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-80','DD-MON-RR'),'1011214016V380945','212441111',null,null,0,0,null,'M1111',0,'systestchema',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31891,'CHEMB','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('25-FEB-80','DD-MON-RR'),'1011214017V492897','212442222',null,null,0,0,null,'M2222',0,'systestchemb',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31893,'CHEMC','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('20-FEB-80','DD-MON-RR'),'1011214018V626782','212443333',null,null,0,0,null,'M3333',0,'systestchemc',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31895,'CHINA','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011216143V365220','705151313',null,null,0,0,null,'M1313',0,'mpisynch0055',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31897,'CINDI','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011218587V645463','708020050',null,null,0,0,null,'M0050',0,'mpisynch0151',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31899,'CLARK','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011214150V684004','705110034',null,null,0,0,null,'M0034',0,'mpisynch0010',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31901,'CLYDE','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011214279V808123','705125555',null,null,0,0,null,'M5555',0,'mpisynch0017',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31903,'DANA','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011215143V516641','705143334',null,null,0,0,null,'M3334',0,'mpisynch0035',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31905,'DAVE','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-12','DD-MON-RR'),'1011214288V496329','705126666',null,null,0,0,null,'M6666',0,'mpisynch0019',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31907,'Daymon','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011226368V585705','708020148',null,null,0,0,null,'M0148',0,'mpisynch0220',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31909,'DEREK','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011214497V556487','705124445',null,null,0,0,null,'M4445',0,'mpisynch0025',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31911,'DIAMOND','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011216205V240441','705162223',null,null,0,0,null,'M2223',0,'mpisynch0058',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31913,'DIRK','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011217850V760785','706114444',null,null,0,0,null,'M4444',0,'mpisynch0090',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31915,'DMITRI','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011217848V996367','706113333',null,null,0,0,null,'M3333',0,'mpisynch0088',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31917,'DOC','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011217843V111824','706111111',null,null,0,0,null,'M1111',0,'mpisynch0086',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31919,'DOM','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011218495V625794','708020017',null,null,0,0,null,'M0017',0,'mpisynch0124',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31921,'DONALD','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011226068V899232','708020135',null,null,0,0,null,'M0135',0,'mpisynch0208',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31923,'DORY','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011218556V614489','708020039',null,null,0,0,null,'M0039',0,'mpisynch0140',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31925,'DRAKE','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011214143V229067','705112223',null,null,0,0,null,'M2223',0,'mpisynch0007',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31927,'EARL','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-08','DD-MON-RR'),'1011214162V761114','705115556',null,null,0,0,null,'M5556',0,'mpisynch0013',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32043,'NORBIT','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011218559V808058','708020041',null,null,0,0,null,'M0041',0,'mpisynch0141',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32045,'NORBIT','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011218563V511658','708020044',null,null,0,0,null,'M0044',0,'mpisynch0146',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32047,'Null','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011218482V685676','708020010',null,null,0,0,null,'M0010',0,'mpisynch0119',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32049,'Ollie','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011217864V668237','706111010',null,null,0,0,null,'M1010',0,'mpisynch0098',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32051,'OPIE','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011214294V603381','705127778',null,null,0,0,null,'M7778',0,'mpisynch0020',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32053,'Oscar','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011218882V504005','708020060',null,null,0,0,null,'M0060',0,'mpisynch0159',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32055,'OWEN','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011213989V940461','705238889',null,null,0,0,null,'M8889',0,'mpisynch0006',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32057,'PAULA','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011216070V444006','705155556',null,null,0,0,null,'M5556',0,'mpisynch0049',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32059,'PITT','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011226051V490256','708020120',null,null,0,0,null,'M0120',0,'mpisynch0199',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32061,'Plaxico','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011218562V868766','708020043',null,null,0,0,null,'M0043',0,'mpisynch0145',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32063,'POLLY','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011217526V342980','707115555',null,null,0,0,null,'M5555',0,'mpisynch0075',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32065,'RAMBO','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011217861V124148','706119999',null,null,0,0,null,'M9999',0,'mpisynch0096',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32067,'RENA','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011216229V181291','705169990',null,null,0,0,null,'M9990',0,'mpisynch0065',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32069,'RICH','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011218548V871139','708020031',null,null,0,0,null,'M0031',0,'mpisynch0135',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32071,'       ','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011218888V665164','708020066',null,null,0,0,null,'M0066',0,'mpisynch0163',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32073,'SADE','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011217522V531305','707114444',null,null,0,0,null,'M4444',0,'mpisynch0074',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32075,'SALLY','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011216065V271919','705153333',null,null,0,0,null,'M3333',0,'mpisynch0045',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32077,'San','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011218352V666253','708010019',null,null,0,0,null,'M0019',0,'mpisynch0113',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32079,'SCOOBY','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011218542V192073','708020025',null,null,0,0,null,'M0025',0,'mpisynch0131',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32081,'SCRAPPY','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011218546V769791','708020029',null,null,0,0,null,'M0029',0,'mpisynch0133',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32083,'SETH','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011226175V561539','708020141',null,null,0,0,null,'M0141',0,'mpisynch0212',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32085,'SETH','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('07-JUL-77','DD-MON-RR'),'1011226176V217964','011111111',null,null,0,0,null,'M1111',0,'mpisynch0213',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32087,'SHREK','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011218551V297975','708020034',null,null,0,0,null,'M0034',0,'mpisynch0136',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32089,'SLADE','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011217855V089279','706116666',null,null,0,0,null,'M6666',0,'mpisynch0092',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32091,'TAMMY','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011216223V732856','705165555',null,null,0,0,null,'M5555',0,'mpisynch0062',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32093,'TAYE','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011214501V795888','705136666',null,null,0,0,null,'M6666',0,'mpisynch0026',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32095,'TestBlankSSN','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('15-APR-20','DD-MON-RR'),'1011217877V600064','100127738',null,null,0,0,null,'M7738',0,'blankssn',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32097,'TestRegBlankSSN','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('22-NOV-60','DD-MON-RR'),'1011217876V445239','100083877',null,null,0,0,null,'M3877',0,'testblankssn',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32099,'Tito','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011217543V982786','707222222',null,null,0,0,null,'M2222',0,'mpisynch0084',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32101,'Tony','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011197048V646651','705233333',null,null,0,0,null,'M3333',0,'mpisynch0001',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32103,'TRACE','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011226065V646143','708020132',null,null,0,0,null,'M0132',0,'mpisynch0207',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32021,'LIZ','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011217535V252877','707119999',null,null,0,0,null,'M9999',0,'mpisynch0080',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32023,'MARCEL','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011217852V876162','706115555',null,null,0,0,null,'M5555',0,'mpisynch0091',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32025,'MARIO','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011226053V756573','708020122',null,null,0,0,null,'M0122',0,'mpisynch0200',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32027,'MARLA','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011216231V056640','705161313',null,null,0,0,null,'M1313',0,'mpisynch0067',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32029,'Marlon','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011217542V700894','707221111',null,null,0,0,null,'M1111',0,'mpisynch0083',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32031,'MARY','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011215167V642474','705142345',null,null,0,0,null,'M2345',0,'mpisynch0043',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32033,'MEL','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011218327V498627','708010003',null,null,0,0,null,'M0003',0,'mpisynch0102',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32035,'Michelle','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('28-SEP-73','DD-MON-RR'),'1011218922V078703','708020074',null,null,0,0,null,'M0074',0,'mpisynch0169',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32037,'MICKEY','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011226070V563911','708020136',null,null,0,0,null,'M0136',0,'mpisynch0209',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32039,'MINU','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011226061V037919','708020128',null,null,0,0,null,'M0128',0,'mpisynch0204',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32041,'NEMO','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011218554V332641','708020037',null,null,0,0,null,'M0037',0,'mpisynch0139',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31578,'Teddy','MHVRXCKS','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('19-NOV-77','DD-MON-RR'),'1011119048V350090','101010125',null,null,0,0,null,'M0125',0,'refill424',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31580,'Carol','MHVRXCKSON','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('24-NOV-64','DD-MON-RR'),'1011119058V102602','101010131',null,null,0,0,null,'M0131',0,'refill430',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31582,'Carl','MHVRXDERSON','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('04-FEB-42','DD-MON-RR'),'1011118969V707342','101010109',null,null,0,0,null,'M0109',0,'refill408',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31584,'Henry','MHVRXEL','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('11-AUG-64','DD-MON-RR'),'1011118963V256964','101010104',null,null,0,0,null,'M0104',0,'refill402',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31586,'Boyd','MHVRXENS','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('19-JAN-36','DD-MON-RR'),'1011119075V652239','101010138',null,null,0,0,null,'M0138',0,'refill437',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31588,'STEVEN','MHVRXEX','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('15-DEC-75','DD-MON-RR'),'1011118967V478105',null,null,null,0,0,null,'MNULL',0,'refill406',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31590,'Abe','MHVRXFOUR','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('26-JUN-47','DD-MON-RR'),'1011191192V027720','301010174',null,null,0,0,null,'M0174',0,'refill482',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31592,'Ace','MHVRXFOUR','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('26-SEP-57','DD-MON-RR'),'1011196803V365683','100081893',null,null,0,0,null,'M1893',0,'refill505',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31594,'Adam','MHVRXFOUR','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('26-JUN-47','DD-MON-RR'),'1011191018V698229','201010174',null,null,0,0,null,'M0174',0,'refill478',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31596,'Aj','MHVRXFOUR','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('13-AUG-10','DD-MON-RR'),'1011193810V061038','100108782',null,null,0,0,null,'M8782',0,'refill497',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31598,'Alex','MHVRXFOUR','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('26-JUN-47','DD-MON-RR'),'1011190670V384766','101010174',null,null,0,0,null,'M0174',0,'refill474',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31600,'Alvin','MHVRXFOUR','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('12-SEP-31','DD-MON-RR'),'1011196274V239892','100082259',null,null,0,0,null,'M2259',0,'refill499',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31602,'Arthur','MHVRXFOUR','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('15-JAN-60','DD-MON-RR'),'1011192859V801655','100038610',null,null,0,0,null,'M8610',0,'refill493',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31604,'Ashton','MHVRXFOUR','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('26-SEP-57','DD-MON-RR'),'1011215933V300143','101081894',null,null,0,0,null,'M1894',0,'refill509',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31606,'Four','MHVRXFOUR','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('30-JAN-37','DD-MON-RR'),'1011226423V542348','100133890',null,null,0,0,null,'M3890',0,'mhvrxfour',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31608,'Lee','MHVRXFOUR','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011196419V044407','101120372',null,null,0,0,null,'M0372',0,'refill501',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31610,'Ralph','MHVRXICK','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-53','DD-MON-RR'),'1011119196V468612','101010168',null,null,0,0,null,'M0168',0,'refill467',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31612,'Kevin','MHVRXILLIPS','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('17-FEB-31','DD-MON-RR'),'1011119079V579873','101010141',null,null,0,0,null,'M0141',0,'refill440',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31614,'Larry','MHVRXIN','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('21-MAY-77','DD-MON-RR'),'1011119030V950578','101010119',null,null,0,0,null,'M0119',0,'refill418',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31616,'Alice','MHVRXKER','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('19-OCT-60','DD-MON-RR'),'1011118972V965342','101010111',null,null,0,0,null,'M0111',0,'refill410',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31618,'Glenn','MHVRXKINS','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('09-JUN-59','DD-MON-RR'),'1011118971V737427','101010110',null,null,0,0,null,'M0110',0,'refill409',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31620,'AL','MHVRXLER','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('09-SEP-79','DD-MON-RR'),'1011119173V500349','101010159',null,null,0,0,null,'M0159',0,'refill458',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31622,'Rose','MHVRXLL','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('30-MAR-42','DD-MON-RR'),'1011119049V432589','101010126',null,null,0,0,null,'M0126',0,'refill425',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (44197,'TESTSIX','MHVJBTESTSIX','0',4,null,0,1,to_date('23-SEP-11','DD-MON-RR'),to_date('23-SEP-11','DD-MON-RR'),to_date('15-MAY-64','DD-MON-RR'),'1012593374V012672','705071281',null,null,2,0,null,'M1281',0,'testerjb6',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (44235,'TESTONE','MHVMKTESTONE','0',1,null,212,1,to_date('23-SEP-11','DD-MON-RR'),to_date('23-SEP-11','DD-MON-RR'),to_date('08-SEP-73','DD-MON-RR'),'1012645181V279895','705071380',null,null,0,0,to_date('25-SEP-11','DD-MON-RR'),'M1380',0,'testermk04',null,null,to_timestamp('13-MAR-12 05.30.03.768000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (44241,'TESTFIVE','MHVMKTESTFIVE','0',1,'johnnie.boyett@domain',65,1,to_date('23-SEP-11','DD-MON-RR'),to_date('23-SEP-11','DD-MON-RR'),to_date('15-DEC-65','DD-MON-RR'),'1012645185V495450','705071392',null,null,1,0,to_date('14-MAR-12','DD-MON-RR'),'M1392',0,'testermk01',null,null,to_timestamp('16-MAR-12 10.32.47.441000000 AM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (45023,'Rajesh','M','2',0,null,54,1,to_date('28-SEP-11','DD-MON-RR'),to_date('28-SEP-11','DD-MON-RR'),null,null,null,null,null,0,0,null,null,0,'servermanivr',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (45226,'TESTTHREE','MHVMKTESTTHREE','0',1,'johnnie.boyette@domain',21,1,to_date('28-SEP-11','DD-MON-RR'),to_date('28-SEP-11','DD-MON-RR'),to_date('02-OCT-78','DD-MON-RR'),'1012645183V101632','705071390',null,null,2,0,to_date('30-SEP-11','DD-MON-RR'),'M1390',0,'testermk03',null,null,to_timestamp('09-NOV-11 01.23.16.499000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (45256,'TESTSEVEN','MHVMKTESTSEVEN','0',1,null,35,1,to_date('29-SEP-11','DD-MON-RR'),to_date('29-SEP-11','DD-MON-RR'),to_date('08-APR-61','DD-MON-RR'),'1012645188V936006','705071395',null,null,2,0,to_date('29-SEP-11','DD-MON-RR'),'M1395',0,'testermk05',null,null,to_timestamp('14-MAR-12 09.23.18.633000000 AM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (45337,'teste','mhvjteste','0',1,'Johnnie.Boyette@domain',170,1,to_date('29-SEP-11','DD-MON-RR'),to_date('29-SEP-11','DD-MON-RR'),to_date('01-MAY-32','DD-MON-RR'),'1011231189V935260','705070005',null,null,2,0,to_date('13-MAR-12','DD-MON-RR'),'m0005',0,'testere',null,null,to_timestamp('12-MAR-12 08.49.38.542000000 AM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (45861,'TESTTEN','MHVMKTESTTEN','0',1,'johnnie.boyette@domain',20,1,to_date('30-SEP-11','DD-MON-RR'),to_date('30-SEP-11','DD-MON-RR'),to_date('26-MAR-59','DD-MON-RR'),'1012645449V374172','705071403',null,null,2,0,to_date('04-OCT-11','DD-MON-RR'),'M1403',0,'testermk07',null,null,to_timestamp('06-MAR-12 05.17.01.049000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (46643,'PAMELA','HALL','1',1,'Pamela.Hall@domain',1,1,to_date('05-OCT-11','DD-MON-RR'),to_date('05-OCT-11','DD-MON-RR'),null,null,null,'989','33877',1,0,to_date('05-OCT-11','DD-MON-RR'),null,0,'vahrchallpa',null,1,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (48046,'BRUCE','HALL','1',1,'Bruce.Hall@domain',0,1,to_date('26-OCT-11','DD-MON-RR'),to_date('26-OCT-11','DD-MON-RR'),null,null,null,'989','12159',1,0,null,null,0,'VHASYRHALLB',null,1,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (48313,'TESTSIX','MHVMKTESTSIX','0',3,null,2,1,to_date('09-NOV-11','DD-MON-RR'),to_date('09-NOV-11','DD-MON-RR'),to_date('28-APR-71','DD-MON-RR'),'1012645187V752274','705071393',null,null,2,0,null,'M1393',0,'testermk02',null,null,to_timestamp('09-NOV-11 01.22.42.542000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (46664,'SHIRLEY','HAAS','1',1,'shirley.haas@domain',0,1,to_date('06-OCT-11','DD-MON-RR'),to_date('06-OCT-11','DD-MON-RR'),null,null,null,'989','33849',1,0,null,null,0,'vahrchaassh',null,1,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (46665,'ANN','MARTIN','1',1,'ann.martin@domain',0,1,to_date('06-OCT-11','DD-MON-RR'),to_date('06-OCT-11','DD-MON-RR'),null,null,null,'989','33804',1,0,null,null,0,'vahrcmartia',null,3,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (48345,'USERONE','MHVNEW','0',3,'syamala.pakalapati@domain',8,1,to_date('10-NOV-11','DD-MON-RR'),to_date('10-NOV-11','DD-MON-RR'),to_date('12-DEC-60','DD-MON-RR'),'1012645453V784871','705059812',null,null,2,0,null,'M9812',0,'mhvnewps1',null,null,to_timestamp('06-MAR-12 05.22.45.905000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (48449,'LISA','MHVLHONE','0',3,null,2,1,to_date('29-NOV-11','DD-MON-RR'),to_date('29-NOV-11','DD-MON-RR'),to_date('12-FEB-68','DD-MON-RR'),'1012645558V638206','705063874',null,null,2,0,null,'M3874',0,'mhvnewlh1',null,null,to_timestamp('29-NOV-11 01.43.10.926000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (48555,'Harry','Potter','0',3,null,0,1,to_date('12-DEC-11','DD-MON-RR'),to_date('12-DEC-11','DD-MON-RR'),to_date('05-DEC-08','DD-MON-RR'),'456789132456789','123456777',null,null,2,0,null,'P6777',0,'Potter',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (48864,'TESTTWO','MHVALAROBTWO','0',1,null,3,1,to_date('28-DEC-11','DD-MON-RR'),to_date('28-DEC-11','DD-MON-RR'),to_date('11-JAN-52','DD-MON-RR'),'1012645345V176469','578787880',null,null,2,0,null,'M7880',0,'mhvalarob2',null,null,to_timestamp('28-DEC-11 10.08.01.572000000 AM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (75297,'TESTTEN','MHVMKTESTTEN','0',1,'johnnie.boyette@domain',6,1,to_date('31-JAN-12','DD-MON-RR'),to_date('31-JAN-12','DD-MON-RR'),to_date('10-SEP-25','DD-MON-RR'),'1012647166V920526','705071518',null,null,2,0,null,'M1518',0,'testmk10',null,null,to_timestamp('31-JAN-12 12.56.36.600000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32105,'TRACY','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011215161V529595','705147777',null,null,0,0,null,'M7777',0,'mpisynch0039',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32107,'Trice','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('04-APR-50','DD-MON-RR'),'1011218625V851514','100092241',null,null,0,0,null,'M2241',0,'refill502',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32109,'Troy','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011197050V650037','705234444',null,null,0,0,null,'M4444',0,'mpisynch0002',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32111,'TWEEDY','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011226384V792685','708020150',null,null,0,0,null,'M0150',0,'mpisynch0221',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32113,'VAL','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011218325V103873','708010001',null,null,0,0,null,'M0001',0,'mpisynch0101',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32115,'VELMA','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011218544V454927','708020027',null,null,0,0,null,'M0027',0,'mpisynch0132',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32117,'VIN','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011218493V381920','708020015',null,null,0,0,null,'M0015',0,'mpisynch0123',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32119,'VON','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011218473V966372','708020004',null,null,0,0,null,'M0004',0,'mpisynch0115',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32121,'WHOOPI','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011218583V039849','708020045',null,null,0,0,null,'M0045',0,'mpisynch0147',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32123,'WILLIE','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011226063V310706','708020131',null,null,0,0,null,'M0131',0,'mpisynch0205',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32125,'Yasmine','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('03-MAR-24','DD-MON-RR'),'1011217808V338125','100152859',null,null,0,0,null,'M2859',0,'mpisynch0085',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32127,'YURI','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011218536V581944','708020023',null,null,0,0,null,'M0023',0,'mpisynch0129',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32129,'Zan','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011218534V949000','708020022',null,null,0,0,null,'M0022',0,'mpisynch0128',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32131,'ADATEST','MHVSYSTESTADA','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('18-JUN-60','DD-MON-RR'),'1011196888V152165','722222027',null,null,0,0,null,'M2027',0,'systestada',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32133,'TESTAH','MHVSYSTESTAH','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('08-MAR-30','DD-MON-RR'),'1011164175V898024','333330108',null,null,0,0,null,'M0108',0,'mhvsystestah',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32135,'TESTAI','MHVSYSTESTAI','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('09-MAR-30','DD-MON-RR'),'1011182083V283524','333330109',null,null,0,0,null,'M0109',0,'mhvsystestai',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32137,'TESTAK','MHVSYSTESTAK','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('11-MAR-30','DD-MON-RR'),'1011186065V053612','333330111',null,null,0,0,null,'M0111',0,'mhvsystestak',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32139,'TESTAL','MHVSYSTESTAL','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('12-MAR-30','DD-MON-RR'),'1011186066V139171','333330112',null,null,0,0,null,'M0112',0,'mhvsystestal',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32141,'TESTAM','MHVSYSTESTAM','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('13-MAR-30','DD-MON-RR'),'1011186067V368400','333330113',null,null,0,0,null,'M0113',0,'mhvsystestam',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32143,'TESTAP','MHVSYSTESTAP','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('16-MAR-30','DD-MON-RR'),'1011186325V613586','333330116',null,null,0,0,null,'M0116',0,'mhvsystestap',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32145,'testarrick','mhvsystestarrick','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('12-MAR-69','DD-MON-RR'),'1011186414V468256','212040118',null,null,0,0,null,'M0118',0,'systestar01',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32147,'TESTAS','MHVSYSTESTAS','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('19-MAR-30','DD-MON-RR'),'1011186415V611018','333330119',null,null,0,0,null,'M0119',0,'mhvsystestas',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32149,'TESTAT','MHVSYSTESTAT','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('20-MAR-30','DD-MON-RR'),'1011186416V777573','333330120',null,null,0,0,null,'M0120',0,'mhvsystestat',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32151,'TESTAU','MHVSYSTESTAU','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('21-MAR-30','DD-MON-RR'),'1011186418V800827','333330121',null,null,0,0,null,'M0121',0,'mhvsystestau',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32153,'TESTAV','MHVSYSTESTAV','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('22-MAR-30','DD-MON-RR'),'1011186417V945905','333330122',null,null,0,0,null,'M0122',0,'mhvsystestav',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32155,'TESTBA','MHVSYSTESTBA','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-MAR-30','DD-MON-RR'),'1011194838V876049','333330201',null,null,0,0,null,'M0201',0,'mhvsystestba',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32157,'TESTCA','MHVSYSTESTCA','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('18-JUN-60','DD-MON-RR'),'1011195058V134721','707771001',null,null,0,0,null,'M1001',0,'systestca',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32159,'cq','mhvsystestcq','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('08-NOV-70','DD-MON-RR'),'1011214947V171595','231456459',null,null,0,0,null,'M6459',0,'mhvsystestcq',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32161,'Null','MHVSYSTESTDG','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('18-JUN-60','DD-MON-RR'),'1011214190V522286','721602207',null,null,0,0,null,'M2207',0,'systestdg',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32163,'TESTDH','MHVSYSTESTDH','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('18-JUN-60','DD-MON-RR'),'1011214233V885257','721602208',null,null,0,0,null,'M2208',0,'systestdh',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32165,'TESTDI','MHVSYSTESTDI','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('18-JUN-60','DD-MON-RR'),'1011214234V590012','721602209',null,null,0,0,null,'M2209',0,'systestdi',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32167,'TESTDK','MHVSYSTESTDK','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('18-JUN-60','DD-MON-RR'),'1011214236V056900','721602211',null,null,0,0,null,'M2211',0,'systestdk',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32169,'Null','MHVSYSTESTDL','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('18-JUN-60','DD-MON-RR'),'1011214271V297397','721602212',null,null,0,0,null,'M2212',0,'systestdl',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32171,'TESTDM','MHVSYSTESTDM','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('18-JUN-60','DD-MON-RR'),'1011214272V025282','721602213',null,null,0,0,null,'M2213',0,'systestdm',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32173,'TESTDO','MHVSYSTESTDO','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('18-JUN-60','DD-MON-RR'),'1011214998V418153','721602215',null,null,0,0,null,'M2215',0,'systestdo',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32175,'TESTDP','MHVSYSTESTDP','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('18-JUN-60','DD-MON-RR'),'1012580968V389600','721602216',null,null,0,0,null,'M2216',0,'dougtestdp',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32177,'Null','MHVSYSTESTDT','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('18-JUN-59','DD-MON-RR'),'1011217171V846047','721602220',null,null,0,0,null,'M2220',0,'systestdt',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32179,'appt','mhvsystestfirstlogin','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('07-AUG-79','DD-MON-RR'),'1011217323V844705','705031235',null,null,0,0,null,'M1235',0,'systest1appt',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32181,'chem','mhvsystestfirstlogin','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('07-AUG-79','DD-MON-RR'),'1011217324V503627','705031234',null,null,0,0,null,'M1234',0,'systest1chem',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32183,'TESTIB','MHVSYSTESTIB','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('18-JUN-60','DD-MON-RR'),'1011195811V432924','721600102',null,null,0,0,null,'M0102',0,'dupicnib1',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32185,'TESTIC','MHVSYSTESTIC','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('18-JUN-60','DD-MON-RR'),'1011195814V973683','721600103',null,null,0,0,null,'M0103',0,'dupicnic3',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32187,'TESTID','MHVSYSTESTID','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('18-JUN-60','DD-MON-RR'),'1011195817V281352','721600104',null,null,0,0,null,'M0104',0,'dupicnid4',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32189,'TESTIE','MHVSYSTESTIE','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('18-JUN-60','DD-MON-RR'),'1011195823A000001','721600105',null,null,0,0,null,'M0105',0,'dupicnie',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32191,'TESTIZ','MHVSYSTESTIZ','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('18-JUN-60','DD-MON-RR'),'1011195862V200494','721600126',null,null,0,0,null,'M0126',0,'systestiz',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32193,'Gary','MHVSYSTESTRX','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011216353V605461','705164455',null,null,0,0,null,'M4455',0,'mhvsystestrx',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32195,'AL','MHVTENGA','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-10','DD-MON-RR'),'1011231547V858404','708020164',null,null,0,0,null,'M0164',0,'mpisynch0230',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32197,'Alvin','MHVTENGAA','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-10','DD-MON-RR'),'1011231558V729911','708020170',null,null,0,0,null,'M0170',0,'mpisynch0233',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32199,'All','MHVTENGAAA','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-10','DD-MON-RR'),'1011231583V819927','708020172',null,null,0,0,null,'M0172',0,'mpisynch0234',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32201,'BILL','MHVTENGB','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-10','DD-MON-RR'),'1011231551V567624','708020166',null,null,0,0,null,'M0166',0,'mpisynch0231',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32203,'Bob','MHVTENGBB','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-10','DD-MON-RR'),'1011231585V241791','708020174',null,null,0,0,null,'M0174',0,'mpisynch0235',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32205,'CAL','MHVTENGCC','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-10','DD-MON-RR'),'1011231586V007680','708020175',null,null,0,0,null,'M0175',0,'mpisynch0236',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32207,'Cal','MHVTENGCC','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-10','DD-MON-RR'),'1011231587V185139','708020176',null,null,0,0,null,'M0176',0,'mpisynch0237',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32209,'Ed','MHVTENGE','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-10','DD-MON-RR'),'1011231593V948253','708020180',null,null,0,0,null,'M0180',0,'mpisynch0300',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32211,'FRED','MHVTENGF','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-10','DD-MON-RR'),'1011231595V587577','708020181',null,null,0,0,null,'M0181',0,'mpisynch0301',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32213,'GIL','MHVTENGG','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-10','DD-MON-RR'),'1011231597V020821','708020183',null,null,0,0,null,'M0183',0,'mpisynch0302',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32215,'Gil','MHVTENGG','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-10','DD-MON-RR'),'1011231598V152740','708020184',null,null,0,0,null,'M0184',0,'mpisynch0303',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32217,'Hal','MHVTENGH','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-10','DD-MON-RR'),'1011231609V244132','708020186',null,null,0,0,null,'M0186',0,'mpisynch0304',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32219,'IAN','MHVTENGI','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-10','DD-MON-RR'),'1011231610V880055','708020187',null,null,0,0,null,'M0187',0,'mpisynch0305',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32221,'JACK','MHVTENGJ','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-10','DD-MON-RR'),'1011231612V226972','708020189',null,null,0,0,null,'M0189',0,'mpisynch0306',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32223,'Jack','MHVTENGJ','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-10','DD-MON-RR'),'1011231613V054801','708020190',null,null,0,0,null,'M0190',0,'mpisynch0307',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32225,'KEN','MHVTENGK','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-10','DD-MON-RR'),'1011231615V369649','708020191',null,null,0,0,null,'M0191',0,'mpisynch0308',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32227,'Les','MHVTENGL','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-10','DD-MON-RR'),'1011231617V671486','708020193',null,null,0,0,null,'M0193',0,'mpisynch0309',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32229,'MEL','MHVTENGM','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-10','DD-MON-RR'),'1011231619V905263','708020195',null,null,0,0,null,'M0195',0,'mpisynch0310',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32231,'NICK','MHVTENGN','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-10','DD-MON-RR'),'1011231636V395509','708020197',null,null,0,0,null,'M0197',0,'mpisynch0312',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32233,'VK','MHVTEST','0',1,'KAMAL@VA.ORG',4,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('14-OCT-36','DD-MON-RR'),'1012580955V113401','111223336',null,null,0,0,null,'M3336',0,'mhvtestvkone',null,null,to_timestamp('06-FEB-11 01.53.24.988000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32235,'VKTWO','MHVTEST','0',1,'KAMAL@VA.ORG',4,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('17-SEP-27','DD-MON-RR'),'1012581010V180539','111223337',null,null,0,0,null,'M3337',0,'mhvtestvktwo',null,null,to_timestamp('06-FEB-11 01.54.24.119000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32237,'Scooby','MHVTESTCR','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('03-MAR-33','DD-MON-RR'),'1011213873V907665','705098765',null,null,0,0,null,'M8765',0,'testcr3438',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32239,'Al','MHVTESTEDAT','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011217188V331759','701202020',null,null,0,0,null,'M2020',0,'mpitestedat',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32241,'APPTMK','MHVTESTER','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('31-DEC-70','DD-MON-RR'),'1012580908V922539','100858585',null,null,0,0,null,'M8585',0,'mhvapptmk1',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32243,'APPTMKFOUR','MHVTESTER','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('30-DEC-70','DD-MON-RR'),'1012581001V589205','100929385',null,null,0,0,null,'M9385',0,'mhvapptmk4',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32245,'APPTMKTHREE','MHVTESTER','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('30-DEC-70','DD-MON-RR'),'1012580988V067917','100929384',null,null,0,0,null,'M9384',0,'mhvapptmk3',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32247,'APPTMKTWO','MHVTESTER','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('30-DEC-70','DD-MON-RR'),'1012580981V442620','100292827',null,null,0,0,null,'M2827',0,'mhvapptmk2',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32249,'TESTADMIN A','MHVTESTER','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('30-DEC-70','DD-MON-RR'),'1011229720V098994','101606060',null,null,0,0,null,'M6060',0,'mhvtestermk4',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32251,'TESTIPA','MHVTESTER','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('31-DEC-70','DD-MON-RR'),'1011169131V880493','101909090',null,null,0,0,null,'M9090',0,'mhvtestermk1',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32253,'TESTIPAA','MHVTESTER','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('31-DEC-70','DD-MON-RR'),'1011169129V050387','101808080',null,null,0,0,null,'M8080',0,'mhvtestermk2',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32255,'TESTIPAC','MHVTESTER','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('31-DEC-70','DD-MON-RR'),'1011192189V719951','101505050',null,null,0,0,null,'M5050',0,'mhvtestermk5',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32257,'TEST','MHVTESTSSN','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011215927V238919','666554444',null,null,0,0,null,'M4444',0,'testssn',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32259,'TESTONE','MHVTESTSSN','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011215930V211874','710010001',null,null,0,0,null,'M0001',0,'testssnone',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32261,'TESTRH','MhvTR','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-60','DD-MON-RR'),'1012581385V934537','705070123',null,null,0,0,null,'M0123',0,'testerwf',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32263,'Mark','MHVTWOHUNDREDESR','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('02-FEB-22','DD-MON-RR'),'1011192328V206700','704984444',null,null,0,0,null,'M4444',0,'twohunesr3',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32265,'Ed','MHVUNKNOWNRX','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('02-JAN-23','DD-MON-RR'),'1007109192V902232','101366577',null,null,0,0,null,'M6577',0,'mhvunknownrx',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32267,'Liz','MHVUNKNOWNRX','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('11-AUG-70','DD-MON-RR'),'1001709261V614637','101978044',null,null,0,0,null,'M8044',0,'mhvunknownb',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32269,'ENKA','MHVV','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-OCT-30','DD-MON-RR'),'1011169117V659068','100929292',null,null,0,0,null,'M9292',0,'mhvvenka',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (33413,'TESTU','MHVJTESTU','0',1,null,3,1,to_date('30-SEP-10','DD-MON-RR'),to_date('30-SEP-10','DD-MON-RR'),to_date('09-MAY-55','DD-MON-RR'),'1011231767V700681','705070048',null,null,2,0,null,'M0048',0,'testeru',null,null,to_timestamp('30-SEP-10 01.56.50.096000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (34333,'Null','Two','0',1,'william.mccarty@domain',3,1,to_date('04-OCT-10','DD-MON-RR'),to_date('04-OCT-10','DD-MON-RR'),to_date('15-JUN-11','DD-MON-RR'),'6580051335V383903','223456789',null,null,2,0,null,'T6789',0,'test12',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (35382,'Rajesh','Manivasagam','1',1,'Rajesh.Manivasagam@domain',198,1,to_date('08-OCT-10','DD-MON-RR'),to_date('08-OCT-10','DD-MON-RR'),null,null,null,'989','35279',1,0,to_date('14-MAR-12','DD-MON-RR'),null,1,'VHASTXBERNHD',null,1,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (35383,'TWO','MHVSYSTESTTWO','1',1,'foo@foo.com',78,1,to_date('08-OCT-10','DD-MON-RR'),to_date('08-OCT-10','DD-MON-RR'),null,null,null,'989','35280',1,0,to_date('18-JAN-12','DD-MON-RR'),null,1,'mhvtest1',null,2,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (35384,'Rajesh','M','1',1,'foo@foo.com',69,1,to_date('08-OCT-10','DD-MON-RR'),to_date('08-OCT-10','DD-MON-RR'),null,null,null,'989','35281',1,0,to_date('13-JAN-12','DD-MON-RR'),null,1,'servermanivr',null,3,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (35679,'TESTINP','MHVJTESTINP','0',3,null,0,1,to_date('18-OCT-10','DD-MON-RR'),to_date('18-OCT-10','DD-MON-RR'),to_date('15-MAR-55','DD-MON-RR'),'1012590796V258483','705072354',null,null,2,0,null,'M2354',0,'testerinp',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (35960,'TESTRB','MHVSYSTESTRA','0',1,'joe.joe@bol.com',116,1,to_date('19-OCT-10','DD-MON-RR'),to_date('19-OCT-10','DD-MON-RR'),to_date('30-JUN-60','DD-MON-RR'),'1012590883V134940','705072059',null,null,2,0,to_date('16-DEC-10','DD-MON-RR'),'M2059',0,'testersysa',null,null,to_timestamp('18-NOV-10 12.26.26.464000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (36861,'BEN','VARGAS','0',3,null,2,1,to_date('08-NOV-10','DD-MON-RR'),to_date('08-NOV-10','DD-MON-RR'),to_date('15-MAY-63','DD-MON-RR'),'1012585544V618696','796118533',null,null,2,0,null,'V8533',0,'bvargas1',null,null,to_timestamp('08-NOV-10 02.18.34.995000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (38328,'Muazzam','Khan','2',0,null,11,1,to_date('08-DEC-10','DD-MON-RR'),to_date('08-DEC-10','DD-MON-RR'),null,null,null,null,null,0,0,null,null,0,'serverkhanm',null,null,null,1);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (38265,'TESTP','MHVJTESTP','0',3,null,0,1,to_date('30-NOV-10','DD-MON-RR'),to_date('30-NOV-10','DD-MON-RR'),to_date('17-MAY-50','DD-MON-RR'),'1011231941V604872','705070067',null,null,2,0,null,'M0067',0,'testerp',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (38346,'Madhu','Thanvi','2',0,null,22,1,to_date('08-DEC-10','DD-MON-RR'),to_date('08-DEC-10','DD-MON-RR'),null,null,null,null,null,0,0,null,null,0,'serverthanvm',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (38349,'Madhu','Kantheti','2',0,null,2,1,to_date('08-DEC-10','DD-MON-RR'),to_date('08-DEC-10','DD-MON-RR'),null,null,null,null,null,0,0,null,null,0,'serverkanthm',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (38673,'Johnnie','Boyette','2',0,null,814,1,to_date('14-DEC-10','DD-MON-RR'),to_date('14-DEC-10','DD-MON-RR'),null,null,null,null,null,0,0,null,null,0,'serverboyetj',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (38779,'Susan','Woods','2',0,null,6,1,to_date('21-DEC-10','DD-MON-RR'),to_date('21-DEC-10','DD-MON-RR'),null,null,null,null,null,0,0,null,null,0,'vhaporwoodss',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (38781,'David','Douglas','2',0,null,10,1,to_date('21-DEC-10','DD-MON-RR'),to_date('21-DEC-10','DD-MON-RR'),null,null,null,null,null,0,0,null,null,0,'vhapordougld1',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (38803,'JELUAHT','ATEKN','0',1,null,3,1,to_date('22-DEC-10','DD-MON-RR'),to_date('22-DEC-10','DD-MON-RR'),to_date('17-JUN-36','DD-MON-RR'),'1012588773V037033','101166460',null,null,2,0,null,'A6460',0,'mhvbb003',null,null,to_timestamp('22-DEC-10 08.10.28.542000000 AM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (39155,'ONE','MHVVETERAN','0',1,'mhvveteran@emailaddress.com',10,1,to_date('06-JAN-11','DD-MON-RR'),to_date('06-JAN-11','DD-MON-RR'),to_date('01-MAR-48','DD-MON-RR'),'1012589299V580235','705072053',null,null,2,0,null,'M2053',0,'mhvvet',null,null,to_timestamp('13-JAN-11 10.46.46.251000000 AM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (39164,'Donna','Whitehead','2',0,null,2,1,to_date('07-JAN-11','DD-MON-RR'),to_date('07-JAN-11','DD-MON-RR'),null,null,null,null,null,0,0,null,null,0,'vhaislwhited',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (39559,'TESTACB','MHVJTESTAC','0',1,null,3,1,to_date('27-JAN-11','DD-MON-RR'),to_date('27-JAN-11','DD-MON-RR'),to_date('01-NOV-62','DD-MON-RR'),'1011231945V551494','705070072',null,null,2,0,null,'M0072',0,'testerabc',null,null,to_timestamp('27-JAN-11 03.50.59.088000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (39606,'Kathleen','Painter','2',0,null,6,1,to_date('30-JAN-11','DD-MON-RR'),to_date('30-JAN-11','DD-MON-RR'),null,null,null,null,null,0,0,null,null,0,'vhamocpaintk',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (39608,'Kathleen','Charters','2',0,null,2,1,to_date('30-JAN-11','DD-MON-RR'),to_date('30-JAN-11','DD-MON-RR'),null,null,null,null,null,0,0,null,null,0,'serverchartk',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (40014,'Kenneth','Graham','2',0,null,1,1,to_date('10-FEB-11','DD-MON-RR'),to_date('10-FEB-11','DD-MON-RR'),null,null,null,null,null,0,0,null,null,0,'servergrahak',null,null,null,1);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (40131,'TESTTWO','MHVSPTESTTWO','0',4,null,0,1,to_date('22-FEB-11','DD-MON-RR'),to_date('22-FEB-11','DD-MON-RR'),to_date('15-AUG-52','DD-MON-RR'),'1012592581V884047','705071243',null,null,2,0,null,'M1243',0,'testerapp5',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (40041,'Hermione','Granger','0',3,'william.mccarty@domain',6,1,to_date('16-FEB-11','DD-MON-RR'),to_date('16-FEB-11','DD-MON-RR'),to_date('17-FEB-11','DD-MON-RR'),'11111119234','111119234',null,null,2,0,null,'G9234',0,'granger',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (40134,'TESTTHREE','MHVSPTESTTHREE','0',1,'joe.test@test.com',4,1,to_date('22-FEB-11','DD-MON-RR'),to_date('22-FEB-11','DD-MON-RR'),to_date('01-JAN-62','DD-MON-RR'),'1012592656V426655','705071244',null,null,2,0,null,'M1244',0,'testerapp6',null,null,to_timestamp('22-FEB-11 12.27.00.477000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (40808,'TESTONE','MHVSBTESTONE','0',1,null,3,1,to_date('08-MAR-11','DD-MON-RR'),to_date('08-MAR-11','DD-MON-RR'),to_date('07-JUN-42','DD-MON-RR'),'1012592715V353288','705071247',null,null,2,0,null,'M1247',0,'satishsyst',null,null,to_timestamp('08-MAR-11 12.32.22.053000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (40995,'Testseven','Mhvjbtestseven','0',1,'foo@foo.com',76,1,to_date('31-MAR-11','DD-MON-RR'),to_date('31-MAR-11','DD-MON-RR'),to_date('09-MAR-12','DD-MON-RR'),'1012593387V162271','705071284',null,null,2,0,to_date('03-NOV-11','DD-MON-RR'),'M1284',0,'testerjb7',null,null,to_timestamp('09-MAR-12 02.51.57.043000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (41018,'Testnine','Mhvjbtestnine','0',1,'joe.test@domain',22,1,to_date('01-APR-11','DD-MON-RR'),to_date('01-APR-11','DD-MON-RR'),to_date('31-JAN-12','DD-MON-RR'),'1011231189V935265','705070006',null,null,2,0,null,'M0006',0,'testerjb9',null,null,to_timestamp('31-JAN-12 12.42.29.373000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (41360,'TESTONE','MHVRFTESTONE','0',1,'walter.fatzinger@domain',9,1,to_date('18-APR-11','DD-MON-RR'),to_date('18-APR-11','DD-MON-RR'),to_date('16-NOV-65','DD-MON-RR'),'1012593636V894377','258852258',null,null,2,0,null,'M2258',0,'mhvrf01',null,null,to_timestamp('18-APR-11 01.01.50.218000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (41466,'UserFThree','UserLThree','1',1,'foo@foo.com',2,1,to_date('27-APR-11','DD-MON-RR'),to_date('27-APR-11','DD-MON-RR'),null,null,null,'989','5692',1,0,null,null,1,'VHADAYBACHEC',null,1,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (41474,'TestFName','TestLName','1',1,'Test@test.com',0,1,to_date('05-MAY-11','DD-MON-RR'),to_date('05-MAY-11','DD-MON-RR'),null,null,null,'994','23243',0,0,null,null,0,'user41474',null,1,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (41475,'TestFName','TestLName','1',1,'Test@test.com',0,1,to_date('05-MAY-11','DD-MON-RR'),to_date('05-MAY-11','DD-MON-RR'),null,null,null,'994','23245',0,0,null,null,0,'user41474',null,1,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (42101,'UserFOne','UserLOne','1',1,'Darlinda.      @domain',1,1,to_date('27-MAY-11','DD-MON-RR'),to_date('27-MAY-11','DD-MON-RR'),null,null,null,'989','2977',1,0,null,null,0,'VHADAYTURNED',null,1,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (42102,'UserFFour','UserLFour','1',1,'foo@foo.com',2,1,to_date('27-MAY-11','DD-MON-RR'),to_date('27-MAY-11','DD-MON-RR'),null,null,null,'989','33746',1,0,null,null,0,'VHADAYBLACKB',null,1,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (42129,'TestThree','Mhvchemlabtestthree','0',1,'joe.test@domain',37,1,to_date('01-JUN-11','DD-MON-RR'),to_date('01-JUN-11','DD-MON-RR'),to_date('31-JAN-12','DD-MON-RR'),'1011218157V958875','710988777',null,null,2,0,to_date('11-JAN-12','DD-MON-RR'),'M8777',0,'testercl3',null,null,to_timestamp('31-JAN-12 12.42.03.169000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (42131,'TestTwo','Mhvchemlabtesttwo','0',1,'joe.test@domain',21,1,to_date('01-JUN-11','DD-MON-RR'),to_date('01-JUN-11','DD-MON-RR'),to_date('09-MAR-12','DD-MON-RR'),'1012638698V344915','705071308',null,null,2,0,to_date('11-JAN-12','DD-MON-RR'),'M1308',0,'testercl2',null,null,to_timestamp('09-MAR-12 02.51.49.661000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (42219,'TESTFIVE','MHVSYSTESTFIVE','0',3,'syamala.pakalapati@domain',6,1,to_date('02-JUN-11','DD-MON-RR'),to_date('02-JUN-11','DD-MON-RR'),to_date('01-JUN-62','DD-MON-RR'),'1012593745V582809','705064557',null,null,2,0,null,'M4557',0,'mhvsystest5',null,null,to_timestamp('04-FEB-12 06.17.25.991000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (42408,'Satish','Bhamidipaty','2',0,null,1,1,to_date('14-JUN-11','DD-MON-RR'),to_date('14-JUN-11','DD-MON-RR'),null,null,null,null,null,0,0,null,null,0,'serverbhamis',null,null,null,1);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (42418,'test','mhvwellrem','0',4,null,0,1,to_date('14-JUN-11','DD-MON-RR'),to_date('14-JUN-11','DD-MON-RR'),to_date('13-MAR-26','DD-MON-RR'),'1011217966V301917','710020001',null,null,2,0,null,'m0001',0,'mhvwellrem',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (42420,'test','mhvwellremaa','0',4,null,0,1,to_date('14-JUN-11','DD-MON-RR'),to_date('14-JUN-11','DD-MON-RR'),to_date('29-OCT-63','DD-MON-RR'),'1011220075V557641','704058888',null,null,2,0,null,'m8888',0,'wellremaa',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (42422,'test','mhvwellremb','0',4,null,0,1,to_date('14-JUN-11','DD-MON-RR'),to_date('14-JUN-11','DD-MON-RR'),to_date('03-JUN-29','DD-MON-RR'),'1011217969V720620','710020003',null,null,2,0,null,'m0003',0,'mhvwellremb',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (42424,'test','mhvwellremc','0',4,null,0,1,to_date('14-JUN-11','DD-MON-RR'),to_date('14-JUN-11','DD-MON-RR'),to_date('18-JUL-43','DD-MON-RR'),'1011217970V665397','710020004',null,null,2,0,null,'m0004',0,'mhvwellremc',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (42426,'test','mhvwellremd','0',4,null,0,1,to_date('14-JUN-11','DD-MON-RR'),to_date('14-JUN-11','DD-MON-RR'),to_date('30-NOV-18','DD-MON-RR'),'1011218003V419045','710020010',null,null,2,0,null,'m0010',0,'mhvwellremd',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (42428,'test','mhvwellreme','0',4,null,0,1,to_date('14-JUN-11','DD-MON-RR'),to_date('14-JUN-11','DD-MON-RR'),to_date('13-NOV-53','DD-MON-RR'),'1011217973V846560','710020006',null,null,2,0,null,'m0006',0,'mhvwellreme',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (42430,'test','mhvwellremf','0',4,null,0,1,to_date('14-JUN-11','DD-MON-RR'),to_date('14-JUN-11','DD-MON-RR'),to_date('05-AUG-30','DD-MON-RR'),'1011217976V099776','710020007',null,null,2,0,null,'m0007',0,'mhvwellremf',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (42432,'test','mhvwellremg','0',4,null,0,1,to_date('14-JUN-11','DD-MON-RR'),to_date('14-JUN-11','DD-MON-RR'),to_date('17-AUG-62','DD-MON-RR'),'1011217977V128608','710020008',null,null,2,0,null,'m0008',0,'mhvwellremg',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (42434,'test','mhvwellremh','0',4,null,0,1,to_date('14-JUN-11','DD-MON-RR'),to_date('14-JUN-11','DD-MON-RR'),to_date('01-MAR-59','DD-MON-RR'),'1011217978V351123','710020009',null,null,2,0,null,'m0009',0,'mhvwellremh',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (42436,'test','mhvwrapb','0',4,null,0,1,to_date('14-JUN-11','DD-MON-RR'),to_date('14-JUN-11','DD-MON-RR'),to_date('29-OCT-51','DD-MON-RR'),'1012580958V601094','700010002',null,null,2,0,null,'m0002',0,'mhvwrap2',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (42438,'test','mhvwrapc','0',4,null,0,1,to_date('14-JUN-11','DD-MON-RR'),to_date('14-JUN-11','DD-MON-RR'),to_date('13-MAY-52','DD-MON-RR'),'1012580959V787586','700010003',null,null,2,0,null,'m0003',0,'mhvwrap3',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (42440,'test','mhvwraph','0',4,null,0,1,to_date('14-JUN-11','DD-MON-RR'),to_date('14-JUN-11','DD-MON-RR'),to_date('14-JUN-30','DD-MON-RR'),'1011167870V871880','700010008',null,null,2,0,null,'m0008',0,'mhvwrap8',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (42442,'test','mhvwrapi','0',4,null,0,1,to_date('14-JUN-11','DD-MON-RR'),to_date('14-JUN-11','DD-MON-RR'),to_date('26-DEC-57','DD-MON-RR'),'1012580965V276957','700010009',null,null,2,0,null,'m0009',0,'mhvwrap9',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (42444,'test','mhvwrapj','0',4,null,0,1,to_date('14-JUN-11','DD-MON-RR'),to_date('14-JUN-11','DD-MON-RR'),to_date('08-AUG-23','DD-MON-RR'),'1011169936V636464','700010010',null,null,2,0,null,'m0010',0,'mhvwrap10',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (42446,'test','mhvwrapk','0',4,null,0,1,to_date('14-JUN-11','DD-MON-RR'),to_date('14-JUN-11','DD-MON-RR'),to_date('08-APR-53','DD-MON-RR'),'1012580964V512565','700010011',null,null,2,0,null,'m0011',0,'mhvwrap11',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (42448,'test','mhvwrapl','0',4,null,0,1,to_date('14-JUN-11','DD-MON-RR'),to_date('14-JUN-11','DD-MON-RR'),to_date('28-SEP-28','DD-MON-RR'),'1012580962V935288','700010012',null,null,2,0,null,'m0012',0,'mhvwrap12',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (42450,'test','mhvwrapm','0',4,null,0,1,to_date('14-JUN-11','DD-MON-RR'),to_date('14-JUN-11','DD-MON-RR'),to_date('09-MAR-49','DD-MON-RR'),'1012580963V860033','700010013',null,null,2,0,null,'m0013',0,'mhvwrap13',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (42452,'wella','mhvwrmk','0',4,null,0,1,to_date('14-JUN-11','DD-MON-RR'),to_date('14-JUN-11','DD-MON-RR'),to_date('30-DEC-70','DD-MON-RR'),'1012581146V898222','100928365',null,null,2,0,null,'m8365',0,'mhvwrmk1',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (42454,'wellc','mhvwrmk','0',4,null,0,1,to_date('14-JUN-11','DD-MON-RR'),to_date('14-JUN-11','DD-MON-RR'),to_date('28-DEC-70','DD-MON-RR'),'1012581181V441958','100928372',null,null,2,0,null,'m8372',0,'mhvwrmk3',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (42568,'Test','Three','0',1,null,1,1,to_date('15-JUN-11','DD-MON-RR'),to_date('15-JUN-11','DD-MON-RR'),to_date('15-JUN-11','DD-MON-RR'),'1003521967V296296','323456789',null,null,2,0,null,'T6789',0,'test13',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (42589,'RMTESTEIGHT','MHVRMTESTEIGHT','0',4,null,0,1,to_date('16-JUN-11','DD-MON-RR'),to_date('16-JUN-11','DD-MON-RR'),to_date('24-DEC-57','DD-MON-RR'),'1012644025V962074','707071330',null,null,2,0,null,'M1330',0,'testermr6',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (42591,'RMTESTFIVE','MHVRMTESTFIVE','0',4,null,0,1,to_date('16-JUN-11','DD-MON-RR'),to_date('16-JUN-11','DD-MON-RR'),to_date('31-MAY-79','DD-MON-RR'),'1012644020V188687','705071327',null,null,2,0,null,'M1327',0,'testermr3',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (42593,'RMTESTFOUR','MHVRMTESTFOUR','0',4,null,0,1,to_date('16-JUN-11','DD-MON-RR'),to_date('16-JUN-11','DD-MON-RR'),to_date('22-FEB-62','DD-MON-RR'),'1012644019V943850','705071326',null,null,2,0,null,'M1326',0,'testermr2',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (42595,'RMTESTNINE','MHVRMTESTNINE','0',4,null,0,1,to_date('16-JUN-11','DD-MON-RR'),to_date('16-JUN-11','DD-MON-RR'),to_date('05-NOV-58','DD-MON-RR'),'1012644024V730219','705071331',null,null,2,0,null,'M1331',0,'testermr7',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (42597,'TESTONE','MHVRMTESTONE','0',4,null,0,1,to_date('16-JUN-11','DD-MON-RR'),to_date('16-JUN-11','DD-MON-RR'),to_date('28-JUN-48','DD-MON-RR'),'1012592673V223511','705071245',null,null,2,0,null,'M1245',0,'testerapp7',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (42599,'TESTONE','MHVRMTESTONE','0',4,null,0,1,to_date('16-JUN-11','DD-MON-RR'),to_date('16-JUN-11','DD-MON-RR'),to_date('24-AUG-62','DD-MON-RR'),'1012593329V843764','705071274',null,null,2,0,null,'M1274',0,'testerm1',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (42601,'RMTESTSEVEN','MHVRMTESTSEVEN','0',4,null,0,1,to_date('16-JUN-11','DD-MON-RR'),to_date('16-JUN-11','DD-MON-RR'),to_date('24-APR-54','DD-MON-RR'),'1012644022V427461','707971329',null,null,2,0,null,'M1329',0,'testermr5',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (42603,'RMTESTSIX','MHVRMTESTSIX','0',4,null,0,1,to_date('16-JUN-11','DD-MON-RR'),to_date('16-JUN-11','DD-MON-RR'),to_date('24-JUL-74','DD-MON-RR'),'1012644021V391132','705071328',null,null,2,0,null,'M1328',0,'testermr4',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (42605,'RMTESTTEN','MHVRMTESTTEN','0',4,null,0,1,to_date('16-JUN-11','DD-MON-RR'),to_date('16-JUN-11','DD-MON-RR'),to_date('17-MAR-48','DD-MON-RR'),'1012644026V816506','705071332',null,null,2,0,null,'M1332',0,'testermr8',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (42607,'TESTTHREE','MHVSMTESTTHREE','0',4,null,0,1,to_date('16-JUN-11','DD-MON-RR'),to_date('16-JUN-11','DD-MON-RR'),to_date('19-APR-64','DD-MON-RR'),'1012644013V027428','705071314',null,null,2,0,null,'M1314',0,'testermr9',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (42609,'TESTTWO','MHVSMTESTTWO','0',4,null,0,1,to_date('16-JUN-11','DD-MON-RR'),to_date('16-JUN-11','DD-MON-RR'),to_date('05-JUL-50','DD-MON-RR'),'1012644006V985199','705071313',null,null,2,0,null,'M1313',0,'testermr10',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (42611,'RMTESTTWO','MHVRMTESTTWO','0',4,null,0,1,to_date('16-JUN-11','DD-MON-RR'),to_date('16-JUN-11','DD-MON-RR'),to_date('26-JUL-49','DD-MON-RR'),'1012644018V774961','705071324',null,null,2,0,null,'M1324',0,'testermr1',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (42723,'Tester','Tester_One','1',1,'syamala.pakalapati@domain',14,1,to_date('17-JUN-11','DD-MON-RR'),to_date('17-JUN-11','DD-MON-RR'),null,null,null,'989','35285',1,0,to_date('14-OCT-11','DD-MON-RR'),null,1,'serverpakals',null,3,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (43139,'MHVMPI','MHVMPIRF','0',1,'john.test@domain',6,1,to_date('21-JUN-11','DD-MON-RR'),to_date('21-JUN-11','DD-MON-RR'),to_date('02-JUL-64','DD-MON-RR'),'1012644138V101394','100056566',null,null,2,0,null,'M6566',0,'testercl5',null,null,to_timestamp('24-JUN-11 12.04.17.194000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (43146,'ROBERTA','SAXBE','1',1,'Roberta.Saxbe@domain',0,0,to_date('21-JUN-11','DD-MON-RR'),to_date('21-JUN-11','DD-MON-RR'),null,null,null,'989','28707',1,0,null,null,0,'vhadaysaxber',null,1,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (43353,'SYAMALA','PAKALAPATI','1',1,'Syamala.Pakalapati@domain',0,1,to_date('23-JUN-11','DD-MON-RR'),to_date('23-JUN-11','DD-MON-RR'),null,null,null,'979','59855',1,0,null,null,1,'serverpakals',null,3,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (43461,'MHVPDAADLZ','MHVASPXXI','0',1,'dummy@foo.com',72,1,to_date('24-JUN-11','DD-MON-RR'),to_date('24-JUN-11','DD-MON-RR'),to_date('01-DEC-55','DD-MON-RR'),'1012588770V899444','101074332',null,null,2,0,null,'M4332',0,'mhvbb001',null,null,to_timestamp('16-MAR-12 10.30.56.819000000 AM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (43469,'MHVMPI','MHVMPIRF','0',1,'joe.test@msn.com',8,1,to_date('24-JUN-11','DD-MON-RR'),to_date('24-JUN-11','DD-MON-RR'),to_date('01-JAN-64','DD-MON-RR'),'1012644140V321744','258258721',null,null,2,0,null,'M8721',0,'testercl6',null,null,to_timestamp('30-JUN-11 03.33.20.405000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32305,'Carl','MHVWRBMI','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('14-SEP-50','DD-MON-RR'),'1011218296V672713','100089027',null,null,0,0,null,'M9027',0,'mhvwrbmi',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32307,'Chance','MHVWRCCS','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('25-SEP-24','DD-MON-RR'),'1011218289V536681','100102491',null,null,0,0,null,'M2491',0,'mhvwrccs',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32309,'Bill','MHVWRCHOL','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('29-APR-59','DD-MON-RR'),'1011218290V599341','100021001',null,null,0,0,null,'M1001',0,'mhvwrchol',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32311,'Will','MHVWRFLU','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('23-MAY-24','DD-MON-RR'),'1011218292V051089','100068907',null,null,0,0,null,'M8907',0,'mhvwrflu',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32313,'Bo','MHVWRLIP','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('19-JUL-72','DD-MON-RR'),'1011218293V137534','100080491',null,null,0,0,null,'M0491',0,'mhvwrlip',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32315,'Jane','MHVWRMAMM','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-44','DD-MON-RR'),'1011218291V228290','100043719',null,null,0,0,null,'M3719',0,'mhvwrmamm',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (43747,'JOHN','UATLASTNAME','0',1,'    .Hall4@domain',5,1,to_date('01-JUL-11','DD-MON-RR'),to_date('01-JUL-11','DD-MON-RR'),to_date('09-MAR-69','DD-MON-RR'),'1012644233V660775','705069132',null,null,2,0,null,'U9132',0,'uatacct1',null,null,to_timestamp('01-JUL-11 09.18.48.720000000 AM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (43893,'TESTONE','MHVSMTESTONE','0',1,'joe.test@domain',17,1,to_date('07-JUL-11','DD-MON-RR'),to_date('07-JUL-11','DD-MON-RR'),to_date('15-JUL-64','DD-MON-RR'),'1012644333V897692','705071329',null,null,2,0,to_date('11-JAN-12','DD-MON-RR'),'M1329',0,'testersm16',null,null,to_timestamp('07-JUL-11 05.44.27.320000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32321,'WELLE','MHVWRMK','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('26-DEC-70','DD-MON-RR'),'1012581183V785775','100928377',null,null,0,0,null,'M8377',0,'mhvwrmk5',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32323,'WELLDCWY','MHVWRMRK','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('27-DEC-70','DD-MON-RR'),'1012581182V607813','100928371',null,null,0,0,null,'M8371',0,'mhvwrmk4',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32325,'Jim','MHVWRPNEU','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JUL-28','DD-MON-RR'),'1011218297V746675','100171501',null,null,0,0,null,'M1501',0,'mhvwrpneu',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32327,'TESTB','MHYJTESTB','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('23-MAR-45','DD-MON-RR'),'1011231137V259847','705070002',null,null,0,0,null,'M0002',0,'testerj',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32329,'KING','MHVSYS','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-10','DD-MON-RR'),'1012581143V644113','708020241',null,null,0,0,null,'M0241',0,'mpisynch0341',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32331,'JAY','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011214149V742146','705110011',null,null,0,0,null,'M0011',0,'mpisynch0009',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32333,'TESTIE','MHVSYSTESTIE','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('18-JUN-60','DD-MON-RR'),'1011195823V349670','721600105',null,null,0,0,null,'M0105',0,'dupicnie5',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32335,'TconeD','MPIPATSIXNIN','0',1,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('04-APR-70','DD-MON-RR'),'1011214257V297367','666030673',null,null,0,0,null,'M0673',0,'mpipatsixnin',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32967,'TESTONE','MHVATEST','0',2,null,1,1,to_date('29-SEP-10','DD-MON-RR'),to_date('29-SEP-10','DD-MON-RR'),to_date('21-AUG-73','DD-MON-RR'),'1012589468V509842','705072057',null,null,2,0,null,'M2057',0,'mhvveta',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (33950,'Kenneth','Graham','1',1,'Kamaleswar.Venkata@domain',1,0,to_date('01-OCT-10','DD-MON-RR'),to_date('01-OCT-10','DD-MON-RR'),null,null,null,'989','35269',1,0,null,null,1,'servergrahak',null,1,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (37393,'Jaime','Nasuti','2',0,null,26,1,to_date('12-NOV-10','DD-MON-RR'),to_date('12-NOV-10','DD-MON-RR'),null,null,null,null,null,0,0,null,null,0,'vhamocnasutj',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (38232,'testq','mhvjtestq','0',1,'henry.joh@aol.com',4,1,to_date('30-NOV-10','DD-MON-RR'),to_date('30-NOV-10','DD-MON-RR'),to_date('20-FEB-50','DD-MON-RR'),'1011231942V783701','705070068',null,null,2,0,null,'m0068',0,'testerq',null,null,to_timestamp('30-NOV-10 12.05.05.854000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (40058,'TESTONE','MHVJTEST','0',4,null,0,1,to_date('17-FEB-11','DD-MON-RR'),to_date('17-FEB-11','DD-MON-RR'),to_date('02-JUN-47','DD-MON-RR'),'1012585926V389094','705058990',null,null,2,0,null,'M8990',0,'testera2',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (40833,'OLIVIA','MHVSMFOUR','0',1,null,25,1,to_date('09-MAR-11','DD-MON-RR'),to_date('09-MAR-11','DD-MON-RR'),to_date('18-JUN-60','DD-MON-RR'),'1011214434V974891','721607604',null,null,2,0,null,'M7604',0,'secure04',null,null,to_timestamp('28-JUN-11 11.28.32.212000000 AM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (41044,'Testeight','Mhvjbtesteight','0',1,null,167,1,to_date('04-APR-11','DD-MON-RR'),to_date('04-APR-11','DD-MON-RR'),to_date('14-MAR-12','DD-MON-RR'),'1012593389V474529','705071285',null,null,2,0,to_date('07-MAR-12','DD-MON-RR'),'M1285',0,'testerjb8',null,null,to_timestamp('14-MAR-12 09.29.49.583000000 AM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (41150,'SMTESTONE','MHVSYSTESTSMONE','0',3,null,2,1,to_date('13-APR-11','DD-MON-RR'),to_date('13-APR-11','DD-MON-RR'),to_date('22-JAN-62','DD-MON-RR'),'1012593782V805911','705071302',null,null,2,0,null,'M1302',0,'testersm1',null,null,to_timestamp('13-APR-11 09.01.24.245000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (41381,'TESTTHREE','MHVRFTESTTHREE','0',0,'red@rum.com',4,1,to_date('18-APR-11','DD-MON-RR'),to_date('18-APR-11','DD-MON-RR'),to_date('16-NOV-67','DD-MON-RR'),'1012593714V758415','258852260',null,null,2,0,null,'M2260',0,'mhvrf03',null,null,to_timestamp('18-APR-11 02.31.42.708000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (41438,'ROBERTA','SAXBE','1',1,'Roberta.Saxbe@domain',1,0,to_date('20-APR-11','DD-MON-RR'),to_date('20-APR-11','DD-MON-RR'),null,null,null,'989','123456000',1,0,null,null,0,'abcxyz112',null,1,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (41478,'MICHAEL','KEEVICAN','1',1,'Michael.Keevican@domain',147,1,to_date('11-MAY-11','DD-MON-RR'),to_date('11-MAY-11','DD-MON-RR'),null,null,null,'989','35270',1,0,to_date('13-MAR-12','DD-MON-RR'),null,1,'serverkeevim',null,1,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (41492,'CHEMTESTONE','MHVCHEMLABTESTONE','0',1,'joe.test@domain',203,1,to_date('11-MAY-11','DD-MON-RR'),to_date('11-MAY-11','DD-MON-RR'),to_date('19-FEB-55','DD-MON-RR'),'1012593917V121937','705071305',null,null,2,0,to_date('11-JAN-12','DD-MON-RR'),'M1305',0,'testercl1',null,null,to_timestamp('04-FEB-12 06.18.50.250000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (42124,'MHVSM','SMOKEPATIENT','0',1,null,1,1,to_date('01-JUN-11','DD-MON-RR'),to_date('01-JUN-11','DD-MON-RR'),to_date('01-JUN-11','DD-MON-RR'),'1011218157V958875','710988777',null,null,2,0,null,'S8777',0,'smsmoke1',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (44042,'teste','mhvjteste','0',1,'william.mccarty@domain',511,1,to_date('13-JUL-11','DD-MON-RR'),to_date('13-JUL-11','DD-MON-RR'),to_date('13-JUL-11','DD-MON-RR'),'1011231189V935260','705070005',null,null,0,0,null,'m0005',0,'zztestere',null,null,to_timestamp('13-JUL-11 12.51.22.000000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (44043,'TESTCAL','MHVJCAL','0',1,'foo@foo.com',511,1,to_date('13-JUL-11','DD-MON-RR'),to_date('13-JUL-11','DD-MON-RR'),to_date('13-JUL-11','DD-MON-RR'),'1011231486V374711','705070025',null,null,0,0,null,'M0025',0,'testercal',null,null,to_timestamp('13-JUL-11 12.53.19.000000000 PM','DD-MON-RR HH.MI.SS.FF AM'),0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31929,'ELLE','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011218341V699807','708010011',null,null,0,0,null,'M0011',0,'mpisynch0107',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31931,'ERIC','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011214248V138170','705122223',null,null,0,0,null,'M2223',0,'mpisynch0016',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31933,'Gerald','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011218878V218735','708020057',null,null,0,0,null,'M0057',0,'mpisynch0156',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31935,'GIM','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011218475V573020','708020005',null,null,0,0,null,'M0005',0,'mpisynch0116',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31937,'GINA','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011215140V755975','705142222',null,null,0,0,null,'M2222',0,'mpisynch0033',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31939,'Gino','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011226075V485498','708020138',null,null,0,0,null,'M0138',0,'mpisynch0211',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31941,'GLENDA','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011216060V626495','705151111',null,null,0,0,null,'M1111',0,'mpisynch0047',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31943,'GWEN','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011216195V935658','705161111',null,null,0,0,null,'M1111',0,'mpisynch0057',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31945,'Han','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011218349V304513','708010017',null,null,0,0,null,'M0017',0,'mpisynch0111',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31947,'HAROLD','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011217845V445698','706112222',null,null,0,0,null,'M2222',0,'mpisynch0087',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31949,'HARRY','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011214296V998069','705128889',null,null,0,0,null,'M8889',0,'mpisynch0021',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31951,'HILDA','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011216227V249427','705168888',null,null,0,0,null,'M8888',0,'mpisynch0064',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31953,'Hilton','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011218895V293177','708020073',null,null,0,0,null,'M0073',0,'mpisynch0168',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31955,'Holly','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('04-APR-57','DD-MON-RR'),'1011218577V821718','100063450',null,null,0,0,null,'M3450',0,'refill500',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31957,'HOLLY','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011217528V684764','707116666',null,null,0,0,null,'M6666',0,'mpisynch0076',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31959,'Ike','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011218344V837190','708010013',null,null,0,0,null,'M0013',0,'mpisynch0109',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31961,'Irvin','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011218892V942868','708020070',null,null,0,0,null,'M0070',0,'mpisynch0165',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31963,'IVY','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011216233V363484','705161515',null,null,0,0,null,'M1515',0,'mpisynch0069',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31965,'JAC','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011218484V922423','708020011',null,null,0,0,null,'M0011',0,'mpisynch0120',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31967,'Jac','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011218485V856345','708020012',null,null,0,0,null,'M0012',0,'mpisynch0121',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31969,'James','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011214282V868933','705124444',null,null,0,0,null,'M4444',0,'mpisynch0018',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31971,'Jay','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011214148V670624','705110011',null,null,0,0,null,'M0011',0,'mpisynch0008',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31973,'Jayson','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011226364V619064','708020144',null,null,0,0,null,'M0144',0,'mpisynch0216',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31975,'JEFF','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011210637V715285','705237778',null,null,0,0,null,'M7778',0,'mpisynch0005',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31977,'JEN','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011216225V814673','705167777',null,null,0,0,null,'M7777',0,'mpisynch0063',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31979,'Jermaine','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011217541V645949','707221010',null,null,0,0,null,'M1010',0,'mpisynch0082',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31981,'JEWEL','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011216217V024731','705163333',null,null,0,0,null,'M3333',0,'mpisynch0059',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31983,'Jym','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011218498V866463','708020020',null,null,0,0,null,'M0020',0,'mpisynch0127',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31985,'KAREN','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011215155V786902','705145555',null,null,0,0,null,'M5555',0,'mpisynch0038',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31987,'KATE','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011216068V380628','705154445',null,null,0,0,null,'M4445',0,'mpisynch0048',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31989,'KATT','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011218552V025807','708020035',null,null,0,0,null,'M0035',0,'mpisynch0137',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31991,'KELLY','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011217475V802943','707112222',null,null,0,0,null,'M2222',0,'mpisynch0071',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31993,'KIM','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011215135V468168','705141111',null,null,0,0,null,'M1111',0,'mpisynch0031',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31995,'KIMMY','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011215139V800002','705141114',null,null,0,0,null,'M1114',0,'mpisynch0034',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31997,'KIN','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011218329V757491','708010005',null,null,0,0,null,'M0005',0,'mpisynch0103',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32001,'LAURA','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011216082V601117','705156667',null,null,0,0,null,'M6667',0,'mpisynch0050',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32003,'Leena','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011218590V124738','708020053',null,null,0,0,null,'M0053',0,'mpisynch0154',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32005,'LEN','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011218471V650155','708020001',null,null,0,0,null,'M0001',0,'mpisynch0114',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32007,'LES','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011218331V787940','708010007',null,null,0,0,null,'M0007',0,'mpisynch0105',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32009,'LIAM','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011217857V321526','706117777',null,null,0,0,null,'M7777',0,'mpisynch0094',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32011,'LILLY','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011217477V294787','707113333',null,null,0,0,null,'M3333',0,'mpisynch0072',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32013,'Lim','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011218497V932138','708020019',null,null,0,0,null,'M0019',0,'mpisynch0126',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32015,'LINDA','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011216062V933232','705152222',null,null,0,0,null,'M2222',0,'mpisynch0046',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32017,'LINK','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011214412V990462','705131112',null,null,0,0,null,'M1112',0,'mpisynch0023',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (32019,'LISA','MHVSYSTEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-JAN-11','DD-MON-RR'),'1011215163V031832','705148888',null,null,0,0,null,'M8888',0,'mpisynch0040',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31624,'Leon','MHVRXLLINS','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('27-OCT-63','DD-MON-RR'),'1011119044V508175','101010124',null,null,0,0,null,'M0124',0,'refill423',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31626,'Clay','MHVRXLLY','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('09-JUN-69','DD-MON-RR'),'1011119168V961973','101010154',null,null,0,0,null,'M0154',0,'refill453',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31628,'     ','MHVRXLSON','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('02-NOV-61','DD-MON-RR'),'1011119071V001627','101010135',null,null,0,0,null,'M0135',0,'refill434',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31630,'Andre','MHVRXLTON','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-JAN-55','DD-MON-RR'),'1011118994V963621','101010114',null,null,0,0,null,'M0114',0,'refill413',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31632,'     ','MHVRXLVERT','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('12-JUL-80','DD-MON-RR'),'1011119033V214747','101010120',null,null,0,0,null,'M0120',0,'refill419',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31634,'Jane','MHVRXMPBELL','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('06-FEB-49','DD-MON-RR'),'1011119034V073692','101010121',null,null,0,0,null,'M0121',0,'refill420',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31636,'Brenda','MHVRXNA','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('02-JAN-42','DD-MON-RR'),'1011118959V040921','101010101',null,null,0,0,null,'M0101',0,'refill400',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31638,'    ','MHVRXONE','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('19-JAN-24','DD-MON-RR'),'1011194585V036466','100102019',null,null,0,0,null,'M2019',0,'mhvrxonenick',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31640,'Sal','MHVRXONE','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('07-OCT-46','DD-MON-RR'),'1011196791V834582','100102771',null,null,0,0,null,'M2771',0,'refill506',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31642,'Shane','MHVRXONE','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('28-MAR-14','DD-MON-RR'),'1011193809V627117','100065351',null,null,0,0,null,'M5351',0,'refill494',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31644,'Shawn','MHVRXONE','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('30-JUL-68','DD-MON-RR'),'1011191014V076657','201010170',null,null,0,0,null,'M0170',0,'refill475',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31646,'Slade','MHVRXONE','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('30-JUL-68','DD-MON-RR'),'1011191189V543005','301010170',null,null,0,0,null,'M0170',0,'refill479',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31648,'Sly','MHVRXONE','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('21-APR-12','DD-MON-RR'),'1011192856V613986','100071974',null,null,0,0,null,'M1974',0,'refill490',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31650,'Stan','MHVRXONE','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('30-JUL-68','DD-MON-RR'),'1011190665V531639','101010170',null,null,0,0,null,'M0170',0,'refill471',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31652,'Cecil','MHVRXORE','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('17-MAR-51','DD-MON-RR'),'1011119069V193242','101010133',null,null,0,0,null,'M0133',0,'refill432',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31654,'RUFUS','MHVRXOX','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('09-MAR-64','DD-MON-RR'),'1011119197V611171','101010169',null,null,0,0,null,'M0169',0,'refill468',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31656,'Taylor','MHVRXR','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('09-MAR-72','DD-MON-RR'),'1011119073V395491','101010137',null,null,0,0,null,'M0137',0,'refill436',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31658,'Al','MHVRXREFILL','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-SEP-10','DD-MON-RR'),'1012581025V141454','120111000',null,null,0,0,null,'M1000',0,'rxrefillone',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31660,'Terry','MHVRXREFILL','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('02-FEB-22','DD-MON-RR'),'1011217315V145829','100116134',null,null,0,0,null,'M6134',0,'refill555',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31662,'Tim','MHVRXREFILL','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('02-FEB-22','DD-MON-RR'),'1011217318V696188','100075387',null,null,0,0,null,'M5387',0,'refill556',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31664,'Tom','MHVRXREFILL','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('02-FEB-22','DD-MON-RR'),'1011217321V712918','100049777',null,null,0,0,null,'M9777',0,'refill558',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31666,'Ty','MHVRXREFILL','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('02-FEB-22','DD-MON-RR'),'1011217319V724433','100441234',null,null,0,0,null,'M1234',0,'refill557',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31668,'Al','MHVRXREFONE','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('07-AUG-16','DD-MON-RR'),'1011193425V654515','100033991',null,null,0,0,null,'M3991',0,'refillcr1657',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31670,'Ono','MHVRXREFONE','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('24-JUN-26','DD-MON-RR'),'1011194858V490351','100153331',null,null,0,0,null,'M3331',0,'mhvrxrefono',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31672,'Kyle','MHVRXRGAN','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('22-DEC-43','DD-MON-RR'),'1011119070V248705','101010134',null,null,0,0,null,'M0134',0,'refill433',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31674,'    ','MHVRXRIS','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('03-MAY-55','DD-MON-RR'),'1011119076V736064','101770139',null,null,0,0,null,'M0139',0,'refill438',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31676,'Clara','MHVRXRKER','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('30-JAN-32','DD-MON-RR'),'1011118973V810291','101010112',null,null,0,0,null,'M0112',0,'refill411',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31678,'Jay','MHVRXRONE','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-MAR-47','DD-MON-RR'),'1011219842V252155','100091445',null,null,0,0,null,'M1445',0,'refill559',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31680,'One','MHVRXRONE','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('02-FEB-22','DD-MON-RR'),'1011217539V479499','100991010',null,null,0,0,null,'M1010',0,'mhvrxrone',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31682,'       ','MHVRXRRIS','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('20-MAY-37','DD-MON-RR'),'1011009885V356641','283737373',null,null,0,0,null,'M7373',0,'refill122',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31684,'Rick','MHVRXRROLL','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('14-AUG-52','DD-MON-RR'),'1011119036V308430','101010122',null,null,0,0,null,'M0122',0,'refill421',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31686,'Bob','MHVRXSE','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-FEB-51','DD-MON-RR'),'1011119140V327413','101010148',null,null,0,0,null,'M0148',0,'refill447',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31688,'Earl','MHVRXSH','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('28-APR-38','DD-MON-RR'),'1011119028V246175','101010118',null,null,0,0,null,'M0118',0,'refill417',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31690,'Ella','MHVRXSHOP','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('17-AUG-68','DD-MON-RR'),'1011118995V819140','101010115',null,null,0,0,null,'M0115',0,'refill414',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31692,'Carl','MHVRXTHREE','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('08-SEP-26','DD-MON-RR'),'1011192858V948763','100048277',null,null,0,0,null,'M8277',0,'refill492',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31694,'Chris','MHVRXTHREE','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('26-AUG-65','DD-MON-RR'),'1011190669V342273','101010173',null,null,0,0,null,'M0173',0,'refill473',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31696,'Clay','MHVRXTHREE','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('20-JUN-31','DD-MON-RR'),'1011196802V137798','100163168',null,null,0,0,null,'M3168',0,'refill508',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31698,'     ','MHVRXTHREE','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('26-AUG-65','DD-MON-RR'),'1011191016V303471','201010173',null,null,0,0,null,'M0173',0,'refill477',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31700,'Three','MHVRXTHREE','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('10-FEB-17','DD-MON-RR'),'1011226422V870426','100078791',null,null,0,0,null,'M8791',0,'mhvrxthree',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31702,'Gary','MHVRXTWO','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('23-AUG-18','DD-MON-RR'),'1011191015V144112','201010172',null,null,0,0,null,'M0172',0,'refill476',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31704,'Gene','MHVRXTWO','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('23-AUG-18','DD-MON-RR'),'1011191190V588972','301010172',null,null,0,0,null,'M0172',0,'refill480',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31706,'George','MHVRXTWO','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('09-JUL-28','DD-MON-RR'),'1011192857V779838','100114556',null,null,0,0,null,'M4556',0,'refill491',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31708,'Gil','MHVRXTWO','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('27-NOV-26','DD-MON-RR'),'1011196792V563931','100041913',null,null,0,0,null,'M1913',0,'refill507',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31710,'Glen','MHVRXTWO','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('23-AUG-18','DD-MON-RR'),'1011190666V267164','101010172',null,null,0,0,null,'M0172',0,'refill472',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31712,'Two','MHVRXTWO','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('16-FEB-72','DD-MON-RR'),'1011226421V915104','100091042',null,null,0,0,null,'M1042',0,'mhvrxtwo',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31714,'Armand','MHVRXWMAN','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('16-JUN-37','DD-MON-RR'),'1011192472V895741','101010136',null,null,0,0,null,'M0136',0,'refill435',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31717,'test','mhvsmusera','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('03-SEP-47','DD-MON-RR'),'1011220670V228267','709090909',null,null,0,0,null,'M0909',0,'smusera',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31719,'test','mhvswetesta','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('16-JAN-42','DD-MON-RR'),'1011217753V111135','707047788',null,null,0,0,null,'M7788',0,'swetesta',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31721,'ADAM','MHVSWETHATEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('26-JUN-50','DD-MON-RR'),'1011217613V597315','721250001',null,null,0,0,null,'M0001',0,'swetha1',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31723,'AFOIA','MHVSWETHATEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('14-OCT-76','DD-MON-RR'),'1011171460V471966','721250022',null,null,0,0,null,'M0022',0,'swetha22',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31725,'BFOIA','MHVSWETHATEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('15-OCT-76','DD-MON-RR'),'1011225824V061907','721250023',null,null,0,0,null,'M0023',0,'swetha23',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31727,'BWELL','MHVSWETHATEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('01-OCT-50','DD-MON-RR'),'1011217989V388077','721250009',null,null,0,0,null,'M0009',0,'swetha9',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31729,'CFOIA','MHVSWETHATEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('16-OCT-76','DD-MON-RR'),'1011225825V117822','721250024',null,null,0,0,null,'M0024',0,'swetha24',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31731,'DFOIA','MHVSWETHATEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('17-OCT-76','DD-MON-RR'),'1011225826V375741','721250025',null,null,0,0,null,'M0025',0,'swetha25',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31733,'DWELL','MHVSWETHATEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('03-OCT-76','DD-MON-RR'),'1011217991V459853','721250011',null,null,0,0,null,'M0011',0,'dougtest0',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31735,'EFOIA','MHVSWETHATEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('18-OCT-76','DD-MON-RR'),'1011226355V014704','721250026',null,null,0,0,null,'M0026',0,'swetha26',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31737,'FFOIA','MHVSWETHATEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('19-OCT-76','DD-MON-RR'),'1011226356V173626','721250027',null,null,0,0,null,'M0027',0,'swetha27',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31739,'GFOIA','MHVSWETHATEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('20-OCT-76','DD-MON-RR'),'1011171884V718872','721250028',null,null,0,0,null,'M0028',0,'swetha28',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31741,'HWELL','MHVSWETHATEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('07-OCT-50','DD-MON-RR'),'1011217993V761677','721250015',null,null,0,0,null,'M0015',0,'swetha15',null,null,null,0);
Insert into SMS.SMS_USER (USER_ID,FIRST_NAME,LAST_NAME,USER_TYPE,STATUS,EMAIL_ADDRESS,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,DOB,ICN,SSN,STATION_NO,DUZ,EMAIL_NOTIFICATION,DEFAULT_MESSAGE_FILTER,LAST_EMAIL_NOTIFICATION,NSSN,PROVIDER,EXTERNAL_USER_NAME,MIDDLE_NAME,CLINICAL_USER_TYPE_ID,RELATIONSHIP_UPDATE,NATIONAL) values (31743,'KWELL','MHVSWETHATEST','0',3,null,0,1,to_date('01-JUL-10','DD-MON-RR'),to_date('01-JUL-10','DD-MON-RR'),to_date('19-SEP-23','DD-MON-RR'),'1011218032V537431','721250018',null,null,0,0,null,'M0018',0,'swetha18',null,null,null,0);
-- Unable to render INDEX DDL for object SMS.SMS_USER_02_NUK with DBMS_METADATA attempting internal generator.
CREATE INDEX SMS.SMS_USER_02_NUK ON SMS.SMS_USER (LOWER(LAST_NAME) ASC) 
LOGGING 
TABLESPACE "SM_INDX" 
PCTFREE 10 
INITRANS 2 
STORAGE 
( 
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1 
  MAXEXTENTS 2147483645 
  BUFFER_POOL DEFAULT 
)
-- Unable to render INDEX DDL for object SMS.SMS_USER_UK1 with DBMS_METADATA attempting internal generator.
CREATE UNIQUE INDEX SMS.SMS_USER_UK1 ON SMS.SMS_USER (STATION_NO, DUZ) 
LOGGING 
TABLESPACE "SM_DATA" 
PCTFREE 10 
INITRANS 2 
STORAGE 
( 
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1 
  MAXEXTENTS 2147483645 
  BUFFER_POOL DEFAULT 
)
-- Unable to render INDEX DDL for object SMS.SMS_USER_01_NUK with DBMS_METADATA attempting internal generator.
CREATE INDEX SMS.SMS_USER_01_NUK ON SMS.SMS_USER (CLINICAL_USER_TYPE_ID ASC) 
LOGGING 
TABLESPACE "SM_INDX" 
PCTFREE 10 
INITRANS 2 
STORAGE 
( 
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1 
  MAXEXTENTS 2147483645 
  BUFFER_POOL DEFAULT 
)
-- Unable to render INDEX DDL for object SMS.SMS_USER_03_NUK with DBMS_METADATA attempting internal generator.
CREATE INDEX SMS.SMS_USER_03_NUK ON SMS.SMS_USER (USER_TYPE ASC) 
LOGGING 
TABLESPACE "SM_INDX" 
PCTFREE 10 
INITRANS 2 
STORAGE 
( 
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1 
  MAXEXTENTS 2147483645 
  BUFFER_POOL DEFAULT 
)
-- Unable to render INDEX DDL for object SMS.SYS_C005616 with DBMS_METADATA attempting internal generator.
CREATE INDEX SMS.SYS_C005616 ON ()


