--------------------------------------------------------
--  File created - Monday-March-19-2012   
--------------------------------------------------------
-- Unable to render TABLE DDL for object SMS.SECURE_MESSAGE with DBMS_METADATA attempting internal generator.
COMMENT ON TABLE SMS.SECURE_MESSAGE IS 'The main function of SMS is to produce SecureMessages.  Most of the fields allow for NULL because a message can be saved as a draft at any time during its creation.  A draft SecureMessage may be deleted.  SecureMessages with any other messageStatus than draft must never be deleted.'ALTER TABLE SMS.SECURE_MESSAGE
ADD CONSTRAINT SECURE_MESSAGE_MESSAGE_TH_FK1 FOREIGN KEY
(
  THREAD_ID 
)
REFERENCES SMS.MESSAGE_THREAD
(
  THREAD_ID 
)
ENABLE
ALTER TABLE SMS.SECURE_MESSAGE
ADD CONSTRAINT SECURE_MESSAGE_SMS_USER_FK1 FOREIGN KEY
(
  ASSIGNED_TO 
)
REFERENCES SMS.SMS_USER
(
  USER_ID 
)
ENABLE
ALTER TABLE SMS.SECURE_MESSAGE
ADD CONSTRAINT SECURE_MESSAGE_SMS_USER_FK2 FOREIGN KEY
(
  STATUS_SET_BY 
)
REFERENCES SMS.SMS_USER
(
  USER_ID 
)
ENABLE
CREATE TABLE SMS.SECURE_MESSAGE 
(
  SECURE_MESSAGE_ID NUMBER NOT NULL 
, CLINICIAN_STATUS NUMBER NOT NULL 
, COMPLETED_DATE DATE 
, ASSIGNED_TO NUMBER 
, CHECKSUM CHAR(32 BYTE) 
, THREAD_ID NUMBER NOT NULL 
, STATUS_SET_BY NUMBER 
, OPLOCK NUMBER DEFAULT 0 NOT NULL 
, ACTIVE NUMBER DEFAULT 1 NOT NULL 
, CREATED_DATE DATE DEFAULT SYSDATE NOT NULL 
, MODIFIED_DATE DATE DEFAULT SYSDATE NOT NULL 
, ESCALATED DATE DEFAULT NULL 
, BODY CLOB 
, SENT_DATE DATE 
, SENDER_TYPE NUMBER NOT NULL 
, SENDER_ID NUMBER NOT NULL 
, SENDER_NAME VARCHAR2(100 BYTE) NOT NULL 
, RECIPIENT_TYPE NUMBER 
, RECIPIENT_ID NUMBER 
, RECIPIENT_NAME VARCHAR2(100 BYTE) 
, SENT_DATE_LOCAL DATE 
, ESCALATION_NOTIFICATION_DATE DATE 
, ESCALATION_NOTIFICATION_TRIES NUMBER 
, READ_RECEIPT VARCHAR2(20 BYTE) 
, HAS_ATTACHMENT NUMBER(1, 0) DEFAULT 0 
, ATTACHMENT_ID NUMBER 
, CONSTRAINT SECURE_MESSAGE_PK PRIMARY KEY 
  (
    SECURE_MESSAGE_ID 
  )
  ENABLE 
)
LOGGING 
TABLESPACE "SM_DATA_SYST" 
PCTFREE 10 
INITRANS 1 
STORAGE 
( 
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1 
  MAXEXTENTS 2147483645 
  BUFFER_POOL DEFAULT 
) 
LOB (BODY) STORE AS SYS_LOB0000014987C00013$$ 
( 
  ENABLE STORAGE IN ROW 
  CHUNK 8192 
  PCTVERSION 10 
  NOCACHE 
  LOGGING  
)CREATE INDEX SMS.SECURE_MESSAGE_01_NUK ON SMS.SECURE_MESSAGE (ASSIGNED_TO ASC) 
LOGGING 
TABLESPACE "SM_INDX" 
PCTFREE 10 
INITRANS 2 
STORAGE 
( 
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1 
  MAXEXTENTS 2147483645 
  BUFFER_POOL DEFAULT 
)
CREATE INDEX SMS.SECURE_MESSAGE_02_NUK ON SMS.SECURE_MESSAGE (STATUS_SET_BY ASC) 
LOGGING 
TABLESPACE "SM_INDX" 
PCTFREE 10 
INITRANS 2 
STORAGE 
( 
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1 
  MAXEXTENTS 2147483645 
  BUFFER_POOL DEFAULT 
)
CREATE INDEX SMS.SECURE_MESSAGE_03_NUK ON SMS.SECURE_MESSAGE (THREAD_ID ASC) 
LOGGING 
TABLESPACE "SM_INDX" 
PCTFREE 10 
INITRANS 2 
STORAGE 
( 
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1 
  MAXEXTENTS 2147483645 
  BUFFER_POOL DEFAULT 
)
CREATE UNIQUE INDEX SMS.SECURE_MESSAGE_ID_PK ON SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID ASC) 
LOGGING 
TABLESPACE "SM_DATA" 
PCTFREE 10 
INITRANS 2 
STORAGE 
( 
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1 
  MAXEXTENTS 2147483645 
  BUFFER_POOL DEFAULT 
)COMMENT ON COLUMN SMS.SECURE_MESSAGE.SECURE_MESSAGE_ID IS 'Uniquely identifies the SecureMessage';
COMMENT ON COLUMN SMS.SECURE_MESSAGE.CLINICIAN_STATUS IS 'One of the following values: draft, unread, read, escalated, complete';
COMMENT ON COLUMN SMS.SECURE_MESSAGE.COMPLETED_DATE IS 'The timestamp of when the messageStatus was marked as complete.  This is used to report on response times.';
COMMENT ON COLUMN SMS.SECURE_MESSAGE.ASSIGNED_TO IS 'The SMSUser userId of the person the message is assigned to';
COMMENT ON COLUMN SMS.SECURE_MESSAGE.CHECKSUM IS 'When a message is sent, a checksum is created based on the content of the subjectLine, bodyText, and timestamp.  The purpose of this is to provide message non-repudiability.  The idea is to provide proof that the content of the SecureMessage has not changed since it was sent.  This could be an MD5 checksum or similar mechanism.';
COMMENT ON COLUMN SMS.SECURE_MESSAGE.THREAD_ID IS 'The MessageThread threadId of the MessageThread the SecureMessage is associated with.';
COMMENT ON COLUMN SMS.SECURE_MESSAGE.STATUS_SET_BY IS 'Clinician that last set the status';
COMMENT ON COLUMN SMS.SECURE_MESSAGE.BODY IS 'body of the message';
COMMENT ON COLUMN SMS.SECURE_MESSAGE.READ_RECEIPT IS 'Identify whether health care team member read the message';
COMMENT ON COLUMN SMS.SECURE_MESSAGE.HAS_ATTACHMENT IS 'Identifier used to find out whether message has attachment';
COMMENT ON COLUMN SMS.SECURE_MESSAGE.ATTACHMENT_ID IS 'Identifier used to keep the Attachment Id';
REM INSERTING into SMS.SECURE_MESSAGE
SET DEFINE OFF;
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1051,0,null,null,null,1050,null,0,1,to_date('30-MAY-08','DD-MON-RR'),to_date('30-MAY-08','DD-MON-RR'),null,to_date('30-MAY-08','DD-MON-RR'),2,81,'MHVSMDOCFIVE, SAM',3,979,'SLC10',to_date('30-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1055,0,null,null,null,1054,null,0,1,to_date('30-MAY-08','DD-MON-RR'),to_date('30-MAY-08','DD-MON-RR'),null,to_date('30-MAY-08','DD-MON-RR'),2,81,'MHVSMDOCFIVE, SAM',3,979,'SLC10',to_date('30-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1059,0,null,null,null,1058,null,0,1,to_date('03-JUN-08','DD-MON-RR'),to_date('07-JUN-08','DD-MON-RR'),to_date('07-JUN-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),1,69,'MHVSMTHIRTEEN, GEORGE',3,989,'Dayton 29',to_date('03-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1067,0,null,null,null,1066,null,0,1,to_date('03-JUN-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),null,to_date('03-JUN-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',3,989,'Dayton 29',to_date('03-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1071,0,null,null,null,1070,null,0,1,to_date('03-JUN-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),null,to_date('03-JUN-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',3,989,'Dayton 29',to_date('03-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1075,0,null,null,null,1074,null,0,1,to_date('03-JUN-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),null,to_date('03-JUN-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',3,989,'Dayton 29',to_date('03-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1079,0,null,null,null,1078,null,0,1,to_date('03-JUN-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),null,to_date('03-JUN-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',3,989,'Dayton 29',to_date('03-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1083,0,null,null,null,1082,null,0,1,to_date('03-JUN-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),null,to_date('03-JUN-08','DD-MON-RR'),2,76,'MHVSMDOCTWO, GREG',3,989,'Dayton 29',to_date('03-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1087,0,null,null,null,1086,null,0,1,to_date('03-JUN-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),null,to_date('03-JUN-08','DD-MON-RR'),2,76,'MHVSMDOCTWO, GREG',3,989,'Dayton 29',to_date('03-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1091,0,null,null,null,1090,null,0,1,to_date('03-JUN-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),null,to_date('03-JUN-08','DD-MON-RR'),2,76,'MHVSMDOCTWO, GREG',3,989,'Dayton 29',to_date('03-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1095,0,null,null,null,1094,null,0,1,to_date('03-JUN-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),null,to_date('03-JUN-08','DD-MON-RR'),2,76,'MHVSMDOCTWO, GREG',3,989,'Dayton 29',to_date('03-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1099,0,null,null,null,1098,null,0,1,to_date('03-JUN-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),null,to_date('03-JUN-08','DD-MON-RR'),2,76,'MHVSMDOCTWO, GREG',2,24,'MHVSMDOCONE, MIKE',to_date('03-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1103,20,to_date('03-JUN-08','DD-MON-RR'),null,null,1102,79,1,1,to_date('03-JUN-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),null,to_date('03-JUN-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',to_date('03-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1111,10,null,79,null,1110,79,2,1,to_date('03-JUN-08','DD-MON-RR'),to_date('07-JUN-08','DD-MON-RR'),to_date('07-JUN-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',to_date('03-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1119,0,null,null,null,1102,null,0,1,to_date('03-JUN-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),null,to_date('03-JUN-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',1,29,'MHVSMONE, ALYSSA',to_date('03-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1122,0,null,null,null,1110,null,0,1,to_date('03-JUN-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),null,to_date('03-JUN-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',1,29,'MHVSMONE, ALYSSA',to_date('03-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1126,0,null,null,null,1125,null,0,1,to_date('03-JUN-08','DD-MON-RR'),to_date('07-JUN-08','DD-MON-RR'),to_date('07-JUN-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',to_date('03-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1135,20,to_date('05-JUN-08','DD-MON-RR'),null,null,1134,84,2,1,to_date('04-JUN-08','DD-MON-RR'),to_date('04-JUN-08','DD-MON-RR'),null,to_date('04-JUN-08','DD-MON-RR'),1,51,'MHVSMFOUR, OLIVIA',3,989,'Dayton 29',to_date('04-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1142,0,null,null,null,987,null,0,1,to_date('04-JUN-08','DD-MON-RR'),to_date('10-JUN-08','DD-MON-RR'),to_date('10-JUN-08','DD-MON-RR'),to_date('04-JUN-08','DD-MON-RR'),1,51,'MHVSMFOUR, OLIVIA',3,989,'Dayton 29',to_date('04-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1159,0,null,null,null,1158,null,0,1,to_date('05-JUN-08','DD-MON-RR'),to_date('05-JUN-08','DD-MON-RR'),null,null,2,79,'MHVSMDOCTHREE, PETER',null,null,null,null,null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1162,0,null,null,null,1161,null,0,1,to_date('05-JUN-08','DD-MON-RR'),to_date('11-JUN-08','DD-MON-RR'),to_date('11-JUN-08','DD-MON-RR'),to_date('05-JUN-08','DD-MON-RR'),1,51,'MHVSMFOUR, OLIVIA',3,989,'Dayton 29',to_date('05-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1171,0,null,null,null,1161,null,0,1,to_date('05-JUN-08','DD-MON-RR'),to_date('05-JUN-08','DD-MON-RR'),null,to_date('05-JUN-08','DD-MON-RR'),2,84,'MHVSMSTAFFTHREE, JAN',1,51,'MHVSMFOUR, OLIVIA',to_date('05-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1175,0,null,null,null,1174,null,0,1,to_date('05-JUN-08','DD-MON-RR'),to_date('05-JUN-08','DD-MON-RR'),null,to_date('05-JUN-08','DD-MON-RR'),2,24,'MHVSMDOCONE, MIKE',1,29,'MHVSMONE, ALYSSA',to_date('05-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1178,0,null,null,null,1161,null,0,1,to_date('05-JUN-08','DD-MON-RR'),to_date('05-JUN-08','DD-MON-RR'),null,to_date('05-JUN-08','DD-MON-RR'),2,84,'MHVSMSTAFFTHREE, JAN',1,51,'MHVSMFOUR, OLIVIA',to_date('05-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1219,0,null,null,null,1218,null,0,1,to_date('05-JUN-08','DD-MON-RR'),to_date('05-JUN-08','DD-MON-RR'),null,null,2,79,'MHVSMDOCTHREE, PETER',null,null,null,null,null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1188,20,to_date('16-JUN-08','DD-MON-RR'),24,null,1187,24,2,1,to_date('05-JUN-08','DD-MON-RR'),to_date('11-JUN-08','DD-MON-RR'),to_date('11-JUN-08','DD-MON-RR'),to_date('05-JUN-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',to_date('05-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1199,0,null,null,null,1198,null,0,1,to_date('05-JUN-08','DD-MON-RR'),to_date('11-JUN-08','DD-MON-RR'),to_date('11-JUN-08','DD-MON-RR'),to_date('05-JUN-08','DD-MON-RR'),1,51,'MHVSMFOUR, OLIVIA',3,989,'Dayton 29',to_date('05-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1209,0,null,null,null,1208,null,0,1,to_date('05-JUN-08','DD-MON-RR'),to_date('11-JUN-08','DD-MON-RR'),to_date('11-JUN-08','DD-MON-RR'),to_date('05-JUN-08','DD-MON-RR'),1,51,'MHVSMFOUR, OLIVIA',3,989,'Dayton 29',to_date('05-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1228,0,null,null,null,1227,null,0,1,to_date('05-JUN-08','DD-MON-RR'),to_date('05-JUN-08','DD-MON-RR'),null,to_date('05-JUN-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',1,51,'MHVSMFOUR, OLIVIA',to_date('05-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1231,0,null,null,null,1227,null,0,1,to_date('05-JUN-08','DD-MON-RR'),to_date('11-JUN-08','DD-MON-RR'),to_date('11-JUN-08','DD-MON-RR'),to_date('05-JUN-08','DD-MON-RR'),1,51,'MHVSMFOUR, OLIVIA',3,989,'Dayton 29',to_date('05-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1241,0,null,null,null,1240,null,0,1,to_date('05-JUN-08','DD-MON-RR'),to_date('05-JUN-08','DD-MON-RR'),null,to_date('05-JUN-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',3,989,'Dayton 29',to_date('05-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1245,0,null,null,null,1244,null,0,1,to_date('05-JUN-08','DD-MON-RR'),to_date('05-JUN-08','DD-MON-RR'),null,to_date('05-JUN-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',3,989,'Dayton 29',to_date('05-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1249,0,null,null,null,1248,null,0,1,to_date('05-JUN-08','DD-MON-RR'),to_date('05-JUN-08','DD-MON-RR'),null,to_date('05-JUN-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',3,989,'Dayton 29',to_date('05-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1253,0,null,null,null,1252,null,0,1,to_date('05-JUN-08','DD-MON-RR'),to_date('05-JUN-08','DD-MON-RR'),null,to_date('05-JUN-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',3,989,'Dayton 29',to_date('05-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1257,0,null,null,null,1256,null,0,1,to_date('05-JUN-08','DD-MON-RR'),to_date('05-JUN-08','DD-MON-RR'),null,to_date('05-JUN-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',3,989,'Dayton 29',to_date('05-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1261,0,null,null,null,1260,null,0,1,to_date('05-JUN-08','DD-MON-RR'),to_date('05-JUN-08','DD-MON-RR'),null,to_date('05-JUN-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',3,989,'Dayton 29',to_date('05-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1265,0,null,null,null,1264,null,0,1,to_date('05-JUN-08','DD-MON-RR'),to_date('05-JUN-08','DD-MON-RR'),null,to_date('05-JUN-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',2,76,'MHVSMDOCTWO, GREG',to_date('05-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1268,0,null,null,null,1208,null,0,1,to_date('05-JUN-08','DD-MON-RR'),to_date('05-JUN-08','DD-MON-RR'),null,to_date('05-JUN-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',1,51,'MHVSMFOUR, OLIVIA',to_date('05-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1271,0,null,null,null,1227,null,0,1,to_date('05-JUN-08','DD-MON-RR'),to_date('05-JUN-08','DD-MON-RR'),null,to_date('05-JUN-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',1,51,'MHVSMFOUR, OLIVIA',to_date('05-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1278,0,null,null,null,1277,null,0,1,to_date('06-JUN-08','DD-MON-RR'),to_date('06-JUN-08','DD-MON-RR'),null,to_date('06-JUN-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',1,51,'MHVSMFOUR, OLIVIA',to_date('06-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1282,0,null,null,null,1281,null,0,1,to_date('06-JUN-08','DD-MON-RR'),to_date('06-JUN-08','DD-MON-RR'),null,to_date('06-JUN-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',1,51,'MHVSMFOUR, OLIVIA',to_date('06-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (353,10,null,79,null,352,79,2,1,to_date('21-MAY-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('21-MAY-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',to_date('21-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (361,0,null,null,null,360,null,0,1,to_date('21-MAY-08','DD-MON-RR'),to_date('21-MAY-08','DD-MON-RR'),null,to_date('21-MAY-08','DD-MON-RR'),2,24,'MHVSMDOCONE, MIKE',2,76,'MHVSMDOCTWO, GREG',to_date('21-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (385,20,to_date('21-MAY-08','DD-MON-RR'),null,null,384,24,1,1,to_date('21-MAY-08','DD-MON-RR'),to_date('21-MAY-08','DD-MON-RR'),null,to_date('21-MAY-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',to_date('21-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (371,0,null,null,null,344,null,0,1,to_date('21-MAY-08','DD-MON-RR'),to_date('21-MAY-08','DD-MON-RR'),null,to_date('21-MAY-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',1,53,'MHVSMFIVE, EMMA',to_date('21-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (377,20,to_date('21-MAY-08','DD-MON-RR'),null,null,376,79,2,1,to_date('21-MAY-08','DD-MON-RR'),to_date('21-MAY-08','DD-MON-RR'),null,to_date('21-MAY-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',to_date('21-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (396,0,null,null,null,395,null,0,1,to_date('21-MAY-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('21-MAY-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',to_date('21-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (405,0,null,null,null,404,null,0,1,to_date('21-MAY-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('21-MAY-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',to_date('21-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (413,0,null,null,null,412,null,0,1,to_date('21-MAY-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('21-MAY-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',to_date('21-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (421,20,to_date('21-MAY-08','DD-MON-RR'),76,null,420,76,2,1,to_date('21-MAY-08','DD-MON-RR'),to_date('21-MAY-08','DD-MON-RR'),null,to_date('21-MAY-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',to_date('21-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (428,0,null,null,null,420,null,0,1,to_date('21-MAY-08','DD-MON-RR'),to_date('21-MAY-08','DD-MON-RR'),null,to_date('21-MAY-08','DD-MON-RR'),2,76,'MHVSMDOCTWO, GREG',1,29,'MHVSMONE, ALYSSA',to_date('21-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (437,0,null,null,null,211,null,0,1,to_date('21-MAY-08','DD-MON-RR'),to_date('21-MAY-08','DD-MON-RR'),null,to_date('21-MAY-08','DD-MON-RR'),2,76,'MHVSMDOCTWO, GREG',1,51,'MHVSMFOUR, OLIVIA',to_date('21-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (441,0,null,null,null,440,null,0,1,to_date('21-MAY-08','DD-MON-RR'),to_date('21-MAY-08','DD-MON-RR'),null,to_date('21-MAY-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',1,51,'MHVSMFOUR, OLIVIA',to_date('21-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (445,0,null,null,null,444,null,0,1,to_date('21-MAY-08','DD-MON-RR'),to_date('21-MAY-08','DD-MON-RR'),null,to_date('21-MAY-08','DD-MON-RR'),2,76,'MHVSMDOCTWO, GREG',1,55,'MHVSMSIX, ALICE',to_date('21-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (448,20,to_date('23-MAY-08','DD-MON-RR'),null,null,444,79,1,1,to_date('21-MAY-08','DD-MON-RR'),to_date('21-MAY-08','DD-MON-RR'),null,to_date('21-MAY-08','DD-MON-RR'),1,55,'MHVSMSIX, ALICE',3,989,'Dayton 29',to_date('21-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (458,0,null,null,null,457,null,0,1,to_date('21-MAY-08','DD-MON-RR'),to_date('21-MAY-08','DD-MON-RR'),null,to_date('21-MAY-08','DD-MON-RR'),2,76,'MHVSMDOCTWO, GREG',4,456,'My Patients 8.1.2K',to_date('21-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (462,0,null,null,null,461,null,0,1,to_date('21-MAY-08','DD-MON-RR'),to_date('21-MAY-08','DD-MON-RR'),null,to_date('21-MAY-08','DD-MON-RR'),2,76,'MHVSMDOCTWO, GREG',4,456,'My Patients 8.1.2K',to_date('21-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (466,0,null,null,null,465,null,0,1,to_date('21-MAY-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('21-MAY-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',to_date('21-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (474,0,null,null,null,473,null,0,1,to_date('21-MAY-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('21-MAY-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',to_date('21-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (482,10,null,76,null,481,84,8,1,to_date('21-MAY-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('21-MAY-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',to_date('21-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (494,0,null,null,null,493,null,0,1,to_date('21-MAY-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('21-MAY-08','DD-MON-RR'),1,55,'MHVSMSIX, ALICE',3,989,'Dayton 29',to_date('21-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (532,0,null,null,null,531,null,0,1,to_date('21-MAY-08','DD-MON-RR'),to_date('21-MAY-08','DD-MON-RR'),null,to_date('21-MAY-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',1,51,'MHVSMFOUR, OLIVIA',to_date('21-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (505,20,to_date('22-MAY-08','DD-MON-RR'),76,null,504,79,5,1,to_date('21-MAY-08','DD-MON-RR'),to_date('21-MAY-08','DD-MON-RR'),null,to_date('21-MAY-08','DD-MON-RR'),1,55,'MHVSMSIX, ALICE',3,989,'Dayton 29',to_date('21-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (513,0,null,null,null,512,null,1,1,to_date('21-MAY-08','DD-MON-RR'),to_date('21-MAY-08','DD-MON-RR'),null,null,1,55,'MHVSMSIX, ALICE',3,989,'Dayton 29',null,null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (528,0,null,null,null,440,null,0,1,to_date('21-MAY-08','DD-MON-RR'),to_date('21-MAY-08','DD-MON-RR'),null,to_date('21-MAY-08','DD-MON-RR'),2,76,'MHVSMDOCTWO, GREG',1,51,'MHVSMFOUR, OLIVIA',to_date('21-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (518,20,to_date('21-MAY-08','DD-MON-RR'),76,null,440,76,2,1,to_date('21-MAY-08','DD-MON-RR'),to_date('21-MAY-08','DD-MON-RR'),null,to_date('21-MAY-08','DD-MON-RR'),1,51,'MHVSMFOUR, OLIVIA',3,989,'Dayton 29',to_date('21-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (525,0,null,null,null,440,null,0,1,to_date('21-MAY-08','DD-MON-RR'),to_date('21-MAY-08','DD-MON-RR'),null,to_date('21-MAY-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',1,51,'MHVSMFOUR, OLIVIA',to_date('21-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (536,0,null,null,null,535,null,0,1,to_date('21-MAY-08','DD-MON-RR'),to_date('21-MAY-08','DD-MON-RR'),null,to_date('21-MAY-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',1,51,'MHVSMFOUR, OLIVIA',to_date('21-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (539,20,to_date('21-MAY-08','DD-MON-RR'),76,null,535,76,2,1,to_date('21-MAY-08','DD-MON-RR'),to_date('21-MAY-08','DD-MON-RR'),null,to_date('21-MAY-08','DD-MON-RR'),1,51,'MHVSMFOUR, OLIVIA',3,989,'Dayton 29',to_date('21-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (546,0,null,null,null,535,null,0,1,to_date('21-MAY-08','DD-MON-RR'),to_date('21-MAY-08','DD-MON-RR'),null,to_date('21-MAY-08','DD-MON-RR'),2,76,'MHVSMDOCTWO, GREG',1,51,'MHVSMFOUR, OLIVIA',to_date('21-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (550,0,null,null,null,549,null,0,1,to_date('21-MAY-08','DD-MON-RR'),to_date('21-MAY-08','DD-MON-RR'),null,to_date('21-MAY-08','DD-MON-RR'),2,24,'MHVSMDOCONE, MIKE',2,81,'MHVSMDOCFIVE, SAM',to_date('21-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (555,0,null,null,null,554,null,0,1,to_date('21-MAY-08','DD-MON-RR'),to_date('21-MAY-08','DD-MON-RR'),null,to_date('21-MAY-08','DD-MON-RR'),2,82,'MHVSMSTAFFONE, CAROL',2,24,'MHVSMDOCONE, MIKE',to_date('21-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (561,0,null,null,null,560,null,0,1,to_date('22-MAY-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('22-MAY-08','DD-MON-RR'),1,47,'MHVSMTWO, BRIANNA',3,989,'Dayton 29',to_date('22-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (569,10,null,81,null,568,81,2,1,to_date('22-MAY-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('22-MAY-08','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('22-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (580,20,to_date('23-MAY-08','DD-MON-RR'),null,null,579,79,1,1,to_date('22-MAY-08','DD-MON-RR'),to_date('22-MAY-08','DD-MON-RR'),null,to_date('22-MAY-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',to_date('22-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (588,0,null,null,null,587,null,0,1,to_date('22-MAY-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('22-MAY-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',to_date('22-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (598,20,to_date('22-MAY-08','DD-MON-RR'),79,null,597,79,3,1,to_date('22-MAY-08','DD-MON-RR'),to_date('22-MAY-08','DD-MON-RR'),null,to_date('22-MAY-08','DD-MON-RR'),1,51,'MHVSMFOUR, OLIVIA',3,989,'Dayton 29',to_date('22-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (606,0,null,null,null,605,null,0,1,to_date('22-MAY-08','DD-MON-RR'),to_date('22-MAY-08','DD-MON-RR'),null,to_date('22-MAY-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',1,51,'MHVSMFOUR, OLIVIA',to_date('22-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (610,0,null,null,null,609,null,0,1,to_date('22-MAY-08','DD-MON-RR'),to_date('22-MAY-08','DD-MON-RR'),null,to_date('22-MAY-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',3,989,'Dayton 29',to_date('22-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (614,0,null,null,null,613,null,0,1,to_date('22-MAY-08','DD-MON-RR'),to_date('22-MAY-08','DD-MON-RR'),null,to_date('22-MAY-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',3,989,'Dayton 29',to_date('22-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (618,0,null,null,null,617,null,0,1,to_date('22-MAY-08','DD-MON-RR'),to_date('22-MAY-08','DD-MON-RR'),null,to_date('22-MAY-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',3,989,'Dayton 29',to_date('22-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (622,0,null,null,null,621,null,0,1,to_date('22-MAY-08','DD-MON-RR'),to_date('22-MAY-08','DD-MON-RR'),null,to_date('22-MAY-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',3,989,'Dayton 29',to_date('22-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (626,0,null,null,null,625,null,0,1,to_date('22-MAY-08','DD-MON-RR'),to_date('22-MAY-08','DD-MON-RR'),null,to_date('22-MAY-08','DD-MON-RR'),2,83,'MHVSMSTAFFTWO, MARSHA',3,979,'SLC10',to_date('22-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (630,0,null,null,null,629,null,0,1,to_date('22-MAY-08','DD-MON-RR'),to_date('22-MAY-08','DD-MON-RR'),null,to_date('22-MAY-08','DD-MON-RR'),2,83,'MHVSMSTAFFTWO, MARSHA',3,979,'SLC10',to_date('22-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (634,0,null,null,null,633,null,0,1,to_date('22-MAY-08','DD-MON-RR'),to_date('22-MAY-08','DD-MON-RR'),null,to_date('22-MAY-08','DD-MON-RR'),2,83,'MHVSMSTAFFTWO, MARSHA',3,979,'SLC10',to_date('22-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (639,0,null,null,null,638,null,0,1,to_date('22-MAY-08','DD-MON-RR'),to_date('22-MAY-08','DD-MON-RR'),null,to_date('22-MAY-08','DD-MON-RR'),2,83,'MHVSMSTAFFTWO, MARSHA',3,979,'SLC10',to_date('22-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (643,0,null,null,null,642,null,0,1,to_date('22-MAY-08','DD-MON-RR'),to_date('22-MAY-08','DD-MON-RR'),null,to_date('22-MAY-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',3,989,'Dayton 29',to_date('22-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (647,0,null,null,null,646,null,0,1,to_date('22-MAY-08','DD-MON-RR'),to_date('22-MAY-08','DD-MON-RR'),null,to_date('22-MAY-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',3,989,'Dayton 29',to_date('22-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (651,0,null,null,null,650,null,0,1,to_date('22-MAY-08','DD-MON-RR'),to_date('22-MAY-08','DD-MON-RR'),null,to_date('22-MAY-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',3,989,'Dayton 29',to_date('22-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (655,0,null,null,null,654,null,0,1,to_date('22-MAY-08','DD-MON-RR'),to_date('22-MAY-08','DD-MON-RR'),null,to_date('22-MAY-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',3,989,'Dayton 29',to_date('22-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (659,10,null,79,null,658,79,2,1,to_date('22-MAY-08','DD-MON-RR'),to_date('22-MAY-08','DD-MON-RR'),null,to_date('22-MAY-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',2,76,'MHVSMDOCTWO, GREG',to_date('22-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (665,0,null,null,null,664,null,0,1,to_date('22-MAY-08','DD-MON-RR'),to_date('22-MAY-08','DD-MON-RR'),null,to_date('22-MAY-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',1,51,'MHVSMFOUR, OLIVIA',to_date('22-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (675,0,null,null,null,674,null,0,1,to_date('22-MAY-08','DD-MON-RR'),to_date('22-MAY-08','DD-MON-RR'),null,to_date('22-MAY-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',1,51,'MHVSMFOUR, OLIVIA',to_date('22-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (678,0,null,null,null,444,null,0,1,to_date('23-MAY-08','DD-MON-RR'),to_date('23-MAY-08','DD-MON-RR'),null,to_date('23-MAY-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',1,55,'MHVSMSIX, ALICE',to_date('23-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (683,0,null,null,null,682,null,0,1,to_date('23-MAY-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('23-MAY-08','DD-MON-RR'),1,69,'MHVSMTHIRTEEN, GEORGE',3,989,'Dayton 29',to_date('23-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (691,0,null,null,null,690,null,0,1,to_date('23-MAY-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('23-MAY-08','DD-MON-RR'),1,69,'MHVSMTHIRTEEN, GEORGE',3,989,'Dayton 29',to_date('23-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (699,0,null,null,null,698,null,0,1,to_date('23-MAY-08','DD-MON-RR'),to_date('23-MAY-08','DD-MON-RR'),null,to_date('23-MAY-08','DD-MON-RR'),2,84,'MHVSMSTAFFTHREE, JAN',1,29,'MHVSMONE, ALYSSA',to_date('23-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (703,0,null,24,null,702,null,1,1,to_date('23-MAY-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('23-MAY-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',to_date('23-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (711,0,null,null,null,702,null,0,1,to_date('23-MAY-08','DD-MON-RR'),to_date('23-MAY-08','DD-MON-RR'),null,to_date('23-MAY-08','DD-MON-RR'),2,85,'MHVSMSTAFFFOUR, CINDY',1,29,'MHVSMONE, ALYSSA',to_date('23-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (715,0,null,null,null,714,null,0,1,to_date('23-MAY-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('23-MAY-08','DD-MON-RR'),1,51,'MHVSMFOUR, OLIVIA',3,989,'Dayton 29',to_date('23-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (731,0,null,null,null,587,null,0,1,to_date('27-MAY-08','DD-MON-RR'),to_date('27-MAY-08','DD-MON-RR'),null,to_date('27-MAY-08','DD-MON-RR'),2,24,'MHVSMDOCONE, MIKE',1,29,'MHVSMONE, ALYSSA',to_date('27-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (734,0,null,null,null,702,null,0,1,to_date('27-MAY-08','DD-MON-RR'),to_date('27-MAY-08','DD-MON-RR'),null,to_date('27-MAY-08','DD-MON-RR'),2,24,'MHVSMDOCONE, MIKE',1,29,'MHVSMONE, ALYSSA',to_date('27-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (742,0,null,null,null,741,null,0,1,to_date('28-MAY-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('28-MAY-08','DD-MON-RR'),1,47,'MHVSMTWO, BRIANNA',3,989,'Dayton 29',to_date('28-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (750,20,to_date('29-MAY-08','DD-MON-RR'),24,null,749,76,3,1,to_date('28-MAY-08','DD-MON-RR'),to_date('28-MAY-08','DD-MON-RR'),null,to_date('28-MAY-08','DD-MON-RR'),1,47,'MHVSMTWO, BRIANNA',3,989,'Dayton 29',to_date('28-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (759,0,null,null,null,749,null,0,1,to_date('28-MAY-08','DD-MON-RR'),to_date('28-MAY-08','DD-MON-RR'),null,to_date('28-MAY-08','DD-MON-RR'),2,24,'MHVSMDOCONE, MIKE',1,47,'MHVSMTWO, BRIANNA',to_date('28-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (763,0,null,80,null,762,null,1,1,to_date('28-MAY-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('28-MAY-08','DD-MON-RR'),1,65,'MHVSMELEVEN, JOHN',3,979,'SLC10',to_date('28-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (771,0,null,81,null,770,null,1,1,to_date('28-MAY-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('28-MAY-08','DD-MON-RR'),1,65,'MHVSMELEVEN, JOHN',3,979,'SLC10',to_date('28-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (779,10,null,76,null,778,76,2,1,to_date('28-MAY-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('28-MAY-08','DD-MON-RR'),1,47,'MHVSMTWO, BRIANNA',3,989,'Dayton 29',to_date('28-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (787,0,null,null,null,786,null,0,1,to_date('28-MAY-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('28-MAY-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',to_date('28-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (795,0,null,76,null,794,null,1,1,to_date('28-MAY-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('28-MAY-08','DD-MON-RR'),1,47,'MHVSMTWO, BRIANNA',3,989,'Dayton 29',to_date('28-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (806,20,to_date('28-MAY-08','DD-MON-RR'),null,null,805,79,1,1,to_date('28-MAY-08','DD-MON-RR'),to_date('28-MAY-08','DD-MON-RR'),null,to_date('28-MAY-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',to_date('28-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (145,0,null,null,null,144,null,0,1,to_date('06-MAY-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('06-MAY-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',null,null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (153,20,to_date('06-MAY-08','DD-MON-RR'),null,null,152,24,1,1,to_date('06-MAY-08','DD-MON-RR'),to_date('06-MAY-08','DD-MON-RR'),null,to_date('06-MAY-08','DD-MON-RR'),1,47,'MHVSMTWO, BRIANNA',3,989,'Dayton 29',null,null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (161,0,null,null,null,160,null,0,1,to_date('06-MAY-08','DD-MON-RR'),to_date('06-MAY-08','DD-MON-RR'),null,to_date('06-MAY-08','DD-MON-RR'),2,24,'MHVSMDOCONE, MIKE',1,49,'MHVSMTHREE, CHLOE',null,null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (164,0,null,null,null,152,null,0,1,to_date('06-MAY-08','DD-MON-RR'),to_date('06-MAY-08','DD-MON-RR'),null,to_date('06-MAY-08','DD-MON-RR'),2,24,'MHVSMDOCONE, MIKE',1,47,'MHVSMTWO, BRIANNA',null,null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (170,0,null,76,null,169,null,1,1,to_date('07-MAY-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('07-MAY-08','DD-MON-RR'),1,53,'MHVSMFIVE, EMMA',3,989,'Dayton 29',null,null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (177,0,null,null,null,169,null,0,1,to_date('07-MAY-08','DD-MON-RR'),to_date('07-MAY-08','DD-MON-RR'),null,to_date('07-MAY-08','DD-MON-RR'),2,76,'MHVSMDOCTWO, GREG',1,53,'MHVSMFIVE, EMMA',null,null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (180,0,null,null,null,169,null,0,1,to_date('07-MAY-08','DD-MON-RR'),to_date('07-MAY-08','DD-MON-RR'),null,to_date('07-MAY-08','DD-MON-RR'),2,76,'MHVSMDOCTWO, GREG',1,53,'MHVSMFIVE, EMMA',null,null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (185,0,null,null,null,184,null,0,1,to_date('07-MAY-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('07-MAY-08','DD-MON-RR'),1,65,'MHVSMELEVEN, JOHN',3,979,'SLC10',null,null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (193,0,null,null,null,192,null,0,1,to_date('07-MAY-08','DD-MON-RR'),to_date('07-MAY-08','DD-MON-RR'),null,to_date('07-MAY-08','DD-MON-RR'),2,24,'MHVSMDOCONE, MIKE',1,29,'MHVSMONE, ALYSSA',null,null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (196,0,null,null,null,192,null,0,1,to_date('07-MAY-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('07-MAY-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',null,null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (204,0,null,null,null,203,null,0,1,to_date('07-MAY-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('07-MAY-08','DD-MON-RR'),1,51,'MHVSMFOUR, OLIVIA',3,989,'Dayton 29',null,null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (212,20,to_date('21-MAY-08','DD-MON-RR'),76,null,211,79,2,1,to_date('07-MAY-08','DD-MON-RR'),to_date('07-MAY-08','DD-MON-RR'),null,to_date('07-MAY-08','DD-MON-RR'),1,51,'MHVSMFOUR, OLIVIA',3,989,'Dayton 29',null,null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (220,20,to_date('21-MAY-08','DD-MON-RR'),null,null,219,79,1,1,to_date('07-MAY-08','DD-MON-RR'),to_date('07-MAY-08','DD-MON-RR'),null,to_date('07-MAY-08','DD-MON-RR'),1,51,'MHVSMFOUR, OLIVIA',3,989,'Dayton 29',null,null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (228,0,null,84,null,227,null,2,1,to_date('08-MAY-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('08-MAY-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',null,null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (235,0,null,null,null,227,null,0,1,to_date('08-MAY-08','DD-MON-RR'),to_date('08-MAY-08','DD-MON-RR'),null,to_date('08-MAY-08','DD-MON-RR'),2,84,'MHVSMSTAFFTHREE, JAN',1,29,'MHVSMONE, ALYSSA',null,null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (238,0,null,null,null,219,null,0,1,to_date('08-MAY-08','DD-MON-RR'),to_date('08-MAY-08','DD-MON-RR'),null,to_date('08-MAY-08','DD-MON-RR'),2,24,'MHVSMDOCONE, MIKE',1,51,'MHVSMFOUR, OLIVIA',null,null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (241,0,null,null,null,219,null,0,1,to_date('08-MAY-08','DD-MON-RR'),to_date('08-MAY-08','DD-MON-RR'),null,to_date('08-MAY-08','DD-MON-RR'),2,24,'MHVSMDOCONE, MIKE',1,51,'MHVSMFOUR, OLIVIA',null,null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (245,0,null,null,null,244,null,0,1,to_date('12-MAY-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('12-MAY-08','DD-MON-RR'),1,47,'MHVSMTWO, BRIANNA',3,989,'Dayton 29',null,null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (253,10,null,18,null,252,18,2,1,to_date('13-MAY-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('13-MAY-08','DD-MON-RR'),1,8,'Maley, Richard',3,658,'Salem',to_date('13-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (258,20,to_date('13-MAY-08','DD-MON-RR'),null,null,257,18,1,1,to_date('13-MAY-08','DD-MON-RR'),to_date('13-MAY-08','DD-MON-RR'),null,to_date('13-MAY-08','DD-MON-RR'),1,8,'Maley, Richard',3,658,'Salem',to_date('13-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (262,0,null,null,null,257,null,0,1,to_date('13-MAY-08','DD-MON-RR'),to_date('13-MAY-08','DD-MON-RR'),null,to_date('13-MAY-08','DD-MON-RR'),2,18,'Maleyc, Richard',1,8,'Maley, Richard',to_date('13-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (266,0,null,86,null,265,null,1,1,to_date('13-MAY-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('13-MAY-08','DD-MON-RR'),1,63,'MHVSMTEN, EDNA',3,979,'SLC10',to_date('13-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (274,0,null,86,null,273,null,1,1,to_date('13-MAY-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('13-MAY-08','DD-MON-RR'),1,63,'MHVSMTEN, EDNA',3,979,'SLC10',to_date('13-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (282,0,null,null,null,281,null,0,1,to_date('13-MAY-08','DD-MON-RR'),to_date('13-MAY-08','DD-MON-RR'),null,to_date('13-MAY-08','DD-MON-RR'),2,24,'MHVSMDOCONE, MIKE',1,51,'MHVSMFOUR, OLIVIA',to_date('13-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (286,0,null,null,null,285,null,0,1,to_date('13-MAY-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('13-MAY-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',to_date('13-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (294,0,null,null,null,293,null,0,1,to_date('13-MAY-08','DD-MON-RR'),to_date('13-MAY-08','DD-MON-RR'),null,to_date('13-MAY-08','DD-MON-RR'),2,76,'MHVSMDOCTWO, GREG',2,24,'MHVSMDOCONE, MIKE',to_date('13-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (298,0,null,null,null,192,null,0,1,to_date('13-MAY-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('13-MAY-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',to_date('13-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (306,0,null,null,null,305,null,0,1,to_date('13-MAY-08','DD-MON-RR'),to_date('13-MAY-08','DD-MON-RR'),null,to_date('13-MAY-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',2,24,'MHVSMDOCONE, MIKE',to_date('13-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (311,0,null,null,null,310,null,0,1,to_date('13-MAY-08','DD-MON-RR'),to_date('13-MAY-08','DD-MON-RR'),null,to_date('13-MAY-08','DD-MON-RR'),2,76,'MHVSMDOCTWO, GREG',2,24,'MHVSMDOCONE, MIKE',to_date('13-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (337,20,to_date('22-MAY-08','DD-MON-RR'),86,null,336,82,2,1,to_date('21-MAY-08','DD-MON-RR'),to_date('21-MAY-08','DD-MON-RR'),null,to_date('21-MAY-08','DD-MON-RR'),1,63,'MHVSMTEN, EDNA',3,979,'SLC10',to_date('21-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (345,0,null,79,null,344,null,1,1,to_date('21-MAY-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('21-MAY-08','DD-MON-RR'),1,53,'MHVSMFIVE, EMMA',3,989,'Dayton 29',to_date('21-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (814,20,to_date('28-MAY-08','DD-MON-RR'),79,null,813,79,3,1,to_date('28-MAY-08','DD-MON-RR'),to_date('28-MAY-08','DD-MON-RR'),null,to_date('28-MAY-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',to_date('28-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (822,0,null,null,null,805,null,0,1,to_date('28-MAY-08','DD-MON-RR'),to_date('28-MAY-08','DD-MON-RR'),null,to_date('28-MAY-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',1,29,'MHVSMONE, ALYSSA',to_date('28-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (825,0,null,null,null,813,null,0,1,to_date('28-MAY-08','DD-MON-RR'),to_date('28-MAY-08','DD-MON-RR'),null,to_date('28-MAY-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',1,29,'MHVSMONE, ALYSSA',to_date('28-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (829,0,null,null,null,828,null,0,1,to_date('28-MAY-08','DD-MON-RR'),to_date('28-MAY-08','DD-MON-RR'),null,null,1,65,'MHVSMELEVEN, JOHN',null,null,null,null,null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (832,0,null,null,null,831,null,0,1,to_date('28-MAY-08','DD-MON-RR'),to_date('28-MAY-08','DD-MON-RR'),null,null,1,29,'MHVSMONE, ALYSSA',null,null,null,null,null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (834,0,null,24,null,831,null,1,1,to_date('28-MAY-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('03-JUN-08','DD-MON-RR'),to_date('28-MAY-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',to_date('28-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (843,0,null,null,null,842,null,0,1,to_date('28-MAY-08','DD-MON-RR'),to_date('28-MAY-08','DD-MON-RR'),null,null,1,65,'MHVSMELEVEN, JOHN',null,null,null,null,null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (846,0,null,null,null,845,null,0,1,to_date('28-MAY-08','DD-MON-RR'),to_date('28-MAY-08','DD-MON-RR'),null,null,1,65,'MHVSMELEVEN, JOHN',null,null,null,null,null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (849,0,null,null,null,848,null,0,1,to_date('28-MAY-08','DD-MON-RR'),to_date('28-MAY-08','DD-MON-RR'),null,null,1,65,'MHVSMELEVEN, JOHN',null,null,null,null,null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (856,0,null,null,null,855,null,0,1,to_date('28-MAY-08','DD-MON-RR'),to_date('28-MAY-08','DD-MON-RR'),null,null,1,63,'MHVSMTEN, EDNA',null,null,null,null,null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (972,0,null,null,null,971,null,0,1,to_date('29-MAY-08','DD-MON-RR'),to_date('29-MAY-08','DD-MON-RR'),null,to_date('29-MAY-08','DD-MON-RR'),2,76,'MHVSMDOCTWO, GREG',1,73,'MHVSMFIFTEEN, YOKO',to_date('29-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (901,0,null,null,null,900,null,0,1,to_date('28-MAY-08','DD-MON-RR'),to_date('28-MAY-08','DD-MON-RR'),null,to_date('28-MAY-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',1,51,'MHVSMFOUR, OLIVIA',to_date('28-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (905,0,null,null,null,904,null,0,1,to_date('29-MAY-08','DD-MON-RR'),to_date('29-MAY-08','DD-MON-RR'),null,to_date('29-MAY-08','DD-MON-RR'),2,24,'MHVSMDOCONE, MIKE',1,29,'MHVSMONE, ALYSSA',to_date('29-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (913,0,null,null,null,912,null,0,1,to_date('29-MAY-08','DD-MON-RR'),to_date('29-MAY-08','DD-MON-RR'),null,null,1,55,'MHVSMSIX, ALICE',null,null,null,null,null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (916,0,null,null,null,915,null,0,1,to_date('29-MAY-08','DD-MON-RR'),to_date('29-MAY-08','DD-MON-RR'),null,null,1,55,'MHVSMSIX, ALICE',null,null,null,null,null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (975,0,null,85,null,971,null,1,1,to_date('29-MAY-08','DD-MON-RR'),to_date('04-JUN-08','DD-MON-RR'),to_date('04-JUN-08','DD-MON-RR'),to_date('29-MAY-08','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,989,'Dayton 29',to_date('29-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (922,0,null,null,null,921,null,0,1,to_date('29-MAY-08','DD-MON-RR'),to_date('29-MAY-08','DD-MON-RR'),null,null,2,76,'MHVSMDOCTWO, GREG',null,null,null,null,null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (931,20,to_date('29-MAY-08','DD-MON-RR'),null,null,930,24,1,1,to_date('29-MAY-08','DD-MON-RR'),to_date('29-MAY-08','DD-MON-RR'),null,to_date('29-MAY-08','DD-MON-RR'),1,47,'MHVSMTWO, BRIANNA',3,989,'Dayton 29',to_date('29-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (939,0,null,null,null,938,null,0,1,to_date('29-MAY-08','DD-MON-RR'),to_date('29-MAY-08','DD-MON-RR'),null,to_date('29-MAY-08','DD-MON-RR'),2,24,'MHVSMDOCONE, MIKE',1,47,'MHVSMTWO, BRIANNA',to_date('29-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (945,0,null,null,null,944,null,0,1,to_date('29-MAY-08','DD-MON-RR'),to_date('29-MAY-08','DD-MON-RR'),null,to_date('29-MAY-08','DD-MON-RR'),2,76,'MHVSMDOCTWO, GREG',4,943,'D Group',to_date('29-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (949,0,null,null,null,948,null,0,1,to_date('29-MAY-08','DD-MON-RR'),to_date('29-MAY-08','DD-MON-RR'),null,to_date('29-MAY-08','DD-MON-RR'),2,76,'MHVSMDOCTWO, GREG',4,943,'D Group',to_date('29-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (953,0,null,null,null,952,null,0,1,to_date('29-MAY-08','DD-MON-RR'),to_date('29-MAY-08','DD-MON-RR'),null,to_date('29-MAY-08','DD-MON-RR'),2,76,'MHVSMDOCTWO, GREG',4,943,'D Group',to_date('29-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (958,0,null,null,null,957,null,0,1,to_date('29-MAY-08','DD-MON-RR'),to_date('29-MAY-08','DD-MON-RR'),null,to_date('29-MAY-08','DD-MON-RR'),2,86,'MHVSMSTAFFFIVE, ALICE',4,956,'Distribution Group 1',to_date('29-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (961,0,null,82,null,957,null,1,1,to_date('29-MAY-08','DD-MON-RR'),to_date('04-JUN-08','DD-MON-RR'),to_date('04-JUN-08','DD-MON-RR'),to_date('29-MAY-08','DD-MON-RR'),1,63,'MHVSMTEN, EDNA',3,979,'SLC10',to_date('29-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (968,0,null,null,null,794,null,0,1,to_date('29-MAY-08','DD-MON-RR'),to_date('29-MAY-08','DD-MON-RR'),null,to_date('29-MAY-08','DD-MON-RR'),2,76,'MHVSMDOCTWO, GREG',1,47,'MHVSMTWO, BRIANNA',to_date('29-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (988,20,to_date('30-MAY-08','DD-MON-RR'),null,null,987,79,1,1,to_date('30-MAY-08','DD-MON-RR'),to_date('30-MAY-08','DD-MON-RR'),null,to_date('30-MAY-08','DD-MON-RR'),1,51,'MHVSMFOUR, OLIVIA',3,989,'Dayton 29',to_date('30-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (996,0,null,null,null,995,null,0,1,to_date('30-MAY-08','DD-MON-RR'),to_date('30-MAY-08','DD-MON-RR'),null,to_date('30-MAY-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',1,51,'MHVSMFOUR, OLIVIA',to_date('30-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1000,0,null,null,null,999,null,0,1,to_date('30-MAY-08','DD-MON-RR'),to_date('30-MAY-08','DD-MON-RR'),null,to_date('30-MAY-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',3,989,'Dayton 29',to_date('30-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1004,0,null,null,null,1003,null,0,1,to_date('30-MAY-08','DD-MON-RR'),to_date('30-MAY-08','DD-MON-RR'),null,to_date('30-MAY-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',3,989,'Dayton 29',to_date('30-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1008,0,null,null,null,1007,null,0,1,to_date('30-MAY-08','DD-MON-RR'),to_date('30-MAY-08','DD-MON-RR'),null,to_date('30-MAY-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',3,989,'Dayton 29',to_date('30-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1012,0,null,null,null,1011,null,0,1,to_date('30-MAY-08','DD-MON-RR'),to_date('30-MAY-08','DD-MON-RR'),null,to_date('30-MAY-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',3,989,'Dayton 29',to_date('30-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1016,0,null,null,null,1015,null,0,1,to_date('30-MAY-08','DD-MON-RR'),to_date('30-MAY-08','DD-MON-RR'),null,to_date('30-MAY-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',2,76,'MHVSMDOCTWO, GREG',to_date('30-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1020,0,null,null,null,1019,null,0,1,to_date('30-MAY-08','DD-MON-RR'),to_date('30-MAY-08','DD-MON-RR'),null,null,2,24,'MHVSMDOCONE, MIKE',null,null,null,null,null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1034,0,null,null,null,987,null,0,1,to_date('30-MAY-08','DD-MON-RR'),to_date('30-MAY-08','DD-MON-RR'),null,to_date('30-MAY-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',1,51,'MHVSMFOUR, OLIVIA',to_date('30-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1039,0,null,null,null,1038,null,0,1,to_date('30-MAY-08','DD-MON-RR'),to_date('30-MAY-08','DD-MON-RR'),null,to_date('30-MAY-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',2,24,'MHVSMDOCONE, MIKE',to_date('30-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1043,0,null,null,null,1042,null,0,1,to_date('30-MAY-08','DD-MON-RR'),to_date('30-MAY-08','DD-MON-RR'),null,to_date('30-MAY-08','DD-MON-RR'),2,81,'MHVSMDOCFIVE, SAM',3,979,'SLC10',to_date('30-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1047,0,null,null,null,1046,null,0,1,to_date('30-MAY-08','DD-MON-RR'),to_date('30-MAY-08','DD-MON-RR'),null,to_date('30-MAY-08','DD-MON-RR'),2,81,'MHVSMDOCFIVE, SAM',3,979,'SLC10',to_date('30-MAY-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1683,0,null,null,null,1682,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,1152,'Donita, Searcy',3,989,'Dayton 29',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1688,0,null,null,null,1687,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,1152,'Donita, Searcy',3,989,'Dayton 29',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1692,0,null,null,null,1691,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,1152,'Donita, Searcy',3,989,'Dayton 29',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1695,0,null,null,null,1657,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,84,'MHVSMSTAFFTHREE, JAN',2,1150,'       , Prematta',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1717,0,null,null,null,1641,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('20-JUN-08','DD-MON-RR'),to_date('20-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),1,51,'MHVSMFOUR, OLIVIA',3,989,'Dayton 29',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1733,0,null,null,null,1732,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,1152,'Donita, Searcy',1,55,'MHVSMSIX, ALICE',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1773,0,null,1150,null,1772,null,1,1,to_date('16-JUN-08','DD-MON-RR'),to_date('20-JUN-08','DD-MON-RR'),to_date('20-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),1,51,'MHVSMFOUR, OLIVIA',3,989,'Dayton 29',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1819,0,null,null,null,1818,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,1152,'Donita, Searcy',4,1698,'Distribution Group 1.0F',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1823,0,null,null,null,1822,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,1152,'Donita, Searcy',4,1698,'Distribution Group 1.0F',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1827,0,null,null,null,1826,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,1152,'Donita, Searcy',3,989,'Dayton 29',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1831,0,null,null,null,1830,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,1152,'Donita, Searcy',3,989,'Dayton 29',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1835,0,null,null,null,1834,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,1152,'Donita, Searcy',3,989,'Dayton 29',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1839,0,null,1150,null,1838,null,1,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,1152,'Donita, Searcy',3,989,'Dayton 29',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1844,0,null,null,null,1843,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,1152,'Donita, Searcy',3,989,'Dayton 29',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1848,0,null,null,null,1847,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,1152,'Donita, Searcy',3,989,'Dayton 29',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1852,0,null,null,null,1851,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,1152,'Donita, Searcy',3,989,'Dayton 29',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1856,0,null,null,null,1855,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,1152,'Donita, Searcy',3,989,'Dayton 29',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1860,0,null,null,null,1859,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,1152,'Donita, Searcy',3,989,'Dayton 29',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1864,0,null,null,null,1863,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,1152,'Donita, Searcy',3,989,'Dayton 29',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1869,0,null,null,null,1868,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,1152,'Donita, Searcy',3,989,'Dayton 29',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1873,0,null,1150,null,1872,null,1,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,1152,'Donita, Searcy',3,989,'Dayton 29',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1877,0,null,null,null,1876,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,1150,'       , Prematta',3,989,'Dayton 29',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1881,0,null,null,null,1880,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,1150,'       , Prematta',3,989,'Dayton 29',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1885,0,null,null,null,1884,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,1150,'       , Prematta',3,989,'Dayton 29',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1889,0,null,null,null,1888,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,1150,'       , Prematta',3,989,'Dayton 29',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1893,0,null,null,null,1892,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,1150,'       , Prematta',3,989,'Dayton 29',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1897,0,null,null,null,1896,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,1150,'       , Prematta',3,989,'Dayton 29',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1949,0,null,null,null,1948,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,1152,'Donita, Searcy',3,989,'Dayton 29',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1953,0,null,null,null,1952,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,1152,'Donita, Searcy',3,989,'Dayton 29',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1957,0,null,null,null,1956,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,1152,'Donita, Searcy',3,989,'Dayton 29',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1961,0,null,null,null,1960,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,1152,'Donita, Searcy',3,989,'Dayton 29',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1966,0,null,null,null,1965,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,1152,'Donita, Searcy',3,989,'Dayton 29',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1970,0,null,1150,null,1969,null,1,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,1152,'Donita, Searcy',3,989,'Dayton 29',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1974,0,null,null,null,1973,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,1150,'       , Prematta',1,51,'MHVSMFOUR, OLIVIA',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1977,0,null,null,null,1818,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('20-JUN-08','DD-MON-RR'),to_date('20-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),1,55,'MHVSMSIX, ALICE',3,989,'Dayton 29',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1986,0,null,null,null,1818,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('20-JUN-08','DD-MON-RR'),to_date('20-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),1,55,'MHVSMSIX, ALICE',3,989,'Dayton 29',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1996,0,null,null,null,1995,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,83,'MHVSMSTAFFTWO, MARSHA',2,1156,'Jerome, Kola',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2000,0,null,null,null,1999,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,1150,'       , Prematta',1,51,'MHVSMFOUR, OLIVIA',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2003,0,null,null,null,1616,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,86,'MHVSMSTAFFFIVE, ALICE',1,71,'MHVSMFOURTEEN, RINGO',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2006,0,null,null,null,1616,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,86,'MHVSMSTAFFFIVE, ALICE',1,71,'MHVSMFOURTEEN, RINGO',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2009,0,null,null,null,1616,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,86,'MHVSMSTAFFFIVE, ALICE',1,71,'MHVSMFOURTEEN, RINGO',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2012,0,null,null,null,1616,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,86,'MHVSMSTAFFFIVE, ALICE',1,71,'MHVSMFOURTEEN, RINGO',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2015,0,null,null,null,1616,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,86,'MHVSMSTAFFFIVE, ALICE',1,71,'MHVSMFOURTEEN, RINGO',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3128,0,null,null,null,3127,null,0,1,to_date('25-JUL-08','DD-MON-RR'),to_date('25-JUL-08','DD-MON-RR'),null,to_date('25-JUL-08','DD-MON-RR'),2,1150,'Prematta,        ',3,989,'Dayton 29',to_date('25-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3132,0,null,null,null,3131,null,0,1,to_date('25-JUL-08','DD-MON-RR'),to_date('25-JUL-08','DD-MON-RR'),null,to_date('25-JUL-08','DD-MON-RR'),2,1150,'Prematta,        ',3,989,'Dayton 29',to_date('25-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3139,0,null,null,null,3138,null,0,1,to_date('25-JUL-08','DD-MON-RR'),to_date('25-JUL-08','DD-MON-RR'),null,to_date('25-JUL-08','DD-MON-RR'),2,1152,'Searcy, Donita',1,73,'MHVSMFIFTEEN, YOKO',to_date('25-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3142,0,null,null,null,3138,null,0,1,to_date('25-JUL-08','DD-MON-RR'),to_date('31-JUL-08','DD-MON-RR'),to_date('31-JUL-08','DD-MON-RR'),to_date('25-JUL-08','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,989,'Dayton 29',to_date('25-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3153,0,null,null,null,3152,null,0,1,to_date('25-JUL-08','DD-MON-RR'),to_date('25-JUL-08','DD-MON-RR'),null,to_date('25-JUL-08','DD-MON-RR'),2,1152,'Searcy, Donita',3,989,'Dayton 29',to_date('25-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3157,0,null,null,null,3156,null,0,1,to_date('25-JUL-08','DD-MON-RR'),to_date('25-JUL-08','DD-MON-RR'),null,to_date('25-JUL-08','DD-MON-RR'),2,1152,'Searcy, Donita',3,989,'Dayton 29',to_date('25-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2341,0,null,null,null,2340,null,0,1,to_date('27-JUN-08','DD-MON-RR'),to_date('03-JUL-08','DD-MON-RR'),to_date('03-JUL-08','DD-MON-RR'),to_date('27-JUN-08','DD-MON-RR'),1,55,'MHVSMSIX, ALICE',3,989,'Dayton 29',to_date('27-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2351,0,null,null,null,2350,null,0,1,to_date('27-JUN-08','DD-MON-RR'),to_date('03-JUL-08','DD-MON-RR'),to_date('03-JUL-08','DD-MON-RR'),to_date('27-JUN-08','DD-MON-RR'),1,55,'MHVSMSIX, ALICE',3,989,'Dayton 29',to_date('27-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2361,0,null,null,null,2360,null,0,1,to_date('27-JUN-08','DD-MON-RR'),to_date('03-JUL-08','DD-MON-RR'),to_date('03-JUL-08','DD-MON-RR'),to_date('27-JUN-08','DD-MON-RR'),1,55,'MHVSMSIX, ALICE',3,989,'Dayton 29',to_date('27-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2371,0,null,null,null,2370,null,0,1,to_date('27-JUN-08','DD-MON-RR'),to_date('03-JUL-08','DD-MON-RR'),to_date('03-JUL-08','DD-MON-RR'),to_date('27-JUN-08','DD-MON-RR'),1,55,'MHVSMSIX, ALICE',3,989,'Dayton 29',to_date('27-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2380,0,null,null,null,2370,null,0,1,to_date('27-JUN-08','DD-MON-RR'),to_date('27-JUN-08','DD-MON-RR'),null,to_date('27-JUN-08','DD-MON-RR'),2,1152,'Searcy, Donita',1,55,'MHVSMSIX, ALICE',to_date('27-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2383,0,null,null,null,2360,null,0,1,to_date('27-JUN-08','DD-MON-RR'),to_date('27-JUN-08','DD-MON-RR'),null,to_date('27-JUN-08','DD-MON-RR'),2,1152,'Searcy, Donita',1,55,'MHVSMSIX, ALICE',to_date('27-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2386,0,null,null,null,2350,null,0,1,to_date('27-JUN-08','DD-MON-RR'),to_date('27-JUN-08','DD-MON-RR'),null,to_date('27-JUN-08','DD-MON-RR'),2,1152,'Searcy, Donita',1,55,'MHVSMSIX, ALICE',to_date('27-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2389,0,null,null,null,2340,null,0,1,to_date('27-JUN-08','DD-MON-RR'),to_date('27-JUN-08','DD-MON-RR'),null,to_date('27-JUN-08','DD-MON-RR'),2,1152,'Searcy, Donita',1,55,'MHVSMSIX, ALICE',to_date('27-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2392,0,null,null,null,2330,null,0,1,to_date('27-JUN-08','DD-MON-RR'),to_date('27-JUN-08','DD-MON-RR'),null,to_date('27-JUN-08','DD-MON-RR'),2,1152,'Searcy, Donita',1,55,'MHVSMSIX, ALICE',to_date('27-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2395,0,null,null,null,2320,null,0,1,to_date('27-JUN-08','DD-MON-RR'),to_date('27-JUN-08','DD-MON-RR'),null,to_date('27-JUN-08','DD-MON-RR'),2,1152,'Searcy, Donita',1,55,'MHVSMSIX, ALICE',to_date('27-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2399,0,null,null,null,2398,null,0,1,to_date('27-JUN-08','DD-MON-RR'),to_date('03-JUL-08','DD-MON-RR'),to_date('03-JUL-08','DD-MON-RR'),to_date('27-JUN-08','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('27-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2410,0,null,null,null,2409,null,0,1,to_date('27-JUN-08','DD-MON-RR'),to_date('03-JUL-08','DD-MON-RR'),to_date('03-JUL-08','DD-MON-RR'),to_date('27-JUN-08','DD-MON-RR'),1,55,'MHVSMSIX, ALICE',3,989,'Dayton 29',to_date('27-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2420,0,null,null,null,2419,null,0,1,to_date('27-JUN-08','DD-MON-RR'),to_date('03-JUL-08','DD-MON-RR'),to_date('03-JUL-08','DD-MON-RR'),to_date('27-JUN-08','DD-MON-RR'),1,55,'MHVSMSIX, ALICE',3,989,'Dayton 29',to_date('27-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2430,0,null,79,null,2429,null,1,1,to_date('27-JUN-08','DD-MON-RR'),to_date('03-JUL-08','DD-MON-RR'),to_date('03-JUL-08','DD-MON-RR'),to_date('27-JUN-08','DD-MON-RR'),1,55,'MHVSMSIX, ALICE',3,989,'Dayton 29',to_date('27-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2440,0,null,24,null,2439,null,1,1,to_date('27-JUN-08','DD-MON-RR'),to_date('03-JUL-08','DD-MON-RR'),to_date('03-JUL-08','DD-MON-RR'),to_date('27-JUN-08','DD-MON-RR'),1,55,'MHVSMSIX, ALICE',3,989,'Dayton 29',to_date('27-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2450,0,null,82,null,2449,null,1,1,to_date('27-JUN-08','DD-MON-RR'),to_date('03-JUL-08','DD-MON-RR'),to_date('03-JUL-08','DD-MON-RR'),to_date('27-JUN-08','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('27-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1350,20,to_date('16-JUN-08','DD-MON-RR'),null,null,1349,24,1,1,to_date('06-JUN-08','DD-MON-RR'),to_date('12-JUN-08','DD-MON-RR'),to_date('12-JUN-08','DD-MON-RR'),to_date('06-JUN-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',to_date('06-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1360,0,null,null,null,1359,null,0,1,to_date('06-JUN-08','DD-MON-RR'),to_date('06-JUN-08','DD-MON-RR'),null,to_date('06-JUN-08','DD-MON-RR'),2,76,'MHVSMDOCTWO, GREG',2,24,'MHVSMDOCONE, MIKE',to_date('06-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1366,0,null,null,null,1365,null,0,1,to_date('06-JUN-08','DD-MON-RR'),to_date('06-JUN-08','DD-MON-RR'),null,to_date('06-JUN-08','DD-MON-RR'),2,24,'MHVSMDOCONE, MIKE',4,1364,'kola',to_date('06-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1370,0,null,null,null,1369,null,0,1,to_date('06-JUN-08','DD-MON-RR'),to_date('06-JUN-08','DD-MON-RR'),null,to_date('06-JUN-08','DD-MON-RR'),2,24,'MHVSMDOCONE, MIKE',4,1364,'kola',to_date('06-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1375,0,null,null,null,1374,null,0,1,to_date('06-JUN-08','DD-MON-RR'),to_date('06-JUN-08','DD-MON-RR'),null,to_date('06-JUN-08','DD-MON-RR'),2,24,'MHVSMDOCONE, MIKE',4,1364,'kola',to_date('06-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1380,0,null,null,null,1379,null,0,1,to_date('06-JUN-08','DD-MON-RR'),to_date('06-JUN-08','DD-MON-RR'),null,to_date('06-JUN-08','DD-MON-RR'),2,24,'MHVSMDOCONE, MIKE',4,1364,'kola',to_date('06-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1385,0,null,null,null,1384,null,0,1,to_date('06-JUN-08','DD-MON-RR'),to_date('06-JUN-08','DD-MON-RR'),null,to_date('06-JUN-08','DD-MON-RR'),2,18,'Maleyc, Richard',2,1,'Mhvsyst, SM',to_date('06-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1410,0,null,null,null,1398,null,0,1,to_date('06-JUN-08','DD-MON-RR'),to_date('06-JUN-08','DD-MON-RR'),null,to_date('06-JUN-08','DD-MON-RR'),2,24,'MHVSMDOCONE, MIKE',1,29,'MHVSMONE, ALYSSA',to_date('06-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1399,10,null,24,null,1398,24,2,1,to_date('06-JUN-08','DD-MON-RR'),to_date('12-JUN-08','DD-MON-RR'),to_date('12-JUN-08','DD-MON-RR'),to_date('06-JUN-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',to_date('06-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1416,0,null,null,null,1415,null,0,1,to_date('09-JUN-08','DD-MON-RR'),to_date('09-JUN-08','DD-MON-RR'),null,to_date('09-JUN-08','DD-MON-RR'),2,76,'MHVSMDOCTWO, GREG',2,24,'MHVSMDOCONE, MIKE',to_date('09-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1421,0,null,null,null,1420,null,0,1,to_date('09-JUN-08','DD-MON-RR'),to_date('09-JUN-08','DD-MON-RR'),null,to_date('09-JUN-08','DD-MON-RR'),2,76,'MHVSMDOCTWO, GREG',2,24,'MHVSMDOCONE, MIKE',to_date('09-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1426,0,null,null,null,1425,null,0,1,to_date('09-JUN-08','DD-MON-RR'),to_date('09-JUN-08','DD-MON-RR'),null,to_date('09-JUN-08','DD-MON-RR'),2,84,'MHVSMSTAFFTHREE, JAN',2,24,'MHVSMDOCONE, MIKE',to_date('09-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1436,20,to_date('13-JUN-08','DD-MON-RR'),79,null,1435,79,3,1,to_date('13-JUN-08','DD-MON-RR'),to_date('13-JUN-08','DD-MON-RR'),null,to_date('13-JUN-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',to_date('13-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1446,20,to_date('13-JUN-08','DD-MON-RR'),null,null,1445,79,1,1,to_date('13-JUN-08','DD-MON-RR'),to_date('13-JUN-08','DD-MON-RR'),null,to_date('13-JUN-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',to_date('13-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1455,0,null,79,null,1445,null,1,1,to_date('13-JUN-08','DD-MON-RR'),to_date('13-JUN-08','DD-MON-RR'),null,to_date('13-JUN-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',1,29,'MHVSMONE, ALYSSA',to_date('13-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1459,10,null,79,null,1458,79,2,1,to_date('13-JUN-08','DD-MON-RR'),to_date('19-JUN-08','DD-MON-RR'),to_date('19-JUN-08','DD-MON-RR'),to_date('13-JUN-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',to_date('13-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1468,0,null,null,null,1435,null,0,1,to_date('13-JUN-08','DD-MON-RR'),to_date('13-JUN-08','DD-MON-RR'),null,to_date('13-JUN-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',1,29,'MHVSMONE, ALYSSA',to_date('13-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1472,0,null,null,null,1471,null,0,1,to_date('13-JUN-08','DD-MON-RR'),to_date('13-JUN-08','DD-MON-RR'),null,to_date('13-JUN-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',4,1311,'testclin',to_date('13-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1474,0,null,null,null,1471,null,0,1,to_date('13-JUN-08','DD-MON-RR'),to_date('13-JUN-08','DD-MON-RR'),null,to_date('13-JUN-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',2,79,'MHVSMDOCTHREE, PETER',to_date('13-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1477,0,null,null,null,1476,null,0,1,to_date('13-JUN-08','DD-MON-RR'),to_date('13-JUN-08','DD-MON-RR'),null,to_date('13-JUN-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',4,1311,'testclin',to_date('13-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1480,0,null,null,null,1479,null,0,1,to_date('13-JUN-08','DD-MON-RR'),to_date('13-JUN-08','DD-MON-RR'),null,to_date('13-JUN-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',4,1311,'testclin',to_date('13-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1484,0,null,null,null,1483,null,0,1,to_date('13-JUN-08','DD-MON-RR'),to_date('13-JUN-08','DD-MON-RR'),null,to_date('13-JUN-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',4,1311,'testclin',to_date('13-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1488,0,null,1150,null,1487,null,1,1,to_date('13-JUN-08','DD-MON-RR'),to_date('13-JUN-08','DD-MON-RR'),null,to_date('13-JUN-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',4,1311,'testclin',to_date('13-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1493,0,null,null,null,1492,null,0,1,to_date('13-JUN-08','DD-MON-RR'),to_date('13-JUN-08','DD-MON-RR'),null,to_date('13-JUN-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',4,1311,'testclin',to_date('13-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1496,0,null,null,null,1492,null,0,1,to_date('13-JUN-08','DD-MON-RR'),to_date('13-JUN-08','DD-MON-RR'),null,to_date('13-JUN-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',2,79,'MHVSMDOCTHREE, PETER',to_date('13-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1498,0,null,null,null,1479,null,0,1,to_date('13-JUN-08','DD-MON-RR'),to_date('13-JUN-08','DD-MON-RR'),null,to_date('13-JUN-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',2,79,'MHVSMDOCTHREE, PETER',to_date('13-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1500,0,null,null,null,1483,null,0,1,to_date('13-JUN-08','DD-MON-RR'),to_date('13-JUN-08','DD-MON-RR'),null,to_date('13-JUN-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',2,79,'MHVSMDOCTHREE, PETER',to_date('13-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1502,0,null,null,null,1487,null,0,1,to_date('13-JUN-08','DD-MON-RR'),to_date('13-JUN-08','DD-MON-RR'),null,to_date('13-JUN-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',2,79,'MHVSMDOCTHREE, PETER',to_date('13-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1504,0,null,null,null,1476,null,0,1,to_date('13-JUN-08','DD-MON-RR'),to_date('13-JUN-08','DD-MON-RR'),null,to_date('13-JUN-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',2,79,'MHVSMDOCTHREE, PETER',to_date('13-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1506,0,null,null,null,1476,null,0,1,to_date('13-JUN-08','DD-MON-RR'),to_date('13-JUN-08','DD-MON-RR'),null,to_date('13-JUN-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',2,79,'MHVSMDOCTHREE, PETER',to_date('13-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1509,0,null,null,null,1508,null,0,1,to_date('13-JUN-08','DD-MON-RR'),to_date('13-JUN-08','DD-MON-RR'),null,to_date('13-JUN-08','DD-MON-RR'),2,1150,'       , Prematta',1,51,'MHVSMFOUR, OLIVIA',to_date('13-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1515,0,null,null,null,1514,null,0,1,to_date('13-JUN-08','DD-MON-RR'),to_date('19-JUN-08','DD-MON-RR'),to_date('19-JUN-08','DD-MON-RR'),to_date('13-JUN-08','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,989,'Dayton 29',to_date('13-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1286,0,null,null,null,1285,null,0,1,to_date('06-JUN-08','DD-MON-RR'),to_date('06-JUN-08','DD-MON-RR'),null,to_date('06-JUN-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',1,51,'MHVSMFOUR, OLIVIA',to_date('06-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1290,0,null,null,null,1289,null,0,1,to_date('06-JUN-08','DD-MON-RR'),to_date('06-JUN-08','DD-MON-RR'),null,to_date('06-JUN-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',1,51,'MHVSMFOUR, OLIVIA',to_date('06-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1301,10,null,1150,null,1300,24,2,1,to_date('06-JUN-08','DD-MON-RR'),to_date('12-JUN-08','DD-MON-RR'),to_date('12-JUN-08','DD-MON-RR'),to_date('06-JUN-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',to_date('06-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1315,0,null,null,null,1314,null,0,1,to_date('06-JUN-08','DD-MON-RR'),to_date('12-JUN-08','DD-MON-RR'),to_date('12-JUN-08','DD-MON-RR'),to_date('06-JUN-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',to_date('06-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1325,0,null,null,null,1324,null,0,1,to_date('06-JUN-08','DD-MON-RR'),to_date('12-JUN-08','DD-MON-RR'),to_date('12-JUN-08','DD-MON-RR'),to_date('06-JUN-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',to_date('06-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1337,0,null,null,null,1336,null,0,1,to_date('06-JUN-08','DD-MON-RR'),to_date('12-JUN-08','DD-MON-RR'),to_date('12-JUN-08','DD-MON-RR'),to_date('06-JUN-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',to_date('06-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2133,0,null,86,null,2132,null,1,1,to_date('18-JUN-08','DD-MON-RR'),to_date('24-JUN-08','DD-MON-RR'),to_date('24-JUN-08','DD-MON-RR'),to_date('18-JUN-08','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('18-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2144,0,null,null,null,2143,null,0,1,to_date('19-JUN-08','DD-MON-RR'),to_date('25-JUN-08','DD-MON-RR'),to_date('25-JUN-08','DD-MON-RR'),to_date('19-JUN-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',to_date('19-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2154,0,null,null,null,2153,null,0,1,to_date('19-JUN-08','DD-MON-RR'),to_date('25-JUN-08','DD-MON-RR'),to_date('25-JUN-08','DD-MON-RR'),to_date('19-JUN-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',to_date('19-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2168,10,null,79,null,2167,79,2,1,to_date('19-JUN-08','DD-MON-RR'),to_date('25-JUN-08','DD-MON-RR'),to_date('25-JUN-08','DD-MON-RR'),to_date('19-JUN-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',to_date('19-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2178,0,null,null,null,2177,null,0,1,to_date('19-JUN-08','DD-MON-RR'),to_date('25-JUN-08','DD-MON-RR'),to_date('25-JUN-08','DD-MON-RR'),to_date('19-JUN-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',to_date('19-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2188,0,null,null,null,2177,null,0,1,to_date('19-JUN-08','DD-MON-RR'),to_date('19-JUN-08','DD-MON-RR'),null,to_date('19-JUN-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',1,29,'MHVSMONE, ALYSSA',to_date('19-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2191,0,null,null,null,2167,null,0,1,to_date('19-JUN-08','DD-MON-RR'),to_date('19-JUN-08','DD-MON-RR'),null,to_date('19-JUN-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',1,29,'MHVSMONE, ALYSSA',to_date('19-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2200,0,null,null,null,2199,null,0,1,to_date('26-JUN-08','DD-MON-RR'),to_date('02-JUL-08','DD-MON-RR'),to_date('02-JUL-08','DD-MON-RR'),to_date('26-JUN-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',to_date('26-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2210,0,null,24,null,2209,null,1,1,to_date('26-JUN-08','DD-MON-RR'),to_date('02-JUL-08','DD-MON-RR'),to_date('02-JUL-08','DD-MON-RR'),to_date('26-JUN-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',to_date('26-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2220,0,null,null,null,2209,null,0,1,to_date('26-JUN-08','DD-MON-RR'),to_date('26-JUN-08','DD-MON-RR'),null,to_date('26-JUN-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',1,29,'MHVSMONE, ALYSSA',to_date('26-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2223,0,null,null,null,2199,null,0,1,to_date('26-JUN-08','DD-MON-RR'),to_date('26-JUN-08','DD-MON-RR'),null,to_date('26-JUN-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',1,29,'MHVSMONE, ALYSSA',to_date('26-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2231,0,null,1156,null,2230,null,1,1,to_date('27-JUN-08','DD-MON-RR'),to_date('03-JUL-08','DD-MON-RR'),to_date('03-JUL-08','DD-MON-RR'),to_date('27-JUN-08','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('27-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2242,0,null,null,null,2177,null,0,1,to_date('27-JUN-08','DD-MON-RR'),to_date('27-JUN-08','DD-MON-RR'),null,to_date('27-JUN-08','DD-MON-RR'),2,1150,'Prematta,        ',1,29,'MHVSMONE, ALYSSA',to_date('27-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2246,0,null,1150,null,2245,null,1,1,to_date('27-JUN-08','DD-MON-RR'),to_date('03-JUL-08','DD-MON-RR'),to_date('03-JUL-08','DD-MON-RR'),to_date('27-JUN-08','DD-MON-RR'),1,51,'MHVSMFOUR, OLIVIA',3,989,'Dayton 29',to_date('27-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2255,0,null,null,null,2245,null,0,1,to_date('27-JUN-08','DD-MON-RR'),to_date('27-JUN-08','DD-MON-RR'),null,to_date('27-JUN-08','DD-MON-RR'),2,1150,'Prematta,        ',1,51,'MHVSMFOUR, OLIVIA',to_date('27-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2259,0,null,null,null,2258,null,0,1,to_date('27-JUN-08','DD-MON-RR'),to_date('27-JUN-08','DD-MON-RR'),null,to_date('27-JUN-08','DD-MON-RR'),2,1150,'Prematta,        ',3,989,'Dayton 29',to_date('27-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2263,0,null,null,null,2262,null,0,1,to_date('27-JUN-08','DD-MON-RR'),to_date('27-JUN-08','DD-MON-RR'),null,to_date('27-JUN-08','DD-MON-RR'),2,1150,'Prematta,        ',3,989,'Dayton 29',to_date('27-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2267,0,null,null,null,2266,null,0,1,to_date('27-JUN-08','DD-MON-RR'),to_date('27-JUN-08','DD-MON-RR'),null,to_date('27-JUN-08','DD-MON-RR'),2,1150,'Prematta,        ',3,989,'Dayton 29',to_date('27-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2271,0,null,null,null,2270,null,0,1,to_date('27-JUN-08','DD-MON-RR'),to_date('27-JUN-08','DD-MON-RR'),null,to_date('27-JUN-08','DD-MON-RR'),2,1150,'Prematta,        ',3,989,'Dayton 29',to_date('27-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2275,0,null,null,null,2274,null,0,1,to_date('27-JUN-08','DD-MON-RR'),to_date('27-JUN-08','DD-MON-RR'),null,to_date('27-JUN-08','DD-MON-RR'),2,1150,'Prematta,        ',3,989,'Dayton 29',to_date('27-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2279,0,null,null,null,2278,null,0,1,to_date('27-JUN-08','DD-MON-RR'),to_date('27-JUN-08','DD-MON-RR'),null,to_date('27-JUN-08','DD-MON-RR'),2,1150,'Prematta,        ',3,989,'Dayton 29',to_date('27-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2282,0,null,null,null,2270,null,0,1,to_date('27-JUN-08','DD-MON-RR'),to_date('27-JUN-08','DD-MON-RR'),null,to_date('27-JUN-08','DD-MON-RR'),2,84,'MHVSMSTAFFTHREE, JAN',2,1150,'Prematta,        ',to_date('27-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2286,20,to_date('27-JUN-08','DD-MON-RR'),null,null,2285,79,1,1,to_date('27-JUN-08','DD-MON-RR'),to_date('27-JUN-08','DD-MON-RR'),null,to_date('27-JUN-08','DD-MON-RR'),2,1150,'Prematta,        ',2,79,'MHVSMDOCTHREE, PETER',to_date('27-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2291,10,null,null,null,2285,1150,1,1,to_date('27-JUN-08','DD-MON-RR'),to_date('27-JUN-08','DD-MON-RR'),null,to_date('27-JUN-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',2,1150,'Prematta,        ',to_date('27-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2299,0,null,null,null,2298,null,0,1,to_date('27-JUN-08','DD-MON-RR'),to_date('03-JUL-08','DD-MON-RR'),to_date('03-JUL-08','DD-MON-RR'),to_date('27-JUN-08','DD-MON-RR'),1,55,'MHVSMSIX, ALICE',3,989,'Dayton 29',to_date('27-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2309,0,null,null,null,2308,null,0,1,to_date('27-JUN-08','DD-MON-RR'),to_date('27-JUN-08','DD-MON-RR'),null,to_date('27-JUN-08','DD-MON-RR'),2,1152,'Searcy, Donita',1,55,'MHVSMSIX, ALICE',to_date('27-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2313,0,null,null,null,2312,null,0,1,to_date('27-JUN-08','DD-MON-RR'),to_date('27-JUN-08','DD-MON-RR'),null,to_date('27-JUN-08','DD-MON-RR'),2,1152,'Searcy, Donita',1,55,'MHVSMSIX, ALICE',to_date('27-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2317,0,null,null,null,2316,null,0,1,to_date('27-JUN-08','DD-MON-RR'),to_date('27-JUN-08','DD-MON-RR'),null,to_date('27-JUN-08','DD-MON-RR'),2,1152,'Searcy, Donita',1,55,'MHVSMSIX, ALICE',to_date('27-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2321,0,null,null,null,2320,null,0,1,to_date('27-JUN-08','DD-MON-RR'),to_date('03-JUL-08','DD-MON-RR'),to_date('03-JUL-08','DD-MON-RR'),to_date('27-JUN-08','DD-MON-RR'),1,55,'MHVSMSIX, ALICE',3,989,'Dayton 29',to_date('27-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2331,0,null,null,null,2330,null,0,1,to_date('27-JUN-08','DD-MON-RR'),to_date('03-JUL-08','DD-MON-RR'),to_date('03-JUL-08','DD-MON-RR'),to_date('27-JUN-08','DD-MON-RR'),1,55,'MHVSMSIX, ALICE',3,989,'Dayton 29',to_date('27-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2461,0,null,1150,null,2460,null,1,1,to_date('27-JUN-08','DD-MON-RR'),to_date('03-JUL-08','DD-MON-RR'),to_date('03-JUL-08','DD-MON-RR'),to_date('27-JUN-08','DD-MON-RR'),1,55,'MHVSMSIX, ALICE',3,989,'Dayton 29',to_date('27-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2471,20,to_date('30-JUN-08','DD-MON-RR'),1150,null,2470,79,2,1,to_date('30-JUN-08','DD-MON-RR'),to_date('30-JUN-08','DD-MON-RR'),null,to_date('30-JUN-08','DD-MON-RR'),2,1150,'Prematta,        ',2,79,'MHVSMDOCTHREE, PETER',to_date('30-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2474,0,null,null,null,2470,null,0,1,to_date('30-JUN-08','DD-MON-RR'),to_date('30-JUN-08','DD-MON-RR'),null,to_date('30-JUN-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',2,1150,'Prematta,        ',to_date('30-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2477,0,null,null,null,2470,null,0,1,to_date('30-JUN-08','DD-MON-RR'),to_date('30-JUN-08','DD-MON-RR'),null,to_date('30-JUN-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',2,1150,'Prematta,        ',to_date('30-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2482,0,null,80,null,2481,null,1,1,to_date('30-JUN-08','DD-MON-RR'),to_date('30-JUN-08','DD-MON-RR'),null,to_date('30-JUN-08','DD-MON-RR'),2,80,'MHVSMDOCFOUR, BOBBIE',2,1156,'Kola, Jerome',to_date('30-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2487,20,to_date('24-JUL-08','DD-MON-RR'),83,null,2486,1156,3,1,to_date('30-JUN-08','DD-MON-RR'),to_date('04-JUL-08','DD-MON-RR'),to_date('04-JUL-08','DD-MON-RR'),to_date('30-JUN-08','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('30-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2496,0,null,null,null,2486,null,0,1,to_date('30-JUN-08','DD-MON-RR'),to_date('30-JUN-08','DD-MON-RR'),null,to_date('30-JUN-08','DD-MON-RR'),2,1156,'Kola, Jerome',1,61,'MHVSMNINE, MABEL',to_date('30-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2532,0,null,null,null,2470,null,0,1,to_date('30-JUN-08','DD-MON-RR'),to_date('30-JUN-08','DD-MON-RR'),null,to_date('30-JUN-08','DD-MON-RR'),2,1150,'Prematta,        ',2,79,'MHVSMDOCTHREE, PETER',to_date('30-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2506,0,null,null,null,2505,null,0,1,to_date('30-JUN-08','DD-MON-RR'),to_date('30-JUN-08','DD-MON-RR'),null,to_date('30-JUN-08','DD-MON-RR'),2,1150,'Prematta,        ',3,989,'Dayton 29',to_date('30-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2510,0,null,null,null,2509,null,0,1,to_date('30-JUN-08','DD-MON-RR'),to_date('30-JUN-08','DD-MON-RR'),null,to_date('30-JUN-08','DD-MON-RR'),2,1150,'Prematta,        ',3,989,'Dayton 29',to_date('30-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2514,0,null,null,null,2513,null,0,1,to_date('30-JUN-08','DD-MON-RR'),to_date('30-JUN-08','DD-MON-RR'),null,to_date('30-JUN-08','DD-MON-RR'),2,1150,'Prematta,        ',3,989,'Dayton 29',to_date('30-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2518,0,null,null,null,2517,null,0,1,to_date('30-JUN-08','DD-MON-RR'),to_date('30-JUN-08','DD-MON-RR'),null,to_date('30-JUN-08','DD-MON-RR'),2,1150,'Prematta,        ',3,989,'Dayton 29',to_date('30-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2522,0,null,null,null,2521,null,0,1,to_date('30-JUN-08','DD-MON-RR'),to_date('30-JUN-08','DD-MON-RR'),null,to_date('30-JUN-08','DD-MON-RR'),2,1150,'Prematta,        ',3,989,'Dayton 29',to_date('30-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2526,0,null,null,null,2525,null,0,1,to_date('30-JUN-08','DD-MON-RR'),to_date('30-JUN-08','DD-MON-RR'),null,to_date('30-JUN-08','DD-MON-RR'),2,1150,'Prematta,        ',3,989,'Dayton 29',to_date('30-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2529,0,null,null,null,2517,null,0,1,to_date('30-JUN-08','DD-MON-RR'),to_date('30-JUN-08','DD-MON-RR'),null,to_date('30-JUN-08','DD-MON-RR'),2,84,'MHVSMSTAFFTHREE, JAN',2,1150,'Prematta,        ',to_date('30-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2536,0,null,null,null,2470,null,0,1,to_date('30-JUN-08','DD-MON-RR'),to_date('30-JUN-08','DD-MON-RR'),null,to_date('30-JUN-08','DD-MON-RR'),2,1150,'Prematta,        ',2,79,'MHVSMDOCTHREE, PETER',to_date('30-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2541,0,null,null,null,2540,null,0,1,to_date('30-JUN-08','DD-MON-RR'),to_date('30-JUN-08','DD-MON-RR'),null,to_date('30-JUN-08','DD-MON-RR'),2,1150,'Prematta,        ',4,2539,'Test group 2',to_date('30-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2545,0,null,null,null,2544,null,0,1,to_date('30-JUN-08','DD-MON-RR'),to_date('30-JUN-08','DD-MON-RR'),null,to_date('30-JUN-08','DD-MON-RR'),2,1150,'Prematta,        ',4,2539,'Test group 2',to_date('30-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2549,0,null,null,null,2548,null,0,1,to_date('30-JUN-08','DD-MON-RR'),to_date('30-JUN-08','DD-MON-RR'),null,to_date('30-JUN-08','DD-MON-RR'),2,1150,'Prematta,        ',4,2539,'Test group 2',to_date('30-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2553,0,null,null,null,2552,null,0,1,to_date('30-JUN-08','DD-MON-RR'),to_date('30-JUN-08','DD-MON-RR'),null,to_date('30-JUN-08','DD-MON-RR'),2,1150,'Prematta,        ',4,2539,'Test group 2',to_date('30-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2557,20,to_date('24-JUL-08','DD-MON-RR'),null,null,2556,1156,1,1,to_date('30-JUN-08','DD-MON-RR'),to_date('04-JUL-08','DD-MON-RR'),to_date('04-JUL-08','DD-MON-RR'),to_date('30-JUN-08','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('30-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2570,20,to_date('09-JUL-08','DD-MON-RR'),null,null,2569,79,1,1,to_date('09-JUL-08','DD-MON-RR'),to_date('09-JUL-08','DD-MON-RR'),null,to_date('09-JUL-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',to_date('09-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2580,10,null,79,null,2579,79,2,1,to_date('09-JUL-08','DD-MON-RR'),to_date('15-JUL-08','DD-MON-RR'),to_date('15-JUL-08','DD-MON-RR'),to_date('09-JUL-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',to_date('09-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2590,0,null,null,null,2569,null,0,1,to_date('09-JUL-08','DD-MON-RR'),to_date('09-JUL-08','DD-MON-RR'),null,to_date('09-JUL-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',1,29,'MHVSMONE, ALYSSA',to_date('09-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2595,0,null,null,null,2594,null,0,1,to_date('09-JUL-08','DD-MON-RR'),to_date('09-JUL-08','DD-MON-RR'),null,to_date('09-JUL-08','DD-MON-RR'),2,1150,'Prematta,        ',1,51,'MHVSMFOUR, OLIVIA',to_date('09-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2606,0,null,null,null,2605,null,0,1,to_date('09-JUL-08','DD-MON-RR'),to_date('15-JUL-08','DD-MON-RR'),to_date('15-JUL-08','DD-MON-RR'),to_date('09-JUL-08','DD-MON-RR'),1,51,'MHVSMFOUR, OLIVIA',3,989,'Dayton 29',to_date('09-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2616,0,null,null,null,2615,null,0,1,to_date('09-JUL-08','DD-MON-RR'),to_date('09-JUL-08','DD-MON-RR'),null,to_date('09-JUL-08','DD-MON-RR'),2,1150,'Prematta,        ',3,989,'Dayton 29',to_date('09-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2620,0,null,null,null,2619,null,0,1,to_date('09-JUL-08','DD-MON-RR'),to_date('09-JUL-08','DD-MON-RR'),null,to_date('09-JUL-08','DD-MON-RR'),2,1150,'Prematta,        ',3,989,'Dayton 29',to_date('09-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2624,0,null,null,null,2623,null,0,1,to_date('09-JUL-08','DD-MON-RR'),to_date('09-JUL-08','DD-MON-RR'),null,to_date('09-JUL-08','DD-MON-RR'),2,1150,'Prematta,        ',3,989,'Dayton 29',to_date('09-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2628,0,null,null,null,2627,null,0,1,to_date('09-JUL-08','DD-MON-RR'),to_date('09-JUL-08','DD-MON-RR'),null,to_date('09-JUL-08','DD-MON-RR'),2,1150,'Prematta,        ',3,989,'Dayton 29',to_date('09-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2632,0,null,null,null,2631,null,0,1,to_date('09-JUL-08','DD-MON-RR'),to_date('09-JUL-08','DD-MON-RR'),null,to_date('09-JUL-08','DD-MON-RR'),2,1150,'Prematta,        ',3,989,'Dayton 29',to_date('09-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2636,0,null,null,null,2635,null,0,1,to_date('09-JUL-08','DD-MON-RR'),to_date('09-JUL-08','DD-MON-RR'),null,to_date('09-JUL-08','DD-MON-RR'),2,1150,'Prematta,        ',3,989,'Dayton 29',to_date('09-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2640,0,null,null,null,2639,null,0,1,to_date('09-JUL-08','DD-MON-RR'),to_date('09-JUL-08','DD-MON-RR'),null,to_date('09-JUL-08','DD-MON-RR'),2,1150,'Prematta,        ',2,79,'MHVSMDOCTHREE, PETER',to_date('09-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2659,0,null,null,null,2658,null,0,1,to_date('10-JUL-08','DD-MON-RR'),to_date('10-JUL-08','DD-MON-RR'),null,to_date('10-JUL-08','DD-MON-RR'),2,86,'MHVSMSTAFFFIVE, ALICE',4,2657,'Trige Distribution Group SM1.0',to_date('10-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2663,0,null,null,null,2662,null,0,1,to_date('10-JUL-08','DD-MON-RR'),to_date('10-JUL-08','DD-MON-RR'),null,to_date('10-JUL-08','DD-MON-RR'),2,86,'MHVSMSTAFFFIVE, ALICE',4,2657,'Trige Distribution Group SM1.0',to_date('10-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2667,0,null,null,null,2666,null,0,1,to_date('10-JUL-08','DD-MON-RR'),to_date('10-JUL-08','DD-MON-RR'),null,to_date('10-JUL-08','DD-MON-RR'),2,86,'MHVSMSTAFFFIVE, ALICE',4,2657,'Trige Distribution Group SM1.0',to_date('10-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2671,0,null,null,null,2670,null,0,1,to_date('10-JUL-08','DD-MON-RR'),to_date('10-JUL-08','DD-MON-RR'),null,to_date('10-JUL-08','DD-MON-RR'),2,1152,'Searcy, Donita',4,2669,'Clinician Distr Group SM 1.0I',to_date('10-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2675,0,null,null,null,2674,null,0,1,to_date('10-JUL-08','DD-MON-RR'),to_date('10-JUL-08','DD-MON-RR'),null,to_date('10-JUL-08','DD-MON-RR'),2,1152,'Searcy, Donita',4,2669,'Clinician Distr Group SM 1.0I',to_date('10-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2679,0,null,null,null,2678,null,0,1,to_date('10-JUL-08','DD-MON-RR'),to_date('10-JUL-08','DD-MON-RR'),null,to_date('10-JUL-08','DD-MON-RR'),2,1152,'Searcy, Donita',4,2669,'Clinician Distr Group SM 1.0I',to_date('10-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2683,0,null,null,null,2682,null,0,1,to_date('10-JUL-08','DD-MON-RR'),to_date('10-JUL-08','DD-MON-RR'),null,to_date('10-JUL-08','DD-MON-RR'),2,1152,'Searcy, Donita',4,2669,'Clinician Distr Group SM 1.0I',to_date('10-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2687,0,null,null,null,2686,null,0,1,to_date('10-JUL-08','DD-MON-RR'),to_date('10-JUL-08','DD-MON-RR'),null,to_date('10-JUL-08','DD-MON-RR'),2,1152,'Searcy, Donita',4,2669,'Clinician Distr Group SM 1.0I',to_date('10-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2691,0,null,null,null,2690,null,0,1,to_date('10-JUL-08','DD-MON-RR'),to_date('10-JUL-08','DD-MON-RR'),null,to_date('10-JUL-08','DD-MON-RR'),2,1152,'Searcy, Donita',4,2669,'Clinician Distr Group SM 1.0I',to_date('10-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2695,0,null,null,null,2694,null,0,1,to_date('10-JUL-08','DD-MON-RR'),to_date('10-JUL-08','DD-MON-RR'),null,to_date('10-JUL-08','DD-MON-RR'),2,1152,'Searcy, Donita',4,2669,'Clinician Distr Group SM 1.0I',to_date('10-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2699,0,null,null,null,2698,null,0,1,to_date('10-JUL-08','DD-MON-RR'),to_date('10-JUL-08','DD-MON-RR'),null,to_date('10-JUL-08','DD-MON-RR'),2,1152,'Searcy, Donita',4,2669,'Clinician Distr Group SM 1.0I',to_date('10-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2703,0,null,null,null,2702,null,0,1,to_date('10-JUL-08','DD-MON-RR'),to_date('10-JUL-08','DD-MON-RR'),null,to_date('10-JUL-08','DD-MON-RR'),2,1152,'Searcy, Donita',4,2669,'Clinician Distr Group SM 1.0I',to_date('10-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2707,0,null,null,null,2706,null,0,1,to_date('10-JUL-08','DD-MON-RR'),to_date('10-JUL-08','DD-MON-RR'),null,to_date('10-JUL-08','DD-MON-RR'),2,1152,'Searcy, Donita',4,2669,'Clinician Distr Group SM 1.0I',to_date('10-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2711,0,null,null,null,2710,null,0,1,to_date('10-JUL-08','DD-MON-RR'),to_date('10-JUL-08','DD-MON-RR'),null,to_date('10-JUL-08','DD-MON-RR'),2,1152,'Searcy, Donita',4,2669,'Clinician Distr Group SM 1.0I',to_date('10-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2715,0,null,null,null,2714,null,0,1,to_date('10-JUL-08','DD-MON-RR'),to_date('10-JUL-08','DD-MON-RR'),null,null,1,55,'MHVSMSIX, ALICE',null,null,null,null,null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2718,0,null,null,null,2717,null,2,1,to_date('10-JUL-08','DD-MON-RR'),to_date('10-JUL-08','DD-MON-RR'),null,null,1,55,'MHVSMSIX, ALICE',null,null,null,null,null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2721,0,null,null,null,2720,null,0,1,to_date('10-JUL-08','DD-MON-RR'),to_date('10-JUL-08','DD-MON-RR'),null,to_date('10-JUL-08','DD-MON-RR'),2,86,'MHVSMSTAFFFIVE, ALICE',2,81,'MHVSMDOCFIVE, SAM',to_date('10-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2725,0,null,null,null,2724,null,0,1,to_date('10-JUL-08','DD-MON-RR'),to_date('10-JUL-08','DD-MON-RR'),null,null,2,86,'MHVSMSTAFFFIVE, ALICE',1,71,'MHVSMFOURTEEN, RINGO',null,null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2728,0,null,null,null,2727,null,0,1,to_date('10-JUL-08','DD-MON-RR'),to_date('10-JUL-08','DD-MON-RR'),null,null,2,1152,'Searcy, Donita',1,55,'MHVSMSIX, ALICE',null,null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2745,0,null,null,null,2744,null,0,1,to_date('11-JUL-08','DD-MON-RR'),to_date('11-JUL-08','DD-MON-RR'),null,to_date('11-JUL-08','DD-MON-RR'),2,1152,'Searcy, Donita',4,2669,'Clinician Distr Group SM 1.0I',to_date('11-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2749,0,null,null,null,2748,null,0,1,to_date('11-JUL-08','DD-MON-RR'),to_date('11-JUL-08','DD-MON-RR'),null,to_date('11-JUL-08','DD-MON-RR'),2,1152,'Searcy, Donita',4,2669,'Clinician Distr Group SM 1.0I',to_date('11-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2753,0,null,null,null,2752,null,0,1,to_date('11-JUL-08','DD-MON-RR'),to_date('11-JUL-08','DD-MON-RR'),null,to_date('11-JUL-08','DD-MON-RR'),2,1152,'Searcy, Donita',4,2669,'Clinician Distr Group SM 1.0I',to_date('11-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2757,0,null,null,null,2756,null,0,1,to_date('11-JUL-08','DD-MON-RR'),to_date('11-JUL-08','DD-MON-RR'),null,to_date('11-JUL-08','DD-MON-RR'),2,1152,'Searcy, Donita',4,2669,'Clinician Distr Group SM 1.0I',to_date('11-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2761,0,null,null,null,2760,null,0,1,to_date('11-JUL-08','DD-MON-RR'),to_date('11-JUL-08','DD-MON-RR'),null,to_date('11-JUL-08','DD-MON-RR'),2,1152,'Searcy, Donita',4,2669,'Clinician Distr Group SM 1.0I',to_date('11-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2765,0,null,null,null,2764,null,0,1,to_date('11-JUL-08','DD-MON-RR'),to_date('11-JUL-08','DD-MON-RR'),null,to_date('11-JUL-08','DD-MON-RR'),2,1152,'Searcy, Donita',4,2669,'Clinician Distr Group SM 1.0I',to_date('11-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2769,0,null,null,null,2768,null,0,1,to_date('11-JUL-08','DD-MON-RR'),to_date('11-JUL-08','DD-MON-RR'),null,to_date('11-JUL-08','DD-MON-RR'),2,1152,'Searcy, Donita',4,2669,'Clinician Distr Group SM 1.0I',to_date('11-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2773,0,null,null,null,2772,null,0,1,to_date('11-JUL-08','DD-MON-RR'),to_date('11-JUL-08','DD-MON-RR'),null,to_date('11-JUL-08','DD-MON-RR'),2,1152,'Searcy, Donita',4,2669,'Clinician Distr Group SM 1.0I',to_date('11-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2777,0,null,null,null,2776,null,0,1,to_date('11-JUL-08','DD-MON-RR'),to_date('11-JUL-08','DD-MON-RR'),null,to_date('11-JUL-08','DD-MON-RR'),2,1152,'Searcy, Donita',4,2669,'Clinician Distr Group SM 1.0I',to_date('11-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2781,0,null,null,null,2780,null,0,1,to_date('11-JUL-08','DD-MON-RR'),to_date('11-JUL-08','DD-MON-RR'),null,to_date('11-JUL-08','DD-MON-RR'),2,1152,'Searcy, Donita',4,2669,'Clinician Distr Group SM 1.0I',to_date('11-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2785,0,null,null,null,2784,null,0,1,to_date('11-JUL-08','DD-MON-RR'),to_date('11-JUL-08','DD-MON-RR'),null,to_date('11-JUL-08','DD-MON-RR'),2,86,'MHVSMSTAFFFIVE, ALICE',4,2657,'Trige Distribution Group SM1.0',to_date('11-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2789,0,null,null,null,2788,null,0,1,to_date('11-JUL-08','DD-MON-RR'),to_date('11-JUL-08','DD-MON-RR'),null,to_date('11-JUL-08','DD-MON-RR'),2,86,'MHVSMSTAFFFIVE, ALICE',4,2657,'Trige Distribution Group SM1.0',to_date('11-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2793,0,null,null,null,2792,null,0,1,to_date('11-JUL-08','DD-MON-RR'),to_date('11-JUL-08','DD-MON-RR'),null,to_date('11-JUL-08','DD-MON-RR'),2,86,'MHVSMSTAFFFIVE, ALICE',4,2657,'Trige Distribution Group SM1.0',to_date('11-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2826,10,null,24,null,2825,79,2,1,to_date('22-JUL-08','DD-MON-RR'),to_date('26-JUL-08','DD-MON-RR'),to_date('26-JUL-08','DD-MON-RR'),to_date('22-JUL-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',to_date('22-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2836,20,to_date('22-JUL-08','DD-MON-RR'),1150,null,2835,79,2,1,to_date('22-JUL-08','DD-MON-RR'),to_date('22-JUL-08','DD-MON-RR'),null,to_date('22-JUL-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',to_date('22-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2845,0,null,null,null,2835,null,0,1,to_date('22-JUL-08','DD-MON-RR'),to_date('22-JUL-08','DD-MON-RR'),null,to_date('22-JUL-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',1,29,'MHVSMONE, ALYSSA',to_date('22-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2849,10,null,24,null,2848,79,2,1,to_date('22-JUL-08','DD-MON-RR'),to_date('26-JUL-08','DD-MON-RR'),to_date('26-JUL-08','DD-MON-RR'),to_date('22-JUL-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',to_date('22-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2859,20,to_date('22-JUL-08','DD-MON-RR'),1150,null,2858,79,3,1,to_date('22-JUL-08','DD-MON-RR'),to_date('22-JUL-08','DD-MON-RR'),null,to_date('22-JUL-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',to_date('22-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2868,0,null,null,null,2858,null,0,1,to_date('22-JUL-08','DD-MON-RR'),to_date('22-JUL-08','DD-MON-RR'),null,to_date('22-JUL-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',1,29,'MHVSMONE, ALYSSA',to_date('22-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2873,20,to_date('23-JUL-08','DD-MON-RR'),1150,null,2872,79,3,1,to_date('23-JUL-08','DD-MON-RR'),to_date('23-JUL-08','DD-MON-RR'),null,to_date('23-JUL-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',to_date('23-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2883,20,to_date('23-JUL-08','DD-MON-RR'),1152,null,2882,79,2,1,to_date('23-JUL-08','DD-MON-RR'),to_date('23-JUL-08','DD-MON-RR'),null,to_date('23-JUL-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',to_date('23-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2892,0,null,null,null,2882,null,0,1,to_date('23-JUL-08','DD-MON-RR'),to_date('23-JUL-08','DD-MON-RR'),null,to_date('23-JUL-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',1,29,'MHVSMONE, ALYSSA',to_date('23-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2895,0,null,null,null,2872,null,0,1,to_date('23-JUL-08','DD-MON-RR'),to_date('23-JUL-08','DD-MON-RR'),null,to_date('23-JUL-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',1,29,'MHVSMONE, ALYSSA',to_date('23-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2903,0,null,null,null,2902,null,0,1,to_date('24-JUL-08','DD-MON-RR'),to_date('30-JUL-08','DD-MON-RR'),to_date('30-JUL-08','DD-MON-RR'),to_date('24-JUL-08','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('24-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2913,0,null,null,null,2912,null,0,1,to_date('24-JUL-08','DD-MON-RR'),to_date('30-JUL-08','DD-MON-RR'),to_date('30-JUL-08','DD-MON-RR'),to_date('24-JUL-08','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('24-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2923,0,null,null,null,2922,null,0,1,to_date('24-JUL-08','DD-MON-RR'),to_date('30-JUL-08','DD-MON-RR'),to_date('30-JUL-08','DD-MON-RR'),to_date('24-JUL-08','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('24-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2933,0,null,null,null,2932,null,0,1,to_date('24-JUL-08','DD-MON-RR'),to_date('30-JUL-08','DD-MON-RR'),to_date('30-JUL-08','DD-MON-RR'),to_date('24-JUL-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',to_date('24-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2945,0,null,null,null,2944,null,0,1,to_date('24-JUL-08','DD-MON-RR'),to_date('30-JUL-08','DD-MON-RR'),to_date('30-JUL-08','DD-MON-RR'),to_date('24-JUL-08','DD-MON-RR'),1,71,'MHVSMFOURTEEN, RINGO',3,979,'SLC10',to_date('24-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2955,0,null,null,null,2954,null,0,1,to_date('24-JUL-08','DD-MON-RR'),to_date('30-JUL-08','DD-MON-RR'),to_date('30-JUL-08','DD-MON-RR'),to_date('24-JUL-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',to_date('24-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2964,0,null,null,null,2872,null,0,1,to_date('24-JUL-08','DD-MON-RR'),to_date('30-JUL-08','DD-MON-RR'),to_date('30-JUL-08','DD-MON-RR'),to_date('24-JUL-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',to_date('24-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2974,0,null,null,null,2973,null,0,1,to_date('24-JUL-08','DD-MON-RR'),to_date('30-JUL-08','DD-MON-RR'),to_date('30-JUL-08','DD-MON-RR'),to_date('24-JUL-08','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('24-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2984,0,null,null,null,2983,null,0,1,to_date('24-JUL-08','DD-MON-RR'),to_date('24-JUL-08','DD-MON-RR'),null,to_date('24-JUL-08','DD-MON-RR'),2,81,'MHVSMDOCFIVE, SAM',2,2796,'Balasubramanian, Swetha',to_date('24-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2996,20,to_date('20-FEB-09','DD-MON-RR'),2796,null,2995,2796,2,1,to_date('24-JUL-08','DD-MON-RR'),to_date('24-JUL-08','DD-MON-RR'),null,to_date('24-JUL-08','DD-MON-RR'),2,1156,'Kola, Jerome',2,2796,'Balasubramanian, Swetha',to_date('24-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3000,10,null,80,null,2999,82,3,1,to_date('24-JUL-08','DD-MON-RR'),to_date('30-JUL-08','DD-MON-RR'),to_date('30-JUL-08','DD-MON-RR'),to_date('24-JUL-08','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('24-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3011,20,to_date('20-FEB-09','DD-MON-RR'),2796,null,3010,2796,2,1,to_date('24-JUL-08','DD-MON-RR'),to_date('24-JUL-08','DD-MON-RR'),null,to_date('24-JUL-08','DD-MON-RR'),2,82,'MHVSMSTAFFONE, CAROL',2,2796,'Balasubramanian, Swetha',to_date('24-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3014,0,null,null,null,3010,null,0,1,to_date('24-JUL-08','DD-MON-RR'),to_date('24-JUL-08','DD-MON-RR'),null,to_date('24-JUL-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',2,82,'MHVSMSTAFFONE, CAROL',to_date('24-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3018,0,null,null,null,3017,null,0,1,to_date('24-JUL-08','DD-MON-RR'),to_date('30-JUL-08','DD-MON-RR'),to_date('30-JUL-08','DD-MON-RR'),to_date('24-JUL-08','DD-MON-RR'),1,71,'MHVSMFOURTEEN, RINGO',3,979,'SLC10',to_date('24-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3029,0,null,null,null,3028,null,0,1,to_date('24-JUL-08','DD-MON-RR'),to_date('24-JUL-08','DD-MON-RR'),null,to_date('24-JUL-08','DD-MON-RR'),2,1150,'Prematta,        ',3,989,'Dayton 29',to_date('24-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3033,0,null,null,null,3032,null,0,1,to_date('24-JUL-08','DD-MON-RR'),to_date('24-JUL-08','DD-MON-RR'),null,to_date('24-JUL-08','DD-MON-RR'),2,1150,'Prematta,        ',3,989,'Dayton 29',to_date('24-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3037,0,null,null,null,3036,null,0,1,to_date('24-JUL-08','DD-MON-RR'),to_date('24-JUL-08','DD-MON-RR'),null,to_date('24-JUL-08','DD-MON-RR'),2,1150,'Prematta,        ',3,989,'Dayton 29',to_date('24-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3041,0,null,null,null,3040,null,0,1,to_date('24-JUL-08','DD-MON-RR'),to_date('24-JUL-08','DD-MON-RR'),null,to_date('24-JUL-08','DD-MON-RR'),2,1150,'Prematta,        ',3,989,'Dayton 29',to_date('24-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3045,0,null,null,null,3044,null,0,1,to_date('24-JUL-08','DD-MON-RR'),to_date('24-JUL-08','DD-MON-RR'),null,to_date('24-JUL-08','DD-MON-RR'),2,1150,'Prematta,        ',3,989,'Dayton 29',to_date('24-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3049,0,null,null,null,3048,null,0,1,to_date('24-JUL-08','DD-MON-RR'),to_date('24-JUL-08','DD-MON-RR'),null,to_date('24-JUL-08','DD-MON-RR'),2,1150,'Prematta,        ',3,989,'Dayton 29',to_date('24-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3052,0,null,null,null,3040,null,0,1,to_date('24-JUL-08','DD-MON-RR'),to_date('24-JUL-08','DD-MON-RR'),null,to_date('24-JUL-08','DD-MON-RR'),2,84,'MHVSMSTAFFTHREE, JAN',2,1150,'Prematta,        ',to_date('24-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3055,0,null,null,null,2594,null,0,1,to_date('24-JUL-08','DD-MON-RR'),to_date('30-JUL-08','DD-MON-RR'),to_date('30-JUL-08','DD-MON-RR'),to_date('24-JUL-08','DD-MON-RR'),1,51,'MHVSMFOUR, OLIVIA',3,989,'Dayton 29',to_date('24-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3064,0,null,null,null,2594,null,0,1,to_date('24-JUL-08','DD-MON-RR'),to_date('24-JUL-08','DD-MON-RR'),null,to_date('24-JUL-08','DD-MON-RR'),2,1150,'Prematta,        ',1,51,'MHVSMFOUR, OLIVIA',to_date('24-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3067,0,null,1150,null,2594,null,1,1,to_date('24-JUL-08','DD-MON-RR'),to_date('30-JUL-08','DD-MON-RR'),to_date('30-JUL-08','DD-MON-RR'),to_date('24-JUL-08','DD-MON-RR'),1,51,'MHVSMFOUR, OLIVIA',3,989,'Dayton 29',to_date('24-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3076,0,null,null,null,2245,null,0,1,to_date('24-JUL-08','DD-MON-RR'),to_date('30-JUL-08','DD-MON-RR'),to_date('30-JUL-08','DD-MON-RR'),to_date('24-JUL-08','DD-MON-RR'),1,51,'MHVSMFOUR, OLIVIA',3,989,'Dayton 29',to_date('24-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3085,0,null,79,null,2594,null,1,1,to_date('24-JUL-08','DD-MON-RR'),to_date('30-JUL-08','DD-MON-RR'),to_date('30-JUL-08','DD-MON-RR'),to_date('24-JUL-08','DD-MON-RR'),1,51,'MHVSMFOUR, OLIVIA',3,989,'Dayton 29',to_date('24-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3094,0,null,null,null,2594,null,0,1,to_date('24-JUL-08','DD-MON-RR'),to_date('24-JUL-08','DD-MON-RR'),null,to_date('24-JUL-08','DD-MON-RR'),2,1150,'Prematta,        ',1,51,'MHVSMFOUR, OLIVIA',to_date('24-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3109,0,null,null,null,3108,null,0,1,to_date('25-JUL-08','DD-MON-RR'),to_date('25-JUL-08','DD-MON-RR'),null,null,2,86,'MHVSMSTAFFFIVE, ALICE',1,73,'MHVSMFIFTEEN, YOKO',null,null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3112,0,null,null,null,3111,null,0,1,to_date('25-JUL-08','DD-MON-RR'),to_date('25-JUL-08','DD-MON-RR'),null,to_date('25-JUL-08','DD-MON-RR'),2,1150,'Prematta,        ',3,989,'Dayton 29',to_date('25-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3116,0,null,null,null,3115,null,0,1,to_date('25-JUL-08','DD-MON-RR'),to_date('25-JUL-08','DD-MON-RR'),null,to_date('25-JUL-08','DD-MON-RR'),2,1150,'Prematta,        ',3,989,'Dayton 29',to_date('25-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3120,0,null,null,null,3119,null,0,1,to_date('25-JUL-08','DD-MON-RR'),to_date('25-JUL-08','DD-MON-RR'),null,to_date('25-JUL-08','DD-MON-RR'),2,1150,'Prematta,        ',3,989,'Dayton 29',to_date('25-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3124,0,null,null,null,3123,null,0,1,to_date('25-JUL-08','DD-MON-RR'),to_date('25-JUL-08','DD-MON-RR'),null,to_date('25-JUL-08','DD-MON-RR'),2,1150,'Prematta,        ',3,989,'Dayton 29',to_date('25-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1525,0,null,null,null,1524,null,0,1,to_date('13-JUN-08','DD-MON-RR'),to_date('13-JUN-08','DD-MON-RR'),null,null,1,73,'MHVSMFIFTEEN, YOKO',null,null,null,null,null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1528,0,null,null,null,1527,null,0,1,to_date('13-JUN-08','DD-MON-RR'),to_date('13-JUN-08','DD-MON-RR'),null,to_date('13-JUN-08','DD-MON-RR'),2,1156,'Jerome, Kola',1,1431,'MHVJEROMEAAA, TESTAAA',to_date('13-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1536,0,null,null,null,1535,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,76,'MHVSMDOCTWO, GREG',2,1150,'       , Prematta',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1540,0,null,null,null,1539,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('20-JUN-08','DD-MON-RR'),to_date('20-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1550,20,to_date('24-JUL-08','DD-MON-RR'),null,null,1549,1156,1,1,to_date('16-JUN-08','DD-MON-RR'),to_date('20-JUN-08','DD-MON-RR'),to_date('20-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1559,0,null,null,null,1535,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,1150,'       , Prematta',2,76,'MHVSMDOCTWO, GREG',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1563,20,to_date('20-FEB-09','DD-MON-RR'),null,null,1562,1150,1,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,1152,'Donita, Searcy',2,1150,'       , Prematta',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1567,0,null,null,null,1566,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,81,'MHVSMDOCFIVE, SAM',2,1156,'Jerome, Kola',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1574,0,null,null,null,1562,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,1150,'       , Prematta',2,1152,'Donita, Searcy',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1578,0,null,null,null,1577,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,81,'MHVSMDOCFIVE, SAM',2,1156,'Jerome, Kola',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1571,0,null,null,null,1570,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,1156,'Jerome, Kola',1,61,'MHVSMNINE, MABEL',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1582,20,to_date('17-NOV-08','DD-MON-RR'),1156,null,1581,1156,2,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,81,'MHVSMDOCFIVE, SAM',2,1156,'Jerome, Kola',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1586,20,to_date('17-NOV-08','DD-MON-RR'),1156,null,1585,1156,2,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,81,'MHVSMDOCFIVE, SAM',2,1156,'Jerome, Kola',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1592,0,null,1154,null,1591,null,1,1,to_date('16-JUN-08','DD-MON-RR'),to_date('20-JUN-08','DD-MON-RR'),to_date('20-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),1,71,'MHVSMFOURTEEN, RINGO',3,979,'SLC10',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1603,0,null,null,null,1602,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('20-JUN-08','DD-MON-RR'),to_date('20-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),1,71,'MHVSMFOURTEEN, RINGO',3,979,'SLC10',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1613,20,to_date('20-FEB-09','DD-MON-RR'),1150,null,1562,1150,2,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,1152,'Donita, Searcy',2,1150,'       , Prematta',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1617,20,to_date('17-JUN-08','DD-MON-RR'),1154,null,1616,1154,2,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),1,71,'MHVSMFOURTEEN, RINGO',3,979,'SLC10',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1627,0,null,null,null,1626,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,24,'MHVSMDOCONE, MIKE',1,29,'MHVSMONE, ALYSSA',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1632,0,null,null,null,1631,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('20-JUN-08','DD-MON-RR'),to_date('20-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),1,51,'MHVSMFOUR, OLIVIA',3,989,'Dayton 29',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1642,0,null,null,null,1641,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,1150,'       , Prematta',1,51,'MHVSMFOUR, OLIVIA',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1646,0,null,null,null,1645,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,1150,'       , Prematta',3,989,'Dayton 29',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1650,0,null,null,null,1649,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,1150,'       , Prematta',3,989,'Dayton 29',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1654,0,null,null,null,1653,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,1150,'       , Prematta',3,989,'Dayton 29',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1658,0,null,null,null,1657,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,1150,'       , Prematta',3,989,'Dayton 29',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1662,0,null,null,null,1661,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,1150,'       , Prematta',3,989,'Dayton 29',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1666,0,null,null,null,1665,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,1150,'       , Prematta',3,989,'Dayton 29',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1671,0,null,null,null,1670,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,1152,'Donita, Searcy',3,989,'Dayton 29',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1675,0,null,null,null,1674,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,1152,'Donita, Searcy',3,989,'Dayton 29',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (1679,0,null,null,null,1678,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,1152,'Donita, Searcy',3,989,'Dayton 29',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4604,0,null,1150,null,4603,null,1,1,to_date('14-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,989,'Dayton 29',to_date('14-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4614,0,null,1150,null,4613,null,1,1,to_date('14-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,989,'Dayton 29',to_date('14-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3820,0,null,null,null,3819,null,0,1,to_date('11-AUG-08','DD-MON-RR'),to_date('11-AUG-08','DD-MON-RR'),null,to_date('11-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',2,1154,'Mcdonald, Douglas',to_date('11-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3826,0,null,null,null,3825,null,0,1,to_date('11-AUG-08','DD-MON-RR'),to_date('15-AUG-08','DD-MON-RR'),to_date('15-AUG-08','DD-MON-RR'),to_date('11-AUG-08','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('11-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3836,0,null,null,null,3835,null,0,1,to_date('11-AUG-08','DD-MON-RR'),to_date('15-AUG-08','DD-MON-RR'),to_date('15-AUG-08','DD-MON-RR'),to_date('11-AUG-08','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('11-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3845,0,null,null,null,3835,null,0,1,to_date('11-AUG-08','DD-MON-RR'),to_date('11-AUG-08','DD-MON-RR'),null,to_date('11-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,61,'MHVSMNINE, MABEL',to_date('11-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3850,0,null,null,null,3849,null,0,1,to_date('11-AUG-08','DD-MON-RR'),to_date('15-AUG-08','DD-MON-RR'),to_date('15-AUG-08','DD-MON-RR'),to_date('11-AUG-08','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('11-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3859,0,null,null,null,3835,null,0,1,to_date('11-AUG-08','DD-MON-RR'),to_date('15-AUG-08','DD-MON-RR'),to_date('15-AUG-08','DD-MON-RR'),to_date('11-AUG-08','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('11-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3867,0,null,null,null,3835,null,0,1,to_date('11-AUG-08','DD-MON-RR'),to_date('11-AUG-08','DD-MON-RR'),null,to_date('11-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,61,'MHVSMNINE, MABEL',to_date('11-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3871,0,null,null,null,3835,null,0,1,to_date('11-AUG-08','DD-MON-RR'),to_date('11-AUG-08','DD-MON-RR'),null,to_date('11-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,61,'MHVSMNINE, MABEL',to_date('11-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3876,0,null,null,null,3835,null,0,1,to_date('11-AUG-08','DD-MON-RR'),to_date('15-AUG-08','DD-MON-RR'),to_date('15-AUG-08','DD-MON-RR'),to_date('11-AUG-08','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('11-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3884,0,null,null,null,3835,null,0,1,to_date('11-AUG-08','DD-MON-RR'),to_date('11-AUG-08','DD-MON-RR'),null,to_date('11-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,61,'MHVSMNINE, MABEL',to_date('11-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3889,0,null,null,null,3835,null,0,1,to_date('11-AUG-08','DD-MON-RR'),to_date('15-AUG-08','DD-MON-RR'),to_date('15-AUG-08','DD-MON-RR'),to_date('11-AUG-08','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('11-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3898,0,null,null,null,3835,null,0,1,to_date('11-AUG-08','DD-MON-RR'),to_date('15-AUG-08','DD-MON-RR'),to_date('15-AUG-08','DD-MON-RR'),to_date('11-AUG-08','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('11-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3909,0,null,null,null,3835,null,0,1,to_date('11-AUG-08','DD-MON-RR'),to_date('15-AUG-08','DD-MON-RR'),to_date('15-AUG-08','DD-MON-RR'),to_date('11-AUG-08','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('11-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3919,0,null,null,null,3835,null,0,1,to_date('11-AUG-08','DD-MON-RR'),to_date('15-AUG-08','DD-MON-RR'),to_date('15-AUG-08','DD-MON-RR'),to_date('11-AUG-08','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('11-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3945,0,null,null,null,3944,null,0,1,to_date('11-AUG-08','DD-MON-RR'),to_date('15-AUG-08','DD-MON-RR'),to_date('15-AUG-08','DD-MON-RR'),to_date('11-AUG-08','DD-MON-RR'),1,51,'MHVSMFOUR, OLIVIA',3,989,'Dayton 29',to_date('11-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3969,0,null,1150,null,3968,null,1,1,to_date('11-AUG-08','DD-MON-RR'),to_date('15-AUG-08','DD-MON-RR'),to_date('15-AUG-08','DD-MON-RR'),to_date('11-AUG-08','DD-MON-RR'),1,51,'MHVSMFOUR, OLIVIA',3,989,'Dayton 29',to_date('11-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3981,0,null,null,null,3968,null,0,1,to_date('11-AUG-08','DD-MON-RR'),to_date('11-AUG-08','DD-MON-RR'),null,to_date('11-AUG-08','DD-MON-RR'),2,84,'MHVSMSTAFFTHREE, JAN',1,51,'MHVSMFOUR, OLIVIA',to_date('11-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3990,0,null,null,null,3736,null,0,1,to_date('11-AUG-08','DD-MON-RR'),to_date('15-AUG-08','DD-MON-RR'),to_date('15-AUG-08','DD-MON-RR'),to_date('11-AUG-08','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('11-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4012,20,to_date('11-AUG-08','DD-MON-RR'),86,null,4011,80,2,1,to_date('11-AUG-08','DD-MON-RR'),to_date('11-AUG-08','DD-MON-RR'),null,to_date('11-AUG-08','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('11-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4022,0,null,null,null,4011,null,0,1,to_date('11-AUG-08','DD-MON-RR'),to_date('11-AUG-08','DD-MON-RR'),null,to_date('11-AUG-08','DD-MON-RR'),2,80,'MHVSMDOCFOUR, BOBBIE',1,61,'MHVSMNINE, MABEL',to_date('11-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4037,0,null,null,null,4036,null,0,1,to_date('11-AUG-08','DD-MON-RR'),to_date('11-AUG-08','DD-MON-RR'),null,to_date('11-AUG-08','DD-MON-RR'),2,1150,'Prematta,        ',3,989,'Dayton 29',to_date('11-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4041,0,null,null,null,4040,null,0,1,to_date('11-AUG-08','DD-MON-RR'),to_date('11-AUG-08','DD-MON-RR'),null,to_date('11-AUG-08','DD-MON-RR'),2,1150,'Prematta,        ',3,989,'Dayton 29',to_date('11-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3657,0,null,null,null,3656,null,0,1,to_date('08-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),to_date('08-AUG-08','DD-MON-RR'),1,53,'MHVSMFIVE, EMMA',3,989,'Dayton 29',to_date('08-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3666,0,null,null,null,3656,null,0,1,to_date('08-AUG-08','DD-MON-RR'),to_date('08-AUG-08','DD-MON-RR'),null,to_date('08-AUG-08','DD-MON-RR'),2,76,'MHVSMDOCTWO, GREG',1,53,'MHVSMFIVE, EMMA',to_date('08-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3674,0,null,null,null,3673,null,0,1,to_date('08-AUG-08','DD-MON-RR'),to_date('08-AUG-08','DD-MON-RR'),null,to_date('08-AUG-08','DD-MON-RR'),2,76,'MHVSMDOCTWO, GREG',3,989,'Dayton 29',to_date('08-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3678,0,null,null,null,3677,null,0,1,to_date('08-AUG-08','DD-MON-RR'),to_date('08-AUG-08','DD-MON-RR'),null,to_date('08-AUG-08','DD-MON-RR'),2,76,'MHVSMDOCTWO, GREG',3,989,'Dayton 29',to_date('08-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3682,0,null,null,null,3681,null,0,1,to_date('08-AUG-08','DD-MON-RR'),to_date('08-AUG-08','DD-MON-RR'),null,to_date('08-AUG-08','DD-MON-RR'),2,76,'MHVSMDOCTWO, GREG',3,989,'Dayton 29',to_date('08-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3685,0,null,null,null,3684,null,0,1,to_date('08-AUG-08','DD-MON-RR'),to_date('08-AUG-08','DD-MON-RR'),null,to_date('08-AUG-08','DD-MON-RR'),2,76,'MHVSMDOCTWO, GREG',3,989,'Dayton 29',to_date('08-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3688,0,null,1150,null,3687,null,1,1,to_date('08-AUG-08','DD-MON-RR'),to_date('08-AUG-08','DD-MON-RR'),null,to_date('08-AUG-08','DD-MON-RR'),2,76,'MHVSMDOCTWO, GREG',3,989,'Dayton 29',to_date('08-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3692,0,null,null,null,3691,null,0,1,to_date('08-AUG-08','DD-MON-RR'),to_date('08-AUG-08','DD-MON-RR'),null,to_date('08-AUG-08','DD-MON-RR'),2,76,'MHVSMDOCTWO, GREG',3,989,'Dayton 29',to_date('08-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3697,0,null,null,null,3696,null,0,1,to_date('08-AUG-08','DD-MON-RR'),to_date('08-AUG-08','DD-MON-RR'),null,to_date('08-AUG-08','DD-MON-RR'),2,76,'MHVSMDOCTWO, GREG',4,943,'D Group',to_date('08-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3701,0,null,null,null,3700,null,0,1,to_date('08-AUG-08','DD-MON-RR'),to_date('08-AUG-08','DD-MON-RR'),null,to_date('08-AUG-08','DD-MON-RR'),2,76,'MHVSMDOCTWO, GREG',4,943,'D Group',to_date('08-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3710,0,null,null,null,3709,null,0,1,to_date('08-AUG-08','DD-MON-RR'),to_date('08-AUG-08','DD-MON-RR'),null,to_date('08-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',4,3560,'reddy',to_date('08-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3714,0,null,null,null,3713,null,0,1,to_date('08-AUG-08','DD-MON-RR'),to_date('08-AUG-08','DD-MON-RR'),null,to_date('08-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',4,3560,'reddy',to_date('08-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3718,0,null,null,null,3717,null,0,1,to_date('08-AUG-08','DD-MON-RR'),to_date('08-AUG-08','DD-MON-RR'),null,to_date('08-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',4,3560,'reddy',to_date('08-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3723,0,null,null,null,3722,null,0,1,to_date('08-AUG-08','DD-MON-RR'),to_date('08-AUG-08','DD-MON-RR'),null,to_date('08-AUG-08','DD-MON-RR'),2,82,'MHVSMSTAFFONE, CAROL',2,2796,'Balasubramanian, Swetha',to_date('08-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3727,0,null,null,null,3726,null,0,1,to_date('08-AUG-08','DD-MON-RR'),to_date('08-AUG-08','DD-MON-RR'),null,to_date('08-AUG-08','DD-MON-RR'),2,82,'MHVSMSTAFFONE, CAROL',2,2796,'Balasubramanian, Swetha',to_date('08-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3733,0,null,null,null,3732,null,0,1,to_date('08-AUG-08','DD-MON-RR'),to_date('08-AUG-08','DD-MON-RR'),null,to_date('08-AUG-08','DD-MON-RR'),2,82,'MHVSMSTAFFONE, CAROL',2,2796,'Balasubramanian, Swetha',to_date('08-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3737,0,null,null,null,3736,null,0,1,to_date('08-AUG-08','DD-MON-RR'),to_date('08-AUG-08','DD-MON-RR'),null,to_date('08-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,61,'MHVSMNINE, MABEL',to_date('08-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3743,0,null,null,null,3507,null,0,1,to_date('08-AUG-08','DD-MON-RR'),to_date('08-AUG-08','DD-MON-RR'),null,to_date('08-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,61,'MHVSMNINE, MABEL',to_date('08-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3750,0,null,null,null,3749,null,0,1,to_date('08-AUG-08','DD-MON-RR'),to_date('08-AUG-08','DD-MON-RR'),null,to_date('08-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',2,1154,'Mcdonald, Douglas',to_date('08-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3761,0,null,null,null,3760,null,0,1,to_date('08-AUG-08','DD-MON-RR'),to_date('08-AUG-08','DD-MON-RR'),null,to_date('08-AUG-08','DD-MON-RR'),2,82,'MHVSMSTAFFONE, CAROL',2,2796,'Balasubramanian, Swetha',to_date('08-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3161,0,null,null,null,3160,null,0,1,to_date('25-JUL-08','DD-MON-RR'),to_date('25-JUL-08','DD-MON-RR'),null,to_date('25-JUL-08','DD-MON-RR'),2,1152,'Searcy, Donita',3,989,'Dayton 29',to_date('25-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3165,0,null,null,null,3164,null,0,1,to_date('25-JUL-08','DD-MON-RR'),to_date('25-JUL-08','DD-MON-RR'),null,to_date('25-JUL-08','DD-MON-RR'),2,1152,'Searcy, Donita',3,989,'Dayton 29',to_date('25-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3169,0,null,null,null,3168,null,0,1,to_date('25-JUL-08','DD-MON-RR'),to_date('25-JUL-08','DD-MON-RR'),null,to_date('25-JUL-08','DD-MON-RR'),2,1152,'Searcy, Donita',3,989,'Dayton 29',to_date('25-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3173,0,null,null,null,3172,null,0,1,to_date('25-JUL-08','DD-MON-RR'),to_date('25-JUL-08','DD-MON-RR'),null,to_date('25-JUL-08','DD-MON-RR'),2,1152,'Searcy, Donita',3,989,'Dayton 29',to_date('25-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3179,0,null,null,null,3138,null,0,1,to_date('25-JUL-08','DD-MON-RR'),to_date('31-JUL-08','DD-MON-RR'),to_date('31-JUL-08','DD-MON-RR'),to_date('25-JUL-08','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,989,'Dayton 29',to_date('25-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3189,0,null,null,null,2594,null,0,1,to_date('25-JUL-08','DD-MON-RR'),to_date('25-JUL-08','DD-MON-RR'),null,to_date('25-JUL-08','DD-MON-RR'),2,1150,'Prematta,        ',1,51,'MHVSMFOUR, OLIVIA',to_date('25-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3192,0,null,null,null,2605,null,0,1,to_date('25-JUL-08','DD-MON-RR'),to_date('25-JUL-08','DD-MON-RR'),null,to_date('25-JUL-08','DD-MON-RR'),2,1150,'Prematta,        ',1,51,'MHVSMFOUR, OLIVIA',to_date('25-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3196,0,null,null,null,3195,null,0,1,to_date('25-JUL-08','DD-MON-RR'),to_date('31-JUL-08','DD-MON-RR'),to_date('31-JUL-08','DD-MON-RR'),to_date('25-JUL-08','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('25-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3207,0,null,null,null,3206,null,0,1,to_date('25-JUL-08','DD-MON-RR'),to_date('31-JUL-08','DD-MON-RR'),to_date('31-JUL-08','DD-MON-RR'),to_date('25-JUL-08','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('25-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3218,0,null,82,null,3217,null,1,1,to_date('25-JUL-08','DD-MON-RR'),to_date('31-JUL-08','DD-MON-RR'),to_date('31-JUL-08','DD-MON-RR'),to_date('25-JUL-08','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('25-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3229,0,null,null,null,3228,null,0,1,to_date('28-JUL-08','DD-MON-RR'),to_date('01-AUG-08','DD-MON-RR'),to_date('01-AUG-08','DD-MON-RR'),to_date('28-JUL-08','DD-MON-RR'),1,51,'MHVSMFOUR, OLIVIA',3,989,'Dayton 29',to_date('28-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3239,0,null,null,null,3238,null,0,1,to_date('28-JUL-08','DD-MON-RR'),to_date('01-AUG-08','DD-MON-RR'),to_date('01-AUG-08','DD-MON-RR'),to_date('28-JUL-08','DD-MON-RR'),1,51,'MHVSMFOUR, OLIVIA',3,989,'Dayton 29',to_date('28-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3249,0,null,null,null,3228,null,0,1,to_date('28-JUL-08','DD-MON-RR'),to_date('28-JUL-08','DD-MON-RR'),null,to_date('28-JUL-08','DD-MON-RR'),2,1150,'Prematta,        ',1,51,'MHVSMFOUR, OLIVIA',to_date('28-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3254,0,null,null,null,3253,null,0,1,to_date('28-JUL-08','DD-MON-RR'),to_date('01-AUG-08','DD-MON-RR'),to_date('01-AUG-08','DD-MON-RR'),to_date('28-JUL-08','DD-MON-RR'),1,49,'MHVSMTHREE, CHLOE',3,989,'Dayton 29',to_date('28-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3266,0,null,null,null,3265,null,0,1,to_date('28-JUL-08','DD-MON-RR'),to_date('01-AUG-08','DD-MON-RR'),to_date('01-AUG-08','DD-MON-RR'),to_date('28-JUL-08','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('28-JUL-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3285,20,to_date('06-AUG-08','DD-MON-RR'),79,null,3284,79,3,1,to_date('06-AUG-08','DD-MON-RR'),to_date('06-AUG-08','DD-MON-RR'),null,to_date('06-AUG-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',to_date('06-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3294,20,to_date('06-AUG-08','DD-MON-RR'),null,null,3293,79,1,1,to_date('06-AUG-08','DD-MON-RR'),to_date('06-AUG-08','DD-MON-RR'),null,to_date('06-AUG-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',to_date('06-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3303,0,null,null,null,3293,null,0,1,to_date('06-AUG-08','DD-MON-RR'),to_date('06-AUG-08','DD-MON-RR'),null,to_date('06-AUG-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',1,29,'MHVSMONE, ALYSSA',to_date('06-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3313,0,null,null,null,3284,null,0,1,to_date('06-AUG-08','DD-MON-RR'),to_date('06-AUG-08','DD-MON-RR'),null,to_date('06-AUG-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',1,29,'MHVSMONE, ALYSSA',to_date('06-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3321,0,null,null,null,3320,null,0,1,to_date('06-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),to_date('06-AUG-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',to_date('06-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3377,20,to_date('07-AUG-08','DD-MON-RR'),null,null,3371,18,1,1,to_date('07-AUG-08','DD-MON-RR'),to_date('07-AUG-08','DD-MON-RR'),null,to_date('07-AUG-08','DD-MON-RR'),1,8,'Maley, Richard',3,658,'Salem',to_date('07-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3356,10,null,null,null,3355,1150,1,1,to_date('07-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),to_date('07-AUG-08','DD-MON-RR'),1,47,'MHVSMTWO, BRIANNA',3,989,'Dayton 29',to_date('07-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3372,0,null,null,null,3371,null,0,1,to_date('07-AUG-08','DD-MON-RR'),to_date('07-AUG-08','DD-MON-RR'),null,to_date('07-AUG-08','DD-MON-RR'),2,18,'Maleyc, Richard',1,8,'Maley, Richard',to_date('07-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3383,0,null,null,null,3371,null,0,1,to_date('07-AUG-08','DD-MON-RR'),to_date('07-AUG-08','DD-MON-RR'),null,to_date('07-AUG-08','DD-MON-RR'),2,18,'Maleyc, Richard',1,8,'Maley, Richard',to_date('07-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3391,0,null,null,null,3390,null,0,1,to_date('07-AUG-08','DD-MON-RR'),to_date('07-AUG-08','DD-MON-RR'),null,to_date('07-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',2,1154,'Mcdonald, Douglas',to_date('07-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3396,10,null,null,null,3395,76,1,1,to_date('07-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),to_date('07-AUG-08','DD-MON-RR'),1,51,'MHVSMFOUR, OLIVIA',3,989,'Dayton 29',to_date('07-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3405,0,null,null,null,3404,null,0,1,to_date('07-AUG-08','DD-MON-RR'),to_date('07-AUG-08','DD-MON-RR'),null,to_date('07-AUG-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',2,1150,'Prematta,        ',to_date('07-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3410,0,null,null,null,3409,null,0,1,to_date('07-AUG-08','DD-MON-RR'),to_date('07-AUG-08','DD-MON-RR'),null,to_date('07-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('07-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3414,0,null,null,null,3413,null,0,1,to_date('07-AUG-08','DD-MON-RR'),to_date('07-AUG-08','DD-MON-RR'),null,to_date('07-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('07-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3417,0,null,null,null,3416,null,0,1,to_date('07-AUG-08','DD-MON-RR'),to_date('07-AUG-08','DD-MON-RR'),null,to_date('07-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('07-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3420,0,null,null,null,3419,null,0,1,to_date('07-AUG-08','DD-MON-RR'),to_date('07-AUG-08','DD-MON-RR'),null,to_date('07-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('07-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3424,0,null,null,null,3423,null,0,1,to_date('07-AUG-08','DD-MON-RR'),to_date('07-AUG-08','DD-MON-RR'),null,to_date('07-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('07-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3428,0,null,null,null,3427,null,0,1,to_date('07-AUG-08','DD-MON-RR'),to_date('07-AUG-08','DD-MON-RR'),null,to_date('07-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('07-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3432,0,null,null,null,3431,null,0,1,to_date('07-AUG-08','DD-MON-RR'),to_date('07-AUG-08','DD-MON-RR'),null,to_date('07-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('07-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3436,0,null,1150,null,3435,null,1,1,to_date('07-AUG-08','DD-MON-RR'),to_date('07-AUG-08','DD-MON-RR'),null,to_date('07-AUG-08','DD-MON-RR'),2,84,'MHVSMSTAFFTHREE, JAN',2,1150,'Prematta,        ',to_date('07-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3443,0,null,null,null,3442,null,0,1,to_date('07-AUG-08','DD-MON-RR'),to_date('07-AUG-08','DD-MON-RR'),null,to_date('07-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('07-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3447,0,null,null,null,3446,null,0,1,to_date('07-AUG-08','DD-MON-RR'),to_date('07-AUG-08','DD-MON-RR'),null,to_date('07-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('07-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3450,0,null,null,null,3449,null,0,1,to_date('07-AUG-08','DD-MON-RR'),to_date('07-AUG-08','DD-MON-RR'),null,to_date('07-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('07-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3453,0,null,null,null,3452,null,0,1,to_date('07-AUG-08','DD-MON-RR'),to_date('07-AUG-08','DD-MON-RR'),null,to_date('07-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('07-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3457,0,null,null,null,3456,null,0,1,to_date('07-AUG-08','DD-MON-RR'),to_date('07-AUG-08','DD-MON-RR'),null,to_date('07-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('07-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3461,0,null,null,null,3460,null,0,1,to_date('07-AUG-08','DD-MON-RR'),to_date('07-AUG-08','DD-MON-RR'),null,to_date('07-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('07-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3465,0,null,null,null,3464,null,0,1,to_date('07-AUG-08','DD-MON-RR'),to_date('07-AUG-08','DD-MON-RR'),null,to_date('07-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('07-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3469,0,null,null,null,3468,null,0,1,to_date('07-AUG-08','DD-MON-RR'),to_date('07-AUG-08','DD-MON-RR'),null,to_date('07-AUG-08','DD-MON-RR'),2,1150,'Prematta,        ',3,989,'Dayton 29',to_date('07-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3473,0,null,null,null,3472,null,0,1,to_date('07-AUG-08','DD-MON-RR'),to_date('07-AUG-08','DD-MON-RR'),null,to_date('07-AUG-08','DD-MON-RR'),2,1150,'Prematta,        ',3,989,'Dayton 29',to_date('07-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3477,0,null,null,null,3476,null,0,1,to_date('07-AUG-08','DD-MON-RR'),to_date('07-AUG-08','DD-MON-RR'),null,to_date('07-AUG-08','DD-MON-RR'),2,1150,'Prematta,        ',3,989,'Dayton 29',to_date('07-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3481,0,null,null,null,3480,null,0,1,to_date('07-AUG-08','DD-MON-RR'),to_date('07-AUG-08','DD-MON-RR'),null,to_date('07-AUG-08','DD-MON-RR'),2,1150,'Prematta,        ',3,989,'Dayton 29',to_date('07-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3484,0,null,null,null,3483,null,0,1,to_date('07-AUG-08','DD-MON-RR'),to_date('07-AUG-08','DD-MON-RR'),null,to_date('07-AUG-08','DD-MON-RR'),2,1150,'Prematta,        ',3,989,'Dayton 29',to_date('07-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3487,0,null,null,null,3486,null,0,1,to_date('07-AUG-08','DD-MON-RR'),to_date('07-AUG-08','DD-MON-RR'),null,to_date('07-AUG-08','DD-MON-RR'),2,1150,'Prematta,        ',3,989,'Dayton 29',to_date('07-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3493,0,null,null,null,3404,null,0,1,to_date('07-AUG-08','DD-MON-RR'),to_date('07-AUG-08','DD-MON-RR'),null,to_date('07-AUG-08','DD-MON-RR'),2,1150,'Prematta,        ',2,79,'MHVSMDOCTHREE, PETER',to_date('07-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3498,0,null,null,null,3395,null,0,1,to_date('07-AUG-08','DD-MON-RR'),to_date('07-AUG-08','DD-MON-RR'),null,to_date('07-AUG-08','DD-MON-RR'),2,1150,'Prematta,        ',1,51,'MHVSMFOUR, OLIVIA',to_date('07-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3503,0,null,null,null,3502,null,0,1,to_date('07-AUG-08','DD-MON-RR'),to_date('07-AUG-08','DD-MON-RR'),null,to_date('07-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,61,'MHVSMNINE, MABEL',to_date('07-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3508,0,null,null,null,3507,null,0,1,to_date('07-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),to_date('07-AUG-08','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('07-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3521,0,null,null,null,3395,null,0,1,to_date('07-AUG-08','DD-MON-RR'),to_date('07-AUG-08','DD-MON-RR'),null,to_date('07-AUG-08','DD-MON-RR'),2,1150,'Prematta,        ',1,51,'MHVSMFOUR, OLIVIA',to_date('07-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3565,0,null,null,null,3395,null,0,1,to_date('07-AUG-08','DD-MON-RR'),to_date('07-AUG-08','DD-MON-RR'),null,to_date('07-AUG-08','DD-MON-RR'),2,1150,'Prematta,        ',1,51,'MHVSMFOUR, OLIVIA',to_date('07-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3543,0,null,null,null,3542,null,0,1,to_date('07-AUG-08','DD-MON-RR'),to_date('07-AUG-08','DD-MON-RR'),null,to_date('07-AUG-08','DD-MON-RR'),2,1150,'Prematta,        ',1,51,'MHVSMFOUR, OLIVIA',to_date('07-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3571,0,null,null,null,3253,null,0,1,to_date('07-AUG-08','DD-MON-RR'),to_date('07-AUG-08','DD-MON-RR'),null,to_date('07-AUG-08','DD-MON-RR'),2,1150,'Prematta,        ',1,49,'MHVSMTHREE, CHLOE',to_date('07-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3576,0,null,1150,null,3575,null,1,1,to_date('07-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),to_date('07-AUG-08','DD-MON-RR'),1,51,'MHVSMFOUR, OLIVIA',3,989,'Dayton 29',to_date('07-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3590,0,null,null,null,3395,null,0,1,to_date('07-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),to_date('07-AUG-08','DD-MON-RR'),1,51,'MHVSMFOUR, OLIVIA',3,989,'Dayton 29',to_date('07-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3599,0,null,null,null,3395,null,0,1,to_date('07-AUG-08','DD-MON-RR'),to_date('07-AUG-08','DD-MON-RR'),null,to_date('07-AUG-08','DD-MON-RR'),2,1150,'Prematta,        ',1,51,'MHVSMFOUR, OLIVIA',to_date('07-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3605,0,null,null,null,3404,null,0,1,to_date('07-AUG-08','DD-MON-RR'),to_date('07-AUG-08','DD-MON-RR'),null,to_date('07-AUG-08','DD-MON-RR'),2,1150,'Prematta,        ',2,79,'MHVSMDOCTHREE, PETER',to_date('07-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3611,0,null,null,null,3610,null,0,1,to_date('07-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),to_date('07-AUG-08','DD-MON-RR'),1,8,'Maley, Richard',3,658,'Salem',to_date('07-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3617,0,null,null,null,3610,null,0,1,to_date('07-AUG-08','DD-MON-RR'),to_date('07-AUG-08','DD-MON-RR'),null,to_date('07-AUG-08','DD-MON-RR'),2,18,'Maleyc, Richard',1,8,'Maley, Richard',to_date('07-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3625,0,null,null,null,3624,null,0,1,to_date('08-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),to_date('08-AUG-08','DD-MON-RR'),1,53,'MHVSMFIVE, EMMA',3,989,'Dayton 29',to_date('08-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3634,0,null,null,null,3624,null,0,1,to_date('08-AUG-08','DD-MON-RR'),to_date('08-AUG-08','DD-MON-RR'),null,to_date('08-AUG-08','DD-MON-RR'),2,76,'MHVSMDOCTWO, GREG',1,53,'MHVSMFIVE, EMMA',to_date('08-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3639,0,null,null,null,3624,null,0,1,to_date('08-AUG-08','DD-MON-RR'),to_date('08-AUG-08','DD-MON-RR'),null,to_date('08-AUG-08','DD-MON-RR'),2,76,'MHVSMDOCTWO, GREG',1,53,'MHVSMFIVE, EMMA',to_date('08-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3644,0,null,null,null,3643,null,0,1,to_date('08-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),to_date('08-AUG-08','DD-MON-RR'),1,53,'MHVSMFIVE, EMMA',3,989,'Dayton 29',to_date('08-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4045,0,null,null,null,4044,null,0,1,to_date('11-AUG-08','DD-MON-RR'),to_date('11-AUG-08','DD-MON-RR'),null,to_date('11-AUG-08','DD-MON-RR'),2,1150,'Prematta,        ',3,989,'Dayton 29',to_date('11-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4049,0,null,null,null,4048,null,0,1,to_date('11-AUG-08','DD-MON-RR'),to_date('11-AUG-08','DD-MON-RR'),null,to_date('11-AUG-08','DD-MON-RR'),2,1150,'Prematta,        ',3,989,'Dayton 29',to_date('11-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4053,0,null,null,null,4052,null,0,1,to_date('11-AUG-08','DD-MON-RR'),to_date('11-AUG-08','DD-MON-RR'),null,to_date('11-AUG-08','DD-MON-RR'),2,1150,'Prematta,        ',3,989,'Dayton 29',to_date('11-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4056,0,null,null,null,4055,null,0,1,to_date('11-AUG-08','DD-MON-RR'),to_date('11-AUG-08','DD-MON-RR'),null,to_date('11-AUG-08','DD-MON-RR'),2,1150,'Prematta,        ',3,989,'Dayton 29',to_date('11-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4063,20,to_date('11-AUG-08','DD-MON-RR'),null,null,4062,76,1,1,to_date('11-AUG-08','DD-MON-RR'),to_date('11-AUG-08','DD-MON-RR'),null,to_date('11-AUG-08','DD-MON-RR'),1,53,'MHVSMFIVE, EMMA',3,989,'Dayton 29',to_date('11-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4073,0,null,null,null,4062,null,0,1,to_date('11-AUG-08','DD-MON-RR'),to_date('11-AUG-08','DD-MON-RR'),null,to_date('11-AUG-08','DD-MON-RR'),2,76,'MHVSMDOCTWO, GREG',1,53,'MHVSMFIVE, EMMA',to_date('11-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4093,0,null,null,null,4092,null,0,1,to_date('12-AUG-08','DD-MON-RR'),to_date('16-AUG-08','DD-MON-RR'),to_date('16-AUG-08','DD-MON-RR'),to_date('12-AUG-08','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('12-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4102,0,null,null,null,4092,null,0,1,to_date('12-AUG-08','DD-MON-RR'),to_date('12-AUG-08','DD-MON-RR'),null,to_date('12-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,61,'MHVSMNINE, MABEL',to_date('12-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4107,0,null,null,null,4092,null,0,1,to_date('12-AUG-08','DD-MON-RR'),to_date('16-AUG-08','DD-MON-RR'),to_date('16-AUG-08','DD-MON-RR'),to_date('12-AUG-08','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('12-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4117,0,null,null,null,3944,null,0,1,to_date('12-AUG-08','DD-MON-RR'),to_date('12-AUG-08','DD-MON-RR'),null,to_date('12-AUG-08','DD-MON-RR'),2,1150,'Prematta,        ',1,51,'MHVSMFOUR, OLIVIA',to_date('12-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4125,0,null,null,null,4124,null,0,1,to_date('12-AUG-08','DD-MON-RR'),to_date('16-AUG-08','DD-MON-RR'),to_date('16-AUG-08','DD-MON-RR'),to_date('12-AUG-08','DD-MON-RR'),1,51,'MHVSMFOUR, OLIVIA',3,989,'Dayton 29',to_date('12-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4135,0,null,null,null,4124,null,0,1,to_date('12-AUG-08','DD-MON-RR'),to_date('12-AUG-08','DD-MON-RR'),null,to_date('12-AUG-08','DD-MON-RR'),2,1150,'Prematta,        ',1,51,'MHVSMFOUR, OLIVIA',to_date('12-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4142,0,null,null,null,3968,null,0,1,to_date('12-AUG-08','DD-MON-RR'),to_date('12-AUG-08','DD-MON-RR'),null,to_date('12-AUG-08','DD-MON-RR'),2,1150,'Prematta,        ',1,51,'MHVSMFOUR, OLIVIA',to_date('12-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4147,0,null,null,null,3643,null,0,1,to_date('12-AUG-08','DD-MON-RR'),to_date('12-AUG-08','DD-MON-RR'),null,to_date('12-AUG-08','DD-MON-RR'),2,1150,'Prematta,        ',1,53,'MHVSMFIVE, EMMA',to_date('12-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4339,0,null,null,null,3195,null,0,1,to_date('12-AUG-08','DD-MON-RR'),to_date('12-AUG-08','DD-MON-RR'),null,to_date('12-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,61,'MHVSMNINE, MABEL',to_date('12-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4344,0,null,null,null,4343,null,0,1,to_date('12-AUG-08','DD-MON-RR'),to_date('12-AUG-08','DD-MON-RR'),null,to_date('12-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,73,'MHVSMFIFTEEN, YOKO',to_date('12-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4352,0,null,null,null,4351,null,0,1,to_date('12-AUG-08','DD-MON-RR'),to_date('12-AUG-08','DD-MON-RR'),null,to_date('12-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',4,2900,'Swetha76',to_date('12-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4356,0,null,null,null,4355,null,0,1,to_date('12-AUG-08','DD-MON-RR'),to_date('12-AUG-08','DD-MON-RR'),null,to_date('12-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',4,2900,'Swetha76',to_date('12-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4362,0,null,null,null,4361,null,0,1,to_date('12-AUG-08','DD-MON-RR'),to_date('12-AUG-08','DD-MON-RR'),null,to_date('12-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',4,2900,'Swetha76',to_date('12-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4366,0,null,null,null,4365,null,0,1,to_date('12-AUG-08','DD-MON-RR'),to_date('12-AUG-08','DD-MON-RR'),null,to_date('12-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',4,2900,'Swetha76',to_date('12-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4379,0,null,null,null,4378,null,0,1,to_date('12-AUG-08','DD-MON-RR'),to_date('12-AUG-08','DD-MON-RR'),null,null,2,1150,'Prematta,        ',1,1431,'MHVJEROMEAAA, TESTAAA',null,null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4386,0,null,null,null,4385,null,0,1,to_date('13-AUG-08','DD-MON-RR'),to_date('19-AUG-08','DD-MON-RR'),to_date('19-AUG-08','DD-MON-RR'),to_date('13-AUG-08','DD-MON-RR'),1,71,'MHVSMFOURTEEN, RINGO',3,979,'SLC10',to_date('13-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2018,0,null,null,null,1616,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,86,'MHVSMSTAFFFIVE, ALICE',1,71,'MHVSMFOURTEEN, RINGO',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2021,0,null,null,null,1616,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,86,'MHVSMSTAFFFIVE, ALICE',1,71,'MHVSMFOURTEEN, RINGO',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2024,0,null,null,null,1616,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,86,'MHVSMSTAFFFIVE, ALICE',1,71,'MHVSMFOURTEEN, RINGO',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2028,0,null,null,null,2027,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,1152,'Donita, Searcy',4,1698,'Distribution Group 1.0F',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2032,0,null,null,null,2031,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,1152,'Donita, Searcy',4,1698,'Distribution Group 1.0F',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2035,10,null,76,null,2027,1152,2,1,to_date('16-JUN-08','DD-MON-RR'),to_date('20-JUN-08','DD-MON-RR'),to_date('20-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),1,55,'MHVSMSIX, ALICE',3,989,'Dayton 29',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2054,0,null,null,null,2053,null,1,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,null,2,86,'MHVSMSTAFFFIVE, ALICE',4,956,'Distribution Group 1',null,null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2061,0,null,null,null,2060,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('20-JUN-08','DD-MON-RR'),to_date('20-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),1,71,'MHVSMFOURTEEN, RINGO',3,979,'SLC10',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2087,0,null,null,null,2086,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('20-JUN-08','DD-MON-RR'),to_date('20-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),1,71,'MHVSMFOURTEEN, RINGO',3,979,'SLC10',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2097,0,null,null,null,2096,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,1156,'Kola, Jerome',1,71,'MHVSMFOURTEEN, RINGO',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2101,0,null,null,null,2100,null,0,1,to_date('16-JUN-08','DD-MON-RR'),to_date('16-JUN-08','DD-MON-RR'),null,to_date('16-JUN-08','DD-MON-RR'),2,1156,'Kola, Jerome',1,71,'MHVSMFOURTEEN, RINGO',to_date('16-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2109,0,null,null,null,2108,null,0,1,to_date('17-JUN-08','DD-MON-RR'),to_date('21-JUN-08','DD-MON-RR'),to_date('21-JUN-08','DD-MON-RR'),to_date('17-JUN-08','DD-MON-RR'),1,71,'MHVSMFOURTEEN, RINGO',3,979,'SLC10',to_date('17-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2120,0,null,null,null,2119,null,0,1,to_date('17-JUN-08','DD-MON-RR'),to_date('17-JUN-08','DD-MON-RR'),null,to_date('17-JUN-08','DD-MON-RR'),2,1152,'Searcy, Donita',1,55,'MHVSMSIX, ALICE',to_date('17-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (2123,10,null,76,null,2119,1152,2,1,to_date('17-JUN-08','DD-MON-RR'),to_date('21-JUN-08','DD-MON-RR'),to_date('21-JUN-08','DD-MON-RR'),to_date('17-JUN-08','DD-MON-RR'),1,55,'MHVSMSIX, ALICE',3,989,'Dayton 29',to_date('17-JUN-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4432,0,null,null,null,4431,null,0,1,to_date('14-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('14-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4441,0,null,null,null,4440,null,0,1,to_date('14-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('14-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4450,0,null,null,null,4449,null,0,1,to_date('14-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),1,71,'MHVSMFOURTEEN, RINGO',3,979,'SLC10',to_date('14-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4459,0,null,null,null,4458,null,0,1,to_date('14-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),1,71,'MHVSMFOURTEEN, RINGO',3,979,'SLC10',to_date('14-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4468,0,null,null,null,4467,null,0,1,to_date('14-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),1,71,'MHVSMFOURTEEN, RINGO',3,979,'SLC10',to_date('14-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4477,0,null,null,null,4476,null,0,1,to_date('14-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),1,71,'MHVSMFOURTEEN, RINGO',3,979,'SLC10',to_date('14-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4486,0,null,null,null,4485,null,0,1,to_date('14-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),1,71,'MHVSMFOURTEEN, RINGO',3,979,'SLC10',to_date('14-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4495,0,null,null,null,4494,null,0,1,to_date('14-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),1,71,'MHVSMFOURTEEN, RINGO',3,979,'SLC10',to_date('14-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4513,0,null,null,null,4512,null,0,1,to_date('14-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,989,'Dayton 29',to_date('14-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4523,0,null,null,null,4522,null,0,1,to_date('14-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,989,'Dayton 29',to_date('14-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4504,0,null,2796,null,4503,null,1,1,to_date('14-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),1,71,'MHVSMFOURTEEN, RINGO',3,979,'SLC10',to_date('14-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4533,0,null,null,null,4532,null,0,1,to_date('14-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,989,'Dayton 29',to_date('14-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4543,0,null,null,null,4542,null,0,1,to_date('14-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,989,'Dayton 29',to_date('14-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4553,0,null,null,null,4552,null,0,1,to_date('14-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,989,'Dayton 29',to_date('14-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4563,0,null,null,null,4562,null,0,1,to_date('14-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,989,'Dayton 29',to_date('14-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4573,0,null,1150,null,4572,null,1,1,to_date('14-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,989,'Dayton 29',to_date('14-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4583,0,null,1150,null,4582,null,1,1,to_date('14-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,989,'Dayton 29',to_date('14-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4593,20,to_date('21-AUG-08','DD-MON-RR'),1150,null,4592,1150,2,1,to_date('14-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,989,'Dayton 29',to_date('14-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3799,0,null,null,null,3798,null,0,1,to_date('11-AUG-08','DD-MON-RR'),to_date('11-AUG-08','DD-MON-RR'),null,to_date('11-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,61,'MHVSMNINE, MABEL',to_date('11-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3806,20,to_date('11-AUG-08','DD-MON-RR'),83,null,3805,86,3,1,to_date('11-AUG-08','DD-MON-RR'),to_date('11-AUG-08','DD-MON-RR'),null,to_date('11-AUG-08','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('11-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (3816,20,to_date('20-FEB-09','DD-MON-RR'),null,null,3815,2796,1,1,to_date('11-AUG-08','DD-MON-RR'),to_date('11-AUG-08','DD-MON-RR'),null,to_date('11-AUG-08','DD-MON-RR'),2,82,'MHVSMSTAFFONE, CAROL',2,2796,'Balasubramanian, Swetha',to_date('11-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4756,0,null,null,null,4755,null,0,1,to_date('14-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),1,63,'MHVSMTEN, EDNA',3,979,'SLC10',to_date('14-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4828,20,to_date('09-OCT-08','DD-MON-RR'),80,null,4827,1154,3,1,to_date('14-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),1,63,'MHVSMTEN, EDNA',3,979,'SLC10',to_date('14-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4837,0,null,null,null,4836,null,0,1,to_date('14-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),1,63,'MHVSMTEN, EDNA',3,979,'SLC10',to_date('14-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4940,20,to_date('21-AUG-08','DD-MON-RR'),1152,null,4939,1150,4,1,to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),null,to_date('20-AUG-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',to_date('20-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4950,20,to_date('20-AUG-08','DD-MON-RR'),79,null,4949,79,2,1,to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),null,to_date('20-AUG-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',to_date('20-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4964,0,null,null,null,4949,null,0,1,to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),null,to_date('20-AUG-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',1,29,'MHVSMONE, ALYSSA',to_date('20-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4989,0,null,null,null,3217,null,0,1,to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),null,to_date('20-AUG-08','DD-MON-RR'),2,82,'MHVSMSTAFFONE, CAROL',1,61,'MHVSMNINE, MABEL',to_date('20-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4993,0,null,null,null,2999,null,0,1,to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),null,to_date('20-AUG-08','DD-MON-RR'),2,82,'MHVSMSTAFFONE, CAROL',1,61,'MHVSMNINE, MABEL',to_date('20-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4997,20,to_date('10-NOV-08','DD-MON-RR'),null,null,4996,2796,1,1,to_date('20-AUG-08','DD-MON-RR'),to_date('26-AUG-08','DD-MON-RR'),to_date('26-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('20-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5006,0,null,null,null,5005,null,0,1,to_date('20-AUG-08','DD-MON-RR'),to_date('26-AUG-08','DD-MON-RR'),to_date('26-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('20-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5015,0,null,null,null,5014,null,0,1,to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),null,to_date('20-AUG-08','DD-MON-RR'),2,82,'MHVSMSTAFFONE, CAROL',3,979,'SLC10',to_date('20-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5018,0,null,null,null,5017,null,0,1,to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),null,to_date('20-AUG-08','DD-MON-RR'),2,82,'MHVSMSTAFFONE, CAROL',3,979,'SLC10',to_date('20-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5020,0,null,null,null,5019,null,0,1,to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),null,to_date('20-AUG-08','DD-MON-RR'),2,82,'MHVSMSTAFFONE, CAROL',3,979,'SLC10',to_date('20-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5023,0,null,null,null,5022,null,0,1,to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),null,to_date('20-AUG-08','DD-MON-RR'),2,82,'MHVSMSTAFFONE, CAROL',3,979,'SLC10',to_date('20-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5026,0,null,null,null,5025,null,0,1,to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),null,to_date('20-AUG-08','DD-MON-RR'),2,82,'MHVSMSTAFFONE, CAROL',3,979,'SLC10',to_date('20-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5029,0,null,null,null,5028,null,0,1,to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),null,to_date('20-AUG-08','DD-MON-RR'),2,82,'MHVSMSTAFFONE, CAROL',3,979,'SLC10',to_date('20-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5031,0,null,null,null,5030,null,0,1,to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),null,to_date('20-AUG-08','DD-MON-RR'),2,82,'MHVSMSTAFFONE, CAROL',3,979,'SLC10',to_date('20-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5035,0,null,null,null,5034,null,0,1,to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),null,to_date('20-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5039,0,null,null,null,5038,null,0,1,to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),null,to_date('20-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5042,0,null,null,null,5041,null,0,1,to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),null,to_date('20-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6460,0,null,2796,null,5171,null,2,1,to_date('10-NOV-08','DD-MON-RR'),to_date('10-NOV-08','DD-MON-RR'),null,to_date('10-NOV-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,61,'MHVSMNINE, MABEL',to_date('10-NOV-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6471,0,null,2796,null,4737,null,1,1,to_date('10-NOV-08','DD-MON-RR'),to_date('10-NOV-08','DD-MON-RR'),null,to_date('10-NOV-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,63,'MHVSMTEN, EDNA',to_date('10-NOV-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6493,0,null,2796,null,1527,null,1,1,to_date('13-NOV-08','DD-MON-RR'),to_date('19-NOV-08','DD-MON-RR'),to_date('19-NOV-08','DD-MON-RR'),to_date('13-NOV-08','DD-MON-RR'),1,1431,'MHVJEROMEAAA, TESTAAA',3,979,'SLC10',to_date('13-NOV-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6512,0,null,null,null,2209,null,0,1,to_date('13-NOV-08','DD-MON-RR'),to_date('13-NOV-08','DD-MON-RR'),null,to_date('13-NOV-08','DD-MON-RR'),2,24,'MHVSMDOCONE, MIKE',1,29,'MHVSMONE, ALYSSA',to_date('13-NOV-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6518,0,null,null,null,6517,null,0,1,to_date('13-NOV-08','DD-MON-RR'),to_date('13-NOV-08','DD-MON-RR'),null,to_date('13-NOV-08','DD-MON-RR'),2,24,'MHVSMDOCONE, MIKE',1,29,'MHVSMONE, ALYSSA',to_date('13-NOV-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6549,0,null,null,null,1585,null,0,1,to_date('17-NOV-08','DD-MON-RR'),to_date('17-NOV-08','DD-MON-RR'),null,to_date('17-NOV-08','DD-MON-RR'),2,1156,'Kola, Jerome',2,81,'MHVSMDOCFIVE, SAM',to_date('17-NOV-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6555,0,null,null,null,1581,null,0,1,to_date('17-NOV-08','DD-MON-RR'),to_date('17-NOV-08','DD-MON-RR'),null,to_date('17-NOV-08','DD-MON-RR'),2,1156,'Kola, Jerome',2,81,'MHVSMDOCFIVE, SAM',to_date('17-NOV-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6570,0,null,null,null,6569,null,0,1,to_date('18-NOV-08','DD-MON-RR'),to_date('22-NOV-08','DD-MON-RR'),to_date('22-NOV-08','DD-MON-RR'),to_date('18-NOV-08','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('18-NOV-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6616,20,to_date('08-DEC-08','DD-MON-RR'),2796,null,6615,2796,2,1,to_date('18-NOV-08','DD-MON-RR'),to_date('22-NOV-08','DD-MON-RR'),to_date('22-NOV-08','DD-MON-RR'),to_date('18-NOV-08','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('18-NOV-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6584,0,null,2796,null,6583,null,2,1,to_date('18-NOV-08','DD-MON-RR'),to_date('22-NOV-08','DD-MON-RR'),to_date('22-NOV-08','DD-MON-RR'),to_date('18-NOV-08','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('18-NOV-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6596,20,to_date('26-FEB-09','DD-MON-RR'),2796,null,6595,2796,7,1,to_date('18-NOV-08','DD-MON-RR'),to_date('22-NOV-08','DD-MON-RR'),to_date('22-NOV-08','DD-MON-RR'),to_date('18-NOV-08','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('18-NOV-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6606,20,to_date('08-DEC-08','DD-MON-RR'),null,null,6605,2796,1,1,to_date('18-NOV-08','DD-MON-RR'),to_date('22-NOV-08','DD-MON-RR'),to_date('22-NOV-08','DD-MON-RR'),to_date('18-NOV-08','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('18-NOV-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6626,20,to_date('18-NOV-08','DD-MON-RR'),2796,null,6625,2796,2,1,to_date('18-NOV-08','DD-MON-RR'),to_date('18-NOV-08','DD-MON-RR'),null,to_date('18-NOV-08','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('18-NOV-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6637,0,null,null,null,6625,null,0,1,to_date('18-NOV-08','DD-MON-RR'),to_date('18-NOV-08','DD-MON-RR'),null,to_date('18-NOV-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,57,'MHVSMSEVEN, BERTHA',to_date('18-NOV-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6643,20,to_date('18-NOV-08','DD-MON-RR'),null,null,6625,2796,1,1,to_date('18-NOV-08','DD-MON-RR'),to_date('18-NOV-08','DD-MON-RR'),null,to_date('18-NOV-08','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('18-NOV-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6656,0,null,2796,null,6625,null,1,1,to_date('18-NOV-08','DD-MON-RR'),to_date('22-NOV-08','DD-MON-RR'),to_date('22-NOV-08','DD-MON-RR'),to_date('18-NOV-08','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('18-NOV-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4624,0,null,null,null,4623,null,0,1,to_date('14-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,989,'Dayton 29',to_date('14-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5418,0,null,null,null,5417,null,0,1,to_date('22-AUG-08','DD-MON-RR'),to_date('28-AUG-08','DD-MON-RR'),to_date('28-AUG-08','DD-MON-RR'),to_date('22-AUG-08','DD-MON-RR'),1,55,'mhvsmsix, Alice',3,4891,'Clinic (DAYT29)',to_date('22-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5520,0,null,null,null,5519,null,0,1,to_date('22-AUG-08','DD-MON-RR'),to_date('28-AUG-08','DD-MON-RR'),to_date('28-AUG-08','DD-MON-RR'),to_date('22-AUG-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,4860,'Provider (DAYT29)',to_date('22-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5489,0,null,2796,null,1527,null,1,1,to_date('22-AUG-08','DD-MON-RR'),to_date('28-AUG-08','DD-MON-RR'),to_date('28-AUG-08','DD-MON-RR'),to_date('22-AUG-08','DD-MON-RR'),1,1431,'MHVJEROMEAAA, TESTAAA',3,979,'SLC10',to_date('22-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5512,0,null,null,null,5511,null,0,1,to_date('22-AUG-08','DD-MON-RR'),to_date('28-AUG-08','DD-MON-RR'),to_date('28-AUG-08','DD-MON-RR'),to_date('22-AUG-08','DD-MON-RR'),1,51,'MHVSMFOUR, OLIVIA',3,4151,'test for relationship 1',to_date('22-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5566,0,null,null,null,5565,null,0,1,to_date('22-AUG-08','DD-MON-RR'),to_date('28-AUG-08','DD-MON-RR'),to_date('28-AUG-08','DD-MON-RR'),to_date('22-AUG-08','DD-MON-RR'),1,53,'MHVSMFIVE, EMMA',3,4914,'OE/RR (DAYT29)',to_date('22-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5576,20,to_date('22-AUG-08','DD-MON-RR'),24,null,5575,24,2,1,to_date('22-AUG-08','DD-MON-RR'),to_date('22-AUG-08','DD-MON-RR'),null,to_date('22-AUG-08','DD-MON-RR'),1,53,'MHVSMFIVE, EMMA',3,989,'Dayton 29',to_date('22-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (29682,0,null,null,'b0e3dbe9                        ',29681,null,1,1,to_date('16-JUN-10','DD-MON-RR'),to_date('22-JUN-10','DD-MON-RR'),to_date('22-JUN-10','DD-MON-RR'),to_date('16-JUN-10','DD-MON-RR'),1,53,'MHVSMFIVE, EMMA',3,18282,'JB test triage',to_date('16-JUN-10','DD-MON-RR'),to_date('22-JUN-10','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (29651,0,null,null,'a68423dd                        ',29650,null,1,1,to_date('16-JUN-10','DD-MON-RR'),to_date('22-JUN-10','DD-MON-RR'),to_date('22-JUN-10','DD-MON-RR'),to_date('16-JUN-10','DD-MON-RR'),1,53,'MHVSMFIVE, EMMA',3,18282,'JB test triage',to_date('16-JUN-10','DD-MON-RR'),to_date('22-JUN-10','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5699,10,null,1150,null,5698,1150,1,1,to_date('22-AUG-08','DD-MON-RR'),to_date('28-AUG-08','DD-MON-RR'),to_date('28-AUG-08','DD-MON-RR'),to_date('22-AUG-08','DD-MON-RR'),1,47,'MHVSMTWO, BRIANNA',3,4860,'Provider (DAYT29)',to_date('22-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (29691,0,null,null,'75e735a9                        ',29690,null,0,1,to_date('16-JUN-10','DD-MON-RR'),to_date('16-JUN-10','DD-MON-RR'),null,to_date('16-JUN-10','DD-MON-RR'),2,24280,'FATZINGER, WALTER',1,53,'MHVSMFIVE, EMMA',to_date('16-JUN-10','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5727,0,null,null,null,5726,null,0,1,to_date('22-AUG-08','DD-MON-RR'),to_date('28-AUG-08','DD-MON-RR'),to_date('28-AUG-08','DD-MON-RR'),to_date('22-AUG-08','DD-MON-RR'),1,69,'MHVSMTHIRTEEN, GEORGE',3,5550,'clinic test 2',to_date('22-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5735,0,null,null,null,5734,null,0,1,to_date('22-AUG-08','DD-MON-RR'),to_date('28-AUG-08','DD-MON-RR'),to_date('28-AUG-08','DD-MON-RR'),to_date('22-AUG-08','DD-MON-RR'),1,69,'MHVSMTHIRTEEN, GEORGE',3,5550,'clinic test 2',to_date('22-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5743,0,null,null,null,5742,null,0,1,to_date('22-AUG-08','DD-MON-RR'),to_date('28-AUG-08','DD-MON-RR'),to_date('28-AUG-08','DD-MON-RR'),to_date('22-AUG-08','DD-MON-RR'),1,69,'MHVSMTHIRTEEN, GEORGE',3,5550,'clinic test 2',to_date('22-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5751,0,null,null,null,5750,null,0,1,to_date('22-AUG-08','DD-MON-RR'),to_date('28-AUG-08','DD-MON-RR'),to_date('28-AUG-08','DD-MON-RR'),to_date('22-AUG-08','DD-MON-RR'),1,69,'MHVSMTHIRTEEN, GEORGE',3,5550,'clinic test 2',to_date('22-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5759,0,null,null,null,5758,null,0,1,to_date('22-AUG-08','DD-MON-RR'),to_date('28-AUG-08','DD-MON-RR'),to_date('28-AUG-08','DD-MON-RR'),to_date('22-AUG-08','DD-MON-RR'),1,69,'MHVSMTHIRTEEN, GEORGE',3,989,'Dayton 29',to_date('22-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5778,0,null,null,null,5575,null,0,1,to_date('22-AUG-08','DD-MON-RR'),to_date('22-AUG-08','DD-MON-RR'),null,to_date('22-AUG-08','DD-MON-RR'),2,24,'MHVSMDOCONE, MIKE',1,53,'MHVSMFIVE, EMMA',to_date('22-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7097,0,null,null,null,7096,null,0,1,to_date('02-FEB-09','DD-MON-RR'),to_date('02-FEB-09','DD-MON-RR'),null,to_date('02-FEB-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('02-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7101,0,null,null,null,7100,null,0,1,to_date('02-FEB-09','DD-MON-RR'),to_date('02-FEB-09','DD-MON-RR'),null,to_date('02-FEB-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('02-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7104,0,null,null,null,7103,null,0,1,to_date('02-FEB-09','DD-MON-RR'),to_date('02-FEB-09','DD-MON-RR'),null,to_date('02-FEB-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('02-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7107,0,null,null,null,7106,null,0,1,to_date('02-FEB-09','DD-MON-RR'),to_date('02-FEB-09','DD-MON-RR'),null,to_date('02-FEB-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('02-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7111,0,null,null,null,7110,null,0,1,to_date('02-FEB-09','DD-MON-RR'),to_date('02-FEB-09','DD-MON-RR'),null,to_date('02-FEB-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('02-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7115,0,null,null,null,7114,null,0,1,to_date('02-FEB-09','DD-MON-RR'),to_date('02-FEB-09','DD-MON-RR'),null,to_date('02-FEB-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('02-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (29639,0,null,null,'6faf6864                        ',29638,null,1,1,to_date('16-JUN-10','DD-MON-RR'),to_date('22-JUN-10','DD-MON-RR'),to_date('22-JUN-10','DD-MON-RR'),to_date('16-JUN-10','DD-MON-RR'),1,53,'MHVSMFIVE, EMMA',3,18282,'JB test triage',to_date('16-JUN-10','DD-MON-RR'),to_date('22-JUN-10','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (29661,0,null,null,'e48ca948                        ',29660,null,1,1,to_date('16-JUN-10','DD-MON-RR'),to_date('22-JUN-10','DD-MON-RR'),to_date('22-JUN-10','DD-MON-RR'),to_date('16-JUN-10','DD-MON-RR'),1,53,'MHVSMFIVE, EMMA',3,18282,'JB test triage',to_date('16-JUN-10','DD-MON-RR'),to_date('22-JUN-10','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (29670,0,null,null,'e9bc5021                        ',29669,null,1,1,to_date('16-JUN-10','DD-MON-RR'),to_date('22-JUN-10','DD-MON-RR'),to_date('22-JUN-10','DD-MON-RR'),to_date('16-JUN-10','DD-MON-RR'),1,53,'MHVSMFIVE, EMMA',3,18282,'JB test triage',to_date('16-JUN-10','DD-MON-RR'),to_date('22-JUN-10','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4634,0,null,1150,null,4633,null,1,1,to_date('14-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,989,'Dayton 29',to_date('14-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4644,0,null,1150,null,4643,null,1,1,to_date('14-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,989,'Dayton 29',to_date('14-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4654,0,null,1150,null,4653,null,1,1,to_date('14-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,989,'Dayton 29',to_date('14-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4664,0,null,1150,null,4663,null,1,1,to_date('14-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,989,'Dayton 29',to_date('14-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4674,0,null,1150,null,4673,null,1,1,to_date('14-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,989,'Dayton 29',to_date('14-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4684,0,null,null,null,4683,null,0,1,to_date('14-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),1,63,'MHVSMTEN, EDNA',3,979,'SLC10',to_date('14-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4693,0,null,null,null,4692,null,0,1,to_date('14-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),1,63,'MHVSMTEN, EDNA',3,979,'SLC10',to_date('14-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4702,0,null,null,null,4701,null,0,1,to_date('14-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),1,63,'MHVSMTEN, EDNA',3,979,'SLC10',to_date('14-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4711,0,null,null,null,4710,null,0,1,to_date('14-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),1,63,'MHVSMTEN, EDNA',3,979,'SLC10',to_date('14-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4395,0,null,null,null,4394,null,0,1,to_date('13-AUG-08','DD-MON-RR'),to_date('19-AUG-08','DD-MON-RR'),to_date('19-AUG-08','DD-MON-RR'),to_date('13-AUG-08','DD-MON-RR'),1,71,'MHVSMFOURTEEN, RINGO',3,979,'SLC10',to_date('13-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4405,0,null,null,null,4404,null,0,1,to_date('13-AUG-08','DD-MON-RR'),to_date('19-AUG-08','DD-MON-RR'),to_date('19-AUG-08','DD-MON-RR'),to_date('13-AUG-08','DD-MON-RR'),1,53,'MHVSMFIVE, EMMA',3,989,'Dayton 29',to_date('13-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4416,0,null,1150,null,4415,null,1,1,to_date('13-AUG-08','DD-MON-RR'),to_date('19-AUG-08','DD-MON-RR'),to_date('19-AUG-08','DD-MON-RR'),to_date('13-AUG-08','DD-MON-RR'),1,53,'MHVSMFIVE, EMMA',3,989,'Dayton 29',to_date('13-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5143,0,null,null,null,5142,null,0,1,to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),null,to_date('20-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5147,0,null,null,null,5146,null,0,1,to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),null,to_date('20-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5151,0,null,null,null,5150,null,0,1,to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),null,to_date('20-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5163,0,null,1156,null,5162,null,1,1,to_date('20-AUG-08','DD-MON-RR'),to_date('26-AUG-08','DD-MON-RR'),to_date('26-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('20-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5172,20,to_date('10-NOV-08','DD-MON-RR'),2796,null,5171,2796,2,1,to_date('20-AUG-08','DD-MON-RR'),to_date('26-AUG-08','DD-MON-RR'),to_date('26-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('20-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5203,0,null,null,null,5202,null,0,1,to_date('20-AUG-08','DD-MON-RR'),to_date('26-AUG-08','DD-MON-RR'),to_date('26-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),1,65,'MHVSMELEVEN, JOHN',3,979,'SLC10',to_date('20-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5212,0,null,null,null,4673,null,0,1,to_date('21-AUG-08','DD-MON-RR'),to_date('21-AUG-08','DD-MON-RR'),null,to_date('21-AUG-08','DD-MON-RR'),2,1150,'Prematta,        ',1,73,'MHVSMFIFTEEN, YOKO',to_date('21-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5221,0,null,null,null,4663,null,0,1,to_date('21-AUG-08','DD-MON-RR'),to_date('21-AUG-08','DD-MON-RR'),null,to_date('21-AUG-08','DD-MON-RR'),2,1150,'Prematta,        ',1,73,'MHVSMFIFTEEN, YOKO',to_date('21-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5226,0,null,null,null,4643,null,0,1,to_date('21-AUG-08','DD-MON-RR'),to_date('21-AUG-08','DD-MON-RR'),null,to_date('21-AUG-08','DD-MON-RR'),2,1150,'Prematta,        ',1,73,'MHVSMFIFTEEN, YOKO',to_date('21-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5231,0,null,null,null,4415,null,0,1,to_date('21-AUG-08','DD-MON-RR'),to_date('21-AUG-08','DD-MON-RR'),null,to_date('21-AUG-08','DD-MON-RR'),2,1150,'Prematta,        ',1,53,'MHVSMFIVE, EMMA',to_date('21-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5236,0,null,null,null,3687,null,0,1,to_date('21-AUG-08','DD-MON-RR'),to_date('21-AUG-08','DD-MON-RR'),null,to_date('21-AUG-08','DD-MON-RR'),2,1150,'Prematta,        ',2,76,'MHVSMDOCTWO, GREG',to_date('21-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5241,0,null,null,null,4653,null,0,1,to_date('21-AUG-08','DD-MON-RR'),to_date('21-AUG-08','DD-MON-RR'),null,to_date('21-AUG-08','DD-MON-RR'),2,1150,'Prematta,        ',1,73,'MHVSMFIFTEEN, YOKO',to_date('21-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5246,0,null,null,null,4633,null,0,1,to_date('21-AUG-08','DD-MON-RR'),to_date('21-AUG-08','DD-MON-RR'),null,to_date('21-AUG-08','DD-MON-RR'),2,1150,'Prematta,        ',1,73,'MHVSMFIFTEEN, YOKO',to_date('21-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5251,0,null,null,null,4603,null,0,1,to_date('21-AUG-08','DD-MON-RR'),to_date('21-AUG-08','DD-MON-RR'),null,to_date('21-AUG-08','DD-MON-RR'),2,1150,'Prematta,        ',1,73,'MHVSMFIFTEEN, YOKO',to_date('21-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5258,0,null,null,null,4613,null,0,1,to_date('21-AUG-08','DD-MON-RR'),to_date('21-AUG-08','DD-MON-RR'),null,to_date('21-AUG-08','DD-MON-RR'),2,1150,'Prematta,        ',1,73,'MHVSMFIFTEEN, YOKO',to_date('21-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5263,0,null,null,null,4592,null,0,1,to_date('21-AUG-08','DD-MON-RR'),to_date('21-AUG-08','DD-MON-RR'),null,to_date('21-AUG-08','DD-MON-RR'),2,1150,'Prematta,        ',1,73,'MHVSMFIFTEEN, YOKO',to_date('21-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5268,0,null,null,null,4582,null,0,1,to_date('21-AUG-08','DD-MON-RR'),to_date('21-AUG-08','DD-MON-RR'),null,to_date('21-AUG-08','DD-MON-RR'),2,1150,'Prematta,        ',1,73,'MHVSMFIFTEEN, YOKO',to_date('21-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5273,0,null,null,null,4572,null,0,1,to_date('21-AUG-08','DD-MON-RR'),to_date('21-AUG-08','DD-MON-RR'),null,to_date('21-AUG-08','DD-MON-RR'),2,1150,'Prematta,        ',1,73,'MHVSMFIFTEEN, YOKO',to_date('21-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5278,20,to_date('21-AUG-08','DD-MON-RR'),null,null,5277,1150,1,1,to_date('21-AUG-08','DD-MON-RR'),to_date('21-AUG-08','DD-MON-RR'),null,to_date('21-AUG-08','DD-MON-RR'),1,47,'MHVSMTWO, BRIANNA',3,989,'Dayton 29',to_date('21-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5296,0,null,null,null,4011,null,0,1,to_date('21-AUG-08','DD-MON-RR'),to_date('27-AUG-08','DD-MON-RR'),to_date('27-AUG-08','DD-MON-RR'),to_date('21-AUG-08','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('21-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5343,20,to_date('21-AUG-08','DD-MON-RR'),79,null,5342,79,4,1,to_date('21-AUG-08','DD-MON-RR'),to_date('21-AUG-08','DD-MON-RR'),null,to_date('21-AUG-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,4860,'Provider (DAYT29)',to_date('21-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5363,0,null,null,null,5352,null,0,1,to_date('21-AUG-08','DD-MON-RR'),to_date('21-AUG-08','DD-MON-RR'),null,to_date('21-AUG-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',1,29,'MHVSMONE, ALYSSA',to_date('21-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5353,20,to_date('21-AUG-08','DD-MON-RR'),79,null,5352,79,2,1,to_date('21-AUG-08','DD-MON-RR'),to_date('21-AUG-08','DD-MON-RR'),null,to_date('21-AUG-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,4860,'Provider (DAYT29)',to_date('21-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5371,0,null,null,null,5342,null,0,1,to_date('21-AUG-08','DD-MON-RR'),to_date('21-AUG-08','DD-MON-RR'),null,to_date('21-AUG-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',1,29,'MHVSMONE, ALYSSA',to_date('21-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5383,0,null,null,null,5382,null,0,1,to_date('21-AUG-08','DD-MON-RR'),to_date('27-AUG-08','DD-MON-RR'),to_date('27-AUG-08','DD-MON-RR'),to_date('21-AUG-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,4860,'Provider (DAYT29)',to_date('21-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5393,0,null,null,null,5392,null,0,1,to_date('21-AUG-08','DD-MON-RR'),to_date('27-AUG-08','DD-MON-RR'),to_date('27-AUG-08','DD-MON-RR'),to_date('21-AUG-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,4860,'Provider (DAYT29)',to_date('21-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5804,20,to_date('20-FEB-09','DD-MON-RR'),24,null,5803,1150,2,1,to_date('25-AUG-08','DD-MON-RR'),to_date('29-AUG-08','DD-MON-RR'),to_date('29-AUG-08','DD-MON-RR'),to_date('25-AUG-08','DD-MON-RR'),1,47,'MHVSMTWO, BRIANNA',3,4860,'Provider (DAYT29)',to_date('25-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5815,0,null,null,null,5803,null,0,1,to_date('25-AUG-08','DD-MON-RR'),to_date('25-AUG-08','DD-MON-RR'),null,to_date('25-AUG-08','DD-MON-RR'),2,24,'MHVSMDOCONE, MIKE',1,47,'MHVSMTWO, BRIANNA',to_date('25-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5821,0,null,null,null,227,null,0,1,to_date('26-AUG-08','DD-MON-RR'),to_date('26-AUG-08','DD-MON-RR'),null,to_date('26-AUG-08','DD-MON-RR'),2,84,'MHVSMSTAFFTHREE, JAN',1,29,'MHVSMONE, ALYSSA',to_date('26-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5827,20,to_date('30-MAR-09','DD-MON-RR'),1152,null,227,1152,3,1,to_date('26-AUG-08','DD-MON-RR'),to_date('30-AUG-08','DD-MON-RR'),to_date('30-AUG-08','DD-MON-RR'),to_date('26-AUG-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',to_date('26-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5851,0,null,null,null,5850,null,0,1,to_date('04-SEP-08','DD-MON-RR'),to_date('04-SEP-08','DD-MON-RR'),null,to_date('04-SEP-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',3,4151,'test for relationship 1',to_date('04-SEP-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5855,0,null,null,null,5854,null,0,1,to_date('04-SEP-08','DD-MON-RR'),to_date('04-SEP-08','DD-MON-RR'),null,to_date('04-SEP-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',3,4151,'test for relationship 1',to_date('04-SEP-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5865,0,null,null,null,5864,null,0,1,to_date('04-SEP-08','DD-MON-RR'),to_date('04-SEP-08','DD-MON-RR'),null,to_date('04-SEP-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',4,1348,'jhgjhg',to_date('04-SEP-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5869,0,null,null,null,5868,null,0,1,to_date('04-SEP-08','DD-MON-RR'),to_date('04-SEP-08','DD-MON-RR'),null,to_date('04-SEP-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',4,1348,'jhgjhg',to_date('04-SEP-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5873,0,null,null,null,5872,null,0,1,to_date('04-SEP-08','DD-MON-RR'),to_date('04-SEP-08','DD-MON-RR'),null,to_date('04-SEP-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',4,1348,'jhgjhg',to_date('04-SEP-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5877,0,null,null,null,5876,null,0,1,to_date('04-SEP-08','DD-MON-RR'),to_date('04-SEP-08','DD-MON-RR'),null,to_date('04-SEP-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',4,1348,'jhgjhg',to_date('04-SEP-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5881,0,null,null,null,5880,null,0,1,to_date('04-SEP-08','DD-MON-RR'),to_date('04-SEP-08','DD-MON-RR'),null,to_date('04-SEP-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',4,1348,'jhgjhg',to_date('04-SEP-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5884,0,null,null,null,5883,null,0,1,to_date('04-SEP-08','DD-MON-RR'),to_date('04-SEP-08','DD-MON-RR'),null,to_date('04-SEP-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',4,1348,'jhgjhg',to_date('04-SEP-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5888,0,null,null,null,5887,null,0,1,to_date('04-SEP-08','DD-MON-RR'),to_date('04-SEP-08','DD-MON-RR'),null,to_date('04-SEP-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',4,1348,'jhgjhg',to_date('04-SEP-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5892,0,null,null,null,5891,null,0,1,to_date('04-SEP-08','DD-MON-RR'),to_date('04-SEP-08','DD-MON-RR'),null,to_date('04-SEP-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',4,1348,'jhgjhg',to_date('04-SEP-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5896,0,null,null,null,5895,null,0,1,to_date('04-SEP-08','DD-MON-RR'),to_date('04-SEP-08','DD-MON-RR'),null,to_date('04-SEP-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',4,1348,'jhgjhg',to_date('04-SEP-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5900,0,null,null,null,5899,null,0,1,to_date('04-SEP-08','DD-MON-RR'),to_date('04-SEP-08','DD-MON-RR'),null,to_date('04-SEP-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',4,1348,'jhgjhg',to_date('04-SEP-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5904,0,null,null,null,5903,null,0,1,to_date('04-SEP-08','DD-MON-RR'),to_date('04-SEP-08','DD-MON-RR'),null,to_date('04-SEP-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',4,1348,'jhgjhg',to_date('04-SEP-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5908,0,null,null,null,5907,null,0,1,to_date('04-SEP-08','DD-MON-RR'),to_date('04-SEP-08','DD-MON-RR'),null,to_date('04-SEP-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',4,1348,'jhgjhg',to_date('04-SEP-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5911,0,null,null,null,5910,null,0,1,to_date('04-SEP-08','DD-MON-RR'),to_date('04-SEP-08','DD-MON-RR'),null,to_date('04-SEP-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',4,1348,'jhgjhg',to_date('04-SEP-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5915,0,null,null,null,5914,null,0,1,to_date('04-SEP-08','DD-MON-RR'),to_date('04-SEP-08','DD-MON-RR'),null,to_date('04-SEP-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',4,1348,'jhgjhg',to_date('04-SEP-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5918,0,null,null,null,5917,null,0,1,to_date('04-SEP-08','DD-MON-RR'),to_date('04-SEP-08','DD-MON-RR'),null,to_date('04-SEP-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',4,1348,'jhgjhg',to_date('04-SEP-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5921,0,null,null,null,5920,null,0,1,to_date('04-SEP-08','DD-MON-RR'),to_date('04-SEP-08','DD-MON-RR'),null,to_date('04-SEP-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',4,1348,'jhgjhg',to_date('04-SEP-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5999,0,null,null,null,5998,null,0,1,to_date('09-OCT-08','DD-MON-RR'),to_date('15-OCT-08','DD-MON-RR'),to_date('15-OCT-08','DD-MON-RR'),to_date('09-OCT-08','DD-MON-RR'),1,53,'MHVSMFIVE, EMMA',3,4914,'OE/RR (DAYT29)',to_date('09-OCT-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5968,0,null,null,null,5967,null,0,1,to_date('09-OCT-08','DD-MON-RR'),to_date('15-OCT-08','DD-MON-RR'),to_date('15-OCT-08','DD-MON-RR'),to_date('09-OCT-08','DD-MON-RR'),1,53,'MHVSMFIVE, EMMA',3,4914,'OE/RR (DAYT29)',to_date('09-OCT-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5979,0,null,null,null,5978,null,0,1,to_date('09-OCT-08','DD-MON-RR'),to_date('15-OCT-08','DD-MON-RR'),to_date('15-OCT-08','DD-MON-RR'),to_date('09-OCT-08','DD-MON-RR'),1,53,'MHVSMFIVE, EMMA',3,4914,'OE/RR (DAYT29)',to_date('09-OCT-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5989,0,null,1150,null,5988,null,1,1,to_date('09-OCT-08','DD-MON-RR'),to_date('15-OCT-08','DD-MON-RR'),to_date('15-OCT-08','DD-MON-RR'),to_date('09-OCT-08','DD-MON-RR'),1,53,'MHVSMFIVE, EMMA',3,4914,'OE/RR (DAYT29)',to_date('09-OCT-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6009,20,to_date('30-MAR-09','DD-MON-RR'),1150,null,6008,1150,2,1,to_date('09-OCT-08','DD-MON-RR'),to_date('15-OCT-08','DD-MON-RR'),to_date('15-OCT-08','DD-MON-RR'),to_date('09-OCT-08','DD-MON-RR'),1,53,'MHVSMFIVE, EMMA',3,4914,'OE/RR (DAYT29)',to_date('09-OCT-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6019,0,null,null,null,6018,null,0,1,to_date('09-OCT-08','DD-MON-RR'),to_date('15-OCT-08','DD-MON-RR'),to_date('15-OCT-08','DD-MON-RR'),to_date('09-OCT-08','DD-MON-RR'),1,53,'MHVSMFIVE, EMMA',3,4914,'OE/RR (DAYT29)',to_date('09-OCT-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6029,0,null,1150,null,6028,null,1,1,to_date('09-OCT-08','DD-MON-RR'),to_date('15-OCT-08','DD-MON-RR'),to_date('15-OCT-08','DD-MON-RR'),to_date('09-OCT-08','DD-MON-RR'),1,53,'MHVSMFIVE, EMMA',3,4914,'OE/RR (DAYT29)',to_date('09-OCT-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6039,0,null,1150,null,6038,null,2,1,to_date('09-OCT-08','DD-MON-RR'),to_date('15-OCT-08','DD-MON-RR'),to_date('15-OCT-08','DD-MON-RR'),to_date('09-OCT-08','DD-MON-RR'),1,53,'MHVSMFIVE, EMMA',3,4914,'OE/RR (DAYT29)',to_date('09-OCT-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6049,20,to_date('31-OCT-08','DD-MON-RR'),79,null,6048,79,2,1,to_date('09-OCT-08','DD-MON-RR'),to_date('15-OCT-08','DD-MON-RR'),to_date('15-OCT-08','DD-MON-RR'),to_date('09-OCT-08','DD-MON-RR'),1,53,'MHVSMFIVE, EMMA',3,4914,'OE/RR (DAYT29)',to_date('09-OCT-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6059,20,to_date('26-FEB-09','DD-MON-RR'),null,null,6058,1152,1,1,to_date('09-OCT-08','DD-MON-RR'),to_date('15-OCT-08','DD-MON-RR'),to_date('15-OCT-08','DD-MON-RR'),to_date('09-OCT-08','DD-MON-RR'),1,53,'MHVSMFIVE, EMMA',3,4914,'OE/RR (DAYT29)',to_date('09-OCT-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6070,0,null,null,null,6069,null,0,1,to_date('09-OCT-08','DD-MON-RR'),to_date('09-OCT-08','DD-MON-RR'),null,to_date('09-OCT-08','DD-MON-RR'),2,1154,'Mcdonald, Douglas',1,63,'MHVSMTEN, EDNA',to_date('09-OCT-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6075,0,null,null,null,4827,null,0,1,to_date('09-OCT-08','DD-MON-RR'),to_date('09-OCT-08','DD-MON-RR'),null,to_date('09-OCT-08','DD-MON-RR'),2,1154,'Mcdonald, Douglas',1,63,'MHVSMTEN, EDNA',to_date('09-OCT-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6227,20,to_date('31-OCT-08','DD-MON-RR'),null,null,6226,79,1,1,to_date('21-OCT-08','DD-MON-RR'),to_date('25-OCT-08','DD-MON-RR'),to_date('25-OCT-08','DD-MON-RR'),to_date('21-OCT-08','DD-MON-RR'),1,51,'MHVSMFOUR, OLIVIA',3,989,'Dayton 29',to_date('21-OCT-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6244,20,to_date('31-OCT-08','DD-MON-RR'),79,null,6243,79,2,1,to_date('30-OCT-08','DD-MON-RR'),to_date('30-OCT-08','DD-MON-RR'),null,to_date('30-OCT-08','DD-MON-RR'),1,51,'MHVSMFOUR, OLIVIA',3,989,'Dayton 29',to_date('30-OCT-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6273,0,null,null,null,6272,null,0,1,to_date('31-OCT-08','DD-MON-RR'),to_date('06-NOV-08','DD-MON-RR'),to_date('06-NOV-08','DD-MON-RR'),to_date('31-OCT-08','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('31-OCT-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6282,0,null,null,null,6281,null,0,1,to_date('31-OCT-08','DD-MON-RR'),to_date('06-NOV-08','DD-MON-RR'),to_date('06-NOV-08','DD-MON-RR'),to_date('31-OCT-08','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('31-OCT-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6291,0,null,2796,null,6290,null,1,1,to_date('31-OCT-08','DD-MON-RR'),to_date('06-NOV-08','DD-MON-RR'),to_date('06-NOV-08','DD-MON-RR'),to_date('31-OCT-08','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('31-OCT-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6300,20,to_date('31-OCT-08','DD-MON-RR'),1154,null,6299,1154,2,1,to_date('31-OCT-08','DD-MON-RR'),to_date('31-OCT-08','DD-MON-RR'),null,to_date('31-OCT-08','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('31-OCT-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6318,0,null,null,null,6299,null,0,1,to_date('31-OCT-08','DD-MON-RR'),to_date('31-OCT-08','DD-MON-RR'),null,to_date('31-OCT-08','DD-MON-RR'),2,1154,'Mcdonald, Douglas',1,57,'MHVSMSEVEN, BERTHA',to_date('31-OCT-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6325,0,null,null,null,6243,null,0,1,to_date('31-OCT-08','DD-MON-RR'),to_date('31-OCT-08','DD-MON-RR'),null,to_date('31-OCT-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',1,51,'MHVSMFOUR, OLIVIA',to_date('31-OCT-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6335,0,null,null,null,6048,null,0,1,to_date('31-OCT-08','DD-MON-RR'),to_date('31-OCT-08','DD-MON-RR'),null,to_date('31-OCT-08','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',1,53,'MHVSMFIVE, EMMA',to_date('31-OCT-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6352,20,to_date('26-FEB-09','DD-MON-RR'),76,null,6351,1152,2,1,to_date('04-NOV-08','DD-MON-RR'),to_date('08-NOV-08','DD-MON-RR'),to_date('08-NOV-08','DD-MON-RR'),to_date('04-NOV-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,4860,'Provider (DAYT29)',to_date('04-NOV-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6372,0,null,null,null,6290,null,0,1,to_date('06-NOV-08','DD-MON-RR'),to_date('06-NOV-08','DD-MON-RR'),null,to_date('06-NOV-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,57,'MHVSMSEVEN, BERTHA',to_date('06-NOV-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6377,0,null,null,null,1527,null,0,1,to_date('06-NOV-08','DD-MON-RR'),to_date('06-NOV-08','DD-MON-RR'),null,to_date('06-NOV-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,1431,'MHVJEROMEAAA, TESTAAA',to_date('06-NOV-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6390,0,null,null,null,6389,null,0,1,to_date('07-NOV-08','DD-MON-RR'),to_date('13-NOV-08','DD-MON-RR'),to_date('13-NOV-08','DD-MON-RR'),to_date('07-NOV-08','DD-MON-RR'),1,6384,'MHVSWETHATEST, GWELL',3,4151,'test for relationship 1',to_date('07-NOV-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6401,0,null,null,null,5988,null,0,1,to_date('07-NOV-08','DD-MON-RR'),to_date('07-NOV-08','DD-MON-RR'),null,to_date('07-NOV-08','DD-MON-RR'),2,1150,'Prematta,        ',1,53,'MHVSMFIVE, EMMA',to_date('07-NOV-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6406,20,to_date('26-FEB-09','DD-MON-RR'),null,null,6405,1152,1,1,to_date('07-NOV-08','DD-MON-RR'),to_date('13-NOV-08','DD-MON-RR'),to_date('13-NOV-08','DD-MON-RR'),to_date('07-NOV-08','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,4860,'Provider (DAYT29)',to_date('07-NOV-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6418,0,null,null,null,6417,null,0,1,to_date('07-NOV-08','DD-MON-RR'),to_date('07-NOV-08','DD-MON-RR'),null,to_date('07-NOV-08','DD-MON-RR'),2,82,'MHVSMSTAFFONE, CAROL',1,1431,'MHVJEROMEAAA, TESTAAA',to_date('07-NOV-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6422,20,to_date('21-JAN-09','DD-MON-RR'),2796,null,6417,2796,3,1,to_date('07-NOV-08','DD-MON-RR'),to_date('13-NOV-08','DD-MON-RR'),to_date('13-NOV-08','DD-MON-RR'),to_date('07-NOV-08','DD-MON-RR'),1,1431,'MHVJEROMEAAA, TESTAAA',3,979,'SLC10',to_date('07-NOV-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6432,0,null,null,null,6431,null,0,1,to_date('07-NOV-08','DD-MON-RR'),to_date('13-NOV-08','DD-MON-RR'),to_date('13-NOV-08','DD-MON-RR'),to_date('07-NOV-08','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('07-NOV-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6450,0,null,null,null,4503,null,0,1,to_date('10-NOV-08','DD-MON-RR'),to_date('10-NOV-08','DD-MON-RR'),null,to_date('10-NOV-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,71,'MHVSMFOURTEEN, RINGO',to_date('10-NOV-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4720,0,null,null,null,4719,null,0,1,to_date('14-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),1,63,'MHVSMTEN, EDNA',3,979,'SLC10',to_date('14-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4729,0,null,null,null,4728,null,0,1,to_date('14-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),1,63,'MHVSMTEN, EDNA',3,979,'SLC10',to_date('14-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4738,20,to_date('10-NOV-08','DD-MON-RR'),2796,null,4737,2796,2,1,to_date('14-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),1,63,'MHVSMTEN, EDNA',3,979,'SLC10',to_date('14-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4765,0,null,null,null,4764,null,0,1,to_date('14-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),1,63,'MHVSMTEN, EDNA',3,979,'SLC10',to_date('14-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4774,0,null,null,null,4773,null,0,1,to_date('14-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),1,63,'MHVSMTEN, EDNA',3,979,'SLC10',to_date('14-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4783,0,null,null,null,4782,null,0,1,to_date('14-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),1,63,'MHVSMTEN, EDNA',3,979,'SLC10',to_date('14-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4792,0,null,null,null,4791,null,0,1,to_date('14-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),1,63,'MHVSMTEN, EDNA',3,979,'SLC10',to_date('14-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4801,0,null,null,null,4800,null,0,1,to_date('14-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),1,63,'MHVSMTEN, EDNA',3,979,'SLC10',to_date('14-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4810,0,null,null,null,4809,null,0,1,to_date('14-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),1,63,'MHVSMTEN, EDNA',3,979,'SLC10',to_date('14-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4819,0,null,null,null,4818,null,0,1,to_date('14-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),1,63,'MHVSMTEN, EDNA',3,979,'SLC10',to_date('14-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (4747,0,null,null,null,4746,null,0,1,to_date('14-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),to_date('14-AUG-08','DD-MON-RR'),1,63,'MHVSMTEN, EDNA',3,979,'SLC10',to_date('14-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8527,0,null,null,null,8526,null,1,1,to_date('05-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),to_date('05-MAR-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,989,'Dayton 29',to_date('05-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8539,0,null,null,null,8538,null,0,1,to_date('05-MAR-09','DD-MON-RR'),to_date('05-MAR-09','DD-MON-RR'),null,to_date('05-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',1,73,'MHVSMFIFTEEN, YOKO',to_date('05-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8544,0,null,null,null,8543,null,0,1,to_date('05-MAR-09','DD-MON-RR'),to_date('05-MAR-09','DD-MON-RR'),null,to_date('05-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',1,73,'MHVSMFIFTEEN, YOKO',to_date('05-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8549,0,null,null,null,8548,null,0,1,to_date('05-MAR-09','DD-MON-RR'),to_date('05-MAR-09','DD-MON-RR'),null,to_date('05-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',1,73,'MHVSMFIFTEEN, YOKO',to_date('05-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7565,0,null,null,null,1969,null,0,1,to_date('20-FEB-09','DD-MON-RR'),to_date('20-FEB-09','DD-MON-RR'),null,to_date('20-FEB-09','DD-MON-RR'),2,1150,'Prematta,        ',2,1152,'Searcy, Donita',to_date('20-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7571,20,to_date('04-MAR-09','DD-MON-RR'),2796,null,7570,2796,2,1,to_date('20-FEB-09','DD-MON-RR'),to_date('20-FEB-09','DD-MON-RR'),null,to_date('20-FEB-09','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('20-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7584,0,null,1156,null,5171,null,2,1,to_date('20-FEB-09','DD-MON-RR'),to_date('07-MAR-09','DD-MON-RR'),to_date('07-MAR-09','DD-MON-RR'),to_date('20-FEB-09','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('20-FEB-09','DD-MON-RR'),to_date('07-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7596,0,null,null,null,7595,null,0,1,to_date('20-FEB-09','DD-MON-RR'),to_date('20-FEB-09','DD-MON-RR'),null,to_date('20-FEB-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7600,0,null,null,null,7599,null,0,1,to_date('20-FEB-09','DD-MON-RR'),to_date('20-FEB-09','DD-MON-RR'),null,to_date('20-FEB-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7603,0,null,null,null,7602,null,0,1,to_date('20-FEB-09','DD-MON-RR'),to_date('20-FEB-09','DD-MON-RR'),null,to_date('20-FEB-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7817,0,null,null,null,7816,null,0,1,to_date('26-FEB-09','DD-MON-RR'),to_date('26-FEB-09','DD-MON-RR'),null,to_date('26-FEB-09','DD-MON-RR'),2,1152,'Searcy, Donita',1,71,'MHVSMFOURTEEN, RINGO',to_date('26-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7822,0,null,null,null,7816,null,1,1,to_date('26-FEB-09','DD-MON-RR'),to_date('07-MAR-09','DD-MON-RR'),to_date('07-MAR-09','DD-MON-RR'),to_date('26-FEB-09','DD-MON-RR'),1,71,'MHVSMFOURTEEN, RINGO',3,3336,'Joe''s Systest group',to_date('26-FEB-09','DD-MON-RR'),to_date('07-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7842,0,null,null,null,6038,null,0,1,to_date('26-FEB-09','DD-MON-RR'),to_date('26-FEB-09','DD-MON-RR'),null,to_date('26-FEB-09','DD-MON-RR'),2,1152,'Searcy, Donita',1,53,'MHVSMFIVE, EMMA',to_date('26-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7867,0,null,null,null,7481,null,0,1,to_date('27-FEB-09','DD-MON-RR'),to_date('27-FEB-09','DD-MON-RR'),null,to_date('27-FEB-09','DD-MON-RR'),2,1156,'Kola, Jerome',2,2796,'Balasubramanian, Swetha',to_date('27-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7876,0,null,null,null,5171,null,0,1,to_date('27-FEB-09','DD-MON-RR'),to_date('27-FEB-09','DD-MON-RR'),null,to_date('27-FEB-09','DD-MON-RR'),2,1156,'Kola, Jerome',1,61,'MHVSMNINE, MABEL',to_date('27-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7881,0,null,null,null,7880,null,1,1,to_date('27-FEB-09','DD-MON-RR'),to_date('07-MAR-09','DD-MON-RR'),to_date('07-MAR-09','DD-MON-RR'),to_date('27-FEB-09','DD-MON-RR'),1,5938,'mhvjeromeccc, Test',3,6086,'Test Triage Group - 8.2.1B',to_date('27-FEB-09','DD-MON-RR'),to_date('07-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7888,0,null,null,null,7887,null,1,1,to_date('27-FEB-09','DD-MON-RR'),to_date('07-MAR-09','DD-MON-RR'),to_date('07-MAR-09','DD-MON-RR'),to_date('27-FEB-09','DD-MON-RR'),1,5938,'mhvjeromeccc, Test',3,6086,'Test Triage Group - 8.2.1B',to_date('27-FEB-09','DD-MON-RR'),to_date('07-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7895,0,null,null,null,7894,null,1,1,to_date('27-FEB-09','DD-MON-RR'),to_date('07-MAR-09','DD-MON-RR'),to_date('07-MAR-09','DD-MON-RR'),to_date('27-FEB-09','DD-MON-RR'),1,5938,'mhvjeromeccc, Test',3,6086,'Test Triage Group - 8.2.1B',to_date('27-FEB-09','DD-MON-RR'),to_date('07-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6666,0,null,null,null,6625,null,0,1,to_date('18-NOV-08','DD-MON-RR'),to_date('18-NOV-08','DD-MON-RR'),null,to_date('18-NOV-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,57,'MHVSMSEVEN, BERTHA',to_date('18-NOV-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6672,20,to_date('11-FEB-09','DD-MON-RR'),2796,null,6625,83,3,1,to_date('18-NOV-08','DD-MON-RR'),to_date('22-NOV-08','DD-MON-RR'),to_date('22-NOV-08','DD-MON-RR'),to_date('18-NOV-08','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('18-NOV-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6683,0,null,null,null,6682,null,0,1,to_date('19-NOV-08','DD-MON-RR'),to_date('19-NOV-08','DD-MON-RR'),null,to_date('19-NOV-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,57,'MHVSMSEVEN, BERTHA',to_date('19-NOV-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6688,20,to_date('11-FEB-09','DD-MON-RR'),2796,null,6682,83,4,1,to_date('19-NOV-08','DD-MON-RR'),to_date('25-NOV-08','DD-MON-RR'),to_date('25-NOV-08','DD-MON-RR'),to_date('19-NOV-08','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('19-NOV-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6716,0,null,null,null,6682,null,0,1,to_date('08-DEC-08','DD-MON-RR'),to_date('08-DEC-08','DD-MON-RR'),null,to_date('08-DEC-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,57,'MHVSMSEVEN, BERTHA',to_date('08-DEC-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6721,0,null,null,null,6682,null,0,1,to_date('08-DEC-08','DD-MON-RR'),to_date('08-DEC-08','DD-MON-RR'),null,to_date('08-DEC-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,57,'MHVSMSEVEN, BERTHA',to_date('08-DEC-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7606,0,null,null,null,7605,null,0,1,to_date('20-FEB-09','DD-MON-RR'),to_date('20-FEB-09','DD-MON-RR'),null,to_date('20-FEB-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7610,0,null,null,null,7609,null,0,1,to_date('20-FEB-09','DD-MON-RR'),to_date('20-FEB-09','DD-MON-RR'),null,to_date('20-FEB-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7614,0,null,null,null,7613,null,0,1,to_date('20-FEB-09','DD-MON-RR'),to_date('20-FEB-09','DD-MON-RR'),null,to_date('20-FEB-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7618,0,null,null,null,7617,null,0,1,to_date('20-FEB-09','DD-MON-RR'),to_date('20-FEB-09','DD-MON-RR'),null,to_date('20-FEB-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7622,0,null,null,null,7621,null,0,1,to_date('20-FEB-09','DD-MON-RR'),to_date('20-FEB-09','DD-MON-RR'),null,to_date('20-FEB-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7628,0,null,null,null,7627,null,0,1,to_date('20-FEB-09','DD-MON-RR'),to_date('20-FEB-09','DD-MON-RR'),null,to_date('20-FEB-09','DD-MON-RR'),2,81,'MHVSMDOCFIVE, SAM',3,979,'SLC10',to_date('20-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7631,0,null,null,null,7630,null,0,1,to_date('20-FEB-09','DD-MON-RR'),to_date('20-FEB-09','DD-MON-RR'),null,to_date('20-FEB-09','DD-MON-RR'),2,81,'MHVSMDOCFIVE, SAM',3,979,'SLC10',to_date('20-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7633,0,null,null,null,7632,null,0,1,to_date('20-FEB-09','DD-MON-RR'),to_date('20-FEB-09','DD-MON-RR'),null,to_date('20-FEB-09','DD-MON-RR'),2,81,'MHVSMDOCFIVE, SAM',3,979,'SLC10',to_date('20-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7636,0,null,null,null,7635,null,0,1,to_date('20-FEB-09','DD-MON-RR'),to_date('20-FEB-09','DD-MON-RR'),null,to_date('20-FEB-09','DD-MON-RR'),2,81,'MHVSMDOCFIVE, SAM',3,979,'SLC10',to_date('20-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7639,0,null,null,null,7638,null,0,1,to_date('20-FEB-09','DD-MON-RR'),to_date('20-FEB-09','DD-MON-RR'),null,to_date('20-FEB-09','DD-MON-RR'),2,81,'MHVSMDOCFIVE, SAM',3,979,'SLC10',to_date('20-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7642,0,null,null,null,7641,null,0,1,to_date('20-FEB-09','DD-MON-RR'),to_date('20-FEB-09','DD-MON-RR'),null,to_date('20-FEB-09','DD-MON-RR'),2,81,'MHVSMDOCFIVE, SAM',3,979,'SLC10',to_date('20-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7645,0,null,null,null,7644,null,0,1,to_date('20-FEB-09','DD-MON-RR'),to_date('20-FEB-09','DD-MON-RR'),null,to_date('20-FEB-09','DD-MON-RR'),2,81,'MHVSMDOCFIVE, SAM',3,979,'SLC10',to_date('20-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7648,0,null,null,null,7647,null,0,1,to_date('20-FEB-09','DD-MON-RR'),to_date('20-FEB-09','DD-MON-RR'),null,to_date('20-FEB-09','DD-MON-RR'),2,81,'MHVSMDOCFIVE, SAM',3,979,'SLC10',to_date('20-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7653,0,null,null,null,7652,null,0,1,to_date('20-FEB-09','DD-MON-RR'),to_date('20-FEB-09','DD-MON-RR'),null,to_date('20-FEB-09','DD-MON-RR'),2,81,'MHVSMDOCFIVE, SAM',2,2796,'Balasubramanian, Swetha',to_date('20-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7658,0,null,null,null,7657,null,0,1,to_date('20-FEB-09','DD-MON-RR'),to_date('20-FEB-09','DD-MON-RR'),null,to_date('20-FEB-09','DD-MON-RR'),2,1156,'Kola, Jerome',2,2796,'Balasubramanian, Swetha',to_date('20-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7663,0,null,null,null,7662,null,0,1,to_date('20-FEB-09','DD-MON-RR'),to_date('20-FEB-09','DD-MON-RR'),null,to_date('20-FEB-09','DD-MON-RR'),2,1156,'Kola, Jerome',3,979,'SLC10',to_date('20-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7667,0,null,null,null,7666,null,0,1,to_date('20-FEB-09','DD-MON-RR'),to_date('20-FEB-09','DD-MON-RR'),null,to_date('20-FEB-09','DD-MON-RR'),2,1156,'Kola, Jerome',3,979,'SLC10',to_date('20-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7670,0,null,null,null,7669,null,0,1,to_date('20-FEB-09','DD-MON-RR'),to_date('20-FEB-09','DD-MON-RR'),null,to_date('20-FEB-09','DD-MON-RR'),2,1156,'Kola, Jerome',3,979,'SLC10',to_date('20-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7673,0,null,null,null,7672,null,0,1,to_date('20-FEB-09','DD-MON-RR'),to_date('20-FEB-09','DD-MON-RR'),null,to_date('20-FEB-09','DD-MON-RR'),2,1156,'Kola, Jerome',3,979,'SLC10',to_date('20-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7677,0,null,null,null,7676,null,0,1,to_date('20-FEB-09','DD-MON-RR'),to_date('20-FEB-09','DD-MON-RR'),null,to_date('20-FEB-09','DD-MON-RR'),2,1156,'Kola, Jerome',3,979,'SLC10',to_date('20-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7681,0,null,null,null,7680,null,0,1,to_date('20-FEB-09','DD-MON-RR'),to_date('20-FEB-09','DD-MON-RR'),null,to_date('20-FEB-09','DD-MON-RR'),2,1156,'Kola, Jerome',3,979,'SLC10',to_date('20-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7685,0,null,2796,null,7684,null,1,1,to_date('20-FEB-09','DD-MON-RR'),to_date('20-FEB-09','DD-MON-RR'),null,to_date('20-FEB-09','DD-MON-RR'),2,1156,'Kola, Jerome',3,979,'SLC10',to_date('20-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7689,0,null,null,null,7688,null,0,1,to_date('20-FEB-09','DD-MON-RR'),to_date('20-FEB-09','DD-MON-RR'),null,to_date('20-FEB-09','DD-MON-RR'),2,1156,'Kola, Jerome',3,979,'SLC10',to_date('20-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (13870,0,null,null,null,13869,null,0,1,to_date('27-APR-09','DD-MON-RR'),to_date('27-APR-09','DD-MON-RR'),null,to_date('27-APR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,57,'MHVSMSEVEN, BERTHA',to_date('27-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7705,0,null,null,null,7704,null,0,1,to_date('20-FEB-09','DD-MON-RR'),to_date('20-FEB-09','DD-MON-RR'),null,to_date('20-FEB-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,71,'MHVSMFOURTEEN, RINGO',to_date('20-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7710,0,null,null,null,7704,null,1,1,to_date('20-FEB-09','DD-MON-RR'),to_date('07-MAR-09','DD-MON-RR'),to_date('07-MAR-09','DD-MON-RR'),to_date('20-FEB-09','DD-MON-RR'),1,71,'MHVSMFOURTEEN, RINGO',3,979,'SLC10',to_date('20-FEB-09','DD-MON-RR'),to_date('07-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7735,0,null,null,null,7418,null,0,1,to_date('23-FEB-09','DD-MON-RR'),to_date('23-FEB-09','DD-MON-RR'),null,to_date('23-FEB-09','DD-MON-RR'),2,1150,'Prematta,        ',1,51,'MHVSMFOUR, OLIVIA',to_date('23-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7744,0,null,null,null,7743,null,1,1,to_date('26-FEB-09','DD-MON-RR'),to_date('07-MAR-09','DD-MON-RR'),to_date('07-MAR-09','DD-MON-RR'),to_date('26-FEB-09','DD-MON-RR'),1,71,'MHVSMFOURTEEN, RINGO',3,989,'Dayton 29',to_date('26-FEB-09','DD-MON-RR'),to_date('07-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7754,0,null,null,null,7753,null,1,1,to_date('26-FEB-09','DD-MON-RR'),to_date('07-MAR-09','DD-MON-RR'),to_date('07-MAR-09','DD-MON-RR'),to_date('26-FEB-09','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('26-FEB-09','DD-MON-RR'),to_date('07-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7765,20,to_date('26-FEB-09','DD-MON-RR'),1152,null,7336,1152,3,1,to_date('26-FEB-09','DD-MON-RR'),to_date('26-FEB-09','DD-MON-RR'),null,to_date('26-FEB-09','DD-MON-RR'),2,1152,'Searcy, Donita',1,73,'MHVSMFIFTEEN, YOKO',to_date('26-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7776,0,null,1152,null,7336,null,1,1,to_date('26-FEB-09','DD-MON-RR'),to_date('26-FEB-09','DD-MON-RR'),null,to_date('26-FEB-09','DD-MON-RR'),2,1152,'Searcy, Donita',2,1152,'Searcy, Donita',to_date('26-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (13875,10,null,2796,null,13089,2796,2,1,to_date('27-APR-09','DD-MON-RR'),to_date('27-APR-09','DD-MON-RR'),null,to_date('27-APR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',2,6705,'GOPARAJU, BHANU',to_date('27-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7782,0,null,1152,null,7336,null,1,1,to_date('26-FEB-09','DD-MON-RR'),to_date('26-FEB-09','DD-MON-RR'),null,to_date('26-FEB-09','DD-MON-RR'),2,1152,'Searcy, Donita',2,1152,'Searcy, Donita',to_date('26-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7787,0,null,null,null,7336,null,0,1,to_date('26-FEB-09','DD-MON-RR'),to_date('26-FEB-09','DD-MON-RR'),null,to_date('26-FEB-09','DD-MON-RR'),2,1152,'Searcy, Donita',2,1152,'Searcy, Donita',to_date('26-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7795,0,null,null,null,7794,null,0,1,to_date('26-FEB-09','DD-MON-RR'),to_date('26-FEB-09','DD-MON-RR'),null,to_date('26-FEB-09','DD-MON-RR'),2,1152,'Searcy, Donita',1,55,'mhvsmsix, Alice',to_date('26-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7802,0,null,null,null,1838,null,0,1,to_date('26-FEB-09','DD-MON-RR'),to_date('26-FEB-09','DD-MON-RR'),null,to_date('26-FEB-09','DD-MON-RR'),2,1152,'Searcy, Donita',2,1150,'Prematta,        ',to_date('26-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7832,0,null,null,null,1872,null,0,1,to_date('26-FEB-09','DD-MON-RR'),to_date('26-FEB-09','DD-MON-RR'),null,to_date('26-FEB-09','DD-MON-RR'),2,1152,'Searcy, Donita',2,1150,'Prematta,        ',to_date('26-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6726,0,null,null,null,6625,null,0,1,to_date('08-DEC-08','DD-MON-RR'),to_date('08-DEC-08','DD-MON-RR'),null,to_date('08-DEC-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,57,'MHVSMSEVEN, BERTHA',to_date('08-DEC-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6733,0,null,null,null,6615,null,0,1,to_date('08-DEC-08','DD-MON-RR'),to_date('08-DEC-08','DD-MON-RR'),null,to_date('08-DEC-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,57,'MHVSMSEVEN, BERTHA',to_date('08-DEC-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6744,0,null,null,null,6583,null,0,1,to_date('08-DEC-08','DD-MON-RR'),to_date('08-DEC-08','DD-MON-RR'),null,to_date('08-DEC-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,57,'MHVSMSEVEN, BERTHA',to_date('08-DEC-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6749,0,null,null,null,6595,null,0,1,to_date('08-DEC-08','DD-MON-RR'),to_date('08-DEC-08','DD-MON-RR'),null,to_date('08-DEC-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,57,'MHVSMSEVEN, BERTHA',to_date('08-DEC-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6754,0,null,null,null,6595,null,0,1,to_date('08-DEC-08','DD-MON-RR'),to_date('08-DEC-08','DD-MON-RR'),null,to_date('08-DEC-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,57,'MHVSMSEVEN, BERTHA',to_date('08-DEC-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6759,0,null,null,null,6595,null,0,1,to_date('08-DEC-08','DD-MON-RR'),to_date('08-DEC-08','DD-MON-RR'),null,to_date('08-DEC-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,57,'MHVSMSEVEN, BERTHA',to_date('08-DEC-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6767,0,null,null,null,6583,null,0,1,to_date('09-DEC-08','DD-MON-RR'),to_date('09-DEC-08','DD-MON-RR'),null,to_date('09-DEC-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,57,'MHVSMSEVEN, BERTHA',to_date('09-DEC-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6773,0,null,null,null,6625,null,0,1,to_date('09-DEC-08','DD-MON-RR'),to_date('09-DEC-08','DD-MON-RR'),null,to_date('09-DEC-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,57,'MHVSMSEVEN, BERTHA',to_date('09-DEC-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6787,10,null,1152,null,6786,1150,3,1,to_date('11-DEC-08','DD-MON-RR'),to_date('17-DEC-08','DD-MON-RR'),to_date('17-DEC-08','DD-MON-RR'),to_date('11-DEC-08','DD-MON-RR'),1,71,'MHVSMFOURTEEN, RINGO',3,4891,'Clinic (DAYT29)',to_date('11-DEC-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6797,0,null,76,null,6796,null,2,1,to_date('11-DEC-08','DD-MON-RR'),to_date('17-DEC-08','DD-MON-RR'),to_date('17-DEC-08','DD-MON-RR'),to_date('11-DEC-08','DD-MON-RR'),1,71,'MHVSMFOURTEEN, RINGO',3,989,'Dayton 29',to_date('11-DEC-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6807,0,null,null,null,6796,null,0,1,to_date('11-DEC-08','DD-MON-RR'),to_date('11-DEC-08','DD-MON-RR'),null,to_date('11-DEC-08','DD-MON-RR'),2,1152,'Searcy, Donita',1,71,'MHVSMFOURTEEN, RINGO',to_date('11-DEC-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6815,0,null,null,null,6786,null,0,1,to_date('12-DEC-08','DD-MON-RR'),to_date('12-DEC-08','DD-MON-RR'),null,to_date('12-DEC-08','DD-MON-RR'),2,1152,'Searcy, Donita',1,71,'MHVSMFOURTEEN, RINGO',to_date('12-DEC-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6820,0,null,null,null,6786,null,0,1,to_date('12-DEC-08','DD-MON-RR'),to_date('12-DEC-08','DD-MON-RR'),null,to_date('12-DEC-08','DD-MON-RR'),2,1152,'Searcy, Donita',1,71,'MHVSMFOURTEEN, RINGO',to_date('12-DEC-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6853,0,null,null,null,1527,null,0,1,to_date('22-DEC-08','DD-MON-RR'),to_date('22-DEC-08','DD-MON-RR'),null,to_date('22-DEC-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,1431,'MHVJEROMEAAA, TESTAAA',to_date('22-DEC-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6861,0,null,null,null,6028,null,0,1,to_date('29-DEC-08','DD-MON-RR'),to_date('29-DEC-08','DD-MON-RR'),null,to_date('29-DEC-08','DD-MON-RR'),2,1150,'Prematta,        ',1,53,'MHVSMFIVE, EMMA',to_date('29-DEC-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6867,0,null,1150,null,6866,null,1,1,to_date('29-DEC-08','DD-MON-RR'),to_date('02-JAN-09','DD-MON-RR'),to_date('02-JAN-09','DD-MON-RR'),to_date('29-DEC-08','DD-MON-RR'),1,51,'MHVSMFOUR, OLIVIA',3,989,'Dayton 29',to_date('29-DEC-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6878,0,null,null,null,6595,null,0,1,to_date('02-JAN-09','DD-MON-RR'),to_date('02-JAN-09','DD-MON-RR'),null,to_date('02-JAN-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,57,'MHVSMSEVEN, BERTHA',to_date('02-JAN-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6883,0,null,null,null,6595,null,0,1,to_date('02-JAN-09','DD-MON-RR'),to_date('02-JAN-09','DD-MON-RR'),null,to_date('02-JAN-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,57,'MHVSMSEVEN, BERTHA',to_date('02-JAN-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6889,0,null,null,null,6682,null,0,1,to_date('02-JAN-09','DD-MON-RR'),to_date('02-JAN-09','DD-MON-RR'),null,to_date('02-JAN-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,57,'MHVSMSEVEN, BERTHA',to_date('02-JAN-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6898,0,null,null,null,6866,null,0,1,to_date('09-JAN-09','DD-MON-RR'),to_date('09-JAN-09','DD-MON-RR'),null,to_date('09-JAN-09','DD-MON-RR'),2,1150,'Prematta,        ',1,51,'MHVSMFOUR, OLIVIA',to_date('09-JAN-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6906,0,null,1150,null,6866,null,2,1,to_date('09-JAN-09','DD-MON-RR'),to_date('15-JAN-09','DD-MON-RR'),to_date('15-JAN-09','DD-MON-RR'),to_date('09-JAN-09','DD-MON-RR'),1,51,'MHVSMFOUR, OLIVIA',3,989,'Dayton 29',to_date('09-JAN-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6916,0,null,null,null,6866,null,0,1,to_date('09-JAN-09','DD-MON-RR'),to_date('09-JAN-09','DD-MON-RR'),null,to_date('09-JAN-09','DD-MON-RR'),2,1150,'Prematta,        ',1,51,'MHVSMFOUR, OLIVIA',to_date('09-JAN-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6922,0,null,1150,null,6921,null,1,1,to_date('09-JAN-09','DD-MON-RR'),to_date('15-JAN-09','DD-MON-RR'),to_date('15-JAN-09','DD-MON-RR'),to_date('09-JAN-09','DD-MON-RR'),1,49,'MHVSMTHREE, CHLOE',3,4151,'test for relationship 1',to_date('09-JAN-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6929,0,null,null,null,6921,null,0,1,to_date('09-JAN-09','DD-MON-RR'),to_date('09-JAN-09','DD-MON-RR'),null,to_date('09-JAN-09','DD-MON-RR'),2,1150,'Prematta,        ',1,49,'MHVSMTHREE, CHLOE',to_date('09-JAN-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6937,20,to_date('20-FEB-09','DD-MON-RR'),1150,null,6028,1150,3,1,to_date('09-JAN-09','DD-MON-RR'),to_date('15-JAN-09','DD-MON-RR'),to_date('15-JAN-09','DD-MON-RR'),to_date('09-JAN-09','DD-MON-RR'),1,53,'MHVSMFIVE, EMMA',3,4914,'OE/RR (DAYT29)',to_date('09-JAN-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6947,0,null,null,null,6028,null,0,1,to_date('09-JAN-09','DD-MON-RR'),to_date('09-JAN-09','DD-MON-RR'),null,to_date('09-JAN-09','DD-MON-RR'),2,1150,'Prematta,        ',1,53,'MHVSMFIVE, EMMA',to_date('09-JAN-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6957,0,null,null,null,6866,null,0,1,to_date('09-JAN-09','DD-MON-RR'),to_date('09-JAN-09','DD-MON-RR'),null,to_date('09-JAN-09','DD-MON-RR'),2,1150,'Prematta,        ',1,51,'MHVSMFOUR, OLIVIA',to_date('09-JAN-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (6994,0,null,null,null,6595,null,0,1,to_date('16-JAN-09','DD-MON-RR'),to_date('16-JAN-09','DD-MON-RR'),null,to_date('16-JAN-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,57,'MHVSMSEVEN, BERTHA',to_date('16-JAN-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7026,0,null,null,null,6417,null,0,1,to_date('21-JAN-09','DD-MON-RR'),to_date('21-JAN-09','DD-MON-RR'),null,to_date('21-JAN-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,1431,'MHVJEROMEAAA, TESTAAA',to_date('21-JAN-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10286,0,null,null,null,10285,null,0,1,to_date('20-MAR-09','DD-MON-RR'),to_date('20-MAR-09','DD-MON-RR'),null,to_date('20-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10290,0,null,null,null,10289,null,0,1,to_date('20-MAR-09','DD-MON-RR'),to_date('20-MAR-09','DD-MON-RR'),null,to_date('20-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10294,0,null,null,null,10293,null,0,1,to_date('20-MAR-09','DD-MON-RR'),to_date('20-MAR-09','DD-MON-RR'),null,to_date('20-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10301,0,null,null,null,10300,null,0,1,to_date('20-MAR-09','DD-MON-RR'),to_date('20-MAR-09','DD-MON-RR'),null,to_date('20-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10305,0,null,null,null,10304,null,0,1,to_date('20-MAR-09','DD-MON-RR'),to_date('20-MAR-09','DD-MON-RR'),null,to_date('20-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10308,0,null,null,null,10307,null,0,1,to_date('20-MAR-09','DD-MON-RR'),to_date('20-MAR-09','DD-MON-RR'),null,to_date('20-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10311,0,null,null,null,10310,null,0,1,to_date('20-MAR-09','DD-MON-RR'),to_date('20-MAR-09','DD-MON-RR'),null,to_date('20-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7119,0,null,null,null,7118,null,0,1,to_date('02-FEB-09','DD-MON-RR'),to_date('02-FEB-09','DD-MON-RR'),null,to_date('02-FEB-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('02-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7123,0,null,null,null,7122,null,0,1,to_date('02-FEB-09','DD-MON-RR'),to_date('02-FEB-09','DD-MON-RR'),null,to_date('02-FEB-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('02-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7134,0,null,null,null,7133,null,0,1,to_date('04-FEB-09','DD-MON-RR'),to_date('10-FEB-09','DD-MON-RR'),to_date('10-FEB-09','DD-MON-RR'),to_date('04-FEB-09','DD-MON-RR'),1,6482,'mhvjeromebbb, Test',3,989,'Dayton 29',to_date('04-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7144,0,null,null,null,7143,null,0,1,to_date('04-FEB-09','DD-MON-RR'),to_date('04-FEB-09','DD-MON-RR'),null,to_date('04-FEB-09','DD-MON-RR'),2,24,'MHVSMDOCONE, MIKE',1,6482,'mhvjeromebbb, Test',to_date('04-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7151,20,to_date('04-FEB-09','DD-MON-RR'),null,null,7143,24,1,1,to_date('04-FEB-09','DD-MON-RR'),to_date('04-FEB-09','DD-MON-RR'),null,to_date('04-FEB-09','DD-MON-RR'),1,6482,'mhvjeromebbb, Test',3,989,'Dayton 29',to_date('04-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7167,0,null,null,null,7166,null,0,1,to_date('05-FEB-09','DD-MON-RR'),to_date('05-FEB-09','DD-MON-RR'),null,to_date('05-FEB-09','DD-MON-RR'),2,1150,'Prematta,        ',1,51,'MHVSMFOUR, OLIVIA',to_date('05-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7172,0,null,1152,null,7166,null,1,1,to_date('05-FEB-09','DD-MON-RR'),to_date('11-FEB-09','DD-MON-RR'),to_date('11-FEB-09','DD-MON-RR'),to_date('05-FEB-09','DD-MON-RR'),1,51,'MHVSMFOUR, OLIVIA',3,3336,'Joe''s Systest group',to_date('05-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7208,0,null,null,null,7207,null,0,1,to_date('10-FEB-09','DD-MON-RR'),to_date('14-FEB-09','DD-MON-RR'),to_date('14-FEB-09','DD-MON-RR'),to_date('10-FEB-09','DD-MON-RR'),1,5938,'mhvjeromeccc, Test',3,6086,'Test Triage Group - 8.2.1B',to_date('10-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7220,0,null,null,null,7219,null,0,1,to_date('10-FEB-09','DD-MON-RR'),to_date('14-FEB-09','DD-MON-RR'),to_date('14-FEB-09','DD-MON-RR'),to_date('10-FEB-09','DD-MON-RR'),1,5938,'mhvjeromeccc, Test',3,6086,'Test Triage Group - 8.2.1B',to_date('10-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7227,0,null,80,null,7226,null,1,1,to_date('10-FEB-09','DD-MON-RR'),to_date('14-FEB-09','DD-MON-RR'),to_date('14-FEB-09','DD-MON-RR'),to_date('10-FEB-09','DD-MON-RR'),1,5938,'mhvjeromeccc, Test',3,6086,'Test Triage Group - 8.2.1B',to_date('10-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7235,0,null,null,null,7226,null,0,1,to_date('10-FEB-09','DD-MON-RR'),to_date('10-FEB-09','DD-MON-RR'),null,to_date('10-FEB-09','DD-MON-RR'),2,80,'MHVSMDOCFOUR, BOBBIE',1,5938,'mhvjeromeccc, Test',to_date('10-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7242,0,null,null,null,7241,null,0,1,to_date('10-FEB-09','DD-MON-RR'),to_date('10-FEB-09','DD-MON-RR'),null,to_date('10-FEB-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,71,'MHVSMFOURTEEN, RINGO',to_date('10-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7247,20,to_date('10-FEB-09','DD-MON-RR'),2796,null,7241,2796,2,1,to_date('10-FEB-09','DD-MON-RR'),to_date('10-FEB-09','DD-MON-RR'),null,to_date('10-FEB-09','DD-MON-RR'),1,71,'MHVSMFOURTEEN, RINGO',3,979,'SLC10',to_date('10-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7258,0,null,null,null,7257,null,0,1,to_date('10-FEB-09','DD-MON-RR'),to_date('10-FEB-09','DD-MON-RR'),null,to_date('10-FEB-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,71,'MHVSMFOURTEEN, RINGO',to_date('10-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7265,20,to_date('11-FEB-09','DD-MON-RR'),null,null,7257,83,1,1,to_date('10-FEB-09','DD-MON-RR'),to_date('10-FEB-09','DD-MON-RR'),null,to_date('10-FEB-09','DD-MON-RR'),1,71,'MHVSMFOURTEEN, RINGO',3,979,'SLC10',to_date('10-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7292,0,null,null,null,4737,null,0,1,to_date('10-FEB-09','DD-MON-RR'),to_date('10-FEB-09','DD-MON-RR'),null,to_date('10-FEB-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',2,2796,'Balasubramanian, Swetha',to_date('10-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7297,0,null,null,null,5171,null,0,1,to_date('10-FEB-09','DD-MON-RR'),to_date('10-FEB-09','DD-MON-RR'),null,to_date('10-FEB-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',2,2796,'Balasubramanian, Swetha',to_date('10-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7300,0,null,null,null,5171,null,0,1,to_date('10-FEB-09','DD-MON-RR'),to_date('10-FEB-09','DD-MON-RR'),null,to_date('10-FEB-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',2,2796,'Balasubramanian, Swetha',to_date('10-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7337,20,to_date('26-FEB-09','DD-MON-RR'),1152,null,7336,1152,2,1,to_date('11-FEB-09','DD-MON-RR'),to_date('17-FEB-09','DD-MON-RR'),to_date('17-FEB-09','DD-MON-RR'),to_date('11-FEB-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,989,'Dayton 29',to_date('11-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7365,0,null,null,null,7364,null,0,1,to_date('13-FEB-09','DD-MON-RR'),to_date('19-FEB-09','DD-MON-RR'),to_date('19-FEB-09','DD-MON-RR'),to_date('13-FEB-09','DD-MON-RR'),1,51,'MHVSMFOUR, OLIVIA',3,989,'Dayton 29',to_date('13-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7412,0,null,null,null,7411,null,1,1,to_date('19-FEB-09','DD-MON-RR'),to_date('07-MAR-09','DD-MON-RR'),to_date('07-MAR-09','DD-MON-RR'),to_date('19-FEB-09','DD-MON-RR'),1,51,'MHVSMFOUR, OLIVIA',3,4151,'test for relationship 1',to_date('19-FEB-09','DD-MON-RR'),to_date('07-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7400,0,null,null,null,7399,null,0,1,to_date('18-FEB-09','DD-MON-RR'),to_date('18-FEB-09','DD-MON-RR'),null,null,1,71,'MHVSMFOURTEEN, RINGO',null,null,null,null,null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7419,0,null,1150,null,7418,null,2,1,to_date('19-FEB-09','DD-MON-RR'),to_date('07-MAR-09','DD-MON-RR'),to_date('07-MAR-09','DD-MON-RR'),to_date('19-FEB-09','DD-MON-RR'),1,51,'MHVSMFOUR, OLIVIA',3,989,'Dayton 29',to_date('19-FEB-09','DD-MON-RR'),to_date('07-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7429,0,null,null,null,7428,null,1,1,to_date('19-FEB-09','DD-MON-RR'),to_date('19-FEB-09','DD-MON-RR'),null,null,1,51,'MHVSMFOUR, OLIVIA',null,null,null,null,null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7469,0,null,1152,null,1872,null,1,1,to_date('20-FEB-09','DD-MON-RR'),to_date('20-FEB-09','DD-MON-RR'),null,to_date('20-FEB-09','DD-MON-RR'),2,1150,'Prematta,        ',2,1152,'Searcy, Donita',to_date('20-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7476,0,null,null,null,1562,null,0,1,to_date('20-FEB-09','DD-MON-RR'),to_date('20-FEB-09','DD-MON-RR'),null,to_date('20-FEB-09','DD-MON-RR'),2,1150,'Prematta,        ',2,1152,'Searcy, Donita',to_date('20-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7482,0,null,1156,null,7481,null,1,1,to_date('20-FEB-09','DD-MON-RR'),to_date('20-FEB-09','DD-MON-RR'),null,to_date('20-FEB-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',2,1156,'Kola, Jerome',to_date('20-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7488,20,to_date('26-FEB-09','DD-MON-RR'),1152,null,1838,1152,2,1,to_date('20-FEB-09','DD-MON-RR'),to_date('20-FEB-09','DD-MON-RR'),null,to_date('20-FEB-09','DD-MON-RR'),2,1150,'Prematta,        ',2,1152,'Searcy, Donita',to_date('20-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7497,0,null,null,null,3010,null,0,1,to_date('20-FEB-09','DD-MON-RR'),to_date('20-FEB-09','DD-MON-RR'),null,to_date('20-FEB-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',2,82,'MHVSMSTAFFONE, CAROL',to_date('20-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7505,0,null,null,null,2995,null,0,1,to_date('20-FEB-09','DD-MON-RR'),to_date('20-FEB-09','DD-MON-RR'),null,to_date('20-FEB-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',2,1156,'Kola, Jerome',to_date('20-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7519,0,null,null,null,7518,null,0,1,to_date('20-FEB-09','DD-MON-RR'),to_date('20-FEB-09','DD-MON-RR'),null,to_date('20-FEB-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7523,0,null,null,null,7522,null,0,1,to_date('20-FEB-09','DD-MON-RR'),to_date('20-FEB-09','DD-MON-RR'),null,to_date('20-FEB-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7526,0,null,null,null,7525,null,0,1,to_date('20-FEB-09','DD-MON-RR'),to_date('20-FEB-09','DD-MON-RR'),null,to_date('20-FEB-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7529,0,null,null,null,7528,null,0,1,to_date('20-FEB-09','DD-MON-RR'),to_date('20-FEB-09','DD-MON-RR'),null,to_date('20-FEB-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7533,0,null,null,null,7532,null,0,1,to_date('20-FEB-09','DD-MON-RR'),to_date('20-FEB-09','DD-MON-RR'),null,to_date('20-FEB-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7537,0,null,null,null,7536,null,0,1,to_date('20-FEB-09','DD-MON-RR'),to_date('20-FEB-09','DD-MON-RR'),null,to_date('20-FEB-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7541,0,null,null,null,7540,null,0,1,to_date('20-FEB-09','DD-MON-RR'),to_date('20-FEB-09','DD-MON-RR'),null,to_date('20-FEB-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7545,0,null,null,null,7544,null,0,1,to_date('20-FEB-09','DD-MON-RR'),to_date('20-FEB-09','DD-MON-RR'),null,to_date('20-FEB-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7902,0,null,null,null,6038,null,0,1,to_date('27-FEB-09','DD-MON-RR'),to_date('27-FEB-09','DD-MON-RR'),null,to_date('27-FEB-09','DD-MON-RR'),2,1150,'Prematta,        ',1,53,'MHVSMFIVE, EMMA',to_date('27-FEB-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7912,20,to_date('04-MAR-09','DD-MON-RR'),79,null,7911,79,2,1,to_date('04-MAR-09','DD-MON-RR'),to_date('04-MAR-09','DD-MON-RR'),null,to_date('04-MAR-09','DD-MON-RR'),1,49,'MHVSMTHREE, CHLOE',3,4151,'test for relationship 1',to_date('04-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7919,20,to_date('04-MAR-09','DD-MON-RR'),79,null,7918,79,3,1,to_date('04-MAR-09','DD-MON-RR'),to_date('04-MAR-09','DD-MON-RR'),null,to_date('04-MAR-09','DD-MON-RR'),1,49,'MHVSMTHREE, CHLOE',3,4151,'test for relationship 1',to_date('04-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7926,0,null,null,null,7918,null,0,1,to_date('04-MAR-09','DD-MON-RR'),to_date('04-MAR-09','DD-MON-RR'),null,to_date('04-MAR-09','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',1,49,'MHVSMTHREE, CHLOE',to_date('04-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7942,20,to_date('04-MAR-09','DD-MON-RR'),2796,null,5171,2796,2,1,to_date('04-MAR-09','DD-MON-RR'),to_date('04-MAR-09','DD-MON-RR'),null,to_date('04-MAR-09','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('04-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7954,0,null,1152,null,7953,null,2,1,to_date('04-MAR-09','DD-MON-RR'),to_date('10-MAR-09','DD-MON-RR'),to_date('10-MAR-09','DD-MON-RR'),to_date('04-MAR-09','DD-MON-RR'),1,51,'MHVSMFOUR, OLIVIA',3,989,'Dayton 29',to_date('04-MAR-09','DD-MON-RR'),to_date('10-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7964,20,to_date('04-MAR-09','DD-MON-RR'),2796,null,7963,2796,3,1,to_date('04-MAR-09','DD-MON-RR'),to_date('04-MAR-09','DD-MON-RR'),null,to_date('04-MAR-09','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('04-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7980,0,null,null,null,7963,null,0,1,to_date('04-MAR-09','DD-MON-RR'),to_date('04-MAR-09','DD-MON-RR'),null,to_date('04-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,57,'MHVSMSEVEN, BERTHA',to_date('04-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (7988,20,to_date('04-MAR-09','DD-MON-RR'),2796,null,7963,2796,3,1,to_date('04-MAR-09','DD-MON-RR'),to_date('04-MAR-09','DD-MON-RR'),null,to_date('04-MAR-09','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('04-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8005,0,null,null,null,8004,null,1,1,to_date('04-MAR-09','DD-MON-RR'),to_date('10-MAR-09','DD-MON-RR'),to_date('10-MAR-09','DD-MON-RR'),to_date('04-MAR-09','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('04-MAR-09','DD-MON-RR'),to_date('10-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8021,20,to_date('04-MAR-09','DD-MON-RR'),2796,null,8020,2796,3,1,to_date('04-MAR-09','DD-MON-RR'),to_date('04-MAR-09','DD-MON-RR'),null,to_date('04-MAR-09','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('04-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8032,0,null,null,null,8020,null,0,1,to_date('04-MAR-09','DD-MON-RR'),to_date('04-MAR-09','DD-MON-RR'),null,to_date('04-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,57,'MHVSMSEVEN, BERTHA',to_date('04-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8043,20,to_date('04-MAR-09','DD-MON-RR'),2796,null,8042,2796,3,1,to_date('04-MAR-09','DD-MON-RR'),to_date('04-MAR-09','DD-MON-RR'),null,to_date('04-MAR-09','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('04-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8054,0,null,null,null,8042,null,0,1,to_date('04-MAR-09','DD-MON-RR'),to_date('04-MAR-09','DD-MON-RR'),null,to_date('04-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,57,'MHVSMSEVEN, BERTHA',to_date('04-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8068,20,to_date('04-MAR-09','DD-MON-RR'),2796,null,8067,2796,3,1,to_date('04-MAR-09','DD-MON-RR'),to_date('04-MAR-09','DD-MON-RR'),null,to_date('04-MAR-09','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('04-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8081,0,null,null,null,8067,null,0,1,to_date('04-MAR-09','DD-MON-RR'),to_date('04-MAR-09','DD-MON-RR'),null,to_date('04-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,57,'MHVSMSEVEN, BERTHA',to_date('04-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5045,0,null,null,null,5044,null,0,1,to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),null,to_date('20-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5049,0,null,null,null,5048,null,0,1,to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),null,to_date('20-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5053,0,null,null,null,5052,null,0,1,to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),null,to_date('20-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5057,0,null,null,null,5056,null,0,1,to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),null,to_date('20-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5061,0,null,null,null,5060,null,0,1,to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),null,to_date('20-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5065,0,null,null,null,5064,null,0,1,to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),null,to_date('20-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5068,0,null,null,null,5067,null,0,1,to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),null,to_date('20-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5071,0,null,null,null,5070,null,0,1,to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),null,to_date('20-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5075,0,null,null,null,5074,null,0,1,to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),null,to_date('20-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5079,0,null,null,null,5078,null,0,1,to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),null,to_date('20-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5083,0,null,null,null,5082,null,0,1,to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),null,to_date('20-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5087,0,null,null,null,5086,null,0,1,to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),null,to_date('20-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5091,0,null,null,null,5090,null,0,1,to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),null,to_date('20-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5094,0,null,null,null,5093,null,0,1,to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),null,to_date('20-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5097,0,null,null,null,5096,null,0,1,to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),null,to_date('20-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5101,0,null,null,null,5100,null,0,1,to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),null,to_date('20-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5105,0,null,null,null,5104,null,0,1,to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),null,to_date('20-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5109,0,null,null,null,5108,null,0,1,to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),null,to_date('20-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5129,0,null,null,null,5128,null,0,1,to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),null,to_date('20-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5133,0,null,null,null,5132,null,0,1,to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),null,to_date('20-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5136,0,null,null,null,5135,null,0,1,to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),null,to_date('20-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (5139,0,null,null,null,5138,null,0,1,to_date('20-AUG-08','DD-MON-RR'),to_date('20-AUG-08','DD-MON-RR'),null,to_date('20-AUG-08','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-AUG-08','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8322,0,null,null,null,8321,null,0,1,to_date('05-MAR-09','DD-MON-RR'),to_date('05-MAR-09','DD-MON-RR'),null,to_date('05-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,8316,'Patient Distribution Group',to_date('05-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8326,0,null,null,null,8325,null,0,1,to_date('05-MAR-09','DD-MON-RR'),to_date('05-MAR-09','DD-MON-RR'),null,to_date('05-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,8316,'Patient Distribution Group',to_date('05-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8330,0,null,null,null,8329,null,0,1,to_date('05-MAR-09','DD-MON-RR'),to_date('05-MAR-09','DD-MON-RR'),null,to_date('05-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,8316,'Patient Distribution Group',to_date('05-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8334,0,null,null,null,8333,null,0,1,to_date('05-MAR-09','DD-MON-RR'),to_date('05-MAR-09','DD-MON-RR'),null,to_date('05-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,8316,'Patient Distribution Group',to_date('05-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8340,20,to_date('05-MAR-09','DD-MON-RR'),1152,null,8339,1152,2,1,to_date('05-MAR-09','DD-MON-RR'),to_date('05-MAR-09','DD-MON-RR'),null,to_date('05-MAR-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,989,'Dayton 29',to_date('05-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8354,0,null,null,null,8353,null,0,1,to_date('05-MAR-09','DD-MON-RR'),to_date('05-MAR-09','DD-MON-RR'),null,to_date('05-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',2,1150,'Prematta,        ',to_date('05-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8379,20,to_date('05-MAR-09','DD-MON-RR'),2796,null,8184,2796,3,1,to_date('05-MAR-09','DD-MON-RR'),to_date('05-MAR-09','DD-MON-RR'),null,to_date('05-MAR-09','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('05-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8390,0,null,null,null,8184,null,0,1,to_date('05-MAR-09','DD-MON-RR'),to_date('05-MAR-09','DD-MON-RR'),null,to_date('05-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,57,'MHVSMSEVEN, BERTHA',to_date('05-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8400,0,null,null,null,8399,null,1,1,to_date('05-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),to_date('05-MAR-09','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('05-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8411,20,to_date('05-MAR-09','DD-MON-RR'),1152,null,8410,1152,3,1,to_date('05-MAR-09','DD-MON-RR'),to_date('05-MAR-09','DD-MON-RR'),null,to_date('05-MAR-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,989,'Dayton 29',to_date('05-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8421,20,to_date('05-MAR-09','DD-MON-RR'),1152,null,8420,1152,3,1,to_date('05-MAR-09','DD-MON-RR'),to_date('05-MAR-09','DD-MON-RR'),null,to_date('05-MAR-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,989,'Dayton 29',to_date('05-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8431,20,to_date('05-MAR-09','DD-MON-RR'),1152,null,8430,1152,3,1,to_date('05-MAR-09','DD-MON-RR'),to_date('05-MAR-09','DD-MON-RR'),null,to_date('05-MAR-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,989,'Dayton 29',to_date('05-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8441,0,null,1152,null,8440,null,2,1,to_date('05-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),to_date('05-MAR-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,989,'Dayton 29',to_date('05-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8451,0,null,null,null,8450,null,1,1,to_date('05-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),to_date('05-MAR-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,989,'Dayton 29',to_date('05-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8461,0,null,null,null,7953,null,0,1,to_date('05-MAR-09','DD-MON-RR'),to_date('05-MAR-09','DD-MON-RR'),null,to_date('05-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',1,51,'MHVSMFOUR, OLIVIA',to_date('05-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8466,0,null,null,null,8465,null,1,1,to_date('05-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),to_date('05-MAR-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,989,'Dayton 29',to_date('05-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8476,0,null,null,null,8475,null,1,1,to_date('05-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),to_date('05-MAR-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,989,'Dayton 29',to_date('05-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8486,0,null,null,null,8485,null,1,1,to_date('05-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),to_date('05-MAR-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,989,'Dayton 29',to_date('05-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8496,0,null,null,null,8495,null,1,1,to_date('05-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),to_date('05-MAR-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,989,'Dayton 29',to_date('05-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8506,0,null,null,null,8505,null,1,1,to_date('05-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),to_date('05-MAR-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,989,'Dayton 29',to_date('05-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8517,0,null,null,null,8516,null,1,1,to_date('05-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),to_date('05-MAR-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,989,'Dayton 29',to_date('05-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8990,0,null,null,null,8978,null,0,1,to_date('06-MAR-09','DD-MON-RR'),to_date('06-MAR-09','DD-MON-RR'),null,to_date('06-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,57,'MHVSMSEVEN, BERTHA',to_date('06-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8996,20,to_date('06-MAR-09','DD-MON-RR'),2796,null,8978,2796,2,1,to_date('06-MAR-09','DD-MON-RR'),to_date('06-MAR-09','DD-MON-RR'),null,to_date('06-MAR-09','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('06-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9083,0,null,null,null,8834,null,1,1,to_date('09-MAR-09','DD-MON-RR'),to_date('13-MAR-09','DD-MON-RR'),to_date('13-MAR-09','DD-MON-RR'),to_date('09-MAR-09','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('09-MAR-09','DD-MON-RR'),to_date('13-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9099,0,null,null,null,8774,null,1,1,to_date('09-MAR-09','DD-MON-RR'),to_date('13-MAR-09','DD-MON-RR'),to_date('13-MAR-09','DD-MON-RR'),to_date('09-MAR-09','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('09-MAR-09','DD-MON-RR'),to_date('13-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9113,0,null,null,null,8978,null,1,1,to_date('09-MAR-09','DD-MON-RR'),to_date('13-MAR-09','DD-MON-RR'),to_date('13-MAR-09','DD-MON-RR'),to_date('09-MAR-09','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('09-MAR-09','DD-MON-RR'),to_date('13-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9147,0,null,null,null,9146,null,1,1,to_date('09-MAR-09','DD-MON-RR'),to_date('13-MAR-09','DD-MON-RR'),to_date('13-MAR-09','DD-MON-RR'),to_date('09-MAR-09','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('09-MAR-09','DD-MON-RR'),to_date('13-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9161,0,null,null,null,9160,null,0,1,to_date('09-MAR-09','DD-MON-RR'),to_date('09-MAR-09','DD-MON-RR'),null,to_date('09-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,61,'MHVSMNINE, MABEL',to_date('09-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9167,10,null,2796,null,9166,2796,3,1,to_date('09-MAR-09','DD-MON-RR'),to_date('13-MAR-09','DD-MON-RR'),to_date('13-MAR-09','DD-MON-RR'),to_date('09-MAR-09','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('09-MAR-09','DD-MON-RR'),to_date('13-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9180,0,null,null,null,9166,null,0,1,to_date('09-MAR-09','DD-MON-RR'),to_date('09-MAR-09','DD-MON-RR'),null,to_date('09-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,61,'MHVSMNINE, MABEL',to_date('09-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9196,10,null,2796,null,9195,2796,3,1,to_date('09-MAR-09','DD-MON-RR'),to_date('13-MAR-09','DD-MON-RR'),to_date('13-MAR-09','DD-MON-RR'),to_date('09-MAR-09','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('09-MAR-09','DD-MON-RR'),to_date('13-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9209,0,null,null,null,9195,null,0,1,to_date('09-MAR-09','DD-MON-RR'),to_date('09-MAR-09','DD-MON-RR'),null,to_date('09-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,61,'MHVSMNINE, MABEL',to_date('09-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9215,10,null,2796,null,8978,2796,3,1,to_date('10-MAR-09','DD-MON-RR'),to_date('14-MAR-09','DD-MON-RR'),to_date('14-MAR-09','DD-MON-RR'),to_date('10-MAR-09','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('10-MAR-09','DD-MON-RR'),to_date('14-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9226,0,null,null,null,8978,null,0,1,to_date('10-MAR-09','DD-MON-RR'),to_date('10-MAR-09','DD-MON-RR'),null,to_date('10-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,57,'MHVSMSEVEN, BERTHA',to_date('10-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9232,10,null,1154,null,9231,2796,8,1,to_date('10-MAR-09','DD-MON-RR'),to_date('14-MAR-09','DD-MON-RR'),to_date('14-MAR-09','DD-MON-RR'),to_date('10-MAR-09','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('10-MAR-09','DD-MON-RR'),to_date('14-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9243,0,null,null,null,9231,null,0,1,to_date('10-MAR-09','DD-MON-RR'),to_date('10-MAR-09','DD-MON-RR'),null,to_date('10-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,61,'MHVSMNINE, MABEL',to_date('10-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9253,0,null,null,null,9231,null,0,1,to_date('10-MAR-09','DD-MON-RR'),to_date('10-MAR-09','DD-MON-RR'),null,to_date('10-MAR-09','DD-MON-RR'),2,1154,'Mcdonald, Douglas',1,61,'MHVSMNINE, MABEL',to_date('10-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9265,0,null,null,null,9264,null,0,1,to_date('10-MAR-09','DD-MON-RR'),to_date('10-MAR-09','DD-MON-RR'),null,to_date('10-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,57,'MHVSMSEVEN, BERTHA',to_date('10-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9270,0,null,null,null,9264,null,1,1,to_date('10-MAR-09','DD-MON-RR'),to_date('14-MAR-09','DD-MON-RR'),to_date('14-MAR-09','DD-MON-RR'),to_date('10-MAR-09','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('10-MAR-09','DD-MON-RR'),to_date('14-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9316,20,to_date('10-MAR-09','DD-MON-RR'),1150,null,9315,1150,2,1,to_date('10-MAR-09','DD-MON-RR'),to_date('10-MAR-09','DD-MON-RR'),null,to_date('10-MAR-09','DD-MON-RR'),1,51,'MHVSMFOUR, OLIVIA',3,4151,'test for relationship 1',to_date('10-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9324,20,to_date('10-MAR-09','DD-MON-RR'),1150,null,9323,1150,3,1,to_date('10-MAR-09','DD-MON-RR'),to_date('10-MAR-09','DD-MON-RR'),null,to_date('10-MAR-09','DD-MON-RR'),1,51,'MHVSMFOUR, OLIVIA',3,8855,'Test Triage         edit',to_date('10-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9332,20,to_date('10-MAR-09','DD-MON-RR'),1150,null,9323,1150,2,1,to_date('10-MAR-09','DD-MON-RR'),to_date('10-MAR-09','DD-MON-RR'),null,to_date('10-MAR-09','DD-MON-RR'),2,1150,'Prematta,        ',1,51,'MHVSMFOUR, OLIVIA',to_date('10-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9363,0,null,null,null,9362,null,0,1,to_date('10-MAR-09','DD-MON-RR'),to_date('10-MAR-09','DD-MON-RR'),null,to_date('10-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,61,'MHVSMNINE, MABEL',to_date('10-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9389,20,to_date('10-MAR-09','DD-MON-RR'),2796,null,9388,2796,3,1,to_date('10-MAR-09','DD-MON-RR'),to_date('10-MAR-09','DD-MON-RR'),null,to_date('10-MAR-09','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('10-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9372,0,null,null,null,9371,null,0,1,to_date('10-MAR-09','DD-MON-RR'),to_date('10-MAR-09','DD-MON-RR'),null,to_date('10-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,61,'MHVSMNINE, MABEL',to_date('10-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9386,0,null,null,null,9385,null,1,1,to_date('10-MAR-09','DD-MON-RR'),to_date('10-MAR-09','DD-MON-RR'),null,null,1,61,'MHVSMNINE, MABEL',null,null,null,null,null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9424,0,null,null,null,9195,null,0,1,to_date('11-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),null,to_date('11-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,61,'MHVSMNINE, MABEL',to_date('11-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9432,0,null,null,null,9431,null,0,1,to_date('11-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),null,to_date('11-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',2,6705,'GOPARAJU, BHANU',to_date('11-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9447,10,null,6705,null,9446,6705,2,1,to_date('11-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),null,to_date('11-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',2,6705,'GOPARAJU, BHANU',to_date('11-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9452,0,null,2796,null,9451,null,1,1,to_date('11-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),null,to_date('11-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,9441,'Bhanu test team 2',to_date('11-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9463,0,null,2796,null,9462,null,1,1,to_date('11-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),null,to_date('11-MAR-09','DD-MON-RR'),2,6705,'GOPARAJU, BHANU',3,9441,'Bhanu test team 2',to_date('11-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9479,0,null,null,null,9451,null,0,1,to_date('11-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),null,to_date('11-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',2,2796,'Balasubramanian, Swetha',to_date('11-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9484,0,null,null,null,7684,null,0,1,to_date('11-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),null,to_date('11-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',2,1156,'Kola, Jerome',to_date('11-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9495,0,null,2796,null,9494,null,1,1,to_date('11-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),null,to_date('11-MAR-09','DD-MON-RR'),2,6705,'GOPARAJU, BHANU',3,9441,'Bhanu test team 2',to_date('11-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9500,10,null,79,null,9499,1150,4,1,to_date('11-MAR-09','DD-MON-RR'),to_date('17-MAR-09','DD-MON-RR'),to_date('17-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),1,51,'MHVSMFOUR, OLIVIA',3,4151,'test for relationship 1',to_date('11-MAR-09','DD-MON-RR'),to_date('17-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9508,0,null,null,null,9499,null,0,1,to_date('11-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),null,to_date('11-MAR-09','DD-MON-RR'),2,1150,'Prematta,        ',1,51,'MHVSMFOUR, OLIVIA',to_date('11-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9514,10,null,1150,null,9499,1150,3,1,to_date('11-MAR-09','DD-MON-RR'),to_date('17-MAR-09','DD-MON-RR'),to_date('17-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),1,51,'MHVSMFOUR, OLIVIA',3,4151,'test for relationship 1',to_date('11-MAR-09','DD-MON-RR'),to_date('17-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9521,0,null,null,null,9494,null,0,1,to_date('11-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),null,to_date('11-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',2,6705,'GOPARAJU, BHANU',to_date('11-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9526,0,null,null,null,9499,null,0,1,to_date('11-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),null,to_date('11-MAR-09','DD-MON-RR'),2,1150,'Prematta,        ',1,51,'MHVSMFOUR, OLIVIA',to_date('11-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9532,20,to_date('11-MAR-09','DD-MON-RR'),1150,null,9499,1150,2,1,to_date('11-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),null,to_date('11-MAR-09','DD-MON-RR'),1,51,'MHVSMFOUR, OLIVIA',3,4151,'test for relationship 1',to_date('11-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11311,0,null,null,null,11310,null,0,1,to_date('27-MAR-09','DD-MON-RR'),to_date('27-MAR-09','DD-MON-RR'),null,to_date('27-MAR-09','DD-MON-RR'),2,1150,'Prematta,        ',1,51,'MHVSMFOUR, OLIVIA',to_date('27-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11389,10,null,1154,null,11388,1154,3,1,to_date('27-MAR-09','DD-MON-RR'),to_date('02-APR-09','DD-MON-RR'),to_date('02-APR-09','DD-MON-RR'),to_date('27-MAR-09','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('27-MAR-09','DD-MON-RR'),to_date('02-APR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11400,20,to_date('04-MAY-09','DD-MON-RR'),2796,null,11399,2796,5,1,to_date('27-MAR-09','DD-MON-RR'),to_date('02-APR-09','DD-MON-RR'),to_date('02-APR-09','DD-MON-RR'),to_date('27-MAR-09','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('27-MAR-09','DD-MON-RR'),to_date('02-APR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11411,10,null,1154,null,11410,1154,3,1,to_date('27-MAR-09','DD-MON-RR'),to_date('02-APR-09','DD-MON-RR'),to_date('02-APR-09','DD-MON-RR'),to_date('27-MAR-09','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('27-MAR-09','DD-MON-RR'),to_date('02-APR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11422,10,null,1154,null,11421,1154,3,1,to_date('27-MAR-09','DD-MON-RR'),to_date('02-APR-09','DD-MON-RR'),to_date('02-APR-09','DD-MON-RR'),to_date('27-MAR-09','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('27-MAR-09','DD-MON-RR'),to_date('02-APR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11434,10,null,1154,null,11433,1154,3,1,to_date('27-MAR-09','DD-MON-RR'),to_date('02-APR-09','DD-MON-RR'),to_date('02-APR-09','DD-MON-RR'),to_date('27-MAR-09','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('27-MAR-09','DD-MON-RR'),to_date('02-APR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11445,20,to_date('04-MAY-09','DD-MON-RR'),2796,null,11444,2796,5,1,to_date('27-MAR-09','DD-MON-RR'),to_date('02-APR-09','DD-MON-RR'),to_date('02-APR-09','DD-MON-RR'),to_date('27-MAR-09','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('27-MAR-09','DD-MON-RR'),to_date('02-APR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11504,0,null,null,null,11455,null,0,1,to_date('27-MAR-09','DD-MON-RR'),to_date('27-MAR-09','DD-MON-RR'),null,to_date('27-MAR-09','DD-MON-RR'),2,1154,'Mcdonald, Douglas',1,61,'MHVSMNINE, MABEL',to_date('27-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11510,0,null,null,null,11410,null,0,1,to_date('27-MAR-09','DD-MON-RR'),to_date('27-MAR-09','DD-MON-RR'),null,to_date('27-MAR-09','DD-MON-RR'),2,1154,'Mcdonald, Douglas',1,61,'MHVSMNINE, MABEL',to_date('27-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8554,0,null,null,null,8553,null,0,1,to_date('05-MAR-09','DD-MON-RR'),to_date('05-MAR-09','DD-MON-RR'),null,to_date('05-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',1,73,'MHVSMFIFTEEN, YOKO',to_date('05-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8559,0,null,null,null,8558,null,0,1,to_date('05-MAR-09','DD-MON-RR'),to_date('05-MAR-09','DD-MON-RR'),null,to_date('05-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',1,73,'MHVSMFIFTEEN, YOKO',to_date('05-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8564,0,null,null,null,8410,null,0,1,to_date('05-MAR-09','DD-MON-RR'),to_date('05-MAR-09','DD-MON-RR'),null,to_date('05-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',1,73,'MHVSMFIFTEEN, YOKO',to_date('05-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8575,0,null,null,null,8420,null,0,1,to_date('05-MAR-09','DD-MON-RR'),to_date('05-MAR-09','DD-MON-RR'),null,to_date('05-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',1,73,'MHVSMFIFTEEN, YOKO',to_date('05-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8583,0,null,null,null,8430,null,0,1,to_date('05-MAR-09','DD-MON-RR'),to_date('05-MAR-09','DD-MON-RR'),null,to_date('05-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',1,73,'MHVSMFIFTEEN, YOKO',to_date('05-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10055,0,null,null,null,10054,null,0,1,to_date('12-MAR-09','DD-MON-RR'),to_date('12-MAR-09','DD-MON-RR'),null,to_date('12-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,61,'MHVSMNINE, MABEL',to_date('12-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10105,0,null,null,null,9676,null,0,1,to_date('17-MAR-09','DD-MON-RR'),to_date('17-MAR-09','DD-MON-RR'),null,to_date('17-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',2,6705,'GOPARAJU, BHANU',to_date('17-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10117,0,null,null,null,9805,null,0,1,to_date('18-MAR-09','DD-MON-RR'),to_date('18-MAR-09','DD-MON-RR'),null,to_date('18-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,61,'MHVSMNINE, MABEL',to_date('18-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10147,10,null,79,null,10146,79,2,1,to_date('20-MAR-09','DD-MON-RR'),to_date('26-MAR-09','DD-MON-RR'),to_date('26-MAR-09','DD-MON-RR'),to_date('20-MAR-09','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',to_date('20-MAR-09','DD-MON-RR'),to_date('26-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10156,20,to_date('20-MAR-09','DD-MON-RR'),79,null,10155,79,3,1,to_date('20-MAR-09','DD-MON-RR'),to_date('20-MAR-09','DD-MON-RR'),null,to_date('20-MAR-09','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',to_date('20-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10167,0,null,null,null,10155,null,0,1,to_date('20-MAR-09','DD-MON-RR'),to_date('20-MAR-09','DD-MON-RR'),null,to_date('20-MAR-09','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',1,29,'MHVSMONE, ALYSSA',to_date('20-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10174,0,null,null,null,10146,null,0,1,to_date('20-MAR-09','DD-MON-RR'),to_date('20-MAR-09','DD-MON-RR'),null,to_date('20-MAR-09','DD-MON-RR'),2,79,'MHVSMDOCTHREE, PETER',1,29,'MHVSMONE, ALYSSA',to_date('20-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10185,0,null,null,null,10184,null,1,1,to_date('20-MAR-09','DD-MON-RR'),to_date('26-MAR-09','DD-MON-RR'),to_date('26-MAR-09','DD-MON-RR'),to_date('20-MAR-09','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('20-MAR-09','DD-MON-RR'),to_date('26-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10204,0,null,null,null,10203,null,1,1,to_date('20-MAR-09','DD-MON-RR'),to_date('26-MAR-09','DD-MON-RR'),to_date('26-MAR-09','DD-MON-RR'),to_date('20-MAR-09','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,989,'Dayton 29',to_date('20-MAR-09','DD-MON-RR'),to_date('26-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10214,20,to_date('24-MAR-09','DD-MON-RR'),2796,null,10213,2796,2,1,to_date('20-MAR-09','DD-MON-RR'),to_date('20-MAR-09','DD-MON-RR'),null,to_date('20-MAR-09','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('20-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10228,0,null,null,null,8675,null,0,1,to_date('20-MAR-09','DD-MON-RR'),to_date('20-MAR-09','DD-MON-RR'),null,to_date('20-MAR-09','DD-MON-RR'),2,1150,'Prematta,        ',1,51,'MHVSMFOUR, OLIVIA',to_date('20-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10235,0,null,null,null,10234,null,0,1,to_date('20-MAR-09','DD-MON-RR'),to_date('20-MAR-09','DD-MON-RR'),null,to_date('20-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10239,0,null,null,null,10238,null,0,1,to_date('20-MAR-09','DD-MON-RR'),to_date('20-MAR-09','DD-MON-RR'),null,to_date('20-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10242,0,null,null,null,10241,null,0,1,to_date('20-MAR-09','DD-MON-RR'),to_date('20-MAR-09','DD-MON-RR'),null,to_date('20-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10245,0,null,null,null,10244,null,0,1,to_date('20-MAR-09','DD-MON-RR'),to_date('20-MAR-09','DD-MON-RR'),null,to_date('20-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10249,0,null,null,null,10248,null,0,1,to_date('20-MAR-09','DD-MON-RR'),to_date('20-MAR-09','DD-MON-RR'),null,to_date('20-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10253,0,null,null,null,10252,null,0,1,to_date('20-MAR-09','DD-MON-RR'),to_date('20-MAR-09','DD-MON-RR'),null,to_date('20-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10257,0,null,null,null,10256,null,0,1,to_date('20-MAR-09','DD-MON-RR'),to_date('20-MAR-09','DD-MON-RR'),null,to_date('20-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10261,0,null,null,null,10260,null,0,1,to_date('20-MAR-09','DD-MON-RR'),to_date('20-MAR-09','DD-MON-RR'),null,to_date('20-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10268,0,null,null,null,10267,null,0,1,to_date('20-MAR-09','DD-MON-RR'),to_date('20-MAR-09','DD-MON-RR'),null,to_date('20-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10272,0,null,null,null,10271,null,0,1,to_date('20-MAR-09','DD-MON-RR'),to_date('20-MAR-09','DD-MON-RR'),null,to_date('20-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10275,0,null,null,null,10274,null,0,1,to_date('20-MAR-09','DD-MON-RR'),to_date('20-MAR-09','DD-MON-RR'),null,to_date('20-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10278,0,null,null,null,10277,null,0,1,to_date('20-MAR-09','DD-MON-RR'),to_date('20-MAR-09','DD-MON-RR'),null,to_date('20-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10282,0,null,null,null,10281,null,0,1,to_date('20-MAR-09','DD-MON-RR'),to_date('20-MAR-09','DD-MON-RR'),null,to_date('20-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11485,0,null,null,null,11421,null,0,1,to_date('27-MAR-09','DD-MON-RR'),to_date('27-MAR-09','DD-MON-RR'),null,to_date('27-MAR-09','DD-MON-RR'),2,1154,'Mcdonald, Douglas',1,61,'MHVSMNINE, MABEL',to_date('27-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11524,0,null,null,null,11523,null,0,1,to_date('27-MAR-09','DD-MON-RR'),to_date('27-MAR-09','DD-MON-RR'),null,to_date('27-MAR-09','DD-MON-RR'),2,1150,'Prematta,        ',1,51,'MHVSMFOUR, OLIVIA',to_date('27-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11533,0,null,null,null,11532,null,0,1,to_date('27-MAR-09','DD-MON-RR'),to_date('27-MAR-09','DD-MON-RR'),null,to_date('27-MAR-09','DD-MON-RR'),2,1154,'Mcdonald, Douglas',3,9890,'Doug - Triage Alpha',to_date('27-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8590,0,null,null,null,8440,null,0,1,to_date('05-MAR-09','DD-MON-RR'),to_date('05-MAR-09','DD-MON-RR'),null,to_date('05-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',1,73,'MHVSMFIFTEEN, YOKO',to_date('05-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8629,0,null,null,null,8628,null,1,1,to_date('05-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),to_date('05-MAR-09','DD-MON-RR'),1,71,'MHVSMFOURTEEN, RINGO',3,8598,'Doug Test MHV00004826',to_date('05-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8090,20,to_date('04-MAR-09','DD-MON-RR'),2796,null,8067,2796,2,1,to_date('04-MAR-09','DD-MON-RR'),to_date('04-MAR-09','DD-MON-RR'),null,to_date('04-MAR-09','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('04-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8120,20,to_date('04-MAR-09','DD-MON-RR'),2796,null,8119,2796,3,1,to_date('04-MAR-09','DD-MON-RR'),to_date('04-MAR-09','DD-MON-RR'),null,to_date('04-MAR-09','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('04-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8131,0,null,null,null,8119,null,0,1,to_date('04-MAR-09','DD-MON-RR'),to_date('04-MAR-09','DD-MON-RR'),null,to_date('04-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,57,'MHVSMSEVEN, BERTHA',to_date('04-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8143,10,null,1154,null,8142,2796,3,1,to_date('04-MAR-09','DD-MON-RR'),to_date('10-MAR-09','DD-MON-RR'),to_date('10-MAR-09','DD-MON-RR'),to_date('04-MAR-09','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('04-MAR-09','DD-MON-RR'),to_date('10-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8154,0,null,null,null,8142,null,0,1,to_date('04-MAR-09','DD-MON-RR'),to_date('04-MAR-09','DD-MON-RR'),null,to_date('04-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,57,'MHVSMSEVEN, BERTHA',to_date('04-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8164,10,null,2796,null,8163,2796,3,1,to_date('04-MAR-09','DD-MON-RR'),to_date('10-MAR-09','DD-MON-RR'),to_date('10-MAR-09','DD-MON-RR'),to_date('04-MAR-09','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('04-MAR-09','DD-MON-RR'),to_date('10-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8178,0,null,null,null,8163,null,0,1,to_date('04-MAR-09','DD-MON-RR'),to_date('04-MAR-09','DD-MON-RR'),null,to_date('04-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,57,'MHVSMSEVEN, BERTHA',to_date('04-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8185,20,to_date('05-MAR-09','DD-MON-RR'),2796,null,8184,2796,3,1,to_date('04-MAR-09','DD-MON-RR'),to_date('04-MAR-09','DD-MON-RR'),null,to_date('04-MAR-09','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('04-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8198,0,null,null,null,8184,null,0,1,to_date('04-MAR-09','DD-MON-RR'),to_date('04-MAR-09','DD-MON-RR'),null,to_date('04-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,57,'MHVSMSEVEN, BERTHA',to_date('04-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8204,10,null,1154,null,8203,2796,3,1,to_date('04-MAR-09','DD-MON-RR'),to_date('10-MAR-09','DD-MON-RR'),to_date('10-MAR-09','DD-MON-RR'),to_date('04-MAR-09','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('04-MAR-09','DD-MON-RR'),to_date('10-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8216,0,null,null,null,8203,null,0,1,to_date('04-MAR-09','DD-MON-RR'),to_date('04-MAR-09','DD-MON-RR'),null,to_date('04-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,57,'MHVSMSEVEN, BERTHA',to_date('04-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8226,10,null,1154,null,8225,1154,2,1,to_date('04-MAR-09','DD-MON-RR'),to_date('04-MAR-09','DD-MON-RR'),null,to_date('04-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',2,1154,'Mcdonald, Douglas',to_date('04-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8243,20,to_date('04-MAR-09','DD-MON-RR'),2796,null,8225,2796,2,1,to_date('04-MAR-09','DD-MON-RR'),to_date('04-MAR-09','DD-MON-RR'),null,to_date('04-MAR-09','DD-MON-RR'),2,1154,'Mcdonald, Douglas',2,2796,'Balasubramanian, Swetha',to_date('04-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8258,10,null,2796,null,8257,2796,2,1,to_date('05-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),to_date('05-MAR-09','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('05-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8275,0,null,null,null,8184,null,0,1,to_date('05-MAR-09','DD-MON-RR'),to_date('05-MAR-09','DD-MON-RR'),null,to_date('05-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,57,'MHVSMSEVEN, BERTHA',to_date('05-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8282,20,to_date('05-MAR-09','DD-MON-RR'),2796,null,8184,2796,5,1,to_date('05-MAR-09','DD-MON-RR'),to_date('05-MAR-09','DD-MON-RR'),null,to_date('05-MAR-09','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('05-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8298,0,null,null,null,8184,null,0,1,to_date('05-MAR-09','DD-MON-RR'),to_date('05-MAR-09','DD-MON-RR'),null,to_date('05-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,57,'MHVSMSEVEN, BERTHA',to_date('05-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8305,0,null,null,null,8184,null,0,1,to_date('05-MAR-09','DD-MON-RR'),to_date('05-MAR-09','DD-MON-RR'),null,to_date('05-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,57,'MHVSMSEVEN, BERTHA',to_date('05-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8310,0,null,null,null,8184,null,0,1,to_date('05-MAR-09','DD-MON-RR'),to_date('05-MAR-09','DD-MON-RR'),null,to_date('05-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,57,'MHVSMSEVEN, BERTHA',to_date('05-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8318,0,null,null,null,8317,null,0,1,to_date('05-MAR-09','DD-MON-RR'),to_date('05-MAR-09','DD-MON-RR'),null,to_date('05-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,8316,'Patient Distribution Group',to_date('05-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9683,0,null,2796,null,9676,null,1,1,to_date('11-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),null,to_date('11-MAR-09','DD-MON-RR'),2,6705,'GOPARAJU, BHANU',2,2796,'Balasubramanian, Swetha',to_date('11-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9689,0,null,null,null,9642,null,0,1,to_date('11-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),null,to_date('11-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',2,1154,'Mcdonald, Douglas',to_date('11-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9696,0,null,null,null,9231,null,0,1,to_date('11-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),null,to_date('11-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,61,'MHVSMNINE, MABEL',to_date('11-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9704,0,null,null,null,9231,null,0,1,to_date('11-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),null,to_date('11-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,61,'MHVSMNINE, MABEL',to_date('11-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9711,0,null,null,null,9231,null,0,1,to_date('11-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),null,to_date('11-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,61,'MHVSMNINE, MABEL',to_date('11-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9720,0,null,null,null,9642,null,0,1,to_date('11-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),null,to_date('11-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',2,1154,'Mcdonald, Douglas',to_date('11-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9727,0,null,null,null,9231,null,0,1,to_date('11-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),null,to_date('11-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,61,'MHVSMNINE, MABEL',to_date('11-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9733,0,null,null,null,9231,null,0,1,to_date('11-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),null,to_date('11-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,61,'MHVSMNINE, MABEL',to_date('11-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9762,0,null,null,null,9761,null,1,1,to_date('11-MAR-09','DD-MON-RR'),to_date('17-MAR-09','DD-MON-RR'),to_date('17-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('11-MAR-09','DD-MON-RR'),to_date('17-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9794,10,null,6705,null,9793,2796,2,1,to_date('12-MAR-09','DD-MON-RR'),to_date('18-MAR-09','DD-MON-RR'),to_date('18-MAR-09','DD-MON-RR'),to_date('12-MAR-09','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('12-MAR-09','DD-MON-RR'),to_date('18-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9806,10,null,1154,null,9805,2796,2,1,to_date('12-MAR-09','DD-MON-RR'),to_date('18-MAR-09','DD-MON-RR'),to_date('18-MAR-09','DD-MON-RR'),to_date('12-MAR-09','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('12-MAR-09','DD-MON-RR'),to_date('18-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9829,10,null,2796,null,9828,2796,3,1,to_date('12-MAR-09','DD-MON-RR'),to_date('18-MAR-09','DD-MON-RR'),to_date('18-MAR-09','DD-MON-RR'),to_date('12-MAR-09','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('12-MAR-09','DD-MON-RR'),to_date('18-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9857,0,null,null,null,9856,null,0,1,to_date('12-MAR-09','DD-MON-RR'),to_date('12-MAR-09','DD-MON-RR'),null,to_date('12-MAR-09','DD-MON-RR'),2,6705,'GOPARAJU, BHANU',2,2796,'Balasubramanian, Swetha',to_date('12-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9863,20,to_date('27-APR-09','DD-MON-RR'),2796,null,9862,2796,2,1,to_date('12-MAR-09','DD-MON-RR'),to_date('12-MAR-09','DD-MON-RR'),null,to_date('12-MAR-09','DD-MON-RR'),2,6705,'GOPARAJU, BHANU',2,2796,'Balasubramanian, Swetha',to_date('12-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9877,10,null,2796,null,9876,2796,3,1,to_date('12-MAR-09','DD-MON-RR'),to_date('18-MAR-09','DD-MON-RR'),to_date('18-MAR-09','DD-MON-RR'),to_date('12-MAR-09','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('12-MAR-09','DD-MON-RR'),to_date('18-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9979,0,null,null,null,9978,null,1,1,to_date('12-MAR-09','DD-MON-RR'),to_date('18-MAR-09','DD-MON-RR'),to_date('18-MAR-09','DD-MON-RR'),to_date('12-MAR-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,989,'Dayton 29',to_date('12-MAR-09','DD-MON-RR'),to_date('18-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9939,0,null,null,null,9938,null,1,1,to_date('12-MAR-09','DD-MON-RR'),to_date('18-MAR-09','DD-MON-RR'),to_date('18-MAR-09','DD-MON-RR'),to_date('12-MAR-09','DD-MON-RR'),1,63,'MHVSMTEN, EDNA',3,9890,'Doug - Triage Alpha',to_date('12-MAR-09','DD-MON-RR'),to_date('18-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9951,0,null,null,null,9950,null,1,1,to_date('12-MAR-09','DD-MON-RR'),to_date('18-MAR-09','DD-MON-RR'),to_date('18-MAR-09','DD-MON-RR'),to_date('12-MAR-09','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('12-MAR-09','DD-MON-RR'),to_date('18-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9966,0,null,null,null,9965,null,1,1,to_date('12-MAR-09','DD-MON-RR'),to_date('18-MAR-09','DD-MON-RR'),to_date('18-MAR-09','DD-MON-RR'),to_date('12-MAR-09','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('12-MAR-09','DD-MON-RR'),to_date('18-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9988,0,null,null,null,9987,null,1,1,to_date('12-MAR-09','DD-MON-RR'),to_date('18-MAR-09','DD-MON-RR'),to_date('18-MAR-09','DD-MON-RR'),to_date('12-MAR-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,989,'Dayton 29',to_date('12-MAR-09','DD-MON-RR'),to_date('18-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9997,0,null,null,null,9996,null,1,1,to_date('12-MAR-09','DD-MON-RR'),to_date('18-MAR-09','DD-MON-RR'),to_date('18-MAR-09','DD-MON-RR'),to_date('12-MAR-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,989,'Dayton 29',to_date('12-MAR-09','DD-MON-RR'),to_date('18-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10006,0,null,null,null,10005,null,1,1,to_date('12-MAR-09','DD-MON-RR'),to_date('18-MAR-09','DD-MON-RR'),to_date('18-MAR-09','DD-MON-RR'),to_date('12-MAR-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,989,'Dayton 29',to_date('12-MAR-09','DD-MON-RR'),to_date('18-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10015,0,null,null,null,10014,null,1,1,to_date('12-MAR-09','DD-MON-RR'),to_date('18-MAR-09','DD-MON-RR'),to_date('18-MAR-09','DD-MON-RR'),to_date('12-MAR-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,989,'Dayton 29',to_date('12-MAR-09','DD-MON-RR'),to_date('18-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10024,0,null,null,null,10023,null,1,1,to_date('12-MAR-09','DD-MON-RR'),to_date('18-MAR-09','DD-MON-RR'),to_date('18-MAR-09','DD-MON-RR'),to_date('12-MAR-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,989,'Dayton 29',to_date('12-MAR-09','DD-MON-RR'),to_date('18-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10037,0,null,null,null,9876,null,0,1,to_date('12-MAR-09','DD-MON-RR'),to_date('12-MAR-09','DD-MON-RR'),null,to_date('12-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,61,'MHVSMNINE, MABEL',to_date('12-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10043,0,null,null,null,9876,null,0,1,to_date('12-MAR-09','DD-MON-RR'),to_date('12-MAR-09','DD-MON-RR'),null,to_date('12-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,61,'MHVSMNINE, MABEL',to_date('12-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10049,0,null,null,null,9828,null,0,1,to_date('12-MAR-09','DD-MON-RR'),to_date('12-MAR-09','DD-MON-RR'),null,to_date('12-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,61,'MHVSMNINE, MABEL',to_date('12-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10315,0,null,null,null,10314,null,0,1,to_date('20-MAR-09','DD-MON-RR'),to_date('20-MAR-09','DD-MON-RR'),null,to_date('20-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10319,0,null,null,null,10318,null,0,1,to_date('20-MAR-09','DD-MON-RR'),to_date('20-MAR-09','DD-MON-RR'),null,to_date('20-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10323,0,null,null,null,10322,null,0,1,to_date('20-MAR-09','DD-MON-RR'),to_date('20-MAR-09','DD-MON-RR'),null,to_date('20-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10327,0,null,null,null,10326,null,0,1,to_date('20-MAR-09','DD-MON-RR'),to_date('20-MAR-09','DD-MON-RR'),null,to_date('20-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('20-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10340,10,null,2796,null,10339,2796,3,1,to_date('20-MAR-09','DD-MON-RR'),to_date('26-MAR-09','DD-MON-RR'),to_date('26-MAR-09','DD-MON-RR'),to_date('20-MAR-09','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('20-MAR-09','DD-MON-RR'),to_date('26-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10378,0,null,null,null,10339,null,0,1,to_date('20-MAR-09','DD-MON-RR'),to_date('20-MAR-09','DD-MON-RR'),null,to_date('20-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,57,'MHVSMSEVEN, BERTHA',to_date('20-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10387,10,null,2796,null,9264,2796,2,1,to_date('20-MAR-09','DD-MON-RR'),to_date('26-MAR-09','DD-MON-RR'),to_date('26-MAR-09','DD-MON-RR'),to_date('20-MAR-09','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('20-MAR-09','DD-MON-RR'),to_date('26-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10397,10,null,6705,null,9264,2796,2,1,to_date('20-MAR-09','DD-MON-RR'),to_date('26-MAR-09','DD-MON-RR'),to_date('26-MAR-09','DD-MON-RR'),to_date('20-MAR-09','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('20-MAR-09','DD-MON-RR'),to_date('26-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10407,0,null,null,null,9264,null,1,1,to_date('20-MAR-09','DD-MON-RR'),to_date('26-MAR-09','DD-MON-RR'),to_date('26-MAR-09','DD-MON-RR'),to_date('20-MAR-09','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('20-MAR-09','DD-MON-RR'),to_date('26-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10417,20,to_date('24-MAR-09','DD-MON-RR'),2796,null,9264,2796,2,1,to_date('20-MAR-09','DD-MON-RR'),to_date('20-MAR-09','DD-MON-RR'),null,to_date('20-MAR-09','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('20-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10428,0,null,null,null,10339,null,0,1,to_date('20-MAR-09','DD-MON-RR'),to_date('20-MAR-09','DD-MON-RR'),null,to_date('20-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,57,'MHVSMSEVEN, BERTHA',to_date('20-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10432,0,null,null,null,10339,null,0,1,to_date('20-MAR-09','DD-MON-RR'),to_date('20-MAR-09','DD-MON-RR'),null,to_date('20-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,57,'MHVSMSEVEN, BERTHA',to_date('20-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10436,0,null,null,null,10339,null,0,1,to_date('20-MAR-09','DD-MON-RR'),to_date('20-MAR-09','DD-MON-RR'),null,to_date('20-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,57,'MHVSMSEVEN, BERTHA',to_date('20-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10466,20,to_date('23-MAR-09','DD-MON-RR'),1152,null,10465,1152,4,1,to_date('23-MAR-09','DD-MON-RR'),to_date('23-MAR-09','DD-MON-RR'),null,to_date('23-MAR-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,989,'Dayton 29',to_date('23-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10482,20,to_date('24-MAR-09','DD-MON-RR'),2796,null,10481,2796,3,1,to_date('23-MAR-09','DD-MON-RR'),to_date('23-MAR-09','DD-MON-RR'),null,to_date('23-MAR-09','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('23-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10495,0,null,null,null,10481,null,0,1,to_date('23-MAR-09','DD-MON-RR'),to_date('23-MAR-09','DD-MON-RR'),null,to_date('23-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,61,'MHVSMNINE, MABEL',to_date('23-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10504,20,to_date('23-MAR-09','DD-MON-RR'),2796,null,10503,2796,5,1,to_date('23-MAR-09','DD-MON-RR'),to_date('23-MAR-09','DD-MON-RR'),null,to_date('23-MAR-09','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('23-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10518,0,null,null,null,10503,null,0,1,to_date('23-MAR-09','DD-MON-RR'),to_date('23-MAR-09','DD-MON-RR'),null,to_date('23-MAR-09','DD-MON-RR'),2,6705,'GOPARAJU, BHANU',1,61,'MHVSMNINE, MABEL',to_date('23-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10528,0,null,null,null,10503,null,0,1,to_date('23-MAR-09','DD-MON-RR'),to_date('23-MAR-09','DD-MON-RR'),null,to_date('23-MAR-09','DD-MON-RR'),2,6705,'GOPARAJU, BHANU',1,61,'MHVSMNINE, MABEL',to_date('23-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10535,0,null,null,null,10503,null,0,1,to_date('23-MAR-09','DD-MON-RR'),to_date('23-MAR-09','DD-MON-RR'),null,to_date('23-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,61,'MHVSMNINE, MABEL',to_date('23-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10651,20,to_date('24-MAR-09','DD-MON-RR'),2796,null,10650,2796,3,1,to_date('23-MAR-09','DD-MON-RR'),to_date('23-MAR-09','DD-MON-RR'),null,to_date('23-MAR-09','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,10614,'Swetha''s test',to_date('23-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10694,0,null,null,null,10693,null,1,1,to_date('23-MAR-09','DD-MON-RR'),to_date('27-MAR-09','DD-MON-RR'),to_date('27-MAR-09','DD-MON-RR'),to_date('23-MAR-09','DD-MON-RR'),1,55,'mhvsmsix, Alice',3,5841,'Doug''s Triage 01',to_date('23-MAR-09','DD-MON-RR'),to_date('27-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10737,20,to_date('30-MAR-09','DD-MON-RR'),2796,null,10736,2796,3,1,to_date('24-MAR-09','DD-MON-RR'),to_date('28-MAR-09','DD-MON-RR'),to_date('28-MAR-09','DD-MON-RR'),to_date('24-MAR-09','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('24-MAR-09','DD-MON-RR'),to_date('28-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10754,20,to_date('30-MAR-09','DD-MON-RR'),2796,null,10753,2796,4,1,to_date('24-MAR-09','DD-MON-RR'),to_date('28-MAR-09','DD-MON-RR'),to_date('28-MAR-09','DD-MON-RR'),to_date('24-MAR-09','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('24-MAR-09','DD-MON-RR'),to_date('28-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10791,20,to_date('24-MAR-09','DD-MON-RR'),1150,null,10790,1150,2,1,to_date('24-MAR-09','DD-MON-RR'),to_date('24-MAR-09','DD-MON-RR'),null,to_date('24-MAR-09','DD-MON-RR'),1,51,'MHVSMFOUR, OLIVIA',3,10713,' new triage 3/24/09',to_date('24-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10809,20,to_date('27-MAR-09','DD-MON-RR'),1150,null,10790,1150,2,1,to_date('24-MAR-09','DD-MON-RR'),to_date('24-MAR-09','DD-MON-RR'),null,to_date('24-MAR-09','DD-MON-RR'),1,51,'MHVSMFOUR, OLIVIA',3,10713,' new triage 3/24/09',to_date('24-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10817,20,to_date('24-MAR-09','DD-MON-RR'),2796,null,10650,2796,2,1,to_date('24-MAR-09','DD-MON-RR'),to_date('24-MAR-09','DD-MON-RR'),null,to_date('24-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,61,'MHVSMNINE, MABEL',to_date('24-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10836,10,null,1150,null,10790,1150,2,1,to_date('24-MAR-09','DD-MON-RR'),to_date('24-MAR-09','DD-MON-RR'),null,to_date('24-MAR-09','DD-MON-RR'),2,1150,'Prematta,        ',1,51,'MHVSMFOUR, OLIVIA',to_date('24-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10842,0,null,null,null,10790,null,0,1,to_date('24-MAR-09','DD-MON-RR'),to_date('24-MAR-09','DD-MON-RR'),null,to_date('24-MAR-09','DD-MON-RR'),2,1150,'Prematta,        ',2,1150,'Prematta,        ',to_date('24-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10848,10,null,2796,null,10753,2796,1,1,to_date('24-MAR-09','DD-MON-RR'),to_date('24-MAR-09','DD-MON-RR'),null,to_date('24-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,61,'MHVSMNINE, MABEL',to_date('24-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10911,20,to_date('24-MAR-09','DD-MON-RR'),1150,null,10910,1150,2,1,to_date('24-MAR-09','DD-MON-RR'),to_date('24-MAR-09','DD-MON-RR'),null,to_date('24-MAR-09','DD-MON-RR'),1,51,'MHVSMFOUR, OLIVIA',3,10902,'Antny test triage 1',to_date('24-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10972,0,null,null,null,10481,null,0,1,to_date('24-MAR-09','DD-MON-RR'),to_date('24-MAR-09','DD-MON-RR'),null,to_date('24-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,61,'MHVSMNINE, MABEL',to_date('24-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10986,20,to_date('24-MAR-09','DD-MON-RR'),2796,null,10985,2796,3,1,to_date('24-MAR-09','DD-MON-RR'),to_date('24-MAR-09','DD-MON-RR'),null,to_date('24-MAR-09','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('24-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (10997,0,null,null,null,10985,null,0,1,to_date('24-MAR-09','DD-MON-RR'),to_date('24-MAR-09','DD-MON-RR'),null,to_date('24-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,61,'MHVSMNINE, MABEL',to_date('24-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11089,0,null,null,null,11083,null,0,1,to_date('25-MAR-09','DD-MON-RR'),to_date('25-MAR-09','DD-MON-RR'),null,to_date('25-MAR-09','DD-MON-RR'),2,1150,'Prematta,        ',1,51,'MHVSMFOUR, OLIVIA',to_date('25-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11034,0,null,null,null,11033,null,0,1,to_date('25-MAR-09','DD-MON-RR'),to_date('25-MAR-09','DD-MON-RR'),null,to_date('25-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',2,6705,'GOPARAJU, BHANU',to_date('25-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11043,0,null,null,null,11042,null,0,1,to_date('25-MAR-09','DD-MON-RR'),to_date('25-MAR-09','DD-MON-RR'),null,to_date('25-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',4,10087,'testing',to_date('25-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11047,0,null,null,null,11046,null,0,1,to_date('25-MAR-09','DD-MON-RR'),to_date('25-MAR-09','DD-MON-RR'),null,to_date('25-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',4,10087,'testing',to_date('25-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11051,0,null,null,null,11050,null,0,1,to_date('25-MAR-09','DD-MON-RR'),to_date('25-MAR-09','DD-MON-RR'),null,to_date('25-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',4,10087,'testing',to_date('25-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11054,0,null,null,null,11053,null,0,1,to_date('25-MAR-09','DD-MON-RR'),to_date('25-MAR-09','DD-MON-RR'),null,to_date('25-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',4,10087,'testing',to_date('25-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11060,10,null,14697,null,11059,2796,2,1,to_date('25-MAR-09','DD-MON-RR'),to_date('31-MAR-09','DD-MON-RR'),to_date('31-MAR-09','DD-MON-RR'),to_date('25-MAR-09','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('25-MAR-09','DD-MON-RR'),to_date('31-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11084,10,null,1150,null,11083,1150,3,1,to_date('25-MAR-09','DD-MON-RR'),to_date('31-MAR-09','DD-MON-RR'),to_date('31-MAR-09','DD-MON-RR'),to_date('25-MAR-09','DD-MON-RR'),1,51,'MHVSMFOUR, OLIVIA',3,11074,'Facility Switch Test',to_date('25-MAR-09','DD-MON-RR'),to_date('31-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11095,10,null,2796,null,11094,1150,2,1,to_date('25-MAR-09','DD-MON-RR'),to_date('31-MAR-09','DD-MON-RR'),to_date('31-MAR-09','DD-MON-RR'),to_date('25-MAR-09','DD-MON-RR'),1,51,'MHVSMFOUR, OLIVIA',3,11074,'Facility Switch Test',to_date('25-MAR-09','DD-MON-RR'),to_date('31-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11138,0,null,null,null,11083,null,1,1,to_date('25-MAR-09','DD-MON-RR'),to_date('31-MAR-09','DD-MON-RR'),to_date('31-MAR-09','DD-MON-RR'),to_date('25-MAR-09','DD-MON-RR'),1,51,'MHVSMFOUR, OLIVIA',3,11074,'Facility Switch Test',to_date('25-MAR-09','DD-MON-RR'),to_date('31-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11151,0,null,null,null,11083,null,1,1,to_date('25-MAR-09','DD-MON-RR'),to_date('31-MAR-09','DD-MON-RR'),to_date('31-MAR-09','DD-MON-RR'),to_date('25-MAR-09','DD-MON-RR'),1,51,'MHVSMFOUR, OLIVIA',3,11074,'Facility Switch Test',to_date('25-MAR-09','DD-MON-RR'),to_date('31-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11190,20,to_date('26-MAR-09','DD-MON-RR'),2796,null,11189,2796,2,1,to_date('26-MAR-09','DD-MON-RR'),to_date('26-MAR-09','DD-MON-RR'),null,to_date('26-MAR-09','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('26-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11211,0,null,null,null,11210,null,0,1,to_date('26-MAR-09','DD-MON-RR'),to_date('26-MAR-09','DD-MON-RR'),null,to_date('26-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,61,'MHVSMNINE, MABEL',to_date('26-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11220,0,null,null,null,11219,null,0,1,to_date('26-MAR-09','DD-MON-RR'),to_date('26-MAR-09','DD-MON-RR'),null,to_date('26-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,65,'MHVSMELEVEN, JOHN',to_date('26-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11241,20,to_date('26-MAR-09','DD-MON-RR'),2796,null,11240,2796,2,1,to_date('26-MAR-09','DD-MON-RR'),to_date('26-MAR-09','DD-MON-RR'),null,to_date('26-MAR-09','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('26-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11261,0,null,null,null,11260,null,0,1,to_date('27-MAR-09','DD-MON-RR'),to_date('27-MAR-09','DD-MON-RR'),null,to_date('27-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,61,'MHVSMNINE, MABEL',to_date('27-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11266,0,null,null,null,11265,null,0,1,to_date('27-MAR-09','DD-MON-RR'),to_date('27-MAR-09','DD-MON-RR'),null,to_date('27-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,61,'MHVSMNINE, MABEL',to_date('27-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11292,0,null,null,null,11291,null,0,1,to_date('27-MAR-09','DD-MON-RR'),to_date('27-MAR-09','DD-MON-RR'),null,to_date('27-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,61,'MHVSMNINE, MABEL',to_date('27-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11297,0,null,null,null,11296,null,0,1,to_date('27-MAR-09','DD-MON-RR'),to_date('27-MAR-09','DD-MON-RR'),null,to_date('27-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,61,'MHVSMNINE, MABEL',to_date('27-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8666,20,to_date('27-MAR-09','DD-MON-RR'),1150,null,7418,1150,3,1,to_date('06-MAR-09','DD-MON-RR'),to_date('12-MAR-09','DD-MON-RR'),to_date('12-MAR-09','DD-MON-RR'),to_date('06-MAR-09','DD-MON-RR'),1,51,'MHVSMFOUR, OLIVIA',3,989,'Dayton 29',to_date('06-MAR-09','DD-MON-RR'),to_date('12-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8676,10,null,1150,null,8675,1150,3,1,to_date('06-MAR-09','DD-MON-RR'),to_date('12-MAR-09','DD-MON-RR'),to_date('12-MAR-09','DD-MON-RR'),to_date('06-MAR-09','DD-MON-RR'),1,51,'MHVSMFOUR, OLIVIA',3,989,'Dayton 29',to_date('06-MAR-09','DD-MON-RR'),to_date('12-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8689,0,null,null,null,8688,null,1,1,to_date('06-MAR-09','DD-MON-RR'),to_date('12-MAR-09','DD-MON-RR'),to_date('12-MAR-09','DD-MON-RR'),to_date('06-MAR-09','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('06-MAR-09','DD-MON-RR'),to_date('12-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8700,20,to_date('06-MAR-09','DD-MON-RR'),2796,null,8699,2796,2,1,to_date('06-MAR-09','DD-MON-RR'),to_date('06-MAR-09','DD-MON-RR'),null,to_date('06-MAR-09','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('06-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8712,0,null,null,null,8711,null,1,1,to_date('06-MAR-09','DD-MON-RR'),to_date('12-MAR-09','DD-MON-RR'),to_date('12-MAR-09','DD-MON-RR'),to_date('06-MAR-09','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,8598,'Doug Test MHV00004826',to_date('06-MAR-09','DD-MON-RR'),to_date('12-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8775,10,null,2796,null,8774,2796,3,1,to_date('06-MAR-09','DD-MON-RR'),to_date('12-MAR-09','DD-MON-RR'),to_date('12-MAR-09','DD-MON-RR'),to_date('06-MAR-09','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('06-MAR-09','DD-MON-RR'),to_date('12-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8786,0,null,null,null,8785,null,1,1,to_date('06-MAR-09','DD-MON-RR'),to_date('12-MAR-09','DD-MON-RR'),to_date('12-MAR-09','DD-MON-RR'),to_date('06-MAR-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,989,'Dayton 29',to_date('06-MAR-09','DD-MON-RR'),to_date('12-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8797,20,to_date('06-MAR-09','DD-MON-RR'),2796,null,8796,2796,3,1,to_date('06-MAR-09','DD-MON-RR'),to_date('06-MAR-09','DD-MON-RR'),null,to_date('06-MAR-09','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('06-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8808,0,null,null,null,8796,null,0,1,to_date('06-MAR-09','DD-MON-RR'),to_date('06-MAR-09','DD-MON-RR'),null,to_date('06-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,57,'MHVSMSEVEN, BERTHA',to_date('06-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8818,20,to_date('06-MAR-09','DD-MON-RR'),2796,null,8817,2796,2,1,to_date('06-MAR-09','DD-MON-RR'),to_date('06-MAR-09','DD-MON-RR'),null,to_date('06-MAR-09','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('06-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8835,20,to_date('06-MAR-09','DD-MON-RR'),2796,null,8834,2796,3,1,to_date('06-MAR-09','DD-MON-RR'),to_date('06-MAR-09','DD-MON-RR'),null,to_date('06-MAR-09','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('06-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8848,0,null,null,null,8834,null,0,1,to_date('06-MAR-09','DD-MON-RR'),to_date('06-MAR-09','DD-MON-RR'),null,to_date('06-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,57,'MHVSMSEVEN, BERTHA',to_date('06-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8946,0,null,null,null,8774,null,0,1,to_date('06-MAR-09','DD-MON-RR'),to_date('06-MAR-09','DD-MON-RR'),null,to_date('06-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,57,'MHVSMSEVEN, BERTHA',to_date('06-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8952,0,null,null,null,8774,null,1,1,to_date('06-MAR-09','DD-MON-RR'),to_date('12-MAR-09','DD-MON-RR'),to_date('12-MAR-09','DD-MON-RR'),to_date('06-MAR-09','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('06-MAR-09','DD-MON-RR'),to_date('12-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (8979,10,null,2796,null,8978,2796,3,1,to_date('06-MAR-09','DD-MON-RR'),to_date('12-MAR-09','DD-MON-RR'),to_date('12-MAR-09','DD-MON-RR'),to_date('06-MAR-09','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('06-MAR-09','DD-MON-RR'),to_date('12-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (12026,0,null,null,null,12025,null,0,1,to_date('31-MAR-09','DD-MON-RR'),to_date('31-MAR-09','DD-MON-RR'),null,to_date('31-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11690,'Distribution Group 9.1.B - Pat',to_date('31-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (12030,0,null,null,null,12029,null,0,1,to_date('31-MAR-09','DD-MON-RR'),to_date('31-MAR-09','DD-MON-RR'),null,to_date('31-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11690,'Distribution Group 9.1.B - Pat',to_date('31-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (12034,0,null,null,null,12033,null,0,1,to_date('31-MAR-09','DD-MON-RR'),to_date('31-MAR-09','DD-MON-RR'),null,to_date('31-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11690,'Distribution Group 9.1.B - Pat',to_date('31-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (12038,0,null,null,null,12037,null,0,1,to_date('31-MAR-09','DD-MON-RR'),to_date('31-MAR-09','DD-MON-RR'),null,to_date('31-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11690,'Distribution Group 9.1.B - Pat',to_date('31-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (12042,0,null,null,null,12041,null,0,1,to_date('31-MAR-09','DD-MON-RR'),to_date('31-MAR-09','DD-MON-RR'),null,to_date('31-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11690,'Distribution Group 9.1.B - Pat',to_date('31-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (12046,0,null,null,null,12045,null,0,1,to_date('31-MAR-09','DD-MON-RR'),to_date('31-MAR-09','DD-MON-RR'),null,to_date('31-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11690,'Distribution Group 9.1.B - Pat',to_date('31-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (12050,0,null,null,null,12049,null,0,1,to_date('31-MAR-09','DD-MON-RR'),to_date('31-MAR-09','DD-MON-RR'),null,to_date('31-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11690,'Distribution Group 9.1.B - Pat',to_date('31-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (12054,0,null,null,null,12053,null,0,1,to_date('31-MAR-09','DD-MON-RR'),to_date('31-MAR-09','DD-MON-RR'),null,to_date('31-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11690,'Distribution Group 9.1.B - Pat',to_date('31-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (12060,0,null,null,null,12059,null,0,1,to_date('31-MAR-09','DD-MON-RR'),to_date('31-MAR-09','DD-MON-RR'),null,to_date('31-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',1,73,'MHVSMFIFTEEN, YOKO',to_date('31-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (12066,0,null,null,null,12065,null,0,1,to_date('31-MAR-09','DD-MON-RR'),to_date('31-MAR-09','DD-MON-RR'),null,to_date('31-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',2,6705,'GOPARAJU, BHANU',to_date('31-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (12072,0,null,null,null,12071,null,0,1,to_date('31-MAR-09','DD-MON-RR'),to_date('31-MAR-09','DD-MON-RR'),null,to_date('31-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',2,6705,'GOPARAJU, BHANU',to_date('31-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (12080,0,null,null,null,12079,null,0,1,to_date('31-MAR-09','DD-MON-RR'),to_date('31-MAR-09','DD-MON-RR'),null,to_date('31-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',2,6705,'GOPARAJU, BHANU',to_date('31-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (12085,0,null,null,null,11622,null,0,1,to_date('31-MAR-09','DD-MON-RR'),to_date('31-MAR-09','DD-MON-RR'),null,to_date('31-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',2,1154,'Mcdonald, Douglas',to_date('31-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (12102,20,to_date('27-APR-09','DD-MON-RR'),2796,null,12101,2796,5,1,to_date('31-MAR-09','DD-MON-RR'),to_date('31-MAR-09','DD-MON-RR'),null,to_date('31-MAR-09','DD-MON-RR'),2,6705,'GOPARAJU, BHANU',2,2796,'Balasubramanian, Swetha',to_date('31-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (12107,0,null,null,null,12101,null,0,1,to_date('31-MAR-09','DD-MON-RR'),to_date('31-MAR-09','DD-MON-RR'),null,to_date('31-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',2,6705,'GOPARAJU, BHANU',to_date('31-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (12120,0,null,null,null,12119,null,0,1,to_date('31-MAR-09','DD-MON-RR'),to_date('31-MAR-09','DD-MON-RR'),null,to_date('31-MAR-09','DD-MON-RR'),2,6705,'GOPARAJU, BHANU',3,979,'SLC10',to_date('31-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (12124,0,null,null,null,12123,null,0,1,to_date('31-MAR-09','DD-MON-RR'),to_date('31-MAR-09','DD-MON-RR'),null,to_date('31-MAR-09','DD-MON-RR'),2,6705,'GOPARAJU, BHANU',3,979,'SLC10',to_date('31-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (12127,0,null,null,null,12126,null,0,1,to_date('31-MAR-09','DD-MON-RR'),to_date('31-MAR-09','DD-MON-RR'),null,to_date('31-MAR-09','DD-MON-RR'),2,6705,'GOPARAJU, BHANU',3,979,'SLC10',to_date('31-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (12130,0,null,null,null,12129,null,0,1,to_date('31-MAR-09','DD-MON-RR'),to_date('31-MAR-09','DD-MON-RR'),null,to_date('31-MAR-09','DD-MON-RR'),2,6705,'GOPARAJU, BHANU',3,979,'SLC10',to_date('31-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (12134,0,null,null,null,12133,null,0,1,to_date('31-MAR-09','DD-MON-RR'),to_date('31-MAR-09','DD-MON-RR'),null,to_date('31-MAR-09','DD-MON-RR'),2,6705,'GOPARAJU, BHANU',3,979,'SLC10',to_date('31-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (12138,0,null,null,null,12137,null,0,1,to_date('31-MAR-09','DD-MON-RR'),to_date('31-MAR-09','DD-MON-RR'),null,to_date('31-MAR-09','DD-MON-RR'),2,6705,'GOPARAJU, BHANU',3,979,'SLC10',to_date('31-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (12142,0,null,null,null,12141,null,0,1,to_date('31-MAR-09','DD-MON-RR'),to_date('31-MAR-09','DD-MON-RR'),null,to_date('31-MAR-09','DD-MON-RR'),2,6705,'GOPARAJU, BHANU',3,979,'SLC10',to_date('31-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (12146,20,to_date('21-APR-09','DD-MON-RR'),2796,null,12145,2796,2,1,to_date('31-MAR-09','DD-MON-RR'),to_date('31-MAR-09','DD-MON-RR'),null,to_date('31-MAR-09','DD-MON-RR'),2,6705,'GOPARAJU, BHANU',3,979,'SLC10',to_date('31-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (12151,0,null,null,null,12145,null,0,1,to_date('31-MAR-09','DD-MON-RR'),to_date('31-MAR-09','DD-MON-RR'),null,to_date('31-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',2,6705,'GOPARAJU, BHANU',to_date('31-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (12159,0,null,null,null,12158,null,0,1,to_date('31-MAR-09','DD-MON-RR'),to_date('31-MAR-09','DD-MON-RR'),null,to_date('31-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',2,6705,'GOPARAJU, BHANU',to_date('31-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (12285,0,null,null,null,12284,null,1,1,to_date('31-MAR-09','DD-MON-RR'),to_date('04-APR-09','DD-MON-RR'),to_date('04-APR-09','DD-MON-RR'),to_date('31-MAR-09','DD-MON-RR'),1,53,'MHVSMFIVE, EMMA',3,4151,'test for relationship 1',to_date('31-MAR-09','DD-MON-RR'),to_date('04-APR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11558,0,null,null,null,11557,null,0,1,to_date('27-MAR-09','DD-MON-RR'),to_date('27-MAR-09','DD-MON-RR'),null,to_date('27-MAR-09','DD-MON-RR'),2,1154,'Mcdonald, Douglas',1,61,'MHVSMNINE, MABEL',to_date('27-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11590,0,null,null,null,11589,null,0,1,to_date('27-MAR-09','DD-MON-RR'),to_date('27-MAR-09','DD-MON-RR'),null,to_date('27-MAR-09','DD-MON-RR'),2,1154,'Mcdonald, Douglas',4,7561,'Doug Test PDG 01',to_date('27-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (13579,0,null,null,null,13578,null,0,1,to_date('24-APR-09','DD-MON-RR'),to_date('24-APR-09','DD-MON-RR'),null,to_date('24-APR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,61,'MHVSMNINE, MABEL',to_date('24-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (13589,0,null,null,null,13588,null,0,1,to_date('24-APR-09','DD-MON-RR'),to_date('24-APR-09','DD-MON-RR'),null,to_date('24-APR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',4,4382,'\nv\0\\\\k~\%',to_date('24-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (13618,0,null,null,null,13617,null,0,1,to_date('24-APR-09','DD-MON-RR'),to_date('24-APR-09','DD-MON-RR'),null,to_date('24-APR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,57,'MHVSMSEVEN, BERTHA',to_date('24-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (13104,10,null,2796,null,13103,2796,3,1,to_date('22-APR-09','DD-MON-RR'),to_date('28-APR-09','DD-MON-RR'),to_date('28-APR-09','DD-MON-RR'),to_date('22-APR-09','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('22-APR-09','DD-MON-RR'),to_date('28-APR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (13413,0,null,null,null,13103,null,0,1,to_date('22-APR-09','DD-MON-RR'),to_date('22-APR-09','DD-MON-RR'),null,to_date('22-APR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',2,2796,'Balasubramanian, Swetha',to_date('22-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (13420,0,null,null,null,12315,null,0,1,to_date('22-APR-09','DD-MON-RR'),to_date('22-APR-09','DD-MON-RR'),null,to_date('22-APR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',2,2796,'Balasubramanian, Swetha',to_date('22-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11571,0,null,null,null,11570,null,0,1,to_date('27-MAR-09','DD-MON-RR'),to_date('27-MAR-09','DD-MON-RR'),null,to_date('27-MAR-09','DD-MON-RR'),2,1154,'Mcdonald, Douglas',3,9890,'Doug - Triage Alpha',to_date('27-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11575,0,null,null,null,11574,null,0,1,to_date('27-MAR-09','DD-MON-RR'),to_date('27-MAR-09','DD-MON-RR'),null,to_date('27-MAR-09','DD-MON-RR'),2,1154,'Mcdonald, Douglas',3,9890,'Doug - Triage Alpha',to_date('27-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11581,0,null,null,null,11580,null,0,1,to_date('27-MAR-09','DD-MON-RR'),to_date('27-MAR-09','DD-MON-RR'),null,to_date('27-MAR-09','DD-MON-RR'),2,1154,'Mcdonald, Douglas',2,82,'MHVSMSTAFFONE, CAROL',to_date('27-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (13020,0,null,null,null,12697,null,0,1,to_date('21-APR-09','DD-MON-RR'),to_date('21-APR-09','DD-MON-RR'),null,to_date('21-APR-09','DD-MON-RR'),2,1152,'Searcy, Donita',1,73,'MHVSMFIFTEEN, YOKO',to_date('21-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (13090,20,to_date('27-APR-09','DD-MON-RR'),2796,null,13089,2796,3,1,to_date('22-APR-09','DD-MON-RR'),to_date('22-APR-09','DD-MON-RR'),null,to_date('22-APR-09','DD-MON-RR'),2,6705,'GOPARAJU, BHANU',2,2796,'Balasubramanian, Swetha',to_date('22-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (12438,0,null,null,null,12426,null,1,1,to_date('02-APR-09','DD-MON-RR'),to_date('08-APR-09','DD-MON-RR'),to_date('08-APR-09','DD-MON-RR'),to_date('02-APR-09','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,12415,'MK_Dayt29',to_date('02-APR-09','DD-MON-RR'),to_date('08-APR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11551,0,null,null,null,11550,null,0,1,to_date('27-MAR-09','DD-MON-RR'),to_date('27-MAR-09','DD-MON-RR'),null,to_date('27-MAR-09','DD-MON-RR'),2,1154,'Mcdonald, Douglas',1,63,'MHVSMTEN, EDNA',to_date('27-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11563,0,null,null,null,11562,null,0,1,to_date('27-MAR-09','DD-MON-RR'),to_date('27-MAR-09','DD-MON-RR'),null,to_date('27-MAR-09','DD-MON-RR'),2,1154,'Mcdonald, Douglas',3,9890,'Doug - Triage Alpha',to_date('27-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11567,0,null,null,null,11566,null,0,1,to_date('27-MAR-09','DD-MON-RR'),to_date('27-MAR-09','DD-MON-RR'),null,to_date('27-MAR-09','DD-MON-RR'),2,1154,'Mcdonald, Douglas',3,9890,'Doug - Triage Alpha',to_date('27-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (13626,0,null,null,null,13595,null,0,1,to_date('24-APR-09','DD-MON-RR'),to_date('24-APR-09','DD-MON-RR'),null,to_date('24-APR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,57,'MHVSMSEVEN, BERTHA',to_date('24-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (13632,0,null,null,null,13595,null,0,1,to_date('24-APR-09','DD-MON-RR'),to_date('24-APR-09','DD-MON-RR'),null,to_date('24-APR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,57,'MHVSMSEVEN, BERTHA',to_date('24-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (13638,0,null,null,null,13595,null,0,1,to_date('24-APR-09','DD-MON-RR'),to_date('24-APR-09','DD-MON-RR'),null,to_date('24-APR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,57,'MHVSMSEVEN, BERTHA',to_date('24-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11456,20,to_date('04-MAY-09','DD-MON-RR'),2796,null,11455,2796,5,1,to_date('27-MAR-09','DD-MON-RR'),to_date('02-APR-09','DD-MON-RR'),to_date('02-APR-09','DD-MON-RR'),to_date('27-MAR-09','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('27-MAR-09','DD-MON-RR'),to_date('02-APR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11467,0,null,null,null,11388,null,0,1,to_date('27-MAR-09','DD-MON-RR'),to_date('27-MAR-09','DD-MON-RR'),null,to_date('27-MAR-09','DD-MON-RR'),2,1154,'Mcdonald, Douglas',1,61,'MHVSMNINE, MABEL',to_date('27-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11473,0,null,null,null,11399,null,0,1,to_date('27-MAR-09','DD-MON-RR'),to_date('27-MAR-09','DD-MON-RR'),null,to_date('27-MAR-09','DD-MON-RR'),2,1154,'Mcdonald, Douglas',1,61,'MHVSMNINE, MABEL',to_date('27-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11479,0,null,null,null,11410,null,0,1,to_date('27-MAR-09','DD-MON-RR'),to_date('27-MAR-09','DD-MON-RR'),null,to_date('27-MAR-09','DD-MON-RR'),2,1154,'Mcdonald, Douglas',1,61,'MHVSMNINE, MABEL',to_date('27-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11537,0,null,null,null,11536,null,0,1,to_date('27-MAR-09','DD-MON-RR'),to_date('27-MAR-09','DD-MON-RR'),null,to_date('27-MAR-09','DD-MON-RR'),2,1154,'Mcdonald, Douglas',3,9890,'Doug - Triage Alpha',to_date('27-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11491,0,null,null,null,11433,null,0,1,to_date('27-MAR-09','DD-MON-RR'),to_date('27-MAR-09','DD-MON-RR'),null,to_date('27-MAR-09','DD-MON-RR'),2,1154,'Mcdonald, Douglas',1,61,'MHVSMNINE, MABEL',to_date('27-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11497,0,null,null,null,11444,null,0,1,to_date('27-MAR-09','DD-MON-RR'),to_date('27-MAR-09','DD-MON-RR'),null,to_date('27-MAR-09','DD-MON-RR'),2,1154,'Mcdonald, Douglas',1,61,'MHVSMNINE, MABEL',to_date('27-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11541,0,null,null,null,11540,null,0,1,to_date('27-MAR-09','DD-MON-RR'),to_date('27-MAR-09','DD-MON-RR'),null,to_date('27-MAR-09','DD-MON-RR'),2,1154,'Mcdonald, Douglas',3,9890,'Doug - Triage Alpha',to_date('27-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11545,0,null,null,null,11544,null,0,1,to_date('27-MAR-09','DD-MON-RR'),to_date('27-MAR-09','DD-MON-RR'),null,to_date('27-MAR-09','DD-MON-RR'),2,1154,'Mcdonald, Douglas',3,9890,'Doug - Triage Alpha',to_date('27-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11594,0,null,null,null,11593,null,0,1,to_date('27-MAR-09','DD-MON-RR'),to_date('27-MAR-09','DD-MON-RR'),null,to_date('27-MAR-09','DD-MON-RR'),2,1154,'Mcdonald, Douglas',4,7561,'Doug Test PDG 01',to_date('27-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11598,0,null,null,null,11597,null,0,1,to_date('27-MAR-09','DD-MON-RR'),to_date('27-MAR-09','DD-MON-RR'),null,to_date('27-MAR-09','DD-MON-RR'),2,1154,'Mcdonald, Douglas',1,73,'MHVSMFIFTEEN, YOKO',to_date('27-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11602,0,null,null,null,11601,null,0,1,to_date('27-MAR-09','DD-MON-RR'),to_date('27-MAR-09','DD-MON-RR'),null,to_date('27-MAR-09','DD-MON-RR'),2,1154,'Mcdonald, Douglas',1,71,'MHVSMFOURTEEN, RINGO',to_date('27-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11607,0,null,null,null,11606,null,0,1,to_date('27-MAR-09','DD-MON-RR'),to_date('27-MAR-09','DD-MON-RR'),null,to_date('27-MAR-09','DD-MON-RR'),2,1154,'Mcdonald, Douglas',4,7561,'Doug Test PDG 01',to_date('27-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11611,0,null,null,null,11610,null,0,1,to_date('27-MAR-09','DD-MON-RR'),to_date('27-MAR-09','DD-MON-RR'),null,to_date('27-MAR-09','DD-MON-RR'),2,1154,'Mcdonald, Douglas',4,7561,'Doug Test PDG 01',to_date('27-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11615,0,null,null,null,11614,null,0,1,to_date('27-MAR-09','DD-MON-RR'),to_date('27-MAR-09','DD-MON-RR'),null,to_date('27-MAR-09','DD-MON-RR'),2,1154,'Mcdonald, Douglas',3,9890,'Doug - Triage Alpha',to_date('27-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11619,0,null,null,null,11618,null,0,1,to_date('27-MAR-09','DD-MON-RR'),to_date('27-MAR-09','DD-MON-RR'),null,to_date('27-MAR-09','DD-MON-RR'),2,1154,'Mcdonald, Douglas',3,9890,'Doug - Triage Alpha',to_date('27-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11623,0,null,2796,null,11622,null,1,1,to_date('27-MAR-09','DD-MON-RR'),to_date('27-MAR-09','DD-MON-RR'),null,to_date('27-MAR-09','DD-MON-RR'),2,1154,'Mcdonald, Douglas',3,9890,'Doug - Triage Alpha',to_date('27-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11627,0,null,null,null,11626,null,0,1,to_date('27-MAR-09','DD-MON-RR'),to_date('27-MAR-09','DD-MON-RR'),null,to_date('27-MAR-09','DD-MON-RR'),2,1154,'Mcdonald, Douglas',3,9890,'Doug - Triage Alpha',to_date('27-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11652,0,null,null,null,227,null,0,1,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,to_date('30-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',1,29,'MHVSMONE, ALYSSA',to_date('30-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11668,0,null,null,null,11667,null,0,1,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,to_date('30-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11666,'Distribution Group 9.1.B',to_date('30-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9541,0,null,null,null,9462,null,0,1,to_date('11-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),null,to_date('11-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',2,6705,'GOPARAJU, BHANU',to_date('11-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9574,0,null,null,null,9573,null,0,1,to_date('11-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),null,to_date('11-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('11-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9578,0,null,null,null,9577,null,0,1,to_date('11-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),null,to_date('11-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('11-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9581,0,null,null,null,9580,null,0,1,to_date('11-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),null,to_date('11-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('11-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9584,0,null,null,null,9583,null,0,1,to_date('11-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),null,to_date('11-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('11-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9588,0,null,null,null,9587,null,0,1,to_date('11-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),null,to_date('11-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('11-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9592,0,null,null,null,9591,null,0,1,to_date('11-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),null,to_date('11-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('11-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9597,0,null,null,null,9596,null,0,1,to_date('11-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),null,to_date('11-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('11-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9601,0,null,null,null,9600,null,0,1,to_date('11-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),null,to_date('11-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,979,'SLC10',to_date('11-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9608,0,null,null,null,9499,null,1,1,to_date('11-MAR-09','DD-MON-RR'),to_date('17-MAR-09','DD-MON-RR'),to_date('17-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),1,51,'MHVSMFOUR, OLIVIA',3,4151,'test for relationship 1',to_date('11-MAR-09','DD-MON-RR'),to_date('17-MAR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9616,0,null,null,null,9615,null,0,1,to_date('11-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),null,to_date('11-MAR-09','DD-MON-RR'),2,1154,'Mcdonald, Douglas',2,2796,'Balasubramanian, Swetha',to_date('11-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9621,0,null,null,null,9620,null,0,1,to_date('11-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),null,to_date('11-MAR-09','DD-MON-RR'),2,1154,'Mcdonald, Douglas',3,979,'SLC10',to_date('11-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9625,0,null,null,null,9624,null,0,1,to_date('11-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),null,to_date('11-MAR-09','DD-MON-RR'),2,1154,'Mcdonald, Douglas',3,979,'SLC10',to_date('11-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9628,0,null,null,null,9627,null,0,1,to_date('11-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),null,to_date('11-MAR-09','DD-MON-RR'),2,1154,'Mcdonald, Douglas',3,979,'SLC10',to_date('11-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9631,0,null,null,null,9630,null,0,1,to_date('11-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),null,to_date('11-MAR-09','DD-MON-RR'),2,1154,'Mcdonald, Douglas',3,979,'SLC10',to_date('11-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9635,0,null,null,null,9634,null,0,1,to_date('11-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),null,to_date('11-MAR-09','DD-MON-RR'),2,1154,'Mcdonald, Douglas',3,979,'SLC10',to_date('11-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9639,0,null,null,null,9638,null,0,1,to_date('11-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),null,to_date('11-MAR-09','DD-MON-RR'),2,1154,'Mcdonald, Douglas',3,979,'SLC10',to_date('11-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9643,0,null,2796,null,9642,null,1,1,to_date('11-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),null,to_date('11-MAR-09','DD-MON-RR'),2,1154,'Mcdonald, Douglas',3,979,'SLC10',to_date('11-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9647,0,null,null,null,9646,null,0,1,to_date('11-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),null,to_date('11-MAR-09','DD-MON-RR'),2,1154,'Mcdonald, Douglas',3,979,'SLC10',to_date('11-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9668,10,null,2796,null,9667,2796,2,1,to_date('11-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),null,to_date('11-MAR-09','DD-MON-RR'),2,6705,'GOPARAJU, BHANU',2,2796,'Balasubramanian, Swetha',to_date('11-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (9677,0,null,6705,null,9676,null,1,1,to_date('11-MAR-09','DD-MON-RR'),to_date('11-MAR-09','DD-MON-RR'),null,to_date('11-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,9441,'Bhanu test team 2',to_date('11-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11847,0,null,null,null,11846,null,0,1,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,to_date('30-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11690,'Distribution Group 9.1.B - Pat',to_date('30-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11850,0,null,null,null,11849,null,0,1,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,to_date('30-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11690,'Distribution Group 9.1.B - Pat',to_date('30-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11854,0,null,null,null,11853,null,0,1,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,to_date('30-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11690,'Distribution Group 9.1.B - Pat',to_date('30-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11858,0,null,null,null,11857,null,0,1,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,to_date('30-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11690,'Distribution Group 9.1.B - Pat',to_date('30-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11862,0,null,null,null,11861,null,0,1,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,to_date('30-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11690,'Distribution Group 9.1.B - Pat',to_date('30-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11866,0,null,null,null,11865,null,0,1,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,to_date('30-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11690,'Distribution Group 9.1.B - Pat',to_date('30-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11870,0,null,null,null,11869,null,0,1,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,to_date('30-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11690,'Distribution Group 9.1.B - Pat',to_date('30-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11874,0,null,null,null,11873,null,0,1,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,to_date('30-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11690,'Distribution Group 9.1.B - Pat',to_date('30-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11879,0,null,null,null,11878,null,0,1,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,to_date('30-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11690,'Distribution Group 9.1.B - Pat',to_date('30-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11883,0,null,null,null,11882,null,0,1,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,to_date('30-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11690,'Distribution Group 9.1.B - Pat',to_date('30-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11887,0,null,null,null,11886,null,0,1,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,to_date('30-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11690,'Distribution Group 9.1.B - Pat',to_date('30-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11891,0,null,null,null,11890,null,0,1,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,to_date('30-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11690,'Distribution Group 9.1.B - Pat',to_date('30-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11894,0,null,null,null,11893,null,0,1,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,to_date('30-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11690,'Distribution Group 9.1.B - Pat',to_date('30-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11898,0,null,null,null,11897,null,0,1,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,to_date('30-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11690,'Distribution Group 9.1.B - Pat',to_date('30-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11902,0,null,null,null,11901,null,0,1,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,to_date('30-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11690,'Distribution Group 9.1.B - Pat',to_date('30-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11906,0,null,null,null,11905,null,0,1,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,to_date('30-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11690,'Distribution Group 9.1.B - Pat',to_date('30-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11910,0,null,null,null,11909,null,0,1,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,to_date('30-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11690,'Distribution Group 9.1.B - Pat',to_date('30-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11914,0,null,null,null,11913,null,0,1,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,to_date('30-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11690,'Distribution Group 9.1.B - Pat',to_date('30-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11918,0,null,null,null,11917,null,0,1,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,to_date('30-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11690,'Distribution Group 9.1.B - Pat',to_date('30-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11935,0,null,null,null,11934,null,1,1,to_date('30-MAR-09','DD-MON-RR'),to_date('03-APR-09','DD-MON-RR'),to_date('03-APR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),1,51,'MHVSMFOUR, OLIVIA',3,11923,'Dayt29 to SLC10 Triage Switch',to_date('30-MAR-09','DD-MON-RR'),to_date('03-APR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11953,10,null,1154,null,11952,1154,3,1,to_date('30-MAR-09','DD-MON-RR'),to_date('03-APR-09','DD-MON-RR'),to_date('03-APR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('30-MAR-09','DD-MON-RR'),to_date('03-APR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11964,10,null,1154,null,11963,1154,3,1,to_date('30-MAR-09','DD-MON-RR'),to_date('03-APR-09','DD-MON-RR'),to_date('03-APR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('30-MAR-09','DD-MON-RR'),to_date('03-APR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11976,0,null,null,null,11952,null,0,1,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,to_date('30-MAR-09','DD-MON-RR'),2,1154,'Mcdonald, Douglas',1,61,'MHVSMNINE, MABEL',to_date('30-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11982,0,null,null,null,11963,null,0,1,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,to_date('30-MAR-09','DD-MON-RR'),2,1154,'Mcdonald, Douglas',1,61,'MHVSMNINE, MABEL',to_date('30-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11997,0,null,null,null,11996,null,0,1,to_date('31-MAR-09','DD-MON-RR'),to_date('31-MAR-09','DD-MON-RR'),null,to_date('31-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11666,'Distribution Group 9.1.B',to_date('31-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (12001,0,null,null,null,12000,null,0,1,to_date('31-MAR-09','DD-MON-RR'),to_date('31-MAR-09','DD-MON-RR'),null,to_date('31-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11666,'Distribution Group 9.1.B',to_date('31-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (12005,0,null,null,null,12004,null,0,1,to_date('31-MAR-09','DD-MON-RR'),to_date('31-MAR-09','DD-MON-RR'),null,to_date('31-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11666,'Distribution Group 9.1.B',to_date('31-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (12009,0,null,null,null,12008,null,0,1,to_date('31-MAR-09','DD-MON-RR'),to_date('31-MAR-09','DD-MON-RR'),null,to_date('31-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11666,'Distribution Group 9.1.B',to_date('31-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (12012,0,null,null,null,12011,null,0,1,to_date('31-MAR-09','DD-MON-RR'),to_date('31-MAR-09','DD-MON-RR'),null,to_date('31-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11666,'Distribution Group 9.1.B',to_date('31-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (12018,0,null,null,null,12017,null,0,1,to_date('31-MAR-09','DD-MON-RR'),to_date('31-MAR-09','DD-MON-RR'),null,to_date('31-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11690,'Distribution Group 9.1.B - Pat',to_date('31-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (12022,0,null,null,null,12021,null,0,1,to_date('31-MAR-09','DD-MON-RR'),to_date('31-MAR-09','DD-MON-RR'),null,to_date('31-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11690,'Distribution Group 9.1.B - Pat',to_date('31-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (12847,10,null,6705,null,12846,2796,2,1,to_date('21-APR-09','DD-MON-RR'),to_date('25-APR-09','DD-MON-RR'),to_date('25-APR-09','DD-MON-RR'),to_date('21-APR-09','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('21-APR-09','DD-MON-RR'),to_date('25-APR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (12867,20,to_date('21-APR-09','DD-MON-RR'),1150,null,12866,1150,2,1,to_date('21-APR-09','DD-MON-RR'),to_date('21-APR-09','DD-MON-RR'),null,to_date('21-APR-09','DD-MON-RR'),1,51,'MHVSMFOUR, OLIVIA',3,12185,'       ''s Clinic Association Test',to_date('21-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (12883,10,null,2796,null,12315,2796,2,1,to_date('21-APR-09','DD-MON-RR'),to_date('21-APR-09','DD-MON-RR'),null,to_date('21-APR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,61,'MHVSMNINE, MABEL',to_date('21-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (12905,0,null,null,null,12904,null,0,1,to_date('21-APR-09','DD-MON-RR'),to_date('21-APR-09','DD-MON-RR'),null,to_date('21-APR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,12890,'swetha test',to_date('21-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (12909,0,null,null,null,12908,null,0,1,to_date('21-APR-09','DD-MON-RR'),to_date('21-APR-09','DD-MON-RR'),null,to_date('21-APR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',3,12890,'swetha test',to_date('21-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (13032,10,null,2796,null,12101,2796,2,1,to_date('21-APR-09','DD-MON-RR'),to_date('21-APR-09','DD-MON-RR'),null,to_date('21-APR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',2,6705,'GOPARAJU, BHANU',to_date('21-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (13052,20,to_date('21-APR-09','DD-MON-RR'),2796,null,12101,2796,3,1,to_date('21-APR-09','DD-MON-RR'),to_date('21-APR-09','DD-MON-RR'),null,to_date('21-APR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',2,2796,'Balasubramanian, Swetha',to_date('21-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (13060,0,null,null,null,12101,null,0,1,to_date('21-APR-09','DD-MON-RR'),to_date('21-APR-09','DD-MON-RR'),null,to_date('21-APR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',2,2796,'Balasubramanian, Swetha',to_date('21-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (13067,10,null,2796,null,12101,2796,2,1,to_date('21-APR-09','DD-MON-RR'),to_date('21-APR-09','DD-MON-RR'),null,to_date('21-APR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',2,6705,'GOPARAJU, BHANU',to_date('21-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (13075,0,null,null,null,12101,null,0,1,to_date('21-APR-09','DD-MON-RR'),to_date('21-APR-09','DD-MON-RR'),null,to_date('21-APR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',2,2796,'Balasubramanian, Swetha',to_date('21-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (13117,10,null,6705,null,13103,2796,2,1,to_date('22-APR-09','DD-MON-RR'),to_date('22-APR-09','DD-MON-RR'),null,to_date('22-APR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,61,'MHVSMNINE, MABEL',to_date('22-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (14194,0,null,null,null,14193,null,0,1,to_date('27-APR-09','DD-MON-RR'),to_date('27-APR-09','DD-MON-RR'),null,to_date('27-APR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,14128,'Patient Distr Group 9.1C',to_date('27-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (14200,0,null,null,null,14199,null,0,1,to_date('27-APR-09','DD-MON-RR'),to_date('27-APR-09','DD-MON-RR'),null,to_date('27-APR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,14128,'Patient Distr Group 9.1C',to_date('27-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (14204,0,null,null,null,14203,null,0,1,to_date('27-APR-09','DD-MON-RR'),to_date('27-APR-09','DD-MON-RR'),null,to_date('27-APR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,14128,'Patient Distr Group 9.1C',to_date('27-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (14208,0,null,null,null,14207,null,0,1,to_date('27-APR-09','DD-MON-RR'),to_date('27-APR-09','DD-MON-RR'),null,to_date('27-APR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,14128,'Patient Distr Group 9.1C',to_date('27-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (14213,0,null,null,null,14212,null,0,1,to_date('27-APR-09','DD-MON-RR'),to_date('27-APR-09','DD-MON-RR'),null,to_date('27-APR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,14127,'Clinician Distr Group 9.1C',to_date('27-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (14217,0,null,null,null,14216,null,0,1,to_date('27-APR-09','DD-MON-RR'),to_date('27-APR-09','DD-MON-RR'),null,to_date('27-APR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,14127,'Clinician Distr Group 9.1C',to_date('27-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (14221,0,null,null,null,14220,null,0,1,to_date('27-APR-09','DD-MON-RR'),to_date('27-APR-09','DD-MON-RR'),null,to_date('27-APR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,14126,'Clin/Pat Dist Group 9.1C',to_date('27-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (14225,0,null,null,null,14224,null,0,1,to_date('27-APR-09','DD-MON-RR'),to_date('27-APR-09','DD-MON-RR'),null,to_date('27-APR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,14126,'Clin/Pat Dist Group 9.1C',to_date('27-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (14229,0,null,null,null,14228,null,0,1,to_date('27-APR-09','DD-MON-RR'),to_date('27-APR-09','DD-MON-RR'),null,to_date('27-APR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,14126,'Clin/Pat Dist Group 9.1C',to_date('27-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (14233,0,null,null,null,14232,null,0,1,to_date('27-APR-09','DD-MON-RR'),to_date('27-APR-09','DD-MON-RR'),null,to_date('27-APR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,14126,'Clin/Pat Dist Group 9.1C',to_date('27-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (14237,0,null,null,null,14236,null,0,1,to_date('27-APR-09','DD-MON-RR'),to_date('27-APR-09','DD-MON-RR'),null,to_date('27-APR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,14126,'Clin/Pat Dist Group 9.1C',to_date('27-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (14241,0,null,null,null,14240,null,0,1,to_date('27-APR-09','DD-MON-RR'),to_date('27-APR-09','DD-MON-RR'),null,to_date('27-APR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,14126,'Clin/Pat Dist Group 9.1C',to_date('27-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (14245,0,null,null,null,14244,null,0,1,to_date('27-APR-09','DD-MON-RR'),to_date('27-APR-09','DD-MON-RR'),null,to_date('27-APR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,14126,'Clin/Pat Dist Group 9.1C',to_date('27-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (14249,0,null,null,null,14248,null,0,1,to_date('27-APR-09','DD-MON-RR'),to_date('27-APR-09','DD-MON-RR'),null,to_date('27-APR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,14126,'Clin/Pat Dist Group 9.1C',to_date('27-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (14252,0,null,null,null,14251,null,0,1,to_date('27-APR-09','DD-MON-RR'),to_date('27-APR-09','DD-MON-RR'),null,to_date('27-APR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,14126,'Clin/Pat Dist Group 9.1C',to_date('27-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (14258,0,null,null,null,14157,null,0,1,to_date('28-APR-09','DD-MON-RR'),to_date('28-APR-09','DD-MON-RR'),null,to_date('28-APR-09','DD-MON-RR'),2,1150,'Prematta,        ',2,1152,'Searcy, Donita',to_date('28-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (14264,0,null,null,null,14169,null,0,1,to_date('28-APR-09','DD-MON-RR'),to_date('28-APR-09','DD-MON-RR'),null,to_date('28-APR-09','DD-MON-RR'),2,1150,'Prematta,        ',2,1152,'Searcy, Donita',to_date('28-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (14534,20,to_date('04-MAY-09','DD-MON-RR'),79,null,14533,79,3,1,to_date('04-MAY-09','DD-MON-RR'),to_date('04-MAY-09','DD-MON-RR'),null,to_date('04-MAY-09','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,12415,'MK_Dayt29_TG1',to_date('04-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11672,0,null,null,null,11671,null,0,1,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,to_date('30-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11666,'Distribution Group 9.1.B',to_date('30-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11675,0,null,null,null,11674,null,0,1,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,to_date('30-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11666,'Distribution Group 9.1.B',to_date('30-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11679,0,null,null,null,11678,null,0,1,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,to_date('30-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11666,'Distribution Group 9.1.B',to_date('30-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11683,0,null,null,null,11682,null,0,1,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,to_date('30-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11666,'Distribution Group 9.1.B',to_date('30-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (13450,0,null,null,null,12315,null,0,1,to_date('22-APR-09','DD-MON-RR'),to_date('22-APR-09','DD-MON-RR'),null,to_date('22-APR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',2,2796,'Balasubramanian, Swetha',to_date('22-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (13465,0,null,null,null,13464,null,0,1,to_date('22-APR-09','DD-MON-RR'),to_date('22-APR-09','DD-MON-RR'),null,to_date('22-APR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',4,13463,'swetha test',to_date('22-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (13469,0,null,null,null,13468,null,0,1,to_date('22-APR-09','DD-MON-RR'),to_date('22-APR-09','DD-MON-RR'),null,to_date('22-APR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',4,13463,'swetha test',to_date('22-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (13473,0,null,null,null,13472,null,0,1,to_date('22-APR-09','DD-MON-RR'),to_date('22-APR-09','DD-MON-RR'),null,to_date('22-APR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',4,13463,'swetha test',to_date('22-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (13596,10,null,2796,null,13595,6705,4,1,to_date('24-APR-09','DD-MON-RR'),to_date('30-APR-09','DD-MON-RR'),to_date('30-APR-09','DD-MON-RR'),to_date('24-APR-09','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('24-APR-09','DD-MON-RR'),to_date('30-APR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (13497,10,null,2796,null,13496,2796,3,1,to_date('23-APR-09','DD-MON-RR'),to_date('29-APR-09','DD-MON-RR'),to_date('29-APR-09','DD-MON-RR'),to_date('23-APR-09','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('23-APR-09','DD-MON-RR'),to_date('29-APR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (13509,0,null,null,null,13496,null,0,1,to_date('23-APR-09','DD-MON-RR'),to_date('23-APR-09','DD-MON-RR'),null,to_date('23-APR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,57,'MHVSMSEVEN, BERTHA',to_date('23-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (13861,0,null,null,null,13595,null,0,1,to_date('27-APR-09','DD-MON-RR'),to_date('27-APR-09','DD-MON-RR'),null,to_date('27-APR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,57,'MHVSMSEVEN, BERTHA',to_date('27-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (13884,0,null,null,null,13089,null,0,1,to_date('27-APR-09','DD-MON-RR'),to_date('27-APR-09','DD-MON-RR'),null,to_date('27-APR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',2,2796,'Balasubramanian, Swetha',to_date('27-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (13889,0,null,null,null,12101,null,0,1,to_date('27-APR-09','DD-MON-RR'),to_date('27-APR-09','DD-MON-RR'),null,to_date('27-APR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',2,6705,'GOPARAJU, BHANU',to_date('27-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (13910,0,null,null,null,13896,null,0,1,to_date('27-APR-09','DD-MON-RR'),to_date('27-APR-09','DD-MON-RR'),null,to_date('27-APR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,57,'MHVSMSEVEN, BERTHA',to_date('27-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (13936,0,null,null,null,12101,null,0,1,to_date('27-APR-09','DD-MON-RR'),to_date('27-APR-09','DD-MON-RR'),null,to_date('27-APR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',2,6705,'GOPARAJU, BHANU',to_date('27-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (13947,0,null,null,null,13916,null,0,1,to_date('27-APR-09','DD-MON-RR'),to_date('27-APR-09','DD-MON-RR'),null,to_date('27-APR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,57,'MHVSMSEVEN, BERTHA',to_date('27-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (13951,0,null,null,null,13916,null,0,1,to_date('27-APR-09','DD-MON-RR'),to_date('27-APR-09','DD-MON-RR'),null,to_date('27-APR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,57,'MHVSMSEVEN, BERTHA',to_date('27-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (13978,0,null,null,null,13977,null,0,1,to_date('27-APR-09','DD-MON-RR'),to_date('27-APR-09','DD-MON-RR'),null,to_date('27-APR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',2,1154,'Mcdonald, Douglas',to_date('27-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (14130,0,null,null,null,14129,null,0,1,to_date('27-APR-09','DD-MON-RR'),to_date('27-APR-09','DD-MON-RR'),null,to_date('27-APR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,14126,'Clin/Pat Dist Group 9.1C',to_date('27-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (14134,0,null,null,null,14133,null,0,1,to_date('27-APR-09','DD-MON-RR'),to_date('27-APR-09','DD-MON-RR'),null,to_date('27-APR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,14126,'Clin/Pat Dist Group 9.1C',to_date('27-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (14138,0,null,null,null,14137,null,0,1,to_date('27-APR-09','DD-MON-RR'),to_date('27-APR-09','DD-MON-RR'),null,to_date('27-APR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,14126,'Clin/Pat Dist Group 9.1C',to_date('27-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (14142,0,null,null,null,14141,null,0,1,to_date('27-APR-09','DD-MON-RR'),to_date('27-APR-09','DD-MON-RR'),null,to_date('27-APR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,14126,'Clin/Pat Dist Group 9.1C',to_date('27-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (14146,0,null,null,null,14145,null,0,1,to_date('27-APR-09','DD-MON-RR'),to_date('27-APR-09','DD-MON-RR'),null,to_date('27-APR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,14126,'Clin/Pat Dist Group 9.1C',to_date('27-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (14150,0,null,null,null,14149,null,0,1,to_date('27-APR-09','DD-MON-RR'),to_date('27-APR-09','DD-MON-RR'),null,to_date('27-APR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,14126,'Clin/Pat Dist Group 9.1C',to_date('27-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (14154,0,null,null,null,14153,null,0,1,to_date('27-APR-09','DD-MON-RR'),to_date('27-APR-09','DD-MON-RR'),null,to_date('27-APR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,14126,'Clin/Pat Dist Group 9.1C',to_date('27-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (14158,10,null,1150,null,14157,1150,2,1,to_date('27-APR-09','DD-MON-RR'),to_date('27-APR-09','DD-MON-RR'),null,to_date('27-APR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,14126,'Clin/Pat Dist Group 9.1C',to_date('27-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (14162,0,null,null,null,14161,null,0,1,to_date('27-APR-09','DD-MON-RR'),to_date('27-APR-09','DD-MON-RR'),null,to_date('27-APR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,14126,'Clin/Pat Dist Group 9.1C',to_date('27-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (14165,0,null,null,null,14164,null,0,1,to_date('27-APR-09','DD-MON-RR'),to_date('27-APR-09','DD-MON-RR'),null,to_date('27-APR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,14126,'Clin/Pat Dist Group 9.1C',to_date('27-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (14170,10,null,1150,null,14169,1150,2,1,to_date('27-APR-09','DD-MON-RR'),to_date('27-APR-09','DD-MON-RR'),null,to_date('27-APR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,14127,'Clinician Distr Group 9.1C',to_date('27-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (14174,0,null,null,null,14173,null,0,1,to_date('27-APR-09','DD-MON-RR'),to_date('27-APR-09','DD-MON-RR'),null,to_date('27-APR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,14127,'Clinician Distr Group 9.1C',to_date('27-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (14178,0,null,null,null,14177,null,0,1,to_date('27-APR-09','DD-MON-RR'),to_date('27-APR-09','DD-MON-RR'),null,to_date('27-APR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,14127,'Clinician Distr Group 9.1C',to_date('27-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (14182,0,null,null,null,14181,null,0,1,to_date('27-APR-09','DD-MON-RR'),to_date('27-APR-09','DD-MON-RR'),null,to_date('27-APR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,14128,'Patient Distr Group 9.1C',to_date('27-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (14186,0,null,null,null,14185,null,0,1,to_date('27-APR-09','DD-MON-RR'),to_date('27-APR-09','DD-MON-RR'),null,to_date('27-APR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,14128,'Patient Distr Group 9.1C',to_date('27-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (14190,0,null,null,null,14189,null,0,1,to_date('27-APR-09','DD-MON-RR'),to_date('27-APR-09','DD-MON-RR'),null,to_date('27-APR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,14128,'Patient Distr Group 9.1C',to_date('27-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (12294,0,null,null,null,12293,null,0,1,to_date('31-MAR-09','DD-MON-RR'),to_date('31-MAR-09','DD-MON-RR'),null,to_date('31-MAR-09','DD-MON-RR'),2,1154,'Mcdonald, Douglas',1,73,'MHVSMFIFTEEN, YOKO',to_date('31-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (12316,20,to_date('04-MAY-09','DD-MON-RR'),2796,null,12315,2796,4,1,to_date('31-MAR-09','DD-MON-RR'),to_date('04-APR-09','DD-MON-RR'),to_date('04-APR-09','DD-MON-RR'),to_date('31-MAR-09','DD-MON-RR'),1,61,'MHVSMNINE, MABEL',3,979,'SLC10',to_date('31-MAR-09','DD-MON-RR'),to_date('04-APR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (12336,0,null,null,null,12315,null,0,1,to_date('31-MAR-09','DD-MON-RR'),to_date('31-MAR-09','DD-MON-RR'),null,to_date('31-MAR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,61,'MHVSMNINE, MABEL',to_date('31-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (12427,0,null,null,null,12426,null,0,1,to_date('02-APR-09','DD-MON-RR'),to_date('02-APR-09','DD-MON-RR'),null,to_date('02-APR-09','DD-MON-RR'),2,12397,'KETHA, MASTAN',1,29,'MHVSMONE, ALYSSA',to_date('02-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15821,0,null,null,null,15820,null,0,1,to_date('08-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),null,to_date('08-MAY-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,15819,'Create Clin Distr Grp 9.1D',to_date('08-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15824,0,null,null,null,15823,null,0,1,to_date('08-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),null,to_date('08-MAY-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,15819,'Create Clin Distr Grp 9.1D',to_date('08-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15830,0,null,null,null,15829,null,0,1,to_date('08-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),null,to_date('08-MAY-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,15828,'Create Pat Distr Grp 9.1D',to_date('08-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15834,0,null,null,null,15833,null,0,1,to_date('08-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),null,to_date('08-MAY-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,15828,'Create Pat Distr Grp 9.1D',to_date('08-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15838,0,null,null,null,15837,null,0,1,to_date('08-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),null,to_date('08-MAY-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,15828,'Create Pat Distr Grp 9.1D',to_date('08-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15842,0,null,null,null,15841,null,0,1,to_date('08-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),null,to_date('08-MAY-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,15828,'Create Pat Distr Grp 9.1D',to_date('08-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15846,0,null,null,null,15845,null,0,1,to_date('08-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),null,to_date('08-MAY-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,15828,'Create Pat Distr Grp 9.1D',to_date('08-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15850,0,null,null,null,15849,null,0,1,to_date('08-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),null,to_date('08-MAY-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,15828,'Create Pat Distr Grp 9.1D',to_date('08-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15854,0,null,null,null,15853,null,0,1,to_date('08-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),null,to_date('08-MAY-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,15828,'Create Pat Distr Grp 9.1D',to_date('08-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15858,0,null,null,null,15857,null,0,1,to_date('08-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),null,to_date('08-MAY-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,15828,'Create Pat Distr Grp 9.1D',to_date('08-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15862,0,null,null,null,15861,null,0,1,to_date('08-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),null,to_date('08-MAY-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,15828,'Create Pat Distr Grp 9.1D',to_date('08-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15866,0,null,null,null,15865,null,0,1,to_date('08-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),null,to_date('08-MAY-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,15828,'Create Pat Distr Grp 9.1D',to_date('08-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15870,0,null,null,null,15869,null,0,1,to_date('08-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),null,to_date('08-MAY-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,15828,'Create Pat Distr Grp 9.1D',to_date('08-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15874,0,null,null,null,15873,null,0,1,to_date('08-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),null,to_date('08-MAY-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,15828,'Create Pat Distr Grp 9.1D',to_date('08-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15879,0,null,null,null,15878,null,0,1,to_date('08-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),null,to_date('08-MAY-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,15819,'Create Clin Distr Grp 9.1D',to_date('08-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15882,10,null,1150,null,15881,1150,2,1,to_date('08-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),null,to_date('08-MAY-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,15819,'Create Clin Distr Grp 9.1D',to_date('08-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15887,0,null,null,null,15886,null,0,1,to_date('08-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),null,to_date('08-MAY-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,15819,'Create Clin Distr Grp 9.1D',to_date('08-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15891,0,null,null,null,15890,null,0,1,to_date('08-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),null,to_date('08-MAY-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,15819,'Create Clin Distr Grp 9.1D',to_date('08-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15895,0,null,null,null,15894,null,0,1,to_date('08-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),null,to_date('08-MAY-09','DD-MON-RR'),2,14698,'SEARCY, DONITA',3,979,'SLC10',to_date('08-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15899,0,null,null,null,15898,null,0,1,to_date('08-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),null,to_date('08-MAY-09','DD-MON-RR'),2,14698,'SEARCY, DONITA',3,979,'SLC10',to_date('08-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15902,0,null,null,null,15901,null,0,1,to_date('08-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),null,to_date('08-MAY-09','DD-MON-RR'),2,14698,'SEARCY, DONITA',3,979,'SLC10',to_date('08-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15906,0,null,null,null,15905,null,0,1,to_date('08-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),null,to_date('08-MAY-09','DD-MON-RR'),2,14698,'SEARCY, DONITA',3,979,'SLC10',to_date('08-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15911,0,null,null,null,15910,null,0,1,to_date('08-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),null,to_date('08-MAY-09','DD-MON-RR'),2,14698,'SEARCY, DONITA',3,979,'SLC10',to_date('08-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15915,0,null,null,null,15914,null,0,1,to_date('08-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),null,to_date('08-MAY-09','DD-MON-RR'),2,14698,'SEARCY, DONITA',3,979,'SLC10',to_date('08-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15919,0,null,null,null,15918,null,0,1,to_date('08-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),null,to_date('08-MAY-09','DD-MON-RR'),2,14698,'SEARCY, DONITA',3,979,'SLC10',to_date('08-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15923,0,null,null,null,15922,null,0,1,to_date('08-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),null,to_date('08-MAY-09','DD-MON-RR'),2,14698,'SEARCY, DONITA',3,979,'SLC10',to_date('08-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15927,0,null,null,null,15926,null,0,1,to_date('08-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),null,to_date('08-MAY-09','DD-MON-RR'),2,14698,'SEARCY, DONITA',3,979,'SLC10',to_date('08-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15931,0,null,null,null,15930,null,0,1,to_date('08-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),null,to_date('08-MAY-09','DD-MON-RR'),2,14698,'SEARCY, DONITA',3,979,'SLC10',to_date('08-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15935,0,null,null,null,15934,null,0,1,to_date('08-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),null,to_date('08-MAY-09','DD-MON-RR'),2,14698,'SEARCY, DONITA',3,979,'SLC10',to_date('08-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15942,0,null,null,null,15941,null,0,1,to_date('08-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),null,to_date('08-MAY-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,15819,'Create Clin Distr Grp 9.1D',to_date('08-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15947,0,null,null,null,15946,null,0,1,to_date('08-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),null,to_date('08-MAY-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,15806,'Create Clin/Pat Distr Grp 9.1D',to_date('08-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15951,0,null,null,null,15950,null,0,1,to_date('08-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),null,to_date('08-MAY-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,15806,'Create Clin/Pat Distr Grp 9.1D',to_date('08-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15956,0,null,null,null,15881,null,0,1,to_date('08-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),null,to_date('08-MAY-09','DD-MON-RR'),2,1150,'Prematta,        ',2,1152,'Searcy, Donita',to_date('08-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15968,20,to_date('12-MAY-09','DD-MON-RR'),2796,null,15731,2796,3,1,to_date('08-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),null,to_date('08-MAY-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,979,'SLC10',to_date('08-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15983,20,to_date('20-MAY-09','DD-MON-RR'),1152,null,15807,1152,3,1,to_date('08-MAY-09','DD-MON-RR'),to_date('14-MAY-09','DD-MON-RR'),to_date('14-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,989,'Dayton 29',to_date('08-MAY-09','DD-MON-RR'),to_date('14-MAY-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (16011,0,null,null,null,16010,null,1,1,to_date('11-MAY-09','DD-MON-RR'),to_date('15-MAY-09','DD-MON-RR'),to_date('15-MAY-09','DD-MON-RR'),to_date('11-MAY-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,979,'SLC10',to_date('11-MAY-09','DD-MON-RR'),to_date('15-MAY-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (16026,0,null,null,null,16025,null,1,1,to_date('11-MAY-09','DD-MON-RR'),to_date('15-MAY-09','DD-MON-RR'),to_date('15-MAY-09','DD-MON-RR'),to_date('11-MAY-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,979,'SLC10',to_date('11-MAY-09','DD-MON-RR'),to_date('15-MAY-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (16041,0,null,null,null,16040,null,1,1,to_date('11-MAY-09','DD-MON-RR'),to_date('15-MAY-09','DD-MON-RR'),to_date('15-MAY-09','DD-MON-RR'),to_date('11-MAY-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,979,'SLC10',to_date('11-MAY-09','DD-MON-RR'),to_date('15-MAY-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (16056,0,null,null,null,16055,null,1,1,to_date('11-MAY-09','DD-MON-RR'),to_date('15-MAY-09','DD-MON-RR'),to_date('15-MAY-09','DD-MON-RR'),to_date('11-MAY-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,979,'SLC10',to_date('11-MAY-09','DD-MON-RR'),to_date('15-MAY-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (17107,0,null,null,null,17106,null,2,1,to_date('21-MAY-09','DD-MON-RR'),to_date('21-MAY-09','DD-MON-RR'),null,null,1,73,'MHVSMFIFTEEN, YOKO',null,null,null,null,null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (17083,10,null,1152,null,17082,1152,3,1,to_date('21-MAY-09','DD-MON-RR'),to_date('27-MAY-09','DD-MON-RR'),to_date('27-MAY-09','DD-MON-RR'),to_date('21-MAY-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,4891,'Clinic (DAYT29)',to_date('21-MAY-09','DD-MON-RR'),to_date('27-MAY-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (17095,10,null,1152,null,17094,1152,3,1,to_date('21-MAY-09','DD-MON-RR'),to_date('27-MAY-09','DD-MON-RR'),to_date('27-MAY-09','DD-MON-RR'),to_date('21-MAY-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,4891,'Clinic (DAYT29)',to_date('21-MAY-09','DD-MON-RR'),to_date('27-MAY-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (17110,20,to_date('14-SEP-09','DD-MON-RR'),1152,null,17109,1152,5,1,to_date('21-MAY-09','DD-MON-RR'),to_date('27-MAY-09','DD-MON-RR'),to_date('27-MAY-09','DD-MON-RR'),to_date('21-MAY-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,4891,'Clinic (DAYT29)',to_date('21-MAY-09','DD-MON-RR'),to_date('27-MAY-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (18112,0,null,null,null,18111,null,0,1,to_date('25-JUN-09','DD-MON-RR'),to_date('25-JUN-09','DD-MON-RR'),null,to_date('25-JUN-09','DD-MON-RR'),2,14698,'SEARCY, DONITA',3,17985,'SLC10 June 25 triage test',to_date('25-JUN-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (18116,0,null,null,null,18115,null,0,1,to_date('25-JUN-09','DD-MON-RR'),to_date('25-JUN-09','DD-MON-RR'),null,to_date('25-JUN-09','DD-MON-RR'),2,14698,'SEARCY, DONITA',3,17985,'SLC10 June 25 triage test',to_date('25-JUN-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (18120,0,null,null,null,18119,null,0,1,to_date('25-JUN-09','DD-MON-RR'),to_date('25-JUN-09','DD-MON-RR'),null,to_date('25-JUN-09','DD-MON-RR'),2,14698,'SEARCY, DONITA',3,17985,'SLC10 June 25 triage test',to_date('25-JUN-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11687,0,null,null,null,11686,null,0,1,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,to_date('30-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11666,'Distribution Group 9.1.B',to_date('30-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11692,0,null,null,null,11691,null,0,1,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,to_date('30-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11690,'Distribution Group 9.1.B - Pat',to_date('30-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11696,0,null,null,null,11695,null,0,1,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,to_date('30-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11690,'Distribution Group 9.1.B - Pat',to_date('30-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11700,0,null,null,null,11699,null,0,1,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,to_date('30-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11690,'Distribution Group 9.1.B - Pat',to_date('30-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11704,0,null,null,null,11703,null,0,1,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,to_date('30-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11690,'Distribution Group 9.1.B - Pat',to_date('30-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11707,0,null,null,null,11706,null,0,1,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,to_date('30-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11690,'Distribution Group 9.1.B - Pat',to_date('30-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11711,0,null,null,null,11710,null,0,1,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,to_date('30-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11690,'Distribution Group 9.1.B - Pat',to_date('30-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11715,0,null,null,null,11714,null,0,1,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,to_date('30-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11690,'Distribution Group 9.1.B - Pat',to_date('30-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11719,0,null,null,null,11718,null,0,1,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,to_date('30-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11690,'Distribution Group 9.1.B - Pat',to_date('30-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11723,0,null,null,null,11722,null,0,1,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,to_date('30-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11690,'Distribution Group 9.1.B - Pat',to_date('30-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11727,0,null,null,null,11726,null,0,1,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,to_date('30-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11690,'Distribution Group 9.1.B - Pat',to_date('30-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11731,0,null,null,null,11730,null,0,1,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,to_date('30-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11690,'Distribution Group 9.1.B - Pat',to_date('30-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11740,0,null,null,null,11739,null,0,1,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,to_date('30-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11666,'Distribution Group 9.1.B',to_date('30-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11744,0,null,null,null,11743,null,0,1,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,to_date('30-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11666,'Distribution Group 9.1.B',to_date('30-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11748,0,null,null,null,11747,null,0,1,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,to_date('30-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11666,'Distribution Group 9.1.B',to_date('30-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11752,0,null,null,null,11751,null,0,1,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,to_date('30-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11666,'Distribution Group 9.1.B',to_date('30-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11755,0,null,null,null,11754,null,0,1,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,to_date('30-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11666,'Distribution Group 9.1.B',to_date('30-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11759,0,null,null,null,11758,null,0,1,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,to_date('30-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11666,'Distribution Group 9.1.B',to_date('30-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11763,0,null,null,null,11762,null,0,1,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,to_date('30-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11666,'Distribution Group 9.1.B',to_date('30-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11767,0,null,null,null,11766,null,0,1,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,to_date('30-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11666,'Distribution Group 9.1.B',to_date('30-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11771,0,null,null,null,11770,null,0,1,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,to_date('30-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11666,'Distribution Group 9.1.B',to_date('30-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11775,0,null,null,null,11774,null,0,1,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,to_date('30-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11666,'Distribution Group 9.1.B',to_date('30-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11778,0,null,null,null,11777,null,0,1,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,to_date('30-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11666,'Distribution Group 9.1.B',to_date('30-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11782,0,null,null,null,11781,null,0,1,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,to_date('30-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11666,'Distribution Group 9.1.B',to_date('30-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11788,10,null,1152,null,11726,1152,2,1,to_date('30-MAR-09','DD-MON-RR'),to_date('03-APR-09','DD-MON-RR'),to_date('03-APR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,989,'Dayton 29',to_date('30-MAR-09','DD-MON-RR'),to_date('03-APR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11799,0,null,null,null,11798,null,0,1,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,to_date('30-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11666,'Distribution Group 9.1.B',to_date('30-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11803,0,null,null,null,11802,null,0,1,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,to_date('30-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11666,'Distribution Group 9.1.B',to_date('30-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11807,0,null,null,null,11806,null,0,1,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,to_date('30-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11666,'Distribution Group 9.1.B',to_date('30-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11811,0,null,null,null,11810,null,0,1,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,to_date('30-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11666,'Distribution Group 9.1.B',to_date('30-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11814,0,null,null,null,11813,null,0,1,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,to_date('30-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11666,'Distribution Group 9.1.B',to_date('30-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11818,0,null,null,null,11817,null,0,1,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,to_date('30-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11666,'Distribution Group 9.1.B',to_date('30-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11835,0,null,null,null,11834,null,0,1,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,to_date('30-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11690,'Distribution Group 9.1.B - Pat',to_date('30-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11839,0,null,null,null,11838,null,0,1,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,to_date('30-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11690,'Distribution Group 9.1.B - Pat',to_date('30-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (11843,0,null,null,null,11842,null,0,1,to_date('30-MAR-09','DD-MON-RR'),to_date('30-MAR-09','DD-MON-RR'),null,to_date('30-MAR-09','DD-MON-RR'),2,1152,'Searcy, Donita',4,11690,'Distribution Group 9.1.B - Pat',to_date('30-MAR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15051,0,null,null,null,15032,null,0,1,to_date('06-MAY-09','DD-MON-RR'),to_date('06-MAY-09','DD-MON-RR'),null,to_date('06-MAY-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,57,'MHVSMSEVEN, BERTHA',to_date('06-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15110,20,to_date('06-MAY-09','DD-MON-RR'),2796,null,15109,2796,3,1,to_date('06-MAY-09','DD-MON-RR'),to_date('06-MAY-09','DD-MON-RR'),null,to_date('06-MAY-09','DD-MON-RR'),2,14697,'KETHA, MASTAN',2,2796,'Balasubramanian, Swetha',to_date('06-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15115,10,null,2796,null,15109,14697,1,1,to_date('06-MAY-09','DD-MON-RR'),to_date('06-MAY-09','DD-MON-RR'),null,to_date('06-MAY-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',2,14697,'KETHA, MASTAN',to_date('06-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15123,0,null,null,null,15109,null,0,1,to_date('06-MAY-09','DD-MON-RR'),to_date('06-MAY-09','DD-MON-RR'),null,to_date('06-MAY-09','DD-MON-RR'),2,14697,'KETHA, MASTAN',2,2796,'Balasubramanian, Swetha',to_date('06-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15162,10,null,1154,null,15161,14675,4,1,to_date('07-MAY-09','DD-MON-RR'),to_date('07-MAY-09','DD-MON-RR'),null,to_date('07-MAY-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',2,14675,'PREMATTA, ANTHONY',to_date('07-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15167,20,to_date('07-MAY-09','DD-MON-RR'),2796,null,15161,2796,2,1,to_date('07-MAY-09','DD-MON-RR'),to_date('07-MAY-09','DD-MON-RR'),null,to_date('07-MAY-09','DD-MON-RR'),2,14675,'PREMATTA, ANTHONY',2,2796,'Balasubramanian, Swetha',to_date('07-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15176,10,null,2796,null,15161,2796,1,1,to_date('07-MAY-09','DD-MON-RR'),to_date('07-MAY-09','DD-MON-RR'),null,to_date('07-MAY-09','DD-MON-RR'),2,14675,'PREMATTA, ANTHONY',2,2796,'Balasubramanian, Swetha',to_date('07-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15183,10,null,2796,null,15182,14675,1,1,to_date('07-MAY-09','DD-MON-RR'),to_date('07-MAY-09','DD-MON-RR'),null,to_date('07-MAY-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',2,14697,'KETHA, MASTAN',to_date('07-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15351,0,null,null,null,15335,null,0,1,to_date('07-MAY-09','DD-MON-RR'),to_date('07-MAY-09','DD-MON-RR'),null,to_date('07-MAY-09','DD-MON-RR'),2,14698,'SEARCY, DONITA',1,73,'MHVSMFIFTEEN, YOKO',to_date('07-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15477,10,null,14675,null,15476,14675,2,1,to_date('07-MAY-09','DD-MON-RR'),to_date('07-MAY-09','DD-MON-RR'),null,to_date('07-MAY-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',2,14675,'PREMATTA, ANTHONY',to_date('07-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15482,10,null,2796,null,15476,2796,2,1,to_date('07-MAY-09','DD-MON-RR'),to_date('07-MAY-09','DD-MON-RR'),null,to_date('07-MAY-09','DD-MON-RR'),2,14675,'PREMATTA, ANTHONY',2,2796,'Balasubramanian, Swetha',to_date('07-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15488,0,null,14675,null,15476,null,1,1,to_date('07-MAY-09','DD-MON-RR'),to_date('07-MAY-09','DD-MON-RR'),null,to_date('07-MAY-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',2,14675,'PREMATTA, ANTHONY',to_date('07-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15492,0,null,null,null,15476,null,0,1,to_date('07-MAY-09','DD-MON-RR'),to_date('07-MAY-09','DD-MON-RR'),null,to_date('07-MAY-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',2,14675,'PREMATTA, ANTHONY',to_date('07-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15498,0,null,null,null,15476,null,0,1,to_date('07-MAY-09','DD-MON-RR'),to_date('07-MAY-09','DD-MON-RR'),null,to_date('07-MAY-09','DD-MON-RR'),2,14675,'PREMATTA, ANTHONY',2,2796,'Balasubramanian, Swetha',to_date('07-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15504,0,null,null,null,15503,null,0,1,to_date('07-MAY-09','DD-MON-RR'),to_date('07-MAY-09','DD-MON-RR'),null,to_date('07-MAY-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',2,14675,'PREMATTA, ANTHONY',to_date('07-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15509,0,null,null,null,15508,null,0,1,to_date('07-MAY-09','DD-MON-RR'),to_date('07-MAY-09','DD-MON-RR'),null,to_date('07-MAY-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',2,14675,'PREMATTA, ANTHONY',to_date('07-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15520,0,null,null,null,15519,null,0,1,to_date('07-MAY-09','DD-MON-RR'),to_date('07-MAY-09','DD-MON-RR'),null,to_date('07-MAY-09','DD-MON-RR'),2,14675,'PREMATTA, ANTHONY',2,2796,'Balasubramanian, Swetha',to_date('07-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15545,20,to_date('18-MAY-09','DD-MON-RR'),1152,null,15544,1152,4,1,to_date('08-MAY-09','DD-MON-RR'),to_date('14-MAY-09','DD-MON-RR'),to_date('14-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,4891,'Clinic (DAYT29)',to_date('08-MAY-09','DD-MON-RR'),to_date('14-MAY-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15557,20,to_date('20-MAY-09','DD-MON-RR'),1152,null,15556,1152,3,1,to_date('08-MAY-09','DD-MON-RR'),to_date('14-MAY-09','DD-MON-RR'),to_date('14-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,4891,'Clinic (DAYT29)',to_date('08-MAY-09','DD-MON-RR'),to_date('14-MAY-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15569,20,to_date('18-MAY-09','DD-MON-RR'),1152,null,15568,1152,4,1,to_date('08-MAY-09','DD-MON-RR'),to_date('14-MAY-09','DD-MON-RR'),to_date('14-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,4891,'Clinic (DAYT29)',to_date('08-MAY-09','DD-MON-RR'),to_date('14-MAY-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15581,20,to_date('18-MAY-09','DD-MON-RR'),1152,null,15580,1152,4,1,to_date('08-MAY-09','DD-MON-RR'),to_date('14-MAY-09','DD-MON-RR'),to_date('14-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,4891,'Clinic (DAYT29)',to_date('08-MAY-09','DD-MON-RR'),to_date('14-MAY-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15593,0,null,null,null,15592,null,1,1,to_date('08-MAY-09','DD-MON-RR'),to_date('14-MAY-09','DD-MON-RR'),to_date('14-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,4891,'Clinic (DAYT29)',to_date('08-MAY-09','DD-MON-RR'),to_date('14-MAY-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15649,10,null,14698,null,15648,14698,2,1,to_date('08-MAY-09','DD-MON-RR'),to_date('14-MAY-09','DD-MON-RR'),to_date('14-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,979,'SLC10',to_date('08-MAY-09','DD-MON-RR'),to_date('14-MAY-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15664,10,null,14698,null,15663,14698,2,1,to_date('08-MAY-09','DD-MON-RR'),to_date('14-MAY-09','DD-MON-RR'),to_date('14-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,979,'SLC10',to_date('08-MAY-09','DD-MON-RR'),to_date('14-MAY-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15679,10,null,14698,null,15678,14698,2,1,to_date('08-MAY-09','DD-MON-RR'),to_date('14-MAY-09','DD-MON-RR'),to_date('14-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,979,'SLC10',to_date('08-MAY-09','DD-MON-RR'),to_date('14-MAY-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15694,20,to_date('12-MAY-09','DD-MON-RR'),14698,null,15693,14698,2,1,to_date('08-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),null,to_date('08-MAY-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,979,'SLC10',to_date('08-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15725,0,null,null,null,15724,null,0,1,to_date('08-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),null,to_date('08-MAY-09','DD-MON-RR'),2,14698,'SEARCY, DONITA',4,15723,'Create Clin/Pat Distr Grp 9.1D',to_date('08-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15728,0,null,null,null,15727,null,0,1,to_date('08-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),null,to_date('08-MAY-09','DD-MON-RR'),2,14698,'SEARCY, DONITA',4,15723,'Create Clin/Pat Distr Grp 9.1D',to_date('08-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15732,0,null,null,null,15731,null,0,1,to_date('08-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),null,to_date('08-MAY-09','DD-MON-RR'),2,14698,'SEARCY, DONITA',4,15723,'Create Clin/Pat Distr Grp 9.1D',to_date('08-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15738,0,null,null,null,15737,null,0,1,to_date('08-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),null,to_date('08-MAY-09','DD-MON-RR'),2,14698,'SEARCY, DONITA',4,15736,'Create Clin Distr Grp 9.1D',to_date('08-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15741,0,null,null,null,15740,null,0,1,to_date('08-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),null,to_date('08-MAY-09','DD-MON-RR'),2,14698,'SEARCY, DONITA',4,15736,'Create Clin Distr Grp 9.1D',to_date('08-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15747,0,null,null,null,15746,null,0,1,to_date('08-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),null,to_date('08-MAY-09','DD-MON-RR'),2,14698,'SEARCY, DONITA',4,15745,'Create Pat Distr Grp 9.1D',to_date('08-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15751,0,null,null,null,15750,null,0,1,to_date('08-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),null,to_date('08-MAY-09','DD-MON-RR'),2,14698,'SEARCY, DONITA',4,15745,'Create Pat Distr Grp 9.1D',to_date('08-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15755,0,null,null,null,15754,null,0,1,to_date('08-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),null,to_date('08-MAY-09','DD-MON-RR'),2,14698,'SEARCY, DONITA',4,15745,'Create Pat Distr Grp 9.1D',to_date('08-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15759,0,null,null,null,15758,null,0,1,to_date('08-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),null,to_date('08-MAY-09','DD-MON-RR'),2,14698,'SEARCY, DONITA',4,15745,'Create Pat Distr Grp 9.1D',to_date('08-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15763,0,null,null,null,15762,null,0,1,to_date('08-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),null,to_date('08-MAY-09','DD-MON-RR'),2,14698,'SEARCY, DONITA',4,15745,'Create Pat Distr Grp 9.1D',to_date('08-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15767,0,null,null,null,15766,null,0,1,to_date('08-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),null,to_date('08-MAY-09','DD-MON-RR'),2,14698,'SEARCY, DONITA',4,15745,'Create Pat Distr Grp 9.1D',to_date('08-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15771,0,null,null,null,15770,null,0,1,to_date('08-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),null,to_date('08-MAY-09','DD-MON-RR'),2,14698,'SEARCY, DONITA',4,15745,'Create Pat Distr Grp 9.1D',to_date('08-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15777,0,null,null,null,15731,null,1,1,to_date('08-MAY-09','DD-MON-RR'),to_date('14-MAY-09','DD-MON-RR'),to_date('14-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,979,'SLC10',to_date('08-MAY-09','DD-MON-RR'),to_date('14-MAY-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (15792,0,null,null,null,15770,null,1,1,to_date('08-MAY-09','DD-MON-RR'),to_date('14-MAY-09','DD-MON-RR'),to_date('14-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,979,'SLC10',to_date('08-MAY-09','DD-MON-RR'),to_date('14-MAY-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (13644,0,null,null,null,13595,null,0,1,to_date('24-APR-09','DD-MON-RR'),to_date('24-APR-09','DD-MON-RR'),null,to_date('24-APR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,57,'MHVSMSEVEN, BERTHA',to_date('24-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (13652,0,null,null,null,13595,null,0,1,to_date('24-APR-09','DD-MON-RR'),to_date('24-APR-09','DD-MON-RR'),null,to_date('24-APR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,57,'MHVSMSEVEN, BERTHA',to_date('24-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (13658,0,null,null,null,13595,null,0,1,to_date('24-APR-09','DD-MON-RR'),to_date('24-APR-09','DD-MON-RR'),null,to_date('24-APR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,57,'MHVSMSEVEN, BERTHA',to_date('24-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (13665,0,null,null,null,13595,null,0,1,to_date('24-APR-09','DD-MON-RR'),to_date('24-APR-09','DD-MON-RR'),null,to_date('24-APR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',1,57,'MHVSMSEVEN, BERTHA',to_date('24-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (13684,0,null,null,null,13683,null,1,1,to_date('27-APR-09','DD-MON-RR'),to_date('01-MAY-09','DD-MON-RR'),to_date('01-MAY-09','DD-MON-RR'),to_date('27-APR-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,4891,'Clinic (DAYT29)',to_date('27-APR-09','DD-MON-RR'),to_date('01-MAY-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (13695,0,null,null,null,13694,null,1,1,to_date('27-APR-09','DD-MON-RR'),to_date('01-MAY-09','DD-MON-RR'),to_date('01-MAY-09','DD-MON-RR'),to_date('27-APR-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,4891,'Clinic (DAYT29)',to_date('27-APR-09','DD-MON-RR'),to_date('01-MAY-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (13706,10,null,1150,null,13705,1152,2,1,to_date('27-APR-09','DD-MON-RR'),to_date('01-MAY-09','DD-MON-RR'),to_date('01-MAY-09','DD-MON-RR'),to_date('27-APR-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,4891,'Clinic (DAYT29)',to_date('27-APR-09','DD-MON-RR'),to_date('01-MAY-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (13717,20,to_date('27-APR-09','DD-MON-RR'),1152,null,13716,1152,2,1,to_date('27-APR-09','DD-MON-RR'),to_date('27-APR-09','DD-MON-RR'),null,to_date('27-APR-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,4891,'Clinic (DAYT29)',to_date('27-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (13728,0,null,null,null,13727,null,1,1,to_date('27-APR-09','DD-MON-RR'),to_date('01-MAY-09','DD-MON-RR'),to_date('01-MAY-09','DD-MON-RR'),to_date('27-APR-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,4891,'Clinic (DAYT29)',to_date('27-APR-09','DD-MON-RR'),to_date('01-MAY-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (13739,0,null,null,null,13738,null,1,1,to_date('27-APR-09','DD-MON-RR'),to_date('01-MAY-09','DD-MON-RR'),to_date('01-MAY-09','DD-MON-RR'),to_date('27-APR-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,4891,'Clinic (DAYT29)',to_date('27-APR-09','DD-MON-RR'),to_date('01-MAY-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (13766,10,null,1150,null,13765,1152,2,1,to_date('27-APR-09','DD-MON-RR'),to_date('01-MAY-09','DD-MON-RR'),to_date('01-MAY-09','DD-MON-RR'),to_date('27-APR-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,4891,'Clinic (DAYT29)',to_date('27-APR-09','DD-MON-RR'),to_date('01-MAY-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (13844,20,to_date('27-APR-09','DD-MON-RR'),2796,null,13595,2796,3,1,to_date('27-APR-09','DD-MON-RR'),to_date('27-APR-09','DD-MON-RR'),null,to_date('27-APR-09','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('27-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (13818,10,null,1150,null,13817,1152,2,1,to_date('27-APR-09','DD-MON-RR'),to_date('01-MAY-09','DD-MON-RR'),to_date('01-MAY-09','DD-MON-RR'),to_date('27-APR-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,4891,'Clinic (DAYT29)',to_date('27-APR-09','DD-MON-RR'),to_date('01-MAY-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (13897,20,to_date('27-APR-09','DD-MON-RR'),2796,null,13896,2796,2,1,to_date('27-APR-09','DD-MON-RR'),to_date('27-APR-09','DD-MON-RR'),null,to_date('27-APR-09','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('27-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (13917,20,to_date('27-APR-09','DD-MON-RR'),2796,null,13916,2796,5,1,to_date('27-APR-09','DD-MON-RR'),to_date('27-APR-09','DD-MON-RR'),null,to_date('27-APR-09','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('27-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (13990,10,null,1152,null,13989,1152,2,1,to_date('27-APR-09','DD-MON-RR'),to_date('01-MAY-09','DD-MON-RR'),to_date('01-MAY-09','DD-MON-RR'),to_date('27-APR-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,4891,'Clinic (DAYT29)',to_date('27-APR-09','DD-MON-RR'),to_date('01-MAY-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (14002,0,null,null,null,14001,null,1,1,to_date('27-APR-09','DD-MON-RR'),to_date('01-MAY-09','DD-MON-RR'),to_date('01-MAY-09','DD-MON-RR'),to_date('27-APR-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,4891,'Clinic (DAYT29)',to_date('27-APR-09','DD-MON-RR'),to_date('01-MAY-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (14023,0,null,null,null,14022,null,1,1,to_date('27-APR-09','DD-MON-RR'),to_date('01-MAY-09','DD-MON-RR'),to_date('01-MAY-09','DD-MON-RR'),to_date('27-APR-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,4891,'Clinic (DAYT29)',to_date('27-APR-09','DD-MON-RR'),to_date('01-MAY-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (14035,0,null,null,null,14034,null,1,1,to_date('27-APR-09','DD-MON-RR'),to_date('01-MAY-09','DD-MON-RR'),to_date('01-MAY-09','DD-MON-RR'),to_date('27-APR-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,4891,'Clinic (DAYT29)',to_date('27-APR-09','DD-MON-RR'),to_date('01-MAY-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (14047,0,null,null,null,14046,null,1,1,to_date('27-APR-09','DD-MON-RR'),to_date('01-MAY-09','DD-MON-RR'),to_date('01-MAY-09','DD-MON-RR'),to_date('27-APR-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,4891,'Clinic (DAYT29)',to_date('27-APR-09','DD-MON-RR'),to_date('01-MAY-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (14059,0,null,null,null,14058,null,1,1,to_date('27-APR-09','DD-MON-RR'),to_date('01-MAY-09','DD-MON-RR'),to_date('01-MAY-09','DD-MON-RR'),to_date('27-APR-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,4891,'Clinic (DAYT29)',to_date('27-APR-09','DD-MON-RR'),to_date('01-MAY-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (14074,0,null,null,null,14073,null,1,1,to_date('27-APR-09','DD-MON-RR'),to_date('01-MAY-09','DD-MON-RR'),to_date('01-MAY-09','DD-MON-RR'),to_date('27-APR-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,4891,'Clinic (DAYT29)',to_date('27-APR-09','DD-MON-RR'),to_date('01-MAY-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (14086,0,null,null,null,14085,null,1,1,to_date('27-APR-09','DD-MON-RR'),to_date('01-MAY-09','DD-MON-RR'),to_date('01-MAY-09','DD-MON-RR'),to_date('27-APR-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,4891,'Clinic (DAYT29)',to_date('27-APR-09','DD-MON-RR'),to_date('01-MAY-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (14272,0,null,null,null,14271,null,1,1,to_date('28-APR-09','DD-MON-RR'),to_date('02-MAY-09','DD-MON-RR'),to_date('02-MAY-09','DD-MON-RR'),to_date('28-APR-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,4891,'Clinic (DAYT29)',to_date('28-APR-09','DD-MON-RR'),to_date('02-MAY-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (14283,0,null,null,null,14282,null,1,1,to_date('28-APR-09','DD-MON-RR'),to_date('02-MAY-09','DD-MON-RR'),to_date('02-MAY-09','DD-MON-RR'),to_date('28-APR-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,4891,'Clinic (DAYT29)',to_date('28-APR-09','DD-MON-RR'),to_date('02-MAY-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (14294,0,null,null,null,14293,null,1,1,to_date('28-APR-09','DD-MON-RR'),to_date('02-MAY-09','DD-MON-RR'),to_date('02-MAY-09','DD-MON-RR'),to_date('28-APR-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,4891,'Clinic (DAYT29)',to_date('28-APR-09','DD-MON-RR'),to_date('02-MAY-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (14305,0,null,null,null,14304,null,1,1,to_date('28-APR-09','DD-MON-RR'),to_date('02-MAY-09','DD-MON-RR'),to_date('02-MAY-09','DD-MON-RR'),to_date('28-APR-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,4891,'Clinic (DAYT29)',to_date('28-APR-09','DD-MON-RR'),to_date('02-MAY-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (14316,0,null,null,null,14315,null,1,1,to_date('28-APR-09','DD-MON-RR'),to_date('02-MAY-09','DD-MON-RR'),to_date('02-MAY-09','DD-MON-RR'),to_date('28-APR-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,4891,'Clinic (DAYT29)',to_date('28-APR-09','DD-MON-RR'),to_date('02-MAY-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (14328,0,null,null,null,14327,null,1,1,to_date('28-APR-09','DD-MON-RR'),to_date('02-MAY-09','DD-MON-RR'),to_date('02-MAY-09','DD-MON-RR'),to_date('28-APR-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,4891,'Clinic (DAYT29)',to_date('28-APR-09','DD-MON-RR'),to_date('02-MAY-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (14339,0,null,null,null,14338,null,1,1,to_date('28-APR-09','DD-MON-RR'),to_date('02-MAY-09','DD-MON-RR'),to_date('02-MAY-09','DD-MON-RR'),to_date('28-APR-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,4891,'Clinic (DAYT29)',to_date('28-APR-09','DD-MON-RR'),to_date('02-MAY-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (14350,0,null,null,null,14349,null,1,1,to_date('28-APR-09','DD-MON-RR'),to_date('02-MAY-09','DD-MON-RR'),to_date('02-MAY-09','DD-MON-RR'),to_date('28-APR-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,4891,'Clinic (DAYT29)',to_date('28-APR-09','DD-MON-RR'),to_date('02-MAY-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (14361,0,null,null,null,14360,null,1,1,to_date('28-APR-09','DD-MON-RR'),to_date('02-MAY-09','DD-MON-RR'),to_date('02-MAY-09','DD-MON-RR'),to_date('28-APR-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,4891,'Clinic (DAYT29)',to_date('28-APR-09','DD-MON-RR'),to_date('02-MAY-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (14484,0,null,null,null,14483,null,1,1,to_date('29-APR-09','DD-MON-RR'),to_date('05-MAY-09','DD-MON-RR'),to_date('05-MAY-09','DD-MON-RR'),to_date('29-APR-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,4891,'Clinic (DAYT29)',to_date('29-APR-09','DD-MON-RR'),to_date('05-MAY-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (14495,0,null,null,null,14494,null,1,1,to_date('29-APR-09','DD-MON-RR'),to_date('05-MAY-09','DD-MON-RR'),to_date('05-MAY-09','DD-MON-RR'),to_date('29-APR-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,4891,'Clinic (DAYT29)',to_date('29-APR-09','DD-MON-RR'),to_date('05-MAY-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (14516,0,null,null,null,14515,null,1,1,to_date('04-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),to_date('04-MAY-09','DD-MON-RR'),1,73,'MHVSMFIFTEEN, YOKO',3,4891,'Clinic (DAYT29)',to_date('04-MAY-09','DD-MON-RR'),to_date('08-MAY-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (12745,0,null,null,null,12744,null,1,1,to_date('11-APR-09','DD-MON-RR'),to_date('16-APR-09','DD-MON-RR'),to_date('16-APR-09','DD-MON-RR'),to_date('11-APR-09','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,12415,'MK_Dayt29_TG1',to_date('11-APR-09','DD-MON-RR'),to_date('16-APR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (12750,0,null,null,null,12749,null,1,1,to_date('11-APR-09','DD-MON-RR'),to_date('16-APR-09','DD-MON-RR'),to_date('16-APR-09','DD-MON-RR'),to_date('11-APR-09','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,12415,'MK_Dayt29_TG1',to_date('11-APR-09','DD-MON-RR'),to_date('16-APR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (14528,20,to_date('04-MAY-09','DD-MON-RR'),79,null,14527,79,3,1,to_date('04-MAY-09','DD-MON-RR'),to_date('04-MAY-09','DD-MON-RR'),null,to_date('04-MAY-09','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,12415,'MK_Dayt29_TG1',to_date('04-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (12822,20,to_date('20-APR-09','DD-MON-RR'),79,null,12821,79,3,1,to_date('20-APR-09','DD-MON-RR'),to_date('20-APR-09','DD-MON-RR'),null,to_date('20-APR-09','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,12415,'MK_Dayt29_TG1',to_date('20-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (12828,10,null,79,null,12827,79,2,1,to_date('20-APR-09','DD-MON-RR'),to_date('24-APR-09','DD-MON-RR'),to_date('24-APR-09','DD-MON-RR'),to_date('20-APR-09','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,12415,'MK_Dayt29_TG1',to_date('20-APR-09','DD-MON-RR'),to_date('24-APR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (12860,0,null,null,null,12859,null,0,1,to_date('21-APR-09','DD-MON-RR'),to_date('21-APR-09','DD-MON-RR'),null,to_date('21-APR-09','DD-MON-RR'),2,1150,'Prematta,        ',1,51,'MHVSMFOUR, OLIVIA',to_date('21-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (13013,0,null,null,null,12685,null,0,1,to_date('21-APR-09','DD-MON-RR'),to_date('21-APR-09','DD-MON-RR'),null,to_date('21-APR-09','DD-MON-RR'),2,1152,'Searcy, Donita',1,73,'MHVSMFIFTEEN, YOKO',to_date('21-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (14397,20,to_date('04-MAY-09','DD-MON-RR'),2796,null,14396,2796,4,1,to_date('28-APR-09','DD-MON-RR'),to_date('02-MAY-09','DD-MON-RR'),to_date('02-MAY-09','DD-MON-RR'),to_date('28-APR-09','DD-MON-RR'),1,71,'MHVSMFOURTEEN, RINGO',3,9890,'Doug - Triage Alpha',to_date('28-APR-09','DD-MON-RR'),to_date('02-MAY-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (14450,0,null,null,null,14449,null,1,1,to_date('29-APR-09','DD-MON-RR'),to_date('05-MAY-09','DD-MON-RR'),to_date('05-MAY-09','DD-MON-RR'),to_date('29-APR-09','DD-MON-RR'),1,71,'MHVSMFOURTEEN, RINGO',3,14426,'Doug - Manual Relationship Test',to_date('29-APR-09','DD-MON-RR'),to_date('05-MAY-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (17037,0,null,null,null,17036,null,0,1,to_date('20-MAY-09','DD-MON-RR'),to_date('20-MAY-09','DD-MON-RR'),null,to_date('20-MAY-09','DD-MON-RR'),2,1154,'Mcdonald, Douglas',4,7561,'Doug Test PDG 01',to_date('20-MAY-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (13431,10,null,6705,null,13430,2796,2,1,to_date('22-APR-09','DD-MON-RR'),to_date('28-APR-09','DD-MON-RR'),to_date('28-APR-09','DD-MON-RR'),to_date('22-APR-09','DD-MON-RR'),1,57,'MHVSMSEVEN, BERTHA',3,979,'SLC10',to_date('22-APR-09','DD-MON-RR'),to_date('28-APR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (12444,0,null,null,null,12443,null,1,1,to_date('02-APR-09','DD-MON-RR'),to_date('08-APR-09','DD-MON-RR'),to_date('08-APR-09','DD-MON-RR'),to_date('02-APR-09','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,12415,'MK_Dayt29',to_date('02-APR-09','DD-MON-RR'),to_date('08-APR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (12474,0,null,null,null,12473,null,1,1,to_date('02-APR-09','DD-MON-RR'),to_date('08-APR-09','DD-MON-RR'),to_date('08-APR-09','DD-MON-RR'),to_date('02-APR-09','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,12450,'MK_Dayt29_TG2',to_date('02-APR-09','DD-MON-RR'),to_date('08-APR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (12480,0,null,null,null,12479,null,1,1,to_date('02-APR-09','DD-MON-RR'),to_date('08-APR-09','DD-MON-RR'),to_date('08-APR-09','DD-MON-RR'),to_date('02-APR-09','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,12461,'MK_Dayt29_TG3',to_date('02-APR-09','DD-MON-RR'),to_date('08-APR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (12489,0,null,null,null,12488,null,1,1,to_date('02-APR-09','DD-MON-RR'),to_date('08-APR-09','DD-MON-RR'),to_date('08-APR-09','DD-MON-RR'),to_date('02-APR-09','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,12461,'MK_Dayt29_TG3',to_date('02-APR-09','DD-MON-RR'),to_date('08-APR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (12498,0,null,null,null,12426,null,1,1,to_date('02-APR-09','DD-MON-RR'),to_date('08-APR-09','DD-MON-RR'),to_date('08-APR-09','DD-MON-RR'),to_date('02-APR-09','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,12415,'MK_Dayt29_TG1',to_date('02-APR-09','DD-MON-RR'),to_date('08-APR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (12503,0,null,null,null,12502,null,1,1,to_date('02-APR-09','DD-MON-RR'),to_date('08-APR-09','DD-MON-RR'),to_date('08-APR-09','DD-MON-RR'),to_date('02-APR-09','DD-MON-RR'),1,29,'MHVSMONE, ALYSSA',3,12415,'MK_Dayt29_TG1',to_date('02-APR-09','DD-MON-RR'),to_date('08-APR-09','DD-MON-RR'),1,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (12513,0,null,null,null,12512,null,0,1,to_date('02-APR-09','DD-MON-RR'),to_date('02-APR-09','DD-MON-RR'),null,to_date('02-APR-09','DD-MON-RR'),2,12397,'KETHA, MASTAN',2,12509,'GOPARAJU, BHANU',to_date('02-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (12567,0,null,null,null,12101,null,0,1,to_date('07-APR-09','DD-MON-RR'),to_date('07-APR-09','DD-MON-RR'),null,to_date('07-APR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',2,6705,'GOPARAJU, BHANU',to_date('07-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (12587,0,null,null,null,12586,null,0,1,to_date('07-APR-09','DD-MON-RR'),to_date('07-APR-09','DD-MON-RR'),null,to_date('07-APR-09','DD-MON-RR'),2,2796,'Balasubramanian, Swetha',2,6705,'GOPARAJU, BHANU',to_date('07-APR-09','DD-MON-RR'),null,null,null,0,null);
Insert into SMS.SECURE_MESSAGE (SECURE_MESSAGE_ID,CLINICIAN_STATUS,COMPLETED_DATE,ASSIGNED_TO,CHECKSUM,THREAD_ID,STATUS_SET_BY,OPLOCK,ACTIVE,CREATED_DATE,MODIFIED_DATE,ESCALATED,SENT_DATE,SENDER_TYPE,SENDER_ID,SENDER_NAME,RECIPIENT_TYPE,RECIPIENT_ID,RECIPIENT_NAME,SENT_DATE_LOCAL,ESCALATION_NOTIFICATION_DATE,ESCALATION_NOTIFICATION_TRIES,READ_RECEIPT,HAS_ATTACHMENT,ATTACHMENT_ID) values (12593,0,null,12397,null,12592,null,1,1,to_date('07-APR-09','DD-MON-RR'),to_date('07-APR-09','DD-MON-RR'),null,to_date('07-APR-09','DD-MON-RR'),2,1150,'Prematta,      