create sequence sms.seq_secure_message
  start with 500000
  increment by 1
  nocache;

CREATE OR REPLACE TRIGGER trg_secure_message_insert 
  BEFORE INSERT ON secure_message
  FOR EACH ROW
BEGIN
  IF :new.secure_message_id IS NULL THEN
    select seq_secure_message.nextval into :new.secure_message_id from dual;
  END IF;
END;

create sequence sms.seq_message_thread
  start with 500000
  increment by 1
  nocache;

CREATE OR REPLACE TRIGGER trg_message_thread
  BEFORE INSERT ON message_thread
  FOR EACH ROW
BEGIN
  IF :new.thread_id IS NULL THEN
    select seq_message_thread.nextval into :new.thread_id from dual;
  END IF;
END;

create sequence sms.seq_message_attachment
	
CREATE OR REPLACE TRIGGER trg_message_attachment
  BEFORE INSERT ON message_attachment
  FOR EACH ROW
BEGIN
  IF :new.attachment_id IS NULL THEN
    select seq_message_attachment.nextval into :new.attachment_id from dual;
  END IF;
END;

create sequence sms.seq_message_annotation
	
CREATE OR REPLACE TRIGGER trg_message_annotation
  BEFORE INSERT ON message_annotation
  FOR EACH ROW
BEGIN
  IF :new.annotation_id IS NULL THEN
    select seq_message_annotation.nextval into :new.annotation_id from dual;
  END IF;
END;

create sequence sms.seq_message_activity

CREATE OR REPLACE TRIGGER trg_message_activity
  BEFORE INSERT ON message_activity
  FOR EACH ROW
BEGIN
  IF :new.activity_id IS NULL THEN
    select seq_message_activity.nextval into :new.activity_id from dual;
  END IF;
END;

create sequence sms.seq_folder
	
CREATE OR REPLACE TRIGGER trg_folder
  BEFORE INSERT ON folder
  FOR EACH ROW
BEGIN
  IF :new.folder_id IS NULL THEN
    select seq_folder.nextval into :new.folder_id from dual;
  END IF;
END;

create sequence sms.seq_addressee
	
CREATE OR REPLACE TRIGGER trg_addressee
  BEFORE INSERT ON addressee
  FOR EACH ROW
BEGIN
  IF :new.addressee_id IS NULL THEN
    select seq_addressee.nextval into :new.addressee_id from dual;
  END IF;
END;