CREATE TABLE SMS.ADDRESSEE 
(
  ADDRESSEE_ID NUMBER NOT NULL 
, ADDRESSEE_ROLE NUMBER NOT NULL 
, SECURE_MESSAGE_ID NUMBER NOT NULL 
, USER_ID NUMBER NOT NULL 
, OPLOCK NUMBER DEFAULT 0 NOT NULL 
, ACTIVE NUMBER DEFAULT 1 NOT NULL 
, CREATED_DATE DATE DEFAULT SYSDATE NOT NULL 
, MODIFIED_DATE DATE DEFAULT SYSDATE NOT NULL 
, FOLDER_ID NUMBER DEFAULT 0 NOT NULL 
, READ_DATE DATE 
, REMINDER_DATE DATE 
, CONSTRAINT ADDRESSEE_PK PRIMARY KEY 
  (
    ADDRESSEE_ID 
  )
  ENABLE 
); 

CREATE TABLE SMS.ADMIN_OVERRIDE 
(
  ADMIN_OVERRIDE_ID VARCHAR2(30 BYTE) NOT NULL 
, USER_ID VARCHAR2(32 BYTE) NOT NULL 
, ADMIN_OVERRIDE_PASSWORD VARCHAR2(30 BYTE) NOT NULL 
, TIMESTAMP DATE NOT NULL 
, CONSTRAINT SYS_C005481 PRIMARY KEY 
  (
    ADMIN_OVERRIDE_ID 
  , USER_ID 
  )
  ENABLE 
);

CREATE TABLE SMS.ADMIN_RIGHTS 
(
  ADMIN_RIGHTS_ID VARCHAR2(30 BYTE) NOT NULL 
, USER_ID VARCHAR2(32 BYTE) NOT NULL 
, IS_NATIONAL_ADMIN CHAR(1 BYTE) 
, IS_VISN_ADMIN CHAR(1 BYTE) 
, VISN_ID VARCHAR2(30 BYTE) 
, IS_FACILITY_ADMIN CHAR(1 BYTE) 
, FACILITY_ID VARCHAR2(30 BYTE) 
, CONSTRAINT SYS_C005484 PRIMARY KEY 
  (
    ADMIN_RIGHTS_ID 
  , USER_ID 
  )
  ENABLE 
);

CREATE TABLE SMS.CLINICAL_USER_TYPE 
(
  CLINICAL_USER_TYPE_ID NUMBER NOT NULL 
, CLINICAL_USER_TYPE VARCHAR2(100 BYTE) 
, OPLOCK NUMBER DEFAULT 0 
, ACTIVE NUMBER DEFAULT 1 
, CREATED_DATE DATE DEFAULT SYSDATE 
, MODIFIED_DATE DATE DEFAULT SYSDATE 
, CONSTRAINT CLINICAL_USER_TYPE_PK PRIMARY KEY 
  (
    CLINICAL_USER_TYPE_ID 
  )
  ENABLE 
);

CREATE TABLE SMS.CLINICIAN_TRIAGE_MAP 
(
  TRIAGE_GROUP_ID NUMBER NOT NULL 
, USER_ID NUMBER NOT NULL 
, CTM_ID NUMBER NOT NULL 
, OPLOCK NUMBER DEFAULT 0 NOT NULL 
, ACTIVE NUMBER DEFAULT 1 NOT NULL 
, CREATED_DATE DATE DEFAULT SYSDATE NOT NULL 
, MODIFIED_DATE DATE DEFAULT SYSDATE NOT NULL 
, CONSTRAINT CLINICIAN_TRIAGE_MAP_PK PRIMARY KEY 
  (
    CTM_ID 
  )
  ENABLE 
);

CREATE TABLE SMS.DISTRIBUTION_GROUP 
(
  DIST_GROUP_ID NUMBER NOT NULL 
, DIST_GROUP_NAME VARCHAR2(30 BYTE) NOT NULL 
, USER_ID NUMBER NOT NULL 
, OPLOCK NUMBER DEFAULT 0 NOT NULL 
, ACTIVE NUMBER DEFAULT 1 NOT NULL 
, CREATED_DATE DATE DEFAULT SYSDATE NOT NULL 
, MODIFIED_DATE DATE DEFAULT SYSDATE NOT NULL 
, PUBLIC_GROUP NUMBER(1, 0) DEFAULT 0 
, VISN_ID NUMBER DEFAULT 0 
, CONSTRAINT SYS_C005503 PRIMARY KEY 
  (
    DIST_GROUP_ID 
  )
  ENABLE 
);

CREATE TABLE SMS.FACILITY 
(
  FACILITY_ID NUMBER NOT NULL 
, VISN_ID NUMBER NOT NULL 
, FACILITY_NAME VARCHAR2(30 BYTE) 
, VISN_NAME VARCHAR2(30 BYTE) 
, CONSTRAINT SYS_C005507 PRIMARY KEY 
  (
    FACILITY_ID 
  )
  ENABLE 
);

CREATE TABLE SMS.FOLDER 
(
  FOLDER_ID NUMBER NOT NULL 
, USER_ID NUMBER NOT NULL 
, FOLDER_NAME VARCHAR2(50 BYTE) 
, OPLOCK NUMBER DEFAULT 0 NOT NULL 
, ACTIVE NUMBER DEFAULT 1 NOT NULL 
, CREATED_DATE DATE DEFAULT SYSDATE NOT NULL 
, MODIFIED_DATE DATE DEFAULT SYSDATE NOT NULL 
, CONSTRAINT SYS_C005514 PRIMARY KEY 
  (
    FOLDER_ID 
  , USER_ID 
  )
  ENABLE 
);

CREATE TABLE SMS.HOLIDAY 
(
  HOLIDAY_ID NUMBER NOT NULL 
, HOLIDAY_DATE DATE NOT NULL 
, OPLOCK NUMBER DEFAULT 0 NOT NULL 
, ACTIVE NUMBER DEFAULT 1 NOT NULL 
, CREATED_DATE DATE DEFAULT SYSDATE NOT NULL 
, MODIFIED_DATE DATE DEFAULT SYSDATE NOT NULL 
, CONSTRAINT HOLIDAY_PK PRIMARY KEY 
  (
    HOLIDAY_ID 
  )
  ENABLE 
);

CREATE TABLE SMS.MESSAGE_ACTIVITY 
(
  ACTIVITY_ID NUMBER NOT NULL 
, SMS_USER_ID NUMBER 
, ACTION NUMBER 
, STATUS NUMBER 
, PERFORMER_TYPE NUMBER 
, DETAIL_VALUE VARCHAR2(4000 BYTE) 
, ACTIVITY_TYPE VARCHAR2(24 BYTE) 
, SECURE_MESSAGE_ID NUMBER 
, TIU_CREATION_ID NUMBER 
, OPLOCK NUMBER DEFAULT 0 NOT NULL 
, ACTIVE NUMBER DEFAULT 1 NOT NULL 
, CREATED_DATE TIMESTAMP(6) DEFAULT sysdate NOT NULL 
, MODIFIED_DATE TIMESTAMP(6) DEFAULT sysdate NOT NULL 
, CONSTRAINT MESSAGE_ACTIVITY_PK PRIMARY KEY 
  (
    ACTIVITY_ID 
  )
  ENABLE 
);

CREATE TABLE SMS.MESSAGE_ANNOTATION 
(
  ANNOTATION_ID NUMBER NOT NULL 
, THREAD_ID NUMBER NOT NULL 
, OPLOCK NUMBER DEFAULT 0 NOT NULL 
, ACTIVE NUMBER DEFAULT 1 NOT NULL 
, CREATED_DATE DATE DEFAULT SYSDATE NOT NULL 
, MODIFIED_DATE DATE DEFAULT SYSDATE NOT NULL 
, USER_ID NUMBER NOT NULL 
, ANNOTATION_TEXT CLOB
, CONSTRAINT MESSAGE_ANNOTATION_PK PRIMARY KEY 
  (
    ANNOTATION_ID 
  )
  ENABLE 
);

CREATE TABLE SMS.MESSAGE_ATTACHMENT 
(
  ATTACHMENT_ID NUMBER NOT NULL 
, ATTACHMENT_NAME VARCHAR2(80 BYTE) NOT NULL 
, ATTACHMENT BLOB  
, MIME_TYPE VARCHAR2(100 BYTE) NOT NULL 
, OPLOCK NUMBER(1, 0) DEFAULT '0' 
, CREATED_DATE TIMESTAMP(6) 
, ACTIVE NUMBER(1, 0) 
, CONSTRAINT SYS_C005542 PRIMARY KEY 
  (
    ATTACHMENT_ID 
  )
  ENABLE 
);

CREATE TABLE SMS.MESSAGE_THREAD 
(
  THREAD_ID NUMBER NOT NULL 
, SUBJECT VARCHAR2(512 BYTE) NOT NULL 
, TRIAGE_GROUP_ID NUMBER 
, OPLOCK NUMBER DEFAULT 0 NOT NULL 
, ACTIVE NUMBER DEFAULT 1 NOT NULL 
, CREATED_DATE DATE DEFAULT SYSDATE NOT NULL 
, MODIFIED_DATE DATE DEFAULT SYSDATE NOT NULL 
, CATEGORY_TYPE NUMBER DEFAULT 0 NOT NULL 
, CONSTRAINT MESSAGE_THREAD_PK PRIMARY KEY 
  (
    THREAD_ID 
  )
  ENABLE 
);

CREATE TABLE SMS.PATIENT_FACILITY 
(
  USER_ID NUMBER NOT NULL 
, VISTA_DIV VARCHAR2(10 CHAR) NOT NULL 
, DFN VARCHAR2(20 CHAR) 
, USER_FACILITY_ID NUMBER NOT NULL 
, OPLOCK NUMBER DEFAULT 0 NOT NULL 
, ACTIVE NUMBER DEFAULT 1 NOT NULL 
, CREATED_DATE DATE DEFAULT SYSDATE NOT NULL 
, MODIFIED_DATE DATE DEFAULT SYSDATE NOT NULL 
, CONSTRAINT SYS_C00340664 PRIMARY KEY 
  (
    USER_FACILITY_ID 
  )
  ENABLE 
);

CREATE TABLE SMS.PATIENT_TRIAGE_MAP 
(
  PTM_ID NUMBER NOT NULL 
, RELATION_ID NUMBER NOT NULL 
, USER_ID NUMBER NOT NULL 
, OPLOCK NUMBER DEFAULT 0 NOT NULL 
, ACTIVE NUMBER DEFAULT 1 NOT NULL 
, CREATED_DATE DATE DEFAULT SYSDATE NOT NULL 
, MODIFIED_DATE DATE DEFAULT SYSDATE NOT NULL 
, CONSTRAINT PATIENT_TRIAGE_MAP_PK PRIMARY KEY 
  (
    PTM_ID 
  )
  ENABLE 
);

CREATE TABLE SMS.PLAN_TABLE 
(
  STATEMENT_ID VARCHAR2(30 BYTE) 
, TIMESTAMP DATE 
, REMARKS VARCHAR2(80 BYTE) 
, OPERATION VARCHAR2(30 BYTE) 
, OPTIONS VARCHAR2(30 BYTE) 
, OBJECT_NODE VARCHAR2(128 BYTE) 
, OBJECT_OWNER VARCHAR2(30 BYTE) 
, OBJECT_NAME VARCHAR2(30 BYTE) 
, OBJECT_INSTANCE NUMBER 
, OBJECT_TYPE VARCHAR2(30 BYTE) 
, OPTIMIZER VARCHAR2(255 BYTE) 
, SEARCH_COLUMNS NUMBER 
, ID NUMBER 
, PARENT_ID NUMBER 
, POSITION NUMBER 
, COST NUMBER 
, CARDINALITY NUMBER 
, BYTES NUMBER 
, OTHER_TAG VARCHAR2(255 BYTE) 
, PARTITION_START VARCHAR2(255 BYTE) 
, PARTITION_STOP VARCHAR2(255 BYTE) 
, PARTITION_ID NUMBER 
, OTHER LONG 
, DISTRIBUTION VARCHAR2(30 BYTE) 
);

CREATE TABLE SMS.SECURE_MESSAGE 
(
  SECURE_MESSAGE_ID NUMBER NOT NULL 
, CLINICIAN_STATUS NUMBER NOT NULL 
, COMPLETED_DATE DATE 
, ASSIGNED_TO NUMBER 
, CHECKSUM CHAR(32 BYTE) 
, THREAD_ID NUMBER NOT NULL 
, STATUS_SET_BY NUMBER 
, OPLOCK NUMBER DEFAULT 0 NOT NULL 
, ACTIVE NUMBER DEFAULT 1 NOT NULL 
, CREATED_DATE DATE DEFAULT SYSDATE NOT NULL 
, MODIFIED_DATE DATE DEFAULT SYSDATE NOT NULL 
, ESCALATED DATE DEFAULT NULL 
, BODY CLOB 
, SENT_DATE DATE 
, SENDER_TYPE NUMBER NOT NULL 
, SENDER_ID NUMBER NOT NULL 
, SENDER_NAME VARCHAR2(100 BYTE) NOT NULL 
, RECIPIENT_TYPE NUMBER 
, RECIPIENT_ID NUMBER 
, RECIPIENT_NAME VARCHAR2(100 BYTE) 
, SENT_DATE_LOCAL DATE 
, ESCALATION_NOTIFICATION_DATE DATE 
, ESCALATION_NOTIFICATION_TRIES NUMBER 
, READ_RECEIPT VARCHAR2(20 BYTE) 
, HAS_ATTACHMENT NUMBER(1, 0) DEFAULT 0 
, ATTACHMENT_ID NUMBER 
, CONSTRAINT SECURE_MESSAGE_PK PRIMARY KEY 
  (
    SECURE_MESSAGE_ID 
  )
  ENABLE 
);

CREATE TABLE SMS.SIGNATURE 
(
  SIGNATURE_ID NUMBER NOT NULL 
, USER_ID NUMBER NOT NULL 
, SIGNATURE_NAME VARCHAR2(60 BYTE) 
, SIGNATURE_TITLE VARCHAR2(60 BYTE) 
, SIGNATURE_INCLUDE NUMBER 
, OPLOCK NUMBER NOT NULL 
, CREATED_DATE TIMESTAMP(6) NOT NULL 
, MODIFIED_DATE TIMESTAMP(6) 
, CONSTRAINT SYS_C005585 PRIMARY KEY 
  (
    SIGNATURE_ID 
  , USER_ID 
  )
  ENABLE 
);

CREATE TABLE SMS.SMS_CREDENTIALS 
(
  SMS_CREDENTIALS_ID NUMBER NOT NULL 
, SMS_USER_ID NUMBER NOT NULL 
, OPLOCK NUMBER DEFAULT 0 NOT NULL 
, KEY VARCHAR2(1536 BYTE) 
, EXPIRATION_DATE TIMESTAMP(6) 
, CREATED_DATE TIMESTAMP(6) DEFAULT sysdate NOT NULL 
, MODIFIED_DATE TIMESTAMP(6) DEFAULT sysdate NOT NULL 
, CONSTRAINT SYS_C005591 PRIMARY KEY 
  (
    SMS_CREDENTIALS_ID 
  )
  ENABLE 
);

CREATE TABLE SMS.SMS_DATA_REPORT_LOGS 
(
  REPORT_RUN_START_TIME TIMESTAMP(6) 
, REPORT_RUN_END_TIME TIMESTAMP(6) 
, REPORT_RUN_STATUS VARCHAR2(20 BYTE) 
, REPORT_RUN_ERROR_MESSAGE VARCHAR2(4000 BYTE) 
);

CREATE TABLE SMS.SMS_DATA_REPORTS 
(
  VISN_ID NUMBER NOT NULL 
, STATION_NUMBER NUMBER NOT NULL 
, TRIAGE_GROUP_ID NUMBER NOT NULL 
, REPORT_DATE TIMESTAMP(6) NOT NULL 
, SUB_CATEGORY_ID NUMBER NOT NULL 
, VALUE NUMBER 
, CONSTRAINT SMS_DATA_REPORT_PK PRIMARY KEY 
  (
    VISN_ID 
  , STATION_NUMBER 
  , TRIAGE_GROUP_ID 
  , REPORT_DATE 
  , SUB_CATEGORY_ID 
  )
  ENABLE 
);

CREATE TABLE SMS.SMS_SURROGATE 
(
  SMS_SURROGATE_ID NUMBER NOT NULL 
, SMS_USER_ID NUMBER NOT NULL 
, SURROGATE_ID NUMBER NOT NULL 
, SURROGATE_TYPE NUMBER NOT NULL 
, SURROGATE_START_DATE TIMESTAMP(6) NOT NULL 
, SURROGATE_END_DATE TIMESTAMP(6) NOT NULL 
, SURROGATE_ALL_DAY NUMBER(1, 0) DEFAULT 0 
, OPLOCK NUMBER NOT NULL 
, CREATED_DATE TIMESTAMP(6) NOT NULL 
, TIMEZONE NUMBER NOT NULL 
, MODIFIED_DATE TIMESTAMP(6) 
, CONSTRAINT SYS_C005602 PRIMARY KEY 
  (
    SMS_SURROGATE_ID 
  )
  ENABLE 
);

CREATE TABLE SMS.SMS_USER 
(
  USER_ID NUMBER DEFAULT NULL NOT NULL 
, FIRST_NAME VARCHAR2(50 BYTE) NOT NULL 
, LAST_NAME VARCHAR2(50 BYTE) NOT NULL 
, USER_TYPE VARCHAR2(30 BYTE) NOT NULL 
, STATUS NUMBER DEFAULT 0 NOT NULL 
, EMAIL_ADDRESS VARCHAR2(100 BYTE) 
, OPLOCK NUMBER DEFAULT 0 NOT NULL 
, ACTIVE NUMBER DEFAULT 1 NOT NULL 
, CREATED_DATE DATE DEFAULT SYSDATE NOT NULL 
, MODIFIED_DATE DATE DEFAULT SYSDATE NOT NULL 
, DOB DATE 
, ICN VARCHAR2(50 BYTE) 
, SSN VARCHAR2(15 BYTE) 
, STATION_NO VARCHAR2(10 BYTE) 
, DUZ VARCHAR2(20 BYTE) 
, EMAIL_NOTIFICATION NUMBER DEFAULT 0 NOT NULL 
, DEFAULT_MESSAGE_FILTER NUMBER DEFAULT 0 NOT NULL 
, LAST_EMAIL_NOTIFICATION DATE 
, NSSN VARCHAR2(5 CHAR) 
, PROVIDER NUMBER DEFAULT 0 NOT NULL 
, EXTERNAL_USER_NAME VARCHAR2(50 BYTE) 
, MIDDLE_NAME VARCHAR2(25 CHAR) 
, CLINICAL_USER_TYPE_ID NUMBER 
, RELATIONSHIP_UPDATE TIMESTAMP(6) 
, NATIONAL NUMBER DEFAULT 0 NOT NULL 
, CONSTRAINT SYS_C005616 PRIMARY KEY 
  (
    USER_ID 
  )
  ENABLE 
);

CREATE TABLE SMS.STATION_TIMEZONE_MAP 
(
  STATION_TIMEZONE_ID NUMBER NOT NULL 
, STATION_NUMBER VARCHAR2(15 CHAR) NOT NULL 
, TIMEZONE VARCHAR2(30 CHAR) NOT NULL 
, ACTIVE NUMBER DEFAULT 1 
, OPLOCK NUMBER DEFAULT 0 
, CREATED_DATE DATE DEFAULT SYSDATE NOT NULL 
, MODIFIED_DATE DATE DEFAULT SYSDATE NOT NULL 
, CONSTRAINT STATION_TIMEZONE_MAP_PK PRIMARY KEY 
  (
    STATION_TIMEZONE_ID 
  )
  ENABLE 
);

CREATE TABLE SMS.SYSTEM_FOLDER 
(
  FOLDER_ID NUMBER NOT NULL 
, FOLDER_NAME VARCHAR2(30 BYTE) NOT NULL 
, OPLOCK NUMBER DEFAULT 0 NOT NULL 
, ACTIVE NUMBER DEFAULT 1 NOT NULL 
, CREATED_DATE DATE DEFAULT SYSDATE NOT NULL 
, MODIFIED_DATE DATE DEFAULT SYSDATE NOT NULL 
, USER_ID NUMBER 
, CONSTRAINT SYSTEM_FOLDER_PK PRIMARY KEY 
  (
    FOLDER_ID 
  )
  ENABLE 
);

CREATE TABLE SMS.TIU_CREATION_RECORD 
(
  TIU_NOTE_ID NUMBER NOT NULL 
, THREAD_ID NUMBER NOT NULL 
, VISTA_DIV VARCHAR2(10 BYTE) NOT NULL 
, LAST_MESSAGE_ID NUMBER NOT NULL 
, CONVERSATION_ID VARCHAR2(100 BYTE) 
, ACTIVE NUMBER DEFAULT 1 NOT NULL 
, OPLOCK NUMBER DEFAULT 0 NOT NULL 
, CREATED_DATE DATE DEFAULT SYSDATE NOT NULL 
, MODIFIED_DATE DATE DEFAULT SYSDATE NOT NULL 
, LOCKED_DATE DATE DEFAULT NULL 
, NOTE_CREATION_DATE DATE 
, COMMENTS VARCHAR2(100 BYTE) 
);

CREATE TABLE SMS.TRIAGE_GROUP 
(
  TRIAGE_GROUP_ID NUMBER NOT NULL 
, TRIAGE_GROUP_NAME VARCHAR2(50 BYTE) NOT NULL 
, DESCRIPTION VARCHAR2(512 BYTE) 
, OPLOCK NUMBER DEFAULT 0 NOT NULL 
, ACTIVE NUMBER DEFAULT 1 NOT NULL 
, CREATED_DATE DATE DEFAULT SYSDATE NOT NULL 
, MODIFIED_DATE DATE DEFAULT SYSDATE NOT NULL 
, VISTA_DIV VARCHAR2(7 BYTE) 
, CONSTRAINT SYS_C005649 PRIMARY KEY 
  (
    TRIAGE_GROUP_ID 
  )
  ENABLE 
);

CREATE TABLE SMS.TRIAGE_RELATION 
(
  RELATION_ID NUMBER NOT NULL 
, RELATION_NAME VARCHAR2(512 BYTE) NOT NULL 
, TRIAGE_GROUP_ID NUMBER NOT NULL 
, RELATION_TYPE NUMBER NOT NULL 
, VISTA_DIV VARCHAR2(10 BYTE) 
, VISTA_IEN VARCHAR2(20 BYTE) 
, OPLOCK NUMBER DEFAULT 0 NOT NULL 
, ACTIVE NUMBER DEFAULT 1 NOT NULL 
, CREATED_DATE DATE DEFAULT SYSDATE NOT NULL 
, MODIFIED_DATE DATE DEFAULT SYSDATE NOT NULL 
, CONSTRAINT TRIAGE_RELATION_PK PRIMARY KEY 
  (
    RELATION_ID 
  )
  ENABLE 
);

CREATE TABLE SMS.USER_DGROUP_MAP 
(
  DIST_GROUP_ID NUMBER NOT NULL 
, USER_ID NUMBER NOT NULL 
, CONSTRAINT SYS_C005662 PRIMARY KEY 
  (
    DIST_GROUP_ID 
  , USER_ID 
  )
  ENABLE 
);

CREATE TABLE SMS.USER_FACILITY 
(
  SMS_USER_ID NUMBER NOT NULL 
, FACILITY_ID NUMBER NOT NULL 
, OPLOCK NUMBER DEFAULT 0 NOT NULL 
, CREATED_DATE TIMESTAMP(6) DEFAULT sysdate NOT NULL 
, CONSTRAINT SYS_C005667 PRIMARY KEY 
  (
    SMS_USER_ID 
  , FACILITY_ID 
  )
  ENABLE 
);

CREATE TABLE SMS.USER_SURROGATE 
(
  US_ID NUMBER NOT NULL 
, SURROGATE_USER_ID NUMBER NOT NULL 
, USER_ID NUMBER NOT NULL 
, CONSTRAINT SYS_C005671 PRIMARY KEY 
  (
    US_ID 
  , USER_ID 
  )
  ENABLE 
);

CREATE TABLE SMS.USER_VISN 
(
  SMS_USER_ID NUMBER NOT NULL 
, FACILITY_ID NUMBER NOT NULL 
, OPLOCK NUMBER DEFAULT 0 NOT NULL 
, CREATED_DATE TIMESTAMP(6) DEFAULT sysdate NOT NULL 
, CONSTRAINT SYS_C005677 PRIMARY KEY 
  (
    SMS_USER_ID 
  , FACILITY_ID 
  )
  ENABLE 
); 

