CREATE USER healthadapter
	IDENTIFIED BY removed_for_commit;
	

/* Permissions to login */
GRANT
	CREATE SESSION
TO healthadapter;


/* SELECT Permissions to all tables */
GRANT
	SELECT ON SMS.ADDRESSEE
TO healthadapter;
GRANT
  SELECT ON SMS.ADMIN_OVERRIDE
TO healthadapter;
GRANT
  SELECT ON SMS.ADMIN_RIGHTS 
TO healthadapter;
GRANT
	SELECT ON SMS.CLINICAL_USER_TYPE
TO healthadapter;
GRANT
	SELECT ON SMS.CLINICIAN_TRIAGE_MAP
TO healthadapter;
GRANT	
	SELECT ON SMS.DISTRIBUTION_GROUP
TO healthadapter;
GRANT
	SELECT ON SMS.FACILITY
TO healthadapter;
GRANT	
	SELECT ON SMS.FOLDER
TO healthadapter;
GRANT
	SELECT ON SMS.HOLIDAY
TO healthadapter;
GRANT	
	SELECT ON SMS.MESSAGE_ACTIVITY
TO healthadapter;
GRANT	
	SELECT ON SMS.MESSAGE_ANNOTATION
TO healthadapter;
GRANT	
	SELECT ON SMS.MESSAGE_ATTACHMENT
TO healthadapter;
GRANT	
	SELECT ON SMS.MESSAGE_THREAD
TO healthadapter;
GRANT	
	SELECT ON SMS.PATIENT_FACILITY
TO healthadapter;
GRANT		
	SELECT ON SMS.PATIENT_TRIAGE_MAP
TO healthadapter;
GRANT	
	SELECT ON SMS.PLAN_TABLE
TO healthadapter;
GRANT	
	SELECT ON SMS.SECURE_MESSAGE
TO healthadapter;
GRANT
	SELECT ON SMS.SIGNATURE
TO healthadapter;
GRANT	
	SELECT ON SMS.SMS_CREDENTIALS
TO healthadapter;
GRANT	
	SELECT ON SMS.SMS_DATA_REPORT_LOGS
TO healthadapter;
GRANT
	SELECT ON SMS.SMS_DATA_REPORTS
TO healthadapter;
GRANT
	SELECT ON SMS.SMS_SURROGATE
TO healthadapter;
GRANT	
	SELECT ON SMS.SMS_USER
TO healthadapter;
GRANT	
	SELECT ON SMS.STATION_TIMEZONE_MAP
TO healthadapter;
GRANT	
	SELECT ON SMS.SYSTEM_FOLDER
TO healthadapter;
GRANT	
	SELECT ON SMS.TIU_CREATION_RECORD
TO healthadapter;
GRANT	
	SELECT ON SMS.TRIAGE_GROUP 
TO healthadapter;
GRANT	
	SELECT ON SMS.TRIAGE_GROUP
TO healthadapter;
GRANT	
	SELECT ON SMS.TRIAGE_RELATION
TO healthadapter;
GRANT	
	SELECT ON SMS.USER_DGROUP_MAP
TO healthadapter;
GRANT	
	SELECT ON SMS.USER_FACILITY
TO healthadapter;
GRANT	
	SELECT ON SMS.USER_SURROGATE
TO healthadapter;
GRANT	
	SELECT ON SMS.USER_VISN
TO healthadapter;


/* INSERT Permissions to tables that need writing */
GRANT
	INSERT ON SMS.ADDRESSEE
TO healthadapter;
GRANT
	INSERT ON SMS.MESSAGE_THREAD
TO healthadapter;
GRANT
	INSERT ON SMS.SECURE_MESSAGE
TO healthadapter;
GRANT
	INSERT ON SMS.FOLDER
TO healthadapter;
GRANT
	INSERT ON SMS.MESSAGE_ATTACHMENT
TO healthadapter;


/* UPDATE Permissions to tables that get updated */
GRANT
	UPDATE ON SMS.ADDRESSEE
TO healthadapter;
GRANT
 	UPDATE ON SMS.MESSAGE_THREAD
TO healthadapter;
GRANT
	UPDATE ON SMS.SECURE_MESSAGE
TO healthadapter;
GRANT
	UPDATE ON SMS.SMS_USER
TO healthadapter;
GRANT
	UPDATE ON SMS.MESSAGE_ATTACHMENT
TO healthadapter;
GRANT
	UPDATE ON SMS.FOLDER
TO healthadapter;
