/*
	This file provides cleanup scripts for the main patient that we map Gallow Younger to (MHV test patient 71)
*/


-- Look at the triage group information assigned to our main patient
select * from triage_group tg
  join triage_relation tr on tr.triage_group_id = tg.triage_group_id
  join patient_triage_map ptm on ptm.relation_id = tr.relation_id
where ptm.user_id = 71;

-- Rename the group names that get displayed in the application
update triage_group set triage_group_name = 'Ask a Patient Travel Question Test VAMC' where triage_group_id = 24616;
update triage_group set triage_group_name = 'Ask a Pharmacist Test VAMC' where triage_group_id = 25615;
update triage_group set triage_group_name = 'Billing or Co-pay Challenges Test VAMC' where triage_group_id = 13124;
update triage_group set triage_group_name = 'Chaplain Service Test VAMC' where triage_group_id = 17985;
update triage_group set triage_group_name = 'My HealtheVet Test' where triage_group_id = 979;
update triage_group set triage_group_name = 'My HealtheVet/Secure Messaging Test VAMC' where triage_group_id = 4891;
update triage_group set triage_group_name = 'Patient Advocate Test VAMC' where triage_group_id = 5841;

-- Rename the relation names so that they match up with the group names
update triage_relation set relation_name = 'Pharmacist VAMC Triage Group' where triage_group_id = 25615;
update triage_relation set relation_name = 'Patient Travel Triage Group' where triage_group_id = 24616;
update triage_relation set relation_name = 'Billing / Co-pay Challenge Triage Group' where triage_group_id = 13124;
update triage_relation set relation_name = 'Ny HealtheVet Triage Group' where triage_group_id = 979;
update triage_relation set relation_name = 'Patient Travel Triage Group' where triage_group_id = 5841;
update triage_relation set relation_name = 'Patient Advocate Triage Group' where triage_group_id = 17985;
update triage_relation set relation_name = 'MHV Secure Message Triage Group' where triage_group_id = 4891;

-- Delete extraneous triage entries that aren't needed for our main patient
delete from patient_triage_map where user_id = 71 and ptm_id = 8626;
delete from patient_triage_map where user_id = 71 and ptm_id = 35111;
delete from patient_triage_map where user_id = 71 and ptm_id = 9925;
delete from patient_triage_map where user_id = 71 and ptm_id = 14432;
delete from patient_triage_map where user_id = 71 and ptm_id = 18322;