-- Get columns for User 71's Inbox
select msg.secure_message_id, msg.recipient_id, thrd.triage_group_id from addressee addr
  left join folder f on f.folder_id = addr.folder_id
  join secure_message msg on msg.secure_message_id = addr.secure_message_id
  join message_thread thrd  on thrd.thread_id = msg.thread_id
where addr.user_id = 71 and addr.folder_id = 0 order by addr.secure_message_id;

-- Change the recipient to a valid value for user 71 for all inbox messages (so that reply does not fail)
update secure_message set recipient_id = 979 where secure_message_id in (select secure_message_id from addressee where user_id = 71 and folder_id = 0)

