package com.agilex.healthcare.mobilehealthplatform.web;

import static org.junit.Assert.assertNull;

import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.context.SecurityContextHolder;

import com.agilex.security.oauth.SSOePreAuthFilter;

public class SSOePreAuthFilterTest {
	
    @Test(expected=AccessDeniedException.class)
    public void nullEdipiIdOnAuthentication() throws Exception {
    	SSOePreAuthFilter preAuthFilter = new SSOePreAuthFilter();
    	MockHttpServletRequest request = new MockHttpServletRequest();
        preAuthFilter.getPreAuthenticatedPrincipal(request);
        assertNull(SecurityContextHolder.getContext().getAuthentication());
    }    

    @Test(expected=AccessDeniedException.class)
    public void emptyEdipiIdOnAuthentication() throws Exception {
    	SSOePreAuthFilter preAuthFilter = new SSOePreAuthFilter();
    	MockHttpServletRequest request = new MockHttpServletRequest();
    	request.addHeader("VA_EAUTH_DODEDIPNID", "");
        preAuthFilter.getPreAuthenticatedPrincipal(request);
        assertNull(SecurityContextHolder.getContext().getAuthentication());
    }    

    @Test(expected=AccessDeniedException.class)
    public void NotFoundEdipiIdOnAuthentication() throws Exception {
    	SSOePreAuthFilter preAuthFilter = new SSOePreAuthFilter();
    	MockHttpServletRequest request = new MockHttpServletRequest();
    	request.addHeader("VA_EAUTH_DODEDIPNID", "NOT_FOUND");
        preAuthFilter.getPreAuthenticatedPrincipal(request);
        assertNull(SecurityContextHolder.getContext().getAuthentication());
    }    
    
    @Test(expected=AccessDeniedException.class)
    public void emptyNoTrimEdipiIdOnAuthentication() throws Exception {
    	SSOePreAuthFilter preAuthFilter = new SSOePreAuthFilter();
    	MockHttpServletRequest request = new MockHttpServletRequest();
    	request.addHeader("VA_EAUTH_DODEDIPNID", " ");
        preAuthFilter.getPreAuthenticatedPrincipal(request);
        assertNull(SecurityContextHolder.getContext().getAuthentication());
    }    

    @Test(expected=AccessDeniedException.class)
    public void NotFoundNoTrimEdipiIdOnAuthentication() throws Exception {
    	SSOePreAuthFilter preAuthFilter = new SSOePreAuthFilter();
    	MockHttpServletRequest request = new MockHttpServletRequest();
    	request.addHeader("VA_EAUTH_DODEDIPNID", "NOT_FOUND ");
        preAuthFilter.getPreAuthenticatedPrincipal(request);
        assertNull(SecurityContextHolder.getContext().getAuthentication());
    }     
    
}
