package com.agilex.healthcare.mobilehealthplatform.authorization;

import com.agilex.healthcare.utility.DateHelper;
import org.junit.Before;
import org.junit.Test;

import java.util.Date;

public class ResourceLastAccessedTimeTest {
    ResourceLastAccessedTime resourceLastAccessedTime;
    private int sessionTimeoutInSeconds = 63;

    @Before
    public  void setUp() {
        resourceLastAccessedTime =  new ResourceLastAccessedTime();
        resourceLastAccessedTime.setLastAccessedTime(new Date(System.currentTimeMillis() - 60 * 1000));
    }

    @Test
    public void testTimeToExpire() {

        while ((sessionTimeoutInSeconds - DateHelper.calculateDeltaInSeconds(resourceLastAccessedTime.getLastAccessedTime(), new Date()))> 0 ) {
            resourceLastAccessedTime.setTimeToExpireInSeconds(
                    sessionTimeoutInSeconds  - (DateHelper.calculateDeltaInSeconds(resourceLastAccessedTime.getLastAccessedTime(), new Date())));
            System.out.println("Time to Expire the token is " + resourceLastAccessedTime.getTimeToExpireInSeconds());
            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

    }
}
