package com.agilex.security.oauth;

import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.approval.TokenServicesUserApprovalHandler;

import com.agilex.healthcare.utility.NullChecker;

public class UserApprovalHandler extends TokenServicesUserApprovalHandler {

	private String permittedRedirectUris;
	private boolean useTokenServices;
	
	public String getPermittedRedirectUris() {
		return permittedRedirectUris;
	}

	public void setPermittedRedirectUris(String permittedRedirectUris) {
		this.permittedRedirectUris = permittedRedirectUris;
	}
	
	public void setUseTokenServices(boolean useTokenServices) {
		this.useTokenServices = useTokenServices;
	}

	/**
	 * Allows automatic approval for a white list of clients in the implicit grant case.
	 * 
	 * @param authorizationRequest The authorization request.
	 * @param userAuthentication the current user authentication
	 * 
	 * @return Whether the specified request has been approved by the current user.
	 */
	@Override
	public boolean isApproved(AuthorizationRequest authorizationRequest, Authentication userAuthentication) {

		String redirectUri = authorizationRequest.getRedirectUri();
		
		if(!redirectUriIsPermitted(redirectUri)) {
			//Clear security context
			SecurityContextHolder.clearContext();
			return false;
        }
		
		return true;
	}
	
    /*
    * This method ensures that the URI matches permitted base uris
    * using properties configured on the classpath.
    *
    * The property associated with KEY_REDIRECT_URI_ROOTS can be a comma
    * separated list of base URIs
    *
    * @param redirectUri
    */
    boolean redirectUriIsPermitted(String redirectUri) {
        if(NullChecker.isNullish(redirectUri))
            return false;

        if(NullChecker.isNotNullish(permittedRedirectUris)) {
            String[] roots = permittedRedirectUris.split(",");

            String ignoreCaseRedirectUri = redirectUri.toLowerCase();
            for (String root : roots) {
                String ignoreCaseRoot = root.toLowerCase();
                if (ignoreCaseRedirectUri.startsWith(ignoreCaseRoot))
                    return true;
            }
            return false;
        }else{
        	return true;
        }
    }	

}
