package com.agilex.security.oauth;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.dto.AssigningAuthorityCode;
import com.agilex.vamf.message.GenericMessage;
import com.agilex.vamf.message.MessagePublisher;
import com.agilex.vamf.message.exception.MessagePublishException;

public class SSOePreAuthFilter extends AbstractPreAuthenticatedProcessingFilter {

    private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(SSOePreAuthFilter.class);

    private static String VA_EAUTH_CSID = "va_eauth_csid";
	private static String VA_EAUTH_AUTHENTICATIONMETHOD	= "va_eauth_authenticationmethod";
    private static String VA_EAUTH_AUTHENTICATION_AUTHORITY = "va_eauth_authenticationauthority";

    private static String VA_EAUTH_DODEDIPNID =	"va_eauth_dodedipnid";
    private static String VA_EAUTH_SUBJECT_DODEDIPNID =	"va_eauth_subject_edi";
    private static String VA_EAUTH_SURROGATE_DIDEDIPID= "va_eauth_surrogate_edi";

    private static String VA_EAUTH_ID =	"va_eauth_id";
    private static String VA_EAUTH_ID_TYPE = "va_eauth_idtype";
    private static String VA_EAUTH_FIRSTNAME =	"va_eauth_firstname";
	private static String VA_EAUTH_MIDDLENAME =	"va_eauth_middlename";
	private static String VA_EAUTH_LASTNAME	= "va_eauth_lastname";
	private static String VA_EAUTH_STATUS = "va_eauth_status";
	private static String VA_EAUTH_GENDER =	"va_eauth_gender";
	private static String VA_EAUTH_BIRTHDATE =	"va_eauth_birthdate";

    private static String VA_EAUTH_SUBJECT_ID =	"va_eauth_subject_id";
    private static String VA_EAUTH_SUBJECT_ID_TYPE = "va_eauth_subject_idtype";
    private static String VA_EAUTH_SUBJECT_FIRSTNAME =	"va_eauth_subject_firstname";
    private static String VA_EAUTH_SUBJECT_MIDDLENAME =	"va_eauth_subject_middlename";
    private static String VA_EAUTH_SUBJECT_LASTNAME	= "va_eauth_subject_lastname";
    private static String VA_EAUTH_SUBJECT_STATUS = "va_eauth_subject_status";
    private static String VA_EAUTH_SUBJECT_GENDER =	"va_eauth_subject_gender";
    private static String VA_EAUTH_SUBJECT_BIRTHDATE =	"va_eauth_subject_birthdate";
    
    private static String VA_EAUTH_SURROGATE_LASTNAME = "va_eauth_surrogate_lastName";
    private static String VA_EAUTH_SURROGATE_FIRSTNAME = "va_eauth_surrogate_firstName";
    private static String VA_EAUTH_SURROGATE_MIDDLENAME = "va_eauth_surrogate_middlName";

    @Resource
    MessagePublisher icnMessagePublisher;
    
    @Override
	protected Object getPreAuthenticatedCredentials(HttpServletRequest request) {
		logger.info("------GET PRE AUTHENTICATED CREDENTIALS-----");
		return "N/A";
	}

	@Override
	public Object getPreAuthenticatedPrincipal(HttpServletRequest request) {
		logger.info("------GET PRE AUTHENTICATED PRINCIPAL-----");
		getHeaderData(request);
		IamAppUser iamAppUser = constructSSOePrincipal(request);
		
		publishICNServiceMessage(iamAppUser.getIamUser().getPatientEdipId());
		
		return iamAppUser;
	}
	
	/**
	 * Publish message for ICN update Service.
	 * 
	 * @param patientEdipId
	 */
	private void publishICNServiceMessage(String patientEdipId) {
		PatientIdentifier patientIdentifier = new PatientIdentifier(AssigningAuthorityCode.EDIPI, patientEdipId);
		GenericMessage icnMessage = new GenericMessage(patientIdentifier);
		try {
			logger.info("Publishing ICN message for patientEdipId");
			icnMessagePublisher.publishMessage(icnMessage);
		} catch (MessagePublishException e) {
			logger.error("Error publishing ICN message for patientEdipId");
			//throw new RuntimeException(e);
		}
	}
	
	private IamAppUser constructSSOePrincipal(HttpServletRequest request) {
		validateEdipiId(request);
		IamUser iamUser = createUser(request);
        iamUser.setAuthenticationAuthority(request.getHeader(VA_EAUTH_AUTHENTICATION_AUTHORITY));
        iamUser.setAuthenticationMethod(request.getHeader(VA_EAUTH_AUTHENTICATIONMETHOD));
        iamUser.setAccessCode(request.getHeader(VA_EAUTH_CSID));

     	Collection<GrantedAuthority> grantedAuthorities = new ArrayList<GrantedAuthority>();
        grantedAuthorities.add(new SimpleGrantedAuthority("ROLE_MHP_USER"));
        grantedAuthorities.add(new SimpleGrantedAuthority("ROLE_CONSUMER"));

		IamAppUser iamAppUser = new IamAppUser(iamUser.getId(), "N/A", grantedAuthorities, iamUser);
		
		return iamAppUser;
	}

	private void validateEdipiId(HttpServletRequest request) {
		String edipID = request.getHeader(VA_EAUTH_DODEDIPNID);
		if (edipID == null || "NOT_FOUND".equalsIgnoreCase(edipID.trim()) || "".equals(edipID.trim())) {
			logger.error("EAUTH DOD EDIPI ID is missing/incorrect for user");
	        SecurityContextHolder.clearContext();
			throw new AccessDeniedException (
					"User Access denied, DOD EDIPI ID is missing/incorrect");
		}
	}

	private IamUser createUser(HttpServletRequest request) {
        IamUser iamUser;

        String surrogateEdipID = request.getHeader(VA_EAUTH_SURROGATE_DIDEDIPID);

        if (surrogateEdipID == null || "NOT_FOUND".equals(surrogateEdipID.trim()) || "".equals(surrogateEdipID.trim())) {
        	logger.info("User is a patient");
            //patient or provider
            iamUser = new IamUser(request.getHeader(VA_EAUTH_DODEDIPNID),
                    request.getHeader(VA_EAUTH_LASTNAME),
                    request.getHeader(VA_EAUTH_FIRSTNAME),
                    request.getHeader(VA_EAUTH_MIDDLENAME));

            if ("SSN".equalsIgnoreCase(request.getHeader(VA_EAUTH_ID_TYPE))) {
            	iamUser.setPatientSSN(request.getHeader(VA_EAUTH_ID));
            }

            iamUser.setPatientEdipId(request.getHeader(VA_EAUTH_DODEDIPNID));
            iamUser.setPatientGender(request.getHeader(VA_EAUTH_GENDER));
            iamUser.setPatientDOB(request.getHeader(VA_EAUTH_BIRTHDATE));
            iamUser.setPatientFirstName(request.getHeader(VA_EAUTH_FIRSTNAME));
            iamUser.setPatientMiddleName(request.getHeader(VA_EAUTH_MIDDLENAME));
            iamUser.setPatientLastName(request.getHeader(VA_EAUTH_LASTNAME));
            iamUser.setPatientStatus(request.getHeader(VA_EAUTH_STATUS));
        } else {
            //surrogate user
        	logger.info("User is a surrogate");
            iamUser = new IamUser(surrogateEdipID,
                    request.getHeader(VA_EAUTH_SURROGATE_LASTNAME),
                    request.getHeader(VA_EAUTH_SURROGATE_FIRSTNAME),
                    request.getHeader(VA_EAUTH_SURROGATE_MIDDLENAME));
            
            if ("SSN".equalsIgnoreCase(request.getHeader(VA_EAUTH_SUBJECT_ID_TYPE))) {
            	iamUser.setPatientSSN(request.getHeader(VA_EAUTH_SUBJECT_ID));
            }

            iamUser.setPatientEdipId(request.getHeader(VA_EAUTH_SUBJECT_DODEDIPNID));
            iamUser.setPatientGender(request.getHeader(VA_EAUTH_SUBJECT_GENDER));
            iamUser.setPatientDOB(request.getHeader(VA_EAUTH_SUBJECT_BIRTHDATE));
            iamUser.setPatientFirstName(request.getHeader(VA_EAUTH_SUBJECT_FIRSTNAME));
            iamUser.setPatientMiddleName(request.getHeader(VA_EAUTH_SUBJECT_MIDDLENAME));
            iamUser.setPatientLastName(request.getHeader(VA_EAUTH_SUBJECT_LASTNAME));
            iamUser.setPatientStatus(request.getHeader(VA_EAUTH_SUBJECT_STATUS));
        }
        
        return iamUser;
    }

    private void getHeaderData(HttpServletRequest request) {
		logger.info("Processing Header Information");
		for (Enumeration<String> e = request.getHeaderNames(); e.hasMoreElements();) {
			String key = e.nextElement();
			String value = request.getHeader(key);
		}
	}
}
