package com.agilex.security.oauth;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.InMemoryTokenStore;

public class IamInMemoryTokenStore extends InMemoryTokenStore implements TokenStoreLogout {
	
	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(IamInMemoryTokenStore.class);

	private final  ConcurrentHashMap<String, List<String>> userTokens = new ConcurrentHashMap<String, List<String>>();  

	@Override
	public void storeAccessToken(OAuth2AccessToken token, OAuth2Authentication authentication) {
		IamAppUser userIam = (IamAppUser)authentication.getUserAuthentication().getPrincipal();
		addToken(userIam.getIamUser().getId(), token.getValue());
		super.storeAccessToken(token, authentication);
	}
	
	private void addToken(String userName, String accessToken){
		List<String> accessTokens = userTokens.get(userName);
		if (accessTokens == null){
			accessTokens = new ArrayList<String>();
			userTokens.put(userName, accessTokens);
		}
		accessTokens.add(accessToken);
	}
	
	private String getCurrentUserId(Authentication authentication){
		IamAppUser iamAppUser = (IamAppUser) authentication.getPrincipal();
		IamUser mhpUser = iamAppUser.getIamUser();
		return mhpUser.getId();
	}

    @Override
    public void removeAllUSerTokens(Authentication authentication) {
        String userName = getCurrentUserId(authentication);
        logger.info("Removing access tokens for user");

        List<String> accessTokens = userTokens.get(userName);

        if (accessTokens != null) {
            for (String accessToken : accessTokens) {
                super.removeAccessToken(accessToken);
            }
            userTokens.remove(userName);
        }
    }
}
