package com.agilex.security.oauth;

import java.util.Collection;

import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.User;

/**
 * 
 * Models core user information retrieved to be used in SecurityContext. This
 * extends the base class
 * {@link org.springframework.security.core.userdetails.User} which has
 * implementation for basic security attributes. This class (a Composition) also includes
 * {@link com.agilex.security.oauth.IamUser} and the ProviderID comes from this object (a Delegation)
 *
 * @author Seena K.
 * 
 */
public class IamAppUser extends User {

	private IamUser user;

	//default values; these are not used within the MHP app at this time.
	private static boolean enabled			 	 = true;
	private static boolean accountNonExpired 	 = true;
	private static boolean credentialsNonExpired = true;
	private static boolean accountNonLocked 	 = true;

	public IamAppUser(String username, String password, Collection<? extends GrantedAuthority> authorities, IamUser authenticatedUser) {
		super(username, password, enabled, credentialsNonExpired, accountNonLocked, accountNonExpired, authorities);
        user = authenticatedUser;
    }

	public String getProviderId() {
	     return user.getId();
    }

	public IamUser getIamUser() {
	    return user;
    }

	/**
     * 
     */
    private static final long serialVersionUID = 1L;
    
}
