package com.agilex.healthcare.mobilehealthplatform.security;

import java.util.Date;

import org.apache.commons.lang.time.DateUtils;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

import com.agilex.healthcare.mobilehealthplatform.domain.HealthAdvocateSupportUser;

public class VbaUserFactory {

	public static HealthAdvocateSupportUser createFromSecurityContext() {
        SecurityContext ctx = SecurityContextHolder.getContext();
        return createFromAuthentication(ctx.getAuthentication());
    }

    public static HealthAdvocateSupportUser createFromAuthentication(Authentication authentication) {    	
    	if (authentication != null && authentication instanceof UsernamePasswordAuthenticationToken) {
        	return getUserFromAuth((UsernamePasswordAuthenticationToken)authentication);
    	} else {
        	return getUnknownUser();
    	}
    }
    
    private static HealthAdvocateSupportUser getUnknownUser() {
        HealthAdvocateSupportUser vbaUser = new HealthAdvocateSupportUser();
        vbaUser.setUserId("unknown");
        vbaUser.setPassword("unknown");
        Date date = new Date();
        date = DateUtils.addYears(date, 1);
        vbaUser.setPasswordExpiredDate(date);
        return vbaUser;
    }
    
    private static HealthAdvocateSupportUser getUserFromAuth(UsernamePasswordAuthenticationToken authentication) {
        VbaUser vbaUser = (VbaUser)authentication.getPrincipal();
        return vbaUser.getVbaUser();
    }
}
