package com.agilex.healthcare.mobilehealthplatform.security;

import java.util.Collection;
import java.util.Date;

import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.User;

import com.agilex.healthcare.mobilehealthplatform.domain.HealthAdvocateSupportUser;

public class VbaUser extends User {

	private HealthAdvocateSupportUser vbaUser;

	//default values; these are not used within the MHP app at this time.
	private static boolean enabled			 	 = true;
	private static boolean accountNonExpired 	 = true;
	private static boolean credentialsNonExpired = true;
	private static boolean accountNonLocked 	 = true;
	
	private Date lastRequest;
	
	public VbaUser(String username, String password, Collection<? extends GrantedAuthority> authorities, HealthAdvocateSupportUser authenticatedUser) {
		super(username, password, enabled, credentialsNonExpired, accountNonLocked, accountNonExpired, authorities);
	    vbaUser = authenticatedUser;
    }

	public String getUserId() {
	     return vbaUser.getUserId();
    }

	public HealthAdvocateSupportUser getVbaUser() {
	    return vbaUser;
    }
	
	public Date getLastRequest() {
		return lastRequest;
	}

	public void setLastRequest(Date lastRequest) {
		this.lastRequest = lastRequest;
	}

	/**
     * 
     */
    private static final long serialVersionUID = 1L;
    
}
