package com.agilex.healthcare.mobilehealthplatform.oauth;

import org.springframework.security.oauth2.provider.ClientDetails;

public interface OauthClientDetails extends ClientDetails {
    /**
     * The timeout value for this client. Null if not set explicitly.
     * 
     * @return the timeout value
     */
    Integer getTimeoutSeconds();
    
    /**
     * Is this client has long durable session. No, if not set explicitly.
     * 
     * @return true or false
     */
    boolean isLongDurableSession();
}
