package com.agilex.healthcare.mobilehealthplatform.oauth;

import javax.servlet.http.HttpServletRequest;

import org.springframework.security.oauth2.common.OAuth2AccessToken;

import com.agilex.healthcare.utility.NullChecker;

public class Oauth2AccessTokenReader {

	public String readTokenFromHttpRequest(HttpServletRequest request) {
		String authorizationHeaderValue = request.getHeader("Authorization");

		if (NullChecker.isNotNullish(authorizationHeaderValue) && authorizationHeaderValue.toLowerCase().startsWith(OAuth2AccessToken.BEARER_TYPE.toLowerCase())) {
			String accesToken = authorizationHeaderValue.substring(
					OAuth2AccessToken.BEARER_TYPE.length()).trim();
			return accesToken;
		}

		return null;
	}

}
