package com.agilex.healthcare.mobilehealthplatform.oauth;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

import org.springframework.security.core.context.SecurityContextHolder;

public class HealthAdapterOauth2VerificationFilter implements Filter {
	
	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(HealthAdapterOauth2VerificationFilter.class);	
	
	/**
	 * Implementation is overridden to clear the context if the token is not present in the request.
	 */
	public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
		final HttpServletRequest request = (HttpServletRequest) req;
		
		Oauth2AccessTokenReader reader = new Oauth2AccessTokenReader();
		
		String tokenValue = reader.readTokenFromHttpRequest(request);
		
		if (tokenValue == null) {
			logger.info("Clear the security context as token is required for the resource endpoints");
			SecurityContextHolder.clearContext();
		}
	
		chain.doFilter(request, res);
	}
	

	@Override
	public void init(FilterConfig filterConfig) throws ServletException {
	}

	@Override
	public void destroy() {
	}
}
