package com.agilex.healthcare.mobilehealthplatform.dto;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

import com.agilex.healthcare.mobilehealthplatform.domain.Namespace;

@XmlAccessorType(value = XmlAccessType.PROPERTY)
@XmlRootElement(name = "authorizationRequest", namespace = Namespace.MobileHealthPlatform)
public class ClientAuthorizationRequest implements Serializable{

	private static final long serialVersionUID = -8983489939047784576L;

	public void setApprovalParameters(Map<String, String> approvalParameters) {
		this.approvalParameters = approvalParameters;
	}

	public void setClientId(String clientId) {
		this.clientId = clientId;
	}

	public void setScope(Set<String> scope) {
		this.scope = scope;
	}

	public void setResourceIds(Set<String> resourceIds) {
		this.resourceIds = resourceIds;
	}

	public void setApproved(boolean approved) {
		this.approved = approved;
	}

	public void setDenied(boolean denied) {
		this.denied = denied;
	}

	public void setState(String state) {
		this.state = state;
	}

	public void setRedirectUri(String redirectUri) {
		this.redirectUri = redirectUri;
	}

	public void setResponseTypes(Set<String> responseTypes) {
		this.responseTypes = responseTypes;
	}

	private Map<String, String> approvalParameters;
	private String clientId;
	private Set<String> scope;
	private Set<String> resourceIds;
	private boolean approved;
	private boolean denied;
	private String state;
	private String redirectUri;
	private Set<String> responseTypes;

	public ClientAuthorizationRequest() {
	}

	public Map<String, String> getApprovalParameters() {
		return this.approvalParameters;
	}

	public String getClientId() {
		return this.clientId;
	}

	public Set<String> getScope() {
		return this.scope;
	}

	public Set<String> getResourceIds() {
		return this.resourceIds;
	}

	public boolean isApproved() {
		return this.approved;
	}

	public boolean isDenied() {
		return this.denied;
	}

	public String getState() {
		return this.state;
	}

	public String getRedirectUri() {
		return this.redirectUri;
	}

	public Set<String> getResponseTypes() {
		return this.responseTypes;
	}

}
