package com.agilex.healthcare.mobilehealthplatform.authorization;

import java.io.Serializable;
import java.util.Date;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

import com.agilex.healthcare.mobilehealthplatform.domain.Namespace;

@XmlAccessorType(value = XmlAccessType.PROPERTY)
@XmlRootElement(name = "resourceLastAccessedTime", namespace = Namespace.MobileHealthPlatform)
public class ResourceLastAccessedTime implements Serializable{

	private static final long serialVersionUID = 952835989285254360L;
	private String userId;
	private Date lastAccessedTime;
	private Date lastLoginTime;
    private Integer timeToExpireInSeconds;  // Remaining time for the session to expire in seconds
	
	public Date getLastLoginTime() {
		return lastLoginTime;
	}
	public void setLastLoginTime(Date lastLoginTime) {
		this.lastLoginTime = lastLoginTime;
	}
	public String getUserId() {
		return userId;
	}
	public void setUserId(String userId) {
		this.userId = userId;
	}
	public Date getLastAccessedTime() {
		return lastAccessedTime;
	}
	public void setLastAccessedTime(Date lastAccessedTime) {
		this.lastAccessedTime = lastAccessedTime;
	}
    public Integer getTimeToExpireInSeconds() {return timeToExpireInSeconds; }
    public void setTimeToExpireInSeconds(Integer timeToExpireInSeconds) { this.timeToExpireInSeconds = timeToExpireInSeconds; }

}
