package com.agilex.healthcare.mobilehealthplatform.mdws;

import junit.framework.Assert;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.auth.provider.mdws.MdwsAppAuthenticatorMhpUserUtil;
import com.agilex.healthcare.mobilehealthplatform.domain.MdwsKey;
import com.agilex.healthcare.mobilehealthplatform.domain.MdwsKeys;
import com.agilex.healthcare.mobilehealthplatform.domain.MhpUser;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.UserTO;

public class MdwsAppAuthenticatorMhpUserUtilTest {
	
	@Test
	public void validateMhpUserUpdated() throws Exception{
		MhpUser mhpUser = new MhpUser();
		String mhpUserId = "TEST_ID";
		String mhpUserName = "TEST_NAME";
		mhpUser.setId(mhpUserId);
		UserTO mdwsUser = new UserTO();
		mdwsUser.setUsername(mhpUserName);
		String sessionId = "abcdefghijklmnopqrstuvwxyz";
		String baseMdwsUrl = "http://192.168.25.149/mdws3.0.2.5/";
		
		MdwsKeys keys = new MdwsKeys();
		for (int i=0; i<5; i++) {
			MdwsKey key = new MdwsKey();
			key.setId("TEST_ID_" + i);
			key.setName("TEST_NAME_" + i);
			keys.add(key);
		}

		MdwsAppAuthenticatorMhpUserUtil.updateMhpUser(mhpUser, mdwsUser, sessionId, baseMdwsUrl, keys);
		
		Assert.assertEquals(sessionId, mhpUser.getMdwsInfo().getSessionId());
		Assert.assertEquals(baseMdwsUrl, mhpUser.getMdwsInfo().getBaseUrl());
		assertMdwsMhpUser(mhpUser.getMdwsInfo(), sessionId, baseMdwsUrl);
	}
	
	private void assertMdwsMhpUser(MdwsInfo mdwsInfo, String sessionId, String baseUrl) {
		Assert.assertEquals(sessionId, mdwsInfo.getSessionId());
		Assert.assertEquals(baseUrl, mdwsInfo.getBaseUrl());
		MdwsKeys mdwsKeys = mdwsInfo.getKeys();
		Assert.assertNotNull(mdwsKeys);
		Assert.assertEquals(5, mdwsKeys.size());
		for (int i=0; i<5; i++) {
			String expectedId = "TEST_ID_" + i;
			String actualId = mdwsKeys.get(i).getId();
			String expectedName = "TEST_NAME_" + i;
			String actualName = mdwsKeys.get(i).getName();
			
			Assert.assertEquals(expectedId, actualId);
			Assert.assertEquals(expectedName, actualName);
		}
	}
}
