define([
	'Global',
	'primaryHeaderView',
	'Text!../../html/templates/common/primary.html'
	],
	function(Global, PrimaryHeaderView, primaryTemplate) {
		var PrimaryView = Backbone.View.extend({
			tagName: 'div',
			id: 'content-primary',
			attributes: {"class": "content-primary ui-btn-up-b", "data-tap-toggle": "false"},
			initialize: function() {
				this.template = _.template(primaryTemplate);
			},
			render: function() {
				var template = this.template,
					primaryHeaderView = new PrimaryHeaderView(),
				container = $(this.el),
				headerContainer;
				container.empty().append(template());
				
				headerContainer = $(container).find(":jqmData(role='header')");
				headerContainer.append(primaryHeaderView.render());

				return container;
				
			},
			events: {
				"tap #slide-btn": "slidePrimary",
				"swipe #slide-btn, #content-primary .ui-header": "slidePrimary"
			},
			slidePrimary: function(e) {
				e.preventDefault();
				Global.getUtilities().slidePrimary();
			}
		});
		
		return new PrimaryView();
	}
);