$(document).on("pageinit", ".provider-login", function () {
	"use strict";
	var recentLocations = readLocationsFromStorage('recentLocations');
	m.resources = new m.Resources();
	m.resources.fetch({async: false, url: "../../MobileHealthPlatformWeb/rest/public/resource-directory"});
	m.facilities = new m.Facilities();
	var submitted = false;
	var $username = $('#name-c'),
		$password = $('#password'),
		$error = $('.error'),
		$autocomplete = $('#autocomplete'),
		$autocompleteInput = $('#autocomplete-container input'),
		$facilityName = $('#facilityName'),
		$facilityCode = $('#facilityCode'),
		downToList = function (e) {
			if (e.which === 40) {
				$autocomplete.find('a:first').focus();
			}
		},
		clearErrors = function () {
			$error.text('');
		},
		showErrorMessage = function (text) {
			$error.text(text);
		},
		clearInputs = function () {
			$username.add($password).val("");
		},
		reset = function () {
			clearErrors();
			clearInputs();
			clearAutocompleteInput();
		},
		validateForm = function () {
			var emptyFields = [];
			
			if (submitted) {
				return false;
			}
			
			clearErrors();
			// have to use attr for IE9 support.
			if (!$username.val().trim().length) {
				emptyFields.push($username.attr('placeholder'));
			}
			if (!$password.val().trim().length) {
				emptyFields.push($password.attr('placeholder'));
			}

			var facilityNameVal = $autocompleteInput.val(),
				facilityCodeVal = $facilityCode.val();

			if (facilityCodeVal === "" && facilityNameVal) {
				var facility = findFacilityByName(recentLocations, facilityNameVal);

				if (facility) {
					$facilityCode.val(facility.facilityCode ? facility.facilityCode : facility.get('facilityCode') ? facility.get('facilityCode') : "");
				}
			}

			if (!$facilityCode.val().trim().length) {
				emptyFields.push('VA Hospital Location');
			}

			if (facilityNameVal !== $facilityName.val()) {
				showErrorMessage('Please enter a valid VA Hospital Location');
				return false;
			}

			if (emptyFields.length) {
				showErrorMessage('Please enter ' + emptyFields.join(' and '));
				return false;
			}

			writeLocationsToStorage('recentLocations', findFacilityByName(recentLocations, facilityNameVal));
			submitted = true;
			return true;
		};

	$autocomplete.on("listviewbeforefilter", function (e, data) {
		var $ul = $(this),
			$input = $(data.input),
			value = $input.val(),
			html = "",
			autoCompleteHtml = '<li data-role="list-divider">Search Results</li>',
			mostRecentHtml = '';

		$ul.html("");

		if (value && value.length > 1) {
			$ul.html("<li><div class='ui-loader'><span class='ui-icon ui-icon-loading'></span></div></li>");
			$ul.listview("refresh");

			if (recentLocations.length > 0) {
				mostRecentHtml = '<li data-role="list-divider">Most Recent Facilities</li>';
				$.each(recentLocations, function (i, val) {
					mostRecentHtml += "<li><a href='#' data-facility-name='" + val.name + "' data-facility-code='" + val.facilityCode + "'>" + convertFacilityToAutocompleteItem(val).label + "</a></li>";
				});
			}
			m.facilities.fetch({url: '/AuthorizationServices/rest/facility-service/facilities' + '?term=' + value})
				.then(function (response) {
					if (Array.isArray(response.facility)) {
						$.each(response.facility, function (i, val) {
							autoCompleteHtml += "<li><a href='#' data-facility-name='" + val.name + "' data-facility-code='" + val.facilityCode + "'>" + convertFacilityToAutocompleteItem(val).label + "</a></li>";
						});
					} else 
					{
						autoCompleteHtml += "<li><a href='#' data-facility-name='" + response.facility.name + "' data-facility-code='" + response.facility.facilityCode + "'>" + convertFacilityToAutocompleteItem(response.facility).label + "</a></li>";
					}

					html = autoCompleteHtml + mostRecentHtml;
					$ul.html(html);
					$ul.listview("refresh");
					$ul.trigger("updatelayout");
				});
		}
	});

	$('#resetLogin').on('click', reset);

	$('#logonForm')
		.on('submit', validateForm)
		.on('keyup', 'input', function (e) {
			var $this = $(e.currentTarget),
				empty = $this.val().length;

			$this[empty ? 'removeClass' : 'addClass']('empty');
		});

	$autocompleteInput.textinput({ preventFocusZoom: true });
	$autocomplete
		.on('tap', 'li.ui-btn-up-c a', function (e) {
			e.preventDefault();
			fillAutocompleteInput($(e.currentTarget));
		})
		.on('blur', 'a', function () {
			setTimeout(function () {
				if (!$('#autocomplete a').is(":focus")) {
					hideAutocompleteList();
				}
			}, 200);
		});

	$('#autocomplete-container')
		.on('keydown', 'a', handleKeyboardInteraction)
		.on('keydown', 'input', downToList)
		.on('change', 'input', function () {
			if (m.facilities.length) {
				clearErrors();
			} else {
				showErrorMessage('Please select a valid VA Hospital Location from the autocomplete results');
			}
		});

	function handleKeyboardInteraction(e) {
		switch (e.which) {
			case 38: //UP
				selectPreviousListItem(e);
				break;
			case 40: //DOWN
				selectNextListItem(e);
				break;
			case 13: //SPACE
			case 32: //ENTER
				e.preventDefault();
				fillAutocompleteInput($(e.currentTarget))
				break;
			case 27: //ESC
				hideAutocompleteList();
				$autocompleteInput.focus();
		}
	}

	function selectNextListItem(e) {
		e.preventDefault();
		var $focused = $(e.currentTarget),
			$selectableElements = $focused.parents('ul').find('a'),
			selectionIndex = $selectableElements.index($focused);

		if (selectionIndex < $selectableElements.length) {
			$selectableElements.eq(selectionIndex + 1).focus();
		}
	}

	function selectPreviousListItem(e) {
		e.preventDefault();
		var $focused = $(e.currentTarget),
			$selectableElements = $focused.parents('ul').find('a'),
			selectionIndex = $selectableElements.index($focused);

		if (selectionIndex) {
			$selectableElements.eq(selectionIndex - 1).focus();
			return;
		}

		$autocompleteInput.focus();
	}

	function fillAutocompleteInput(selectedItem) {
		var facilityName = selectedItem.attr('data-facility-name');

		$autocompleteInput.val(facilityName);
		$facilityName.val(facilityName);
		$facilityCode.val(selectedItem.attr('data-facility-code'));
		hideAutocompleteList();
		setFocusToEmptyInput();
	}

	function hideAutocompleteList() {
		$autocomplete.html("");
	}

	function setFocusToEmptyInput() {
		if ($username.val().trim() === "" && !$password.is(":focus")) {
			$username.focus();
			return;
		}
		if ($password.val() === "" && !$username.is(":focus")) {
			$password.focus();
			return;
		}
		$('#loginButton').focus();
	}

	function clearAutocompleteInput() {
		$autocompleteInput.val("");
	}

	function convertFacilityToAutocompleteItem(facility) {
		return {
			label: [facility.name, facility.city, facility.state].join(' - '),
			value: facility.name
		};
	}

	function findFacilityByName(recentLocations, name) {
		var i, facilitiesLength = m.facilities.length;
		if (typeof recentLocations !== 'undefined' && recentLocations) {
			var mostRecentListLength = recentLocations.length;

			for (i = 0; i < mostRecentListLength; i++) {
				if (name === recentLocations[i].name) {
					return recentLocations[i];
				}
			}
		}

		for (i = 0; i < facilitiesLength; i++) {
			if (name === m.facilities.models[i].get('name')) {
				return m.facilities.models[i];
			}
		}

		return null;
	}

	$autocompleteInput
		.after($('[for="va-hospital"]'))
		.addClass('empty')
		.prop("id", "va-hospital")
		.prop('type', 'text')
		.prop('required', true);

	$username.focus();
});
