var m = { };

(function($){
	
	/****** MODELS ******/
	m.Error = Backbone.Model.extend({
		defaults: {
			fieldName:"",
			errorMessage:""
		}
	});
	
	m.User = Backbone.Model.extend({
		defaults: {
			"id":"",
			"lastName":"",
			"firstName":"",
			"displayName":"",
			"rightOfAccessAccepted":false,
			"link":"",
			"vistaLocation":"",
			"facilityName":""
		},
		initialize: function() {
			this.url = m.resources.get('mhpuser').get('href');
		}
	});

	m.ROAimage = Backbone.Model.extend({
		defaults: {
			rightOfAccessAccepted: false
		},
		initialize: function() {
			this.url = m.userFeeds.get("right-of-access").get("href");
		}
	});
	
	m.PatientLink = Backbone.Model.extend({
		initialize: function() {
			this.id = this.get('title');
		}
	});
	
	m.Feed = Backbone.Model.extend({
		defaults: {
			rel: "",
			title: "",
			href: "",
			id: ""
		},
		initialize: function() {
			this.id = this.get('title');
		}
	});
	
	m.ResourceLink = Backbone.Model.extend({
		defaults: {
			rel: "external",
			title: "",
			href: "",
			id: ""
		},
		initialize: function() {
			this.id = this.get('title');
		}
	
	});
	
	m.NavigationLink = Backbone.Model.extend({
		defaults: {
			url: "../",
			icon: "grid",
			title: "Launchpad",
			active: "false"
		},
		parse: function(response) {
			if (response.active == "true") {
				response.active = 'ui-btn-active';
			} else {
				response.active = '';
			}
			return response;
		}
	});
	
	m.RequestMetaData = Backbone.Model.extend({
		initialize: function() {
			this.url = m.resources.get("appointments-metadata").get("href");
		},
		defaults: {
			appointmentTypes:[
				"Primary Care",
				"Mental Health"
			],
			userEmail: "",
			userPhone: "",
			bestTimetoCallOptions:[
				"9 AM - 11 AM",
				"11 AM - 1 PM",
				"1 PM - 3 PM",
				"3 PM - 4 PM"
			],
			visitTypes:[
				"Office Visit",
				"Phone Call",
				"Video Conference"
			],
			purposeOfVisitOptions:[
				"Medication concern",
				"Routine follow-up",
				"New issue",
				"Other"
			],
			earliestTimeVeteranCanRequestAppointmentInDays:4,
			farthestTimeVeteranCanRequestAppointmentInDays:120,
			appointmentRequestStatusOptions:[
				"Submitted",
				"Booked",
				"Not Booked",
				"Cancelled"
			]
		}
	});
	
	m.PrimaryCareProviders = Backbone.Model.extend({
		baseUrl: "",
		initialize: function() {
			this.url = this.baseUrl = m.userFeeds.get("providers-primarycare").get("href");
		},
		setFacilitySiteCode: function(code) {
			if (typeof code !== 'undefined' && code) {
				this.url = this.baseUrl + '?facilitySiteCode=' + code;
			} else {
				this.url = this.baseUrl;
			}
		}
	});
	
	m.MentalHealthProviders = Backbone.Model.extend({
		baseUrl: "",
		initialize: function() {
			this.url = this.baseUrl = m.userFeeds.get("providers-mentalhealth").get("href");
		},
		setFacilitySiteCode: function(code) {
			if (typeof code !== 'undefined' && code) {
				this.url = this.baseUrl + '?facilitySiteCode=' + code;
			} else {
				this.url = this.baseUrl;
			}
		}
	});
	
	m.AppointmentMetric = Backbone.Model.extend({
		initialize: function() {
			this.url = "";
		},
		defaults: {
			"name":"",
			"value":""
		}
	});

	m.AppointmentRequestMessage = Backbone.Model.extend({
		url: "",
		messageText: "",
		messageDateTime: "",
		AppointmentRequestId: "",
		senderId: ""
	});

    m.NotificationPreferences = Backbone.Model.extend({
        idAttribute: "patientIdentifier",
        defaults: {
            notificationFrequency: "Never",
            emailAllowed: false,
            emailAddress: "",
            textMsgAllowed: false,
            textMsgPhNumber: ""
        },

        validate: function(attribs) {

            var emailRegExp = new RegExp("^[a-zA-Z0-9\\-!#%&':,;=/\\s\"\\$\\(\\)\\<\\>\\[\\]\\*\\+\\^\\?\\\\\\._`\\{\\|\\}~@]*[a-zA-Z0-9\\-!#%&':,;=/\\s\"\\$\\(\\)\\<\\>\\[\\]\\*\\+\\^\\?\\\\_`\\{\\|\\}~@]+@[a-zA-Z0-9\\-:-\\[\\]]+(?:\\.[a-zA-Z0-9\\-:-]+)*$");
            var textMsgPhoneNumberRegExp = new RegExp("^[x0-9\\.\\-\\(\\)\\+\\s]+$");

              if(attribs.emailAllowed){
                  if (attribs.emailAddress.length < 3 || attribs.emailAddress.length > 50 ||
                     !emailRegExp.test(attribs.emailAddress)){
                      return "Email must be between 3 and 50 characters in a valid email format";
                  }
              }
               if(attribs.textMsgAllowed){
                   if(attribs.textMsgPhNumber.length < 10 || attribs.textMsgPhNumber.length > 50 ||
                       attribs.textMsgPhNumber.replace(/[^0-9]/g,"").length < 10 ||      //this checks at least 10 numbers
                       !textMsgPhoneNumberRegExp.test(attribs.textMsgPhNumber)){
                         return "Phone must have a minimum of 10 digits and only contain digits and these characters: + ( ) - . x space";
                   }
               }
        }
    });
	
	m.AppointmentRequest = Backbone.Model.extend({
		defaults: {
			"object-type":"AppointmentRequest",
			"dataIdentifier":{
				"uniqueId":"",
				"systemId":""
			},
			"patientIdentifier":{
				"uniqueId":"",
				"assigningAuthority":""
			},
			"link":{
				"href":""	
			},
			"patient" : {
				"patientId": "",
				"firstName": "",
				"lastName": "",
				"textMessagingAllowed": false,
				"textMessagingPhoneNumber": ""
			},
			"createdDate": "",
			"lastUpdatedDate": "",
			"secondRequest":false,
			"secondRequestSubmitted":false,
			"appointmentDate":"",
			"appointmentTime":"",
			"optionDate1":"",
			"optionTime1":"",
			"optionDate2":"",
			"optionTime2":"",
			"optionDate3":"",
			"optionTime3":"",
			"appointmentType":"",
			"visitType": "",
			"purposeOfVisit":"",
			"otherPurposeOfVisit":"",
			"bestTimetoCall":[""],
			"providerId":"",
			"providerName":"",
			"providerPersonClass":"",
			"providerOption":"",
			"facilityName":"",
			"facility": {
				"name": "",
				"type": "",
				"facilityCode": "",
				"state": "",
				"city": "",
				"address": "",
				"parentSiteCode": ""
			},
			"email":"",
			"textMessagingAllowed":false,
			"textMessagingPhoneNumber":"",
			"phoneNumber":"",
			"status":"",
			"hasVeteranNewMessage": false,
			"hasProviderNewMessage": false,
			"providerSeenAppointmentRequest": false
		},
		initialize: function(){
			if (!this.has('appointmentRequestDetailCode')) {
				this.set('appointmentRequestDetailCode', []);
			}
		},
		parse: function(response) {
			response.optionDate1 = produceDate(0, response.optionDate1);
			response.optionDate2 = produceDate(0, response.optionDate2);
			response.optionDate3 = produceDate(0, response.optionDate3);
			return response;
		}
	});

	m.Appointment = Backbone.Model.extend({
		defaults: {
			"providerId": "",
			"providerName": "",
			"clinicId": "",
			"clinicName": "Clinic unspecified",
			"clinicPhone": "Clinic Phone unavailable",
			"clinicType": "",
			"facilityName": "",
			"appointmentStartDate": "",
			"reasonForVisit": "",
			"status": "",
			"dataIdentifier":{
				"uniqueId":"",
				"systemId":""
			},
			"patientIdentifier":{
				"uniqueId":"",
				"assigningAuthority":""
			}
		},
		parse: function(response) {
			response.appointmentStartDate = new Date(response.appointmentStartDate);
			
			return response;
		}
	});
	
	m.Patient = Backbone.Model.extend({
		defaults: {
			"patientId": "",
			"firstName": "",
			"lastName": "",
			"textMessagingAllowed": false,
			"textMessagingPhoneNumber": ""
		},
		initialize: function() {
			this.url = m.userFeeds.get('internal-patient-data').get('href');
		}
	});
	
	m.CustomViewSearch = Backbone.Model.extend({
		
	});
	
	m.CustomView = Backbone.Model.extend({
		
	});
	
	m.CustomViews = Backbone.Collection.extend({
		model: m.CustomView,
		parse: function(collection) {
			return collection.customView;
		}
	});

	
	m.QuestionResponse = Backbone.Model.extend({
		
	});
	
	m.QuestionResponses = Backbone.Collection.extend({
		model: m.QuestionResponse,

		parse: function(collection) {
			return collection.response;
		}
	});
	
	m.Facility = Backbone.Model.extend({
		defaults: {
			"name": "",
			"type": "",
			"facilityCode": "",
			"state": "",
			"city": "",
			"address": "",
			"parentSiteCode": ""
		}
	});

	m.AppointmentRequestInProcess = Backbone.Model.extend({
		defaults: {
			"appointmentRequestId": "",
			"userId": "",
			"firstName": "",
			"lastName": ""
		}
	});

	m.PatientIdentifiers = Backbone.Model.extend({
		initialize: function() {
			this.url = m.patientLinks.get('patient-identifiers').get('href');
		}
	});
	
	/****** COLLECTIONS *****/
	m.AppointmentRequests = Backbone.Collection.extend({
		model: m.AppointmentRequest,
		initialize: function() {
			var endDate = new Date(),
				startDate = new Date(),
				numberOfDaysInThePast;

			numberOfDaysInThePast = m.requestMetaData.get('farthestTimeVeteranCanRequestAppointmentInDays');
			startDate.setDate(endDate.getDate() - numberOfDaysInThePast);

			this.url = m.userFeeds.get("appointments").get("href")+
				"?startDate="+formatDate(startDate)+
				"&endDate="+formatDate(endDate);
		},
		parse: function(response) {
			this.lastAccessDate = response.lastAccessDate;
			return response.appointmentRequest;
		}

	});

	m.Appointments = Backbone.Collection.extend({
		model: m.Appointment,
		initialize: function() {
			var startDate = new Date(),
				endDate = new Date(),
				maxDays,
				appointmentsUri = "",
				query = "";
			
			maxDays = m.requestMetaData.get('farthestTimeVeteranCanRequestAppointmentInDays');
			endDate.setDate(startDate.getDate() + maxDays);

			appointmentsUri = m.patientLinks.get("patient-appointments-operational").get("href");
			query = "?startDate="+formatDate(startDate)+
				"&endDate="+formatDate(endDate)+
				"&sort=date.asc";

			this.url = appointmentsUri + query;
		},
		parse: function(response) {
			return response.appointment;
		}

		//Sort Descending
		//comparator: function(appointmentRequest){
		//var sortDate = new Date(appointmentRequest.get('createdDate'));
		//return -sortDate.getTime();
		//}
		
	});
	
	m.Navigation = Backbone.Collection.extend({
		model: m.NavigationLink,
		url: "footer.json" //Need to add to resources
	});
	
	m.Resources = Backbone.Collection.extend({
		model: m.ResourceLink,
		url: "../../MobileHealthPlatformWeb/rest/public/resource-directory", //Kicks-off dynamic URIs
		parse: function(response) {

			return response.link;
		}
	});

	m.PatientLinks = Backbone.Collection.extend({
		model: m.PatientLink,
		initialize: function() {
			this.url = m.userFeeds.get('patient').get('href');
		},
		parse: function(response) {
			return response.link;
		}
	});
	
	m.UserFeeds = Backbone.Collection.extend({
		model: m.Feed,
		initialize: function() {
			this.url = m.resources.get('mhpuser').get('href');
			this.fetch({
				async : false
			});
			
			if (!this.id && !(typeof this.length !== 'undefined' && this.length >= 0)) {
				
				window.location = getReferencePath() + '../oauthlogin?redirect_uri=' + getReferencePathWithHash();
			}
			
			
		},
		parse: function(response) {
			return response.link;
		}
	});

	m.Facilities = Backbone.Collection.extend({
		model: m.Facility,
		initialize: function() {
			this.url = m.resources.get('facility-service').get('href');
		},
		parse: function(response) {
			return response.facility;
		}
	});
	
	m.ErrorMsgs = Backbone.Collection.extend({
		model: m.Error,
		initialize: function() {},
		parse: function(response) {
			return response.errors;
		}
	});

}(jQuery));
