$(document).on("pageinit", "#autocomplete-page", function(){
	var recentLocations = readLocationsFromStorage('recentLocations');
	m.resources = new m.Resources();
	m.resources.fetch({async: false, url: "../../MobileHealthPlatformWeb/rest/public/resource-directory"});
	m.facilities = new m.Facilities();

	$("#autocomplete").on("listviewbeforefilter", function(e, data){
		var $ul = $(this),
			$input = $(data.input),
			value = $input.val(),
			html = "",
			autoCompleteHtml = '<li data-role="list-divider">Search Results</li>',
			mostRecentHtml = '';
		$ul.html("");

		if(value && value.length > 1){
			$ul.html("<li><div class='ui-loader'><span class='ui-icon ui-icon-loading'></span></div></li>");
			$ul.listview("refresh");

			if(recentLocations.length > 0){
				mostRecentHtml = '<li data-role="list-divider">Most Recent Facilities</li>';
				$.each(recentLocations, function(i, val){
					mostRecentHtml += "<li><a href='#' data-facility-name='" + val.name + "' data-facility-code='" + val.facilityCode + "'>" + convertFacilityToAutocompleteItem(val).label + "</a></li>";
				});
			}
			m.facilities.fetch({url: m.resources.get('facility-service').get('href') + '?parentFacilitiesOnly=true&term=' + value})
				.then(function(response){

					$.each(response.facility, function(i, val){
						autoCompleteHtml += "<li><a href='#' data-facility-name='" + val.name + "' data-facility-code='" + val.facilityCode + "'>" + convertFacilityToAutocompleteItem(val).label + "</a></li>";
					});

					html = autoCompleteHtml + mostRecentHtml;
					$ul.html(html);
					$ul.listview("refresh");
					$ul.trigger("updatelayout");
				});
		}
	});
	$('#loginButton').on('tap', function(){
		$("#logonForm").submit();
		return false;
	});
	$('#resetLogin').on('tap', function(){
		clearErrors();
		clearInputs();
	});

	$('#logonForm').on('submit', function(){
		return validateForm();
	});
	$('#autocomplete').on('tap', 'li.ui-btn-up-c', function(e){
		e.preventDefault();
		var selectedItem = $(e.currentTarget).find('a');
		fillAutocompleteInput(selectedItem);
	});
	$('#autocomplete-container').on('blur', 'input', function(){
		setTimeout(function() {
			if( !$('#autocomplete li a').is( ":focus" ) )
			{
				hideAutocompleteList();
			}
		}, 200);
	});
	$('#autocomplete-container input').textinput({ preventFocusZoom: true })
	$('#autocomplete').on('blur', 'li a', function(){
		hideAutocompleteList();
	});
	$('#autocomplete-container').on('keydown', 'input', function(e){
		handleKeyboardInteraction(e);
	});
	$('#autocomplete-container').on('keydown', 'ul', function(e){
		handleKeyboardInteraction(e);
	});
	$('#password').on('keydown', function(e){
		if($('#haMode').val() !== 'provider'){
			var key= e.which;
			if(key === 13)
			{
				e.preventDefault();
				$('#loginButton').tap();
			}
		}
	});
	$('#loginButton').on('keydown', function(e){
		var key= e.which;
		if(key === 13 || key === 32)
		{
			e.preventDefault();
			$('#loginButton').tap();
		}
	});
	$('#resetLogin').on('keydown', function(e){
		var key= e.which;
		if(key === 13 || key === 32)
		{
			e.preventDefault();
			$('#resetLogin').tap();
		}
	});

	$('article').on('change', '#autocomplete-container input', function(){
		if(m.facilities.length > 0){
			clearErrors();
		}
		else{
			showErrorMessage('Please select a valid VA Hospital Location from the autocomplete results');
		}
	});
	function handleKeyboardInteraction(e){
		if($('#autocomplete').html() !== ""){
			switch (e.which){
				case 40:
					selectNextListItem(e);
					break
				case 38:
					selectPreviousListItem(e);
					break
				case 9:
					if(e.shiftKey){
						selectPreviousListItem(e);
					}else{
						selectNextListItem(e);
					}
					break
				case 32:
					var selectedItem = $('#autocomplete li.ui-focus a')
					if(selectedItem.length > 0)
					{
						e.preventDefault();
						fillAutocompleteInput(selectedItem)
					}
					break
				case 13:
					var selectedItem = $('#autocomplete li.ui-focus a')
					if(selectedItem.length > 0)
					{
						e.preventDefault();
						fillAutocompleteInput(selectedItem);
					}
					break
				case 27:
					hideAutocompleteList();
					break
			}
		}
	}
	function selectNextListItem(e){
		e.preventDefault();
		var selectionIndex = $("#autocomplete li.ui-focus").index(),
			selectableElements = $("#autocomplete li").not('[data-role = "list-divider"]');

		if(selectionIndex === -1)//no selection
		{
			selectableElements.eq(0).find('a').focus();//select top
		}//no selection
		else{
			$("#autocomplete li.ui-focus").blur().nextAll().not('[data-role = "list-divider"]').eq(0).focus();
		}
	}

	function selectPreviousListItem(e){
		e.preventDefault();
		var selectionIndex = $("#autocomplete li.ui-focus").index(),
			selectableElements = $("#autocomplete li").not('[data-role = "list-divider"]');

		if(selectionIndex === -1) //no selection
		{
			selectableElements.eq(selectableElements.length -1).focus();//select bottom
		}
		else
		{
			$("#autocomplete li.ui-focus").blur().prevAll().not('[data-role = "list-divider"]').eq(0).focus();
		}
	}

	function fillAutocompleteInput(selectedItem){
		var facilityName = selectedItem.attr('data-facility-name');

		$('#autocomplete-container input').val(facilityName);
		$('#facilityName').val(facilityName);
		$('#facilityCode').val(selectedItem.attr('data-facility-code'));
		hideAutocompleteList();
		setFocusToEmptyInput();
	}
	function hideAutocompleteList(){
		$('#autocomplete').html("");
	}
	function setFocusToEmptyInput()
	{
		if($('#name-c').val().trim() === "" && !$('#password').is(":focus") )
		{
			$('#name-c').focus();
		}else if($('#password').val() === "" && !$('#name-c').is(":focus") )
		{
			$('#password').focus();
		}
		else
		{
			$('#loginButton').focus();
		}
	}
	function clearInputs(){
		$('#name-c').val("");
		$('#password').val("");
		clearAutocompleteInput();
		hideAutocompleteList();
	}
	function clearAutocompleteInput(){
		$('#autocomplete-container input').val("");
	}

	function validateForm(){
		clearErrors();

		var nameVal = $('#name-c').val();
		var passwordVal = $('#password').val();

		var haModeVal = $('#haMode').val();

		if(haModeVal == 'provider'){
			var $facilityCode = $('#facilityCode');
			var facilityNameVal = $('#autocomplete-container input').val();
			var facilityCodeVal = $facilityCode.val();

			if(facilityCodeVal === "" && facilityNameVal){
				var facility = findFacilityByName(recentLocations, facilityNameVal);

				if(facility){
					var facilityCode = "";

					if(facility.facilityCode){
						facilityCode = facility.facilityCode;
					}
					else if(facility.get('facilityCode')){
						facilityCode = facility.get('facilityCode');
					}

					$facilityCode.val(facilityCode);
					facilityCodeVal = $facilityCode.val();
				}
			}

			if(nameVal === "" || passwordVal === "" || facilityNameVal === "" || facilityCodeVal === ""){
				showErrorMessage('Please enter User Id, Password and VA Hospital Location');
				return false;
			}else if(facilityNameVal !== $('#facilityName').val()){
				showErrorMessage('Please enter a valid VA Hospital Location');
				return false;
			}

			writeLocationsToStorage('recentLocations', findFacilityByName(recentLocations, facilityNameVal));
		}
		else{
			if(nameVal === "" || passwordVal === ""){
				showErrorMessage('Please enter User Id and Password');
				return false;
			}
		}

		return true;
	}

	function clearErrors(){
		$('#errorMsgNoValues').addClass('');
		$('#errorMsg').addClass('');
		$('#errorMsg').text('');
		$('#errorMsgNoValues').text('');
		$('#errorDiv').hide();
	}

	function showErrorMessage(text){
		$('#errorDiv').show();
		$("#errorMsg").hide();
		$("#errorMsgNoValues").text(text);
		$('#errorMsgNoValues').addClass('error');
	}

	function convertFacilityToAutocompleteItem(facility){
		var item;
		var labelString = facility.name + ' - ' + facility.city + ' - ' + facility.state;

		item = {
			label: labelString,
			value: facility.name
		};

		return item;
	}

	function findFacilityByName(recentLocations, name){
		var result = null;
		if(typeof recentLocations !== 'undefined' && recentLocations){
			var mostRecentListLength = recentLocations.length;

			for(var i = 0; i < mostRecentListLength; i++){
				if(name === recentLocations[i].name){
					result = recentLocations[i];
					break;
				}
			}
		}

		if(result === null){
			var listLength = m.facilities.length;
			for(i = 0; i < listLength; i++){
				if(name === m.facilities.models[i].get('name')){
					result = m.facilities.models[i];
					break;
				}
			}
		}

		return result;
	}
});
$(document).on("ready", function(){
	$('#name-c').focus();
})
