/* JS Document */

/**
*
* @project LAUNCHPAD: Mobile Blue Button
* @version MBB/Version 1
* @package xhtml-css
* @author Benjamin Cushing
* @cssdoc version 1
*
*/


jQuery(document).ready(function(){

	parseTokenAndRegisterOauthHandler();

	/*----INIT----*/
	var tempScrollLeft, currentScrollLeft = 0;
	MBP.hideUrlBar();
	
	mainResize();
	$(window).resize(function() {
		mainResize();
		windowWidth = $(window).width();
	});
	
	$('#main').core('getUser',{
		url				: 'rest/public/user-session'
	}, function() {
		$('#btn-login').css('display','none');
		$('#btn-logout').removeAttr('style');
	}, function() {
		$('#btn-login').removeAttr('style');
		$('#btn-logout').css('display','none');
	});

	$('#main').core('getHTML',{
		url				: 'content/home',
		display			: 'main',
		container		: '#main'
	}, function() {
		mainResize();
	});
	
	$('nav').on('click', 'a:not(#btn-login, #btn-logout)', function() { 
		goToByScroll(this.id);
	});
	
	$('nav').on('click', 'a#btn-logout', function() {
		window.sessionStorage['token'] = null;
	});
	
	$('#main').swipe({
		swipe: swipe	
	});	
	
	function swipe(event, direction) {
		if (direction == "left") {
			goToByScroll('btn-links');
		} 
		
		if (direction == "right") {
			goToByScroll('btn-apps');
		} 
		
		
	}
	
	function parseTokenAndRegisterOauthHandler() {
		var params = {}, queryString = location.hash.substring(1),
	    regex = /([^&=]+)=([^&]*)/g, m;
		while (m = regex.exec(queryString)) {
	  		params[decodeURIComponent(m[1])] = decodeURIComponent(m[2]);
		}

		var token = params['token'];

		if(typeof token !== 'undefined' && token !== 'undefined' && token !== null && token !== 'null'){
			window.sessionStorage['token']=JSON.stringify(token);
		}
		
		var storedToken = window.sessionStorage['token'];
		
		if(typeof storedToken !== 'undefined' && storedToken !== 'undefined' && storedToken !== null && storedToken !== 'null'){
			$.ajaxPrefilter(function( options, originalOptions, jqXHR ) {
				var currentToken = JSON.parse(storedToken);
		 
				jqXHR.setRequestHeader("Authorization", "Bearer " + currentToken);
			});
		} else {
			$.ajaxPrefilter(function( options, originalOptions, jqXHR ) {
				jqXHR.setRequestHeader("Authorization", "");
			});
		}

		$(document).ajaxError(function(e, jqxhr, settings, exception) {
			if ( jqxhr.status == 0 || jqxhr.status == 200 || jqxhr.status == 400 || jqxhr.status == 404) {
				
			} else if (jqxhr.status == 401) {
				if (jqxhr.responseText.indexOf('invalid_token') > 0) {
					window.sessionStorage['token'] = null;
					$.ajaxPrefilter(function( options, originalOptions, jqXHR ) {
						jqXHR.setRequestHeader("Authorization", "");
					});
					$.ajax(settings);
				}
			} else {
				alert('unknown error in: ' + settings.url + '\nstatus code: ' + jqxhr.status + ' \nerror:\n' + jqxhr.responseText);
			}
		});
	}
});

