<!doctype html>

<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>

<html lang="en" class="no-js">
    <head>
        <meta charset="UTF-8" />
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        <meta name="description" content="" />
        <meta name="author" content="" />
        <meta name="viewport" content="width=device-width,initial-scale=1, minimum-scale=1, maximum-scale=2" />
        <meta name="apple-mobile-web-app-capable" content="yes" />
        <meta name="apple-mobile-web-app-status-bar-style" content="black" />

        <title>Department of Veterans Affairs - Provider Login Page</title>

        <link rel="stylesheet" href="<c:url value="/css/jquery.mobile-1.3.0.min.css"/>">
        <link rel="stylesheet" href="<c:url value="/css/login/new-login.css"/>">

        <script src="<c:url value="/js/libs/jquery-1.9.1.min.js"/>"></script>
        <script src="<c:url value="/js/utilities.js"/>"></script>
        <script src="<c:url value="/js/libs/modernizr.custom.js"/>"></script>
        <script src="<c:url value="/js/loginBrowserSniffer.js"/>"></script>
        <script src="<c:url value="/js/libs/jquery.mobile-1.3.0.min.js"/>"></script>

        <script src="<c:url value="/js/libs/underscore.js"/>"></script>
        <script src="<c:url value="/js/libs/backbone.js"/>"></script>
        <script src="<c:url value="/js/models.js"/>"></script>
    </head>
    <body>
        <div data-role="page" class="provider-login">
            <div class="heading">
                <header>
                    <h1>Department of Veterans Affairs</h1>
                    <h2>Provider Login</h2>
                </header>
                <img src="<c:url value="/img/logo_navbar_ipad.png"/>" id="logo" alt="VA Login"/>
            </div>
            <div>
                <div class="error" title="error-message"><c:if test="${not empty error}">${error}</c:if></div>
                <form id="logonForm" name="logonForm" data-ajax="false" action="<c:url value="/provider/security_check"/>" method="post">
                    <input data-role="none" required placeholder="Access Code" spellcheck="false" id="name-c" type="password" autocorrect="off" autocapitalize="off" autocomplete="off" name="j_username" value="" class="empty ui-input-text ui-body-null ui-corner-all ui-shadow-inset ui-body-c" />
                    <label class="hide508" for="name-c">Access Code</label>
                    <input data-role="none" required placeholder="Verify Code" id="password" type="password" name="j_password" autocorrect="off" autocapitalize="off" autocomplete="off" value="" class="empty ui-input-text ui-body-null ui-corner-all ui-shadow-inset ui-body-c" />
                    <label class="hide508" for="password">Verify Code</label>

                    <div id="autocomplete-container">
                        <div class="autocomplete-dropdown-wrapper">
                            <ul id="autocomplete" data-role="listview" data-inset="true" data-prevent-focus-zoom="false" data-filter="true"
                            data-filter-placeholder="Station" data-title="Enter facility's name, city, and/or two-letter state to begin search/auto-complete"
                            data-filter-theme="d" data-divider-theme="d" data-mini="true" data-icon="false"></ul>
                            <label class="hide508" for="va-hospital">Station</label>
                        </div>
                    </div>

                    <button type="button" data-inline="true" id="resetLogin" aria-label="Clear"><span aria-hidden="true">Clear</span></button>
                    <button data-inline="true" id="loginButton" aria-label="Sign In"><span aria-hidden="true">Sign In</span></button>
                    <input data-role="none" type="hidden" name="facilityCode" id="facilityCode"/>
                    <input data-role="none" type="hidden" name="facilityName" id="facilityName"/>
                </form>
            </div>
        </div>
        <script src="<c:url value="/js/libs/jquery.placeholder.polyfill.js"/>"></script>
        <script src="<c:url value="/js/provider-login.js"/>"></script>
    </body>
</html>
