package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters;

import com.agilex.healthcare.mobilehealthplatform.domain.AtomLink;
import com.agilex.healthcare.mobilehealthplatform.domain.LinkTitles;
import com.agilex.healthcare.mobilehealthplatform.domain.ResourceDirectory;
import com.agilex.healthcare.mobilehealthplatform.utils.PropertyHelper;
import com.agilex.healthcare.utility.ModeHelper;
import com.agilex.healthcare.utility.NullChecker;
import com.agilex.healthcare.utility.atom.AtomUtility;
import com.sun.syndication.feed.synd.SyndFeed;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;
import java.net.URI;
import java.net.URISyntaxException;

@Service
@Scope(value=ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class ResourceDirectoryBuilder {

	//private static final String OAUTH_SSOE_LOGOUT_URL = "oauth.ssoe_logout_url";
	
	@Resource
	private PropertyHelper propertyHelper;

	private static final org.apache.commons.logging.Log LOGGER = org.apache.commons.logging.LogFactory.getLog(ResourceDirectoryBuilder.class);
	
	private static final String MHP_AUTHORIZE_URL = "oauth.authorize_url";
	private static final String MHP_TOKEN_URL = "oauth.token_url";

	public ResourceDirectoryBuilder() {
	}

	public ResourceDirectory getResourceDirectory(URI systemBaseUri, URI resourceDirectoryUri, URI mhpBaseUri) {

		ResourceDirectory directory = new ResourceDirectory();
		AtomLink link;

		link = new AtomLink();
		link.setHref(resourceDirectoryUri);
		// link.setType(MediaType.APPLICATION_ATOM_XML);
		link.setTitle("resource-directory");
		directory.getLink().setSelfLink(link);

		link = new AtomLink();
		link.setHref(systemBaseUri);
		link.setType(MediaType.APPLICATION_ATOM_XML);
		link.setTitle(LinkTitles.SystemRoot);
		directory.getLink().add(link);

//		link = new AtomLink();
//		link.setHref(UriBuilder.fromUri(mhpBaseUri).path("rest").path("public").path("user-session").build());
//		link.setType(MediaType.APPLICATION_XML);
//		link.setTitle(LinkTitles.PublicUserSession);
//		directory.getLink().add(link);

//		link = new AtomLink();
//		link.setHref(UriBuilder.fromUri(mhpBaseUri).path("rest").path("mhpuser").build());
//		link.setType(MediaType.APPLICATION_JSON);
//		link.setTitle("mhpuser");
//		directory.getLink().add(link);
		
		/*link = new AtomLink();
		link.setHref(UriBuilder.fromUri(systemBaseUri).path("facility-service").path("facilities").build());
		link.setTitle("facility-service");
		link.setType(MediaType.APPLICATION_XML);
		directory.getLink().add(link);*/
		

				
		return directory;
	}

    
	public SyndFeed getResourceDirectoryAsAtomFeed(URI systemBaseUri, URI resourceDirectoryUri) {
        URI mhpUri = UriBuilder.fromUri(propertyHelper.getProperty("mhp.baseUri")).build();
		ResourceDirectory resourceDirectory = getResourceDirectory(systemBaseUri, resourceDirectoryUri, mhpUri);
		SyndFeed feed = AtomUtility.createAtomFeed(resourceDirectory.getLink(), resourceDirectoryUri, "mhp-resources");
		return feed;
	}

	private static URI stripRestFromBaseURI(URI baseURI) {

		String stringURI = baseURI.toString();
		stringURI = stringURI.replaceAll("/rest", "");

		URI uri = URI.create(stringURI);

		return uri;
	}
	
	private static URI stripWebContextFromBaseURI(URI baseURI) {

		String stringURI = baseURI.toString();
		stringURI = stringURI.replaceAll("/AuthorizationServices/rest", "");

		URI uri = URI.create(stringURI);

		return uri;
	}
	
}