package com.agilex.healthcare.mobilehealthplatform.utils;

import org.apache.commons.beanutils.BeanUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

public class LogUtil {
	public static String getInfo(String msg, Object obj) {
		StringProvider provider = getProvider(obj,true);
		return provider==null ? "could not create a provider for target " + obj : commaSeparated(msg,provider);
	}

	public static String getInfo(String msg, Object obj, boolean trim) {
		StringProvider provider = getProvider(obj,trim);
		return provider==null ? "could not create a provider for target " + obj : commaSeparated(msg,provider);
	}

	public static String standardToString(Object target, boolean trim) {
		if (target==null)
			return "null";
		return getInfo("instance of " + target.getClass().getName() + " ",target);
	}
	
	public static String standardToString(Object target) {
		return standardToString(target,true);	
	}

	public static String commaSeparated(String msg, StringProvider provider) {
		StringBuilder sb = new StringBuilder(msg);
		sb.append("{");
		boolean first = true;
		while(provider.hasMore()) {
			if (!first)
				sb.append(", ");
			first = false;
			sb.append(provider.getNext());
		}
		sb.append("}");
		return sb.toString();
	}
	
	@SuppressWarnings("unchecked")
	protected static StringProvider getProvider(Object target, boolean trim) {
		if (target==null)
			return null;
		try {
			if (target instanceof Collection<?>)
				return new ReportStringProvider((Collection<?>)target,trim);
			else if (target instanceof Map<?,?>)
				return new ReportStringProvider((Map<?,?>)target,trim);
			else if (target instanceof Object[])
				return new ReportStringProvider((Object[])target,trim);
			else {
				Map<String, Object> map = (Map<String, Object>)BeanUtils.describe(target);
				return new ReportStringProvider(map,trim);
			}
		} catch (NoSuchMethodException e) {
			System.out.println("had a problem in LogUtil Line 65");
			return null;
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}
	}
	
	public static class ReportStringProvider implements StringProvider {
		private Object[] keys;
		private Object[] values;
		private int index = 0;
		private boolean trim;

		ReportStringProvider(Map<?,?> map, boolean trim) {
			if (map != null) {
				keys = map.keySet().toArray(new Object[map.size()]);
				values = map.values().toArray(new Object[map.size()]);
			}
			this.trim = trim;
		}

		ReportStringProvider(Properties props, boolean trim) {
			if (props != null) {
				keys = props.keySet().toArray(new Object[props.size()]);
				values = props.values().toArray(new Object[props.size()]);
			}
			this.trim = trim;
		}

		ReportStringProvider(Collection<?> collection, boolean trim) {
			if (collection != null) {
				values = collection.toArray(new Object[collection.size()]);
			}	
			this.trim = trim;
		}

		ReportStringProvider(Object[] collection, boolean trim) {
			if (collection != null) {
				values = collection;
			}	
			this.trim = trim;
		}

		public String getNext() {
			if (keys==null) {
				if (values!=null)
					return hasMore() ? getStr(values[index++]) : null;
				else 
					return "";
			} else {
				if (values!=null)
					return hasMore() ? getStr(keys[index],values[index++]) : null;
				else 
					return "";
			}
		}
		
		private String toString(Object obj) {
			try {
				Method mthd = obj.getClass().getDeclaredMethod("toString");
				if (mthd.getDeclaringClass()==Object.class)
					return standardToString(obj,true);
				return obj.toString();
			} catch (SecurityException e) {
				return standardToString(obj,true);
			} catch (NoSuchMethodException e) {
				return standardToString(obj,true);
			}
		}
		
		private String objToStr(Object val) {
			String valStr = val==null ? "null" : toString(val);
			valStr = trim ? valStr.trim() : valStr;
			return valStr;
		}

		private String getStr(Object val) {
			return "[" + objToStr(val) + "]";
		}
		
		private String getStr(Object key, Object val) {
			return "<" + objToStr(key) + ">=[" + objToStr(val) + "]";
		}

		public boolean hasMore() {
			return values!=null && index < values.length;
		}
	}
	
//	private static void writeLog(Logger log, String str) {
//		if (log==null)
//			System.out.println(str);
//		else
//			log.info(str);
//	}
		
	public interface StringProvider {
		public String getNext();
		public boolean hasMore();
	}
}
