package com.agilex.healthcare.mobilehealthplatform.utils;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public class HttpSessionCollector implements HttpSessionListener {
    private static final Map<String, HttpSession> sessions = new HashMap<String, HttpSession>();
	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(HttpSessionListener.class);

    @Override
    public void sessionCreated(HttpSessionEvent event) {
        HttpSession session = event.getSession();
        sessions.put(session.getId(), session);
        logger.debug("Total number of sessions: " + sessions.size());
    }

    @Override
    public void sessionDestroyed(HttpSessionEvent event) {
        sessions.remove(event.getSession().getId());
        logger.debug("Total number of sessions: " + sessions.size());
    }

    public static HttpSession find(String sessionId) {
        return sessions.get(sessionId);
    }
}