 package com.agilex.healthcare.mobilehealthplatform.serviceregistry;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

import com.agilex.healthcare.mobilehealthplatform.datalayer.authservices.FacilityDataLayer;

public class MhpObjectFactory implements DataLayerFactory, ApplicationContextAware {

    private static final org.apache.commons.logging.Log LOGGER = org.apache.commons.logging.LogFactory.getLog(MhpObjectFactory.class);

    private static final String FACILITY_DATALAYER_BEAN = "facilityDataLayer";
    
    private static BeanFactory beanFactory = null;
    private static MhpObjectFactory instance = null;
    private static ApplicationContext springContext = null;

    public MhpObjectFactory() {
        LOGGER.debug("invoked default constructor");
    }
    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        springContext = applicationContext;
    }

    //This uses the existing application context to avoid loading the context twice
    private static BeanFactory getBeanFactory() {
        synchronized (MhpObjectFactory.class) {
            if (beanFactory == null) {
                LOGGER.debug("bean factory not initialized, get app context");
                ApplicationContext appContext = springContext;
                beanFactory = appContext;
                LOGGER.debug("bean factory now set");
            }
        }
        return beanFactory;
    }

	public static MhpObjectFactory getInstance() {
		if (instance == null) {
			initializeInstance();
		}
		return instance;
	}

	private synchronized static void initializeInstance() {
		if (instance == null) {
			LOGGER.debug("initalizing mhp object factory");
			instance = new MhpObjectFactory();
		}
	}

	@SuppressWarnings("unchecked")
	public <T> T getBean(String beanName) {
		T bean = (T) getBeanFactory().getBean(beanName);
		LOGGER.debug("loaded bean (without type safety)");
		return bean;
	}

	public <T> T getBean(String beanName, Class<T> requiredType) {
		T bean = (T) getBeanFactory().getBean(beanName, requiredType);
		LOGGER.debug("loaded bean (with type safety)");
		return bean;
	}
	

	@Override
	public FacilityDataLayer getFacilityDataLayer() {
		return getBean(FACILITY_DATALAYER_BEAN, FacilityDataLayer.class);
	}

	public static <T> T initializeByType(Class<T> type) {
		T object;
		try {
			object = type.newInstance();
		} catch (InstantiationException e) {
			throw new RuntimeException(e);
		} catch (IllegalAccessException e) {
			throw new RuntimeException(e);
		}
		return object;
	}
}
