package com.agilex.healthcare.mobilehealthplatform.restservice;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;

import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.agilex.healthcare.mobilehealthplatform.datalayer.authservices.FacilityDataService;
import com.agilex.healthcare.mobilehealthplatform.domain.Facilities;


@Path("/facility-service")
@Component
@Scope("request")
public class FacilityResource {

	@GET
	@Produces({ "application/xml", "application/json" })
	@Path("/facilities")
	public Facilities fetchFacilities(@QueryParam("term") String term, @Context UriInfo uriInfo, @Context HttpHeaders headers) {
		
		FacilityDataService dataService = new FacilityDataService();
		
		return dataService.fetchFacilities(term);
	}
}
