package com.agilex.healthcare.mobilehealthplatform.oauth;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.agilex.healthcare.mobilehealthplatform.authorization.LoginLogoutUserDAO;
import com.agilex.healthcare.mobilehealthplatform.domain.MhpUser;
import com.agilex.healthcare.mobilehealthplatform.provider.auth.LoginLogoutUser;
import com.agilex.healthcare.mobilehealthplatform.security.MhpUserFactory;

@Controller
public class OauthAuthorizationProxy {

	@Resource
	private LoginLogoutUserDAO loginLogoutUserDAO;

	private static final Log serviceLogger = LogFactory
			.getLog(OauthAuthorizationProxy.class);
	private static final String INTERNAL_SERVER_ERROR = "Internal Server Error";

	@RequestMapping(value = "/provider/authorize", method = RequestMethod.GET)
	public void redirectToAuthorizationServices(HttpServletRequest request,
			HttpServletResponse response) throws Exception {
			checkUserLogoutAndInvalidateSession(request);
			request.getRequestDispatcher("/oauth/authorize").forward(request,
					response);
	}

	@RequestMapping(value = "/veteran/authorize", method = RequestMethod.GET)
	public void redirectToVetAuthorizationServices(HttpServletRequest request,
			HttpServletResponse response) {
		try {
			request.getRequestDispatcher("/oauth/authorize").forward(request,
					response);
		} catch (Exception e) {
			serviceLogger.error(e.getStackTrace());
			throw new RuntimeException(INTERNAL_SERVER_ERROR);
		}
	}

	@RequestMapping(value = "/oauth/confirm_access", method = RequestMethod.GET)
	public void accessDenied(HttpServletRequest request,
			HttpServletResponse response) {
		try {
			response.sendError(403);
			response.flushBuffer();
		} catch (Exception e) {
			serviceLogger.error(e.getStackTrace());
			throw new RuntimeException(INTERNAL_SERVER_ERROR);
		}
	}

	private void checkUserLogoutAndInvalidateSession(HttpServletRequest request) {
		HttpSession session = request.getSession();
		SecurityContext context = (SecurityContext) session
				.getAttribute("SPRING_SECURITY_CONTEXT");
		Authentication authentication = context.getAuthentication();
		MhpUser mhpUser = MhpUserFactory
				.createFromAuthentication(authentication);
		LoginLogoutUser loginLogoutUser = loginLogoutUserDAO
				.fetchLoginLogoutUser(mhpUser.getUserIdentifier());
		if (loginLogoutUser.isLogout()) {
			session.invalidate();
			SecurityContextHolder.clearContext();
		}

	}
}
