package com.agilex.healthcare.mobilehealthplatform.oauth;

import javax.annotation.Resource;
import javax.ws.rs.DELETE;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

import com.agilex.healthcare.mobilehealthplatform.authorization.LoginLogoutUserDAO;
import com.agilex.healthcare.mobilehealthplatform.domain.MhpUser;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.provider.auth.LoginLogoutUser;
import com.agilex.healthcare.mobilehealthplatform.security.MhpUserFactory;
import com.agilex.security.oauth.TokenStoreLogout;

@Path("/token")
@Service
@Scope("request")
public class Oauth2AccessTokenResource {
	
	private static final Log logger = LogFactory.getLog(Oauth2AccessTokenResource.class);
	
	@Resource
	private TokenStoreLogout tokenStore;

	@Resource
	private LoginLogoutUserDAO loginLogoutUserDAO;

	@Autowired (required=false)
	private StaffAppAuthenticator authenticator;

	@DELETE
	public Response deleteToken() {
		Authentication currentUser = getCurrentUser();
		tokenStore.removeAllUSerTokens(currentUser);
		
        MhpUser mhpUser = MhpUserFactory.createFromAuthentication(currentUser);
        if (mhpUser != null && mhpUser.getMdwsInfo() != null){
        	authenticator.logoff(mhpUser);
        	logger.info("Inside Oauth2AccessTokenResource.deleteToken method and logged off the user");
        	//set logout flag to true
        	fetchAndUpdateLoginLogoutUser(mhpUser.getUserIdentifier());
        }
		
		return Response.ok().build();
	}

	private Authentication getCurrentUser() {
		SecurityContext ctx = SecurityContextHolder.getContext();
		return ctx.getAuthentication();
	}
	
	private void fetchAndUpdateLoginLogoutUser(PatientIdentifier patientIdentifier) {
		LoginLogoutUser loginLogoutUser = loginLogoutUserDAO.fetchLoginLogoutUser(patientIdentifier);
		loginLogoutUser.setLogout(true);
		loginLogoutUserDAO.saveLoginLogoutUser(loginLogoutUser);
	}
	
}
