package com.agilex.healthcare.mobilehealthplatform.oauth;

import java.util.Date;

import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.code.AuthorizationCodeServices;
import org.springframework.security.oauth2.provider.code.AuthorizationCodeTokenGranter;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;

import com.agilex.healthcare.mobilehealthplatform.authorization.ResourceLastAccessedTime;
import com.agilex.healthcare.mobilehealthplatform.authorization.ResourceLastAccessedTimeDAO;
import com.agilex.healthcare.mobilehealthplatform.domain.MhpUser;
import com.agilex.healthcare.mobilehealthplatform.security.MhpUserFactory;

public class HealthAdapterAuthorizationCodeTokenGranter extends AuthorizationCodeTokenGranter {
	
	private ResourceLastAccessedTimeDAO resourceLastAccessedTimeDAO;

	public HealthAdapterAuthorizationCodeTokenGranter(AuthorizationServerTokenServices tokenServices, AuthorizationCodeServices authorizationCodeServices,
											ClientDetailsService clientDetailsService, ResourceLastAccessedTimeDAO dao) {
		super(tokenServices, authorizationCodeServices, clientDetailsService);
		resourceLastAccessedTimeDAO = dao;
	}
	
	@Override
	protected OAuth2Authentication getOAuth2Authentication(AuthorizationRequest authorizationRequest) {
		 OAuth2Authentication oAuth2Authentication = super.getOAuth2Authentication(authorizationRequest);
		 Authentication userAuthentication = oAuth2Authentication.getUserAuthentication();
		 
		 if (userAuthentication != null){
			 MhpUser mhpUser = MhpUserFactory.createFromAuthentication(userAuthentication);
			 resetResourceLastAccessedTime(mhpUser, new Date());
		 }
		 
		 return oAuth2Authentication;
	}
	
	private void resetResourceLastAccessedTime(MhpUser mhpUser, Date lastAccessedTime) {
		ResourceLastAccessedTime resourceLastAccessedTime = new ResourceLastAccessedTime();
		resourceLastAccessedTime.setUserId(mhpUser.getUserIdentifier().toString());
		resourceLastAccessedTime.setLastAccessedTime(lastAccessedTime);
		resourceLastAccessedTime.setLastLoginTime(lastAccessedTime);
		
		logger.debug("Stored user last accessed time");
		resourceLastAccessedTimeDAO.saveResourceLastAccessedTime(resourceLastAccessedTime);
	}
	
}
