package com.agilex.healthcare.mobilehealthplatform.mock.auth.provider;

import java.util.Date;

import com.agilex.healthcare.mobilehealthplatform.auth.provider.mdws.MdwsAppAuthenticatorUtil;
import com.agilex.healthcare.mobilehealthplatform.authorization.ResourceLastAccessedTime;
import com.agilex.healthcare.mobilehealthplatform.authorization.ResourceLastAccessedTimeDAO;
import com.agilex.healthcare.mobilehealthplatform.domain.MhpUser;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.mdws.MdwsInfo;
import com.agilex.healthcare.mobilehealthplatform.mdws.MdwsResponseException;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.EmrSvcSoap;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.UserSecurityKeyArray;
import com.agilex.healthcare.utility.DateHelper;

public class MockStaffKeepAliveThread implements Runnable {
	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(MockStaffKeepAliveThread.class);
	private String sessionId;
	private EmrSvcSoap emrPort = null;
	private int secondsToKeepPollingMdws = 15*60; //15 minutes
	private PatientIdentifier userIdentifier;
	private ResourceLastAccessedTimeDAO dao;
	private MhpUser mockUser;

	public MockStaffKeepAliveThread(String sessionId, PatientIdentifier userIdentifier, EmrSvcSoap emrPort, ResourceLastAccessedTimeDAO dao, MhpUser mockUser, int secondsToKeepPollingMdws) {
		this.sessionId = sessionId;
		this.userIdentifier = userIdentifier;
		this.emrPort = emrPort;
		this.mockUser = mockUser;
		this.dao = dao;
		this.secondsToKeepPollingMdws = secondsToKeepPollingMdws;
	}
	
	@Override
	public void run() {
		pollEmr();
	}
	
	private void pollEmr() {
		logger.debug("Keeping emrservice connection alive");
		
		if (isRequestWithinTimeoutBoundary(mockUser.getUserIdentifier().toString()) == false) {
			stopPolling();
			return;
		}

		MdwsAppAuthenticatorUtil.setPortSessionId(sessionId, emrPort);
		
		try {
			UserSecurityKeyArray mdwsKeys = emrPort.getUserSecurityKeys(userIdentifier.getUniqueId());
			if (mdwsKeys.getFault() != null){
				stopPolling();
				logger.error("Error in polling for session id");
			}
		}
		catch (MdwsResponseException e) {
			logger.error("Keeping emrservice connection alive mdws failure");
			stopPolling();
		}
		catch (Exception e) {
			logger.error("Keeping emrservice connection alive failure");
			stopPolling();
		}
	}

	private MdwsInfo getMdwsInfo() {
		MdwsInfo mdwsInfo = new MdwsInfo();
		mdwsInfo.setUserId(this.userIdentifier.toString());
		mdwsInfo.setSessionId(this.sessionId);
		return mdwsInfo;
	}

	private void stopPolling() {
		MdwsInfo mdwsInfo = getMdwsInfo();
		MockStaffAppAuthenticator.stopConnectionPolling(mdwsInfo);
		this.emrPort.disconnect();
	}

	public String getSessionId() {
		return sessionId;
	}

	public EmrSvcSoap getEmrPort() {
		return emrPort;
	}
	
	private boolean isRequestWithinTimeoutBoundary(String userId) {
		
		if (secondsToKeepPollingMdws > DateHelper.calculateDeltaInSeconds(getLastAccessedTime(userId), new Date())) {
			return true;
		} else {
			logger.info("Request is not within timeout boundary");
			return false;
		}
	}
	
	private Date getLastAccessedTime(String userId){
		ResourceLastAccessedTime resourceLastAccessedTime = dao.fetchResourceLastAccessedTime(userId);
		return resourceLastAccessedTime.getLastAccessedTime();
	}

}
