package com.agilex.healthcare.mobilehealthplatform.mock.auth.provider;

import static java.util.concurrent.TimeUnit.SECONDS;

import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;

import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;

import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.security.authentication.BadCredentialsException;

import com.agilex.healthcare.mobilehealthplatform.auth.provider.mdws.MdwsAppAuthenticatorUtil;
import com.agilex.healthcare.mobilehealthplatform.authorization.ResourceLastAccessedTimeDAO;
import com.agilex.healthcare.mobilehealthplatform.domain.MhpUser;
import com.agilex.healthcare.mobilehealthplatform.mdws.MdwsInfo;
import com.agilex.healthcare.mobilehealthplatform.mdws.MdwsResponseException;
import com.agilex.healthcare.mobilehealthplatform.mdws.MdwsResponseException.UserMessages;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.EmrSvc;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.EmrSvcSoap;
import com.agilex.healthcare.mobilehealthplatform.oauth.StaffAppAuthenticator;
import com.agilex.healthcare.mobilehealthplatform.security.VistaAuthenticator;
import com.agilex.healthcare.utility.NullChecker;


public class MockStaffAppAuthenticator extends VistaAuthenticator implements StaffAppAuthenticator, ApplicationContextAware {
	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(MockStaffAppAuthenticator.class);
	protected String mdwsBaseEmrServiceUrl;
	protected String mdwsEmrServiceUrl;
	private ApplicationContext springContext;

	private static ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(10);
	public static Hashtable<String, ScheduledFuture<?>> scheduledTasks = new Hashtable<String, ScheduledFuture<?>>();
	private int sessionTimeOutInSeconds;
	
	public MockStaffAppAuthenticator(String mdwsBaseEmrServiceUrl, String mdwsEmrServiceUrl, int sessionTimeOutInSeconds) {
		super(mdwsBaseEmrServiceUrl, mdwsEmrServiceUrl);
		this.mdwsBaseEmrServiceUrl = mdwsBaseEmrServiceUrl;
		this.mdwsEmrServiceUrl = mdwsEmrServiceUrl;
		this.sessionTimeOutInSeconds = sessionTimeOutInSeconds;
	}
	
    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        springContext = applicationContext;
    }
	
	
	private static boolean isConnectingToMdws() {
		String connect = System.getProperty("mock.auth.provider.mdws.connections");
		if (connect != null && connect.equalsIgnoreCase("false"))
			return false;
		else
			return true;
	}
	
	@Override
	public MhpUser authenticate(String accessCode, String verifyCode, String vistaLocation) throws Exception {
		
		if(NullChecker.isNullish(accessCode) || NullChecker.isNullish(verifyCode) || 
				NullChecker.isNullish(vistaLocation)){
			throw new BadCredentialsException("User name, password and vistaLocation are required");
		}

		Map<String, MhpUser> users = getUsers();

		MhpUser mhpUser = users.get(accessCode.toLowerCase());
		
		if (mhpUser != null
				&& (verifyCode.equals("pass") || verifyCode.equals("password1!") || verifyCode.equals("doc123!!") || verifyCode.equals("cprs4321$") || verifyCode.equals("prov6543$") || verifyCode.equals("clerk7890$") || verifyCode.equals("clerk4343$") || verifyCode.equals("clerk7676$"))
				&& vistaLocation.equals(mhpUser.getVistaLocation())) {
			
			if (isConnectingToMdws())
				loginOrUpdateMdws(vistaLocation, mhpUser, verifyCode);
			return mhpUser;
		} else {
			throw new BadCredentialsException("Username/Password does not match for username");
		}
	}
	
	private void loginOrUpdateMdws(String vistaLocation, MhpUser mhpUser, String verifyCode) throws Exception {
		MhpUser mdwsUser = null;
		if ("500".equals(vistaLocation))
			mdwsUser = loginToMdws(mhpUser, "doc123", "doc123!!", vistaLocation);
		else if ("688".equals(vistaLocation))
			mdwsUser = loginToMdws(mhpUser, "doc123", "doc123!!", vistaLocation);
        else if (mhpUser.getAccessCode().equals("clerk3434") || mhpUser.getAccessCode().equals("clerk0987") || mhpUser.getAccessCode().equals("clerk6767") || mhpUser.getAccessCode().equals("prov3456")){
            mdwsUser = loginToMdws(mhpUser, mhpUser.getAccessCode(), verifyCode, vistaLocation);
        }
		else if ("777".equals(vistaLocation))
			mdwsUser = loginToMdws(mhpUser, "cprs1234", "cprs4321$", vistaLocation);
		else
			throw new MdwsResponseException(UserMessages.CONNECTION_ERROR, "Unable to login to this vista site with credentials provided: " + vistaLocation);
		
		mhpUser.setMdwsInfo(mdwsUser.getMdwsInfo());
	}

	protected MhpUser loginToMdws(MhpUser mockUser, String mdwsAccessCode, String mdwsVerifyCode, String vistaLocation) throws Exception {
		MhpUser mdwsUser = super.authenticate(mdwsAccessCode, mdwsVerifyCode, vistaLocation);
		keepConnectionActive(mockUser, mdwsUser);
		return mdwsUser;
	}

	private void keepConnectionActive(MhpUser mockUser, MhpUser mhpUser) {
		String sessionId = mhpUser.getMdwsInfo().getSessionId();
		stopConnectionPolling(mhpUser.getMdwsInfo()); //Just in case we are already polling, stop it (we never should be)
		ResourceLastAccessedTimeDAO dao = springContext.getBean(ResourceLastAccessedTimeDAO.class);
		
		MockStaffKeepAliveThread keepAliveThread = new MockStaffKeepAliveThread(sessionId, mhpUser.getUserIdentifier(), this.getEmrSvcPort(), dao, mockUser, this.sessionTimeOutInSeconds);
		
		final int intervalForKeepMdwsConnectionAlive = 60;
		
		final ScheduledFuture<?> pollingScheduledTask = scheduler.scheduleAtFixedRate(
				keepAliveThread,
				intervalForKeepMdwsConnectionAlive,
				intervalForKeepMdwsConnectionAlive,
				SECONDS);
		scheduledTasks.put(sessionId, pollingScheduledTask);
	}
	
	private EmrSvcSoap getEmrSvcPort(){
		URL emrSvcWsdlUrl = this.getEmrSvcWsdlUrl();
		
		EmrSvc emrService = null;
		emrService = new EmrSvc(emrSvcWsdlUrl, new QName("http://mdws.domain/EmrSvc", "EmrSvc"));
		EmrSvcSoap port = emrService.getEmrSvcSoap();
		
		((BindingProvider)port).getRequestContext().put(BindingProvider.SESSION_MAINTAIN_PROPERTY, true);
		((BindingProvider)port).getRequestContext().put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY, this.getEmrSvcUrl());	    

		return port;
	}
	
	//Package access
	static void stopConnectionPolling(MdwsInfo mdwsInfo) {
		String sessionId = mdwsInfo.getSessionId();
		
		try {
			
			ScheduledFuture<?> pollingScheduledTask = scheduledTasks.get(sessionId);
			if (pollingScheduledTask != null) {
				pollingScheduledTask.cancel(true);
				scheduledTasks.remove(sessionId);
			}
		}
		catch (Exception e) {
			logger.error("Error stopping polling mdws: " + sessionId + ": " + e.getMessage());
		}
	}
	
	
	@Override
	public void logoff(MhpUser mhpUser) {
		stopConnectionPolling(mhpUser.getMdwsInfo());
		disconnectMdwsConnection(mhpUser.getMdwsInfo());
	}
	
	private void disconnectMdwsConnection(MdwsInfo mdwsInfo) {
		try {
			EmrSvcSoap port = getEmrSvcPort();
			MdwsAppAuthenticatorUtil.setPortSessionId(mdwsInfo.getSessionId(), port);
			port.disconnect();
		} catch (Exception e) {
			logger.error("Problem logging off user: " + e.getMessage());
		}
	}
	
	private Map<String, MhpUser> getUsers(){
		Map<String, MhpUser> users = new HashMap<String, MhpUser>();
		
        MhpUser user6 = new MhpUser();
        
		user6.setAccessCode("zztest.staff01");
		user6.setDisplayName("zztest staff01");
		user6.setFirstName("zztest");
		user6.setLastName("staff01");
		user6.setTitle("Doctor");
		user6.setId("staff001");
		user6.setVistaLocation("688");
		user6.setFacilityName("DCVAMC");
        user6.getPatient().getPatientIdentifier().setUniqueId(user6.getId());

        users.put(user6.getAccessCode(), user6);
        
        MhpUser user7 = new MhpUser();

		user7.setAccessCode("zztest.staff02");
		user7.setDisplayName("zztest staff02");
		user7.setFirstName("zztest");
		user7.setLastName("staff02");
		user7.setTitle("Doctor");
		user7.setId("staff002");
		user7.setVistaLocation("613");
		user7.setFacilityName("Martinsburg");
        user7.getPatient().getPatientIdentifier().setUniqueId(user7.getId());
        users.put(user7.getAccessCode(), user7);
        
        MhpUser user8 = new MhpUser();
        
		user8.setAccessCode("zztest.staff03");
		user8.setDisplayName("zztest staff03");
		user8.setFirstName("zztest");
		user8.setLastName("staff03");
		user8.setTitle("Doctor");
		user8.setId("staff003");
		user8.setVistaLocation("512");
		user8.setFacilityName("Baltimore");
        user8.getPatient().getPatientIdentifier().setUniqueId(user8.getId());
        users.put(user8.getAccessCode(), user8);
        
        MhpUser user9 = new MhpUser();
        
		user9.setAccessCode("zztest.staff04");
		user9.setDisplayName("zztest staff04");
		user9.setFirstName("zztest");
		user9.setLastName("staff04");
		user9.setTitle("Doctor");
		user9.setId("staff004");
		user9.setVistaLocation("556");
		user9.setFacilityName("Chicago");
        user9.getPatient().getPatientIdentifier().setUniqueId(user9.getId());
        users.put(user9.getAccessCode(), user9);
        
        MhpUser user10 = new MhpUser();
        
		user10.setAccessCode("zztest.staff05");
		user10.setDisplayName("zztest staff05");
		user10.setFirstName("zztest");
		user10.setLastName("staff05");
		user10.setTitle("Doctor");
		user10.setId("staff005");
		user10.setVistaLocation("538");
		user10.setFacilityName("Chillicothe");
        user10.getPatient().getPatientIdentifier().setUniqueId(user10.getId());
        users.put(user10.getAccessCode(), user10);
        
        MhpUser user11 = new MhpUser();
        
		user11.setAccessCode("zztest.staff06");
		user11.setDisplayName("zztest staff06");
		user11.setFirstName("zztest");
		user11.setLastName("staff06");
		user11.setTitle("Doctor");
		user11.setId("staff006");
		user11.setVistaLocation("640");
		user11.setFacilityName("Palo Alto");
        user11.getPatient().getPatientIdentifier().setUniqueId(user11.getId());
        users.put(user11.getAccessCode(), user11);
        
        MhpUser user12 = new MhpUser();
        
		user12.setAccessCode("zztest.staff07");
		user12.setDisplayName("zztest staff07");
		user12.setFirstName("zztest");
		user12.setLastName("staff07");
		user12.setTitle("Doctor");
		user12.setId("staff007");
		user12.setVistaLocation("626");
		user12.setFacilityName("Nashville");
        user12.getPatient().getPatientIdentifier().setUniqueId(user12.getId());
        users.put(user12.getAccessCode(), user12);
        
        MhpUser user13 = new MhpUser();
        
		user12.setAccessCode("zztest.staff08");
		user13.setDisplayName("zztest staff08");
		user13.setFirstName("zztest");
		user13.setLastName("staff08");
		user13.setTitle("Doctor");
		user13.setId("staff008");
		user13.setVistaLocation("675");
		user13.setFacilityName("Orlando");
        user13.getPatient().getPatientIdentifier().setUniqueId(user13.getId());
        users.put(user13.getAccessCode(), user13);
        
        MhpUser user14 = new MhpUser();
        
		user14.setAccessCode("zztest.staff09");
		user14.setDisplayName("zztest staff09");
		user14.setFirstName("zztest");
		user14.setLastName("staff09");
		user14.setTitle("Doctor");
		user14.setId("staff009");
		user14.setVistaLocation("561");
		user14.setFacilityName("VANJHCS");
        user14.getPatient().getPatientIdentifier().setUniqueId(user14.getId());
        users.put(user14.getAccessCode(), user14);
        
        MhpUser user15 = new MhpUser();
        
		user15.setAccessCode("zztest.staff10");
		user15.setDisplayName("zztest staff10");
		user15.setFirstName("zztest");
		user15.setLastName("staff10");
		user15.setTitle("Doctor");
		user15.setId("staff010");
		user15.setVistaLocation("565");
		user15.setFacilityName("Fayetteville");
        user15.getPatient().getPatientIdentifier().setUniqueId(user15.getId());
        users.put(user15.getAccessCode(), user15);
        
        MhpUser user16 = new MhpUser();
        
		user16.setAccessCode("zztest.staff11");
		user16.setDisplayName("zztest staff11");
		user16.setFirstName("zztest");
		user16.setLastName("staff11");
		user16.setTitle("Doctor");
		user16.setId("staff011");
		user16.setVistaLocation("554");
		user16.setFacilityName("Denver");
        user16.getPatient().getPatientIdentifier().setUniqueId(user16.getId());
        users.put(user16.getAccessCode(), user16);
        
        MhpUser user17 = new MhpUser();
        
		user17.setAccessCode("zztest.staff12");
		user17.setDisplayName("zztest staff12");
		user17.setFirstName("zztest");
		user17.setLastName("staff12");
		user17.setTitle("Doctor");
		user17.setId("staff012");
		user17.setVistaLocation("691");
		user17.setFacilityName("Greater Los Angeles");
        user17.getPatient().getPatientIdentifier().setUniqueId(user17.getId());
        users.put(user17.getAccessCode(), user17);
        
        MhpUser user18 = new MhpUser();
        
		user18.setAccessCode("zztest.staff13");
		user18.setDisplayName("zztest staff13");
		user18.setFirstName("zztest");
		user18.setLastName("staff13");
		user18.setTitle("Doctor");
		user18.setId("staff013");
		user18.setVistaLocation("659");
		user18.setFacilityName("Salisbury");
        user18.getPatient().getPatientIdentifier().setUniqueId(user18.getId());
        users.put(user18.getAccessCode(), user18);
        
        MhpUser user19 = new MhpUser();
        
		user19.setAccessCode("zztest.staff14");
		user19.setDisplayName("zztest staff14");
		user19.setFirstName("zztest");
		user19.setLastName("staff14");
		user19.setTitle("Doctor");
		user19.setId("staff014");
		user19.setVistaLocation("589");
		user19.setFacilityName("Columbia");
        user19.getPatient().getPatientIdentifier().setUniqueId(user19.getId());
        users.put(user19.getAccessCode(), user19);
        
        MhpUser user20 = new MhpUser();
        
		user20.setAccessCode("zztest.staff15");
		user20.setDisplayName("zztest staff15");
		user20.setFirstName("zztest");
		user20.setLastName("staff15");
		user20.setTitle("Doctor");
		user20.setId("staff015");
		user20.setVistaLocation("549");
		user20.setFacilityName("Polk");
        user20.getPatient().getPatientIdentifier().setUniqueId(user20.getId());
        users.put(user20.getAccessCode(), user20);
        
        MhpUser user21 = new MhpUser();
        
		user21.setAccessCode("zztest.doc01");
		user21.setDisplayName("zztest doc01");
		user21.setFirstName("zztest");
		user21.setLastName("doc01");
		user21.setTitle("Doctor");
		user21.setId("staff016");
		user21.setVistaLocation("688");
		user21.setFacilityName("DCVAMC");
        user21.getPatient().getPatientIdentifier().setUniqueId(user21.getId());
        users.put(user21.getAccessCode(), user21);
        
        MhpUser user22 = new MhpUser();
        
		user22.setAccessCode("zztest.doc02");
		user22.setDisplayName("zztest doc02");
		user22.setFirstName("zztest");
		user22.setLastName("doc02");
		user22.setTitle("Doctor");
		user22.setId("staff017");
		user22.setVistaLocation("613");
		user22.setFacilityName("Martinsburg");
        user22.getPatient().getPatientIdentifier().setUniqueId(user22.getId());
        users.put(user22.getAccessCode(), user22);
        
        MhpUser user23 = new MhpUser();
        
		user23.setAccessCode("zztest.doc03");
		user23.setDisplayName("zztest doc03");
		user23.setFirstName("zztest");
		user23.setLastName("doc03");
		user23.setTitle("Doctor");
		user23.setId("staff018");
		user23.setVistaLocation("512");
		user23.setFacilityName("Baltimore");
        user23.getPatient().getPatientIdentifier().setUniqueId(user23.getId());
        users.put(user23.getAccessCode(), user23);
        
        MhpUser user24 = new MhpUser();
        
		user24.setAccessCode("zztest.doc04");
		user24.setDisplayName("zztest doc04");
		user24.setFirstName("zztest");
		user24.setLastName("doc04");
		user24.setTitle("Doctor");
		user24.setId("staff019");
		user24.setVistaLocation("556");
		user24.setFacilityName("Chicago");
        user24.getPatient().getPatientIdentifier().setUniqueId(user24.getId());
        users.put(user24.getAccessCode(), user24);
        
        MhpUser user25 = new MhpUser();
        
		user25.setAccessCode("zztest.doc05");
		user25.setDisplayName("zztest doc05");
		user25.setFirstName("zztest");
		user25.setLastName("doc05");
		user25.setTitle("Doctor");
		user25.setId("staff020");
		user25.setVistaLocation("538");
		user25.setFacilityName("Chillicothe");
        user25.getPatient().getPatientIdentifier().setUniqueId(user25.getId());
        users.put(user25.getAccessCode(), user25);
        
        MhpUser user26 = new MhpUser();
        
		user26.setAccessCode("zztest.doc06");
		user26.setDisplayName("zztest doc06");
		user26.setFirstName("zztest");
		user26.setLastName("doc06");
		user26.setTitle("Doctor");
		user26.setId("staff021");
		user26.setVistaLocation("640");
		user26.setFacilityName("Palo Alto");
        user26.getPatient().getPatientIdentifier().setUniqueId(user26.getId());
        users.put(user26.getAccessCode(), user26);
        
        MhpUser user27 = new MhpUser();
        
		user27.setAccessCode("zztest.doc07");
		user27.setDisplayName("zztest doc07");
		user27.setFirstName("zztest");
		user27.setLastName("doc07");
		user27.setTitle("Doctor");
		user27.setId("staff022");
		user27.setVistaLocation("626");
		user27.setFacilityName("Nashville");
        user27.getPatient().getPatientIdentifier().setUniqueId(user27.getId());
        users.put(user27.getAccessCode(), user27);
        
        MhpUser user28 = new MhpUser();
        
		user28.setAccessCode("zztest.doc08");
		user28.setDisplayName("zztest doc08");
		user28.setFirstName("zztest");
		user28.setLastName("doc08");
		user28.setTitle("Doctor");
		user28.setId("staff023");
		user28.setVistaLocation("675");
		user28.setFacilityName("Orlando");
        user28.getPatient().getPatientIdentifier().setUniqueId(user28.getId());
        users.put(user28.getAccessCode(), user28);
        
        MhpUser user29 = new MhpUser();
        
		user29.setAccessCode("zztest.doc09");
		user29.setDisplayName("zztest doc09");
		user29.setFirstName("zztest");
		user29.setLastName("doc09");
		user29.setTitle("Doctor");
		user29.setId("staff024");
		user29.setVistaLocation("561");
		user29.setFacilityName("VANJHCS");
        user29.getPatient().getPatientIdentifier().setUniqueId(user29.getId());
        users.put(user29.getAccessCode(), user29);
        
        MhpUser user30 = new MhpUser();
        
		user30.setAccessCode("zztest.doc10");
		user30.setDisplayName("zztest doc10");
		user30.setFirstName("zztest");
		user30.setLastName("doc10");
		user30.setTitle("Doctor");
		user30.setId("staff025");
		user30.setVistaLocation("565");
		user30.setFacilityName("Fayetteville");
        user30.getPatient().getPatientIdentifier().setUniqueId(user30.getId());
        users.put(user30.getAccessCode(), user30);
        
        MhpUser user31 = new MhpUser();
        
		user31.setAccessCode("zztest.doc11");
		user31.setDisplayName("zztest doc11");
		user31.setFirstName("zztest");
		user31.setLastName("doc11");
		user31.setTitle("Doctor");
		user31.setId("staff026");
		user31.setVistaLocation("554");
		user31.setFacilityName("Denver");
        user31.getPatient().getPatientIdentifier().setUniqueId(user31.getId());
        users.put(user31.getAccessCode(), user31);
        
        MhpUser user32 = new MhpUser();
        
		user32.setAccessCode("zztest.doc12");
		user32.setDisplayName("zztest doc12");
		user32.setFirstName("zztest");
		user32.setLastName("doc12");
		user32.setTitle("Doctor");
		user32.setId("staff027");
		user32.setVistaLocation("691");
		user32.setFacilityName("Greater Los Angeles");
        user32.getPatient().getPatientIdentifier().setUniqueId(user32.getId());
        users.put(user32.getAccessCode(), user32);
        
        MhpUser user33 = new MhpUser();
        
		user33.setAccessCode("zztest.doc13");
		user33.setDisplayName("zztest doc13");
		user33.setFirstName("zztest");
		user33.setLastName("doc13");
		user33.setTitle("Doctor");
		user33.setId("staff028");
		user33.setVistaLocation("659");
		user33.setFacilityName("Salisbury");
        user33.getPatient().getPatientIdentifier().setUniqueId(user33.getId());
        users.put(user33.getAccessCode(), user33);
        
        MhpUser user34 = new MhpUser();
        
		user34.setAccessCode("zztest.doc14");
		user34.setDisplayName("zztest doc14");
		user34.setFirstName("zztest");
		user34.setLastName("doc14");
		user34.setTitle("Doctor");
		user34.setId("staff029");
		user34.setVistaLocation("589");
		user34.setFacilityName("Columbia");
        user34.getPatient().getPatientIdentifier().setUniqueId(user34.getId());
        users.put(user34.getAccessCode(), user34);
        
        MhpUser user35 = new MhpUser();
        
		user35.setAccessCode("zztest.doc15");
		user35.setDisplayName("zztest doc15");
		user35.setFirstName("zztest");
		user35.setLastName("doc15");
		user35.setTitle("Doctor");
		user35.setId("staff030");
		user35.setVistaLocation("549");
		user35.setFacilityName("Polk");
        user35.getPatient().getPatientIdentifier().setUniqueId(user35.getId());
        users.put(user35.getAccessCode(), user35);
        
        MhpUser user36 = new MhpUser();
        
		user36.setAccessCode("usability.staff01");
		user36.setDisplayName("usability staff01");
		user36.setFirstName("usability");
		user36.setLastName("staff01");
		user36.setTitle("");
		user36.setId("staff031");
		user36.setVistaLocation("688");
		user36.setFacilityName("DCVAMC");
        user36.getPatient().getPatientIdentifier().setUniqueId(user36.getId());
        users.put(user36.getAccessCode(), user36);
        
        MhpUser user37 = new MhpUser();
        
		user37.setAccessCode("usability.staff02");
		user37.setDisplayName("usability staff02");
		user37.setFirstName("usability");
		user37.setLastName("staff02");
		user37.setTitle("Doctor");
		user37.setId("staff032");
		user37.setVistaLocation("613");
		user37.setFacilityName("Martinsburg");
        user37.getPatient().getPatientIdentifier().setUniqueId(user37.getId());
        users.put(user37.getAccessCode(), user37);
        
        MhpUser user38 = new MhpUser();
        
		user38.setAccessCode("usability.staff03");
		user38.setDisplayName("usability staff03");
		user38.setFirstName("usability");
		user38.setLastName("staff03");
		user38.setTitle("Doctor");
		user38.setId("staff033");
		user38.setVistaLocation("512");
		user38.setFacilityName("Baltimore");
        user38.getPatient().getPatientIdentifier().setUniqueId(user38.getId());
        users.put(user38.getAccessCode(), user38);
        
        MhpUser user39 = new MhpUser();
        
		user39.setAccessCode("usability.staff04");
		user39.setDisplayName("usability staff04");
		user39.setFirstName("usability");
		user39.setLastName("staff04");
		user39.setTitle("Doctor");
		user39.setId("staff034");
		user39.setVistaLocation("556");
		user39.setFacilityName("Chicago");
        user39.getPatient().getPatientIdentifier().setUniqueId(user39.getId());
        users.put(user39.getAccessCode(), user39);
        
        MhpUser user40 = new MhpUser();
        
		user40.setAccessCode("usability.staff05");
		user40.setDisplayName("usability staff05");
		user40.setFirstName("usability");
		user40.setLastName("staff05");
		user40.setTitle("Doctor");
		user40.setId("staff035");
		user40.setVistaLocation("538");
		user40.setFacilityName("Chillicothe");
        user40.getPatient().getPatientIdentifier().setUniqueId(user40.getId());
        users.put(user40.getAccessCode(), user40);
        
        MhpUser user41 = new MhpUser();
        
		user41.setAccessCode("usability.staff06");
		user41.setDisplayName("usability staff06");
		user41.setFirstName("usability");
		user41.setLastName("staff06");
		user41.setTitle("Doctor");
		user41.setId("staff036");
		user41.setVistaLocation("640");
		user41.setFacilityName("Palo Alto");
        user41.getPatient().getPatientIdentifier().setUniqueId(user41.getId());
        users.put(user41.getAccessCode(), user41);
        
        MhpUser user42 = new MhpUser();
        
		user42.setAccessCode("usability.staff07");
		user42.setDisplayName("usability staff07");
		user42.setFirstName("usability");
		user42.setLastName("staff07");
		user42.setTitle("Doctor");
		user42.setId("staff037");
		user42.setVistaLocation("626");
		user42.setFacilityName("Nashville");
        user42.getPatient().getPatientIdentifier().setUniqueId(user42.getId());
        users.put(user42.getAccessCode(), user42);
        
        MhpUser user43 = new MhpUser();
        
		user43.setAccessCode("usability.staff08");
		user43.setDisplayName("usability staff08");
		user43.setFirstName("usability");
		user43.setLastName("staff08");
		user43.setTitle("Doctor");
		user43.setId("staff038");
		user43.setVistaLocation("675");
		user43.setFacilityName("Orlando");
        user43.getPatient().getPatientIdentifier().setUniqueId(user43.getId());
        users.put(user43.getAccessCode(), user43);
        
        MhpUser user44 = new MhpUser();
        
		user44.setAccessCode("usability.staff09");
		user44.setDisplayName("usability staff09");
		user44.setFirstName("usability");
		user44.setLastName("staff09");
		user44.setTitle("Doctor");
		user44.setId("staff039");
		user44.setVistaLocation("561");
		user44.setFacilityName("VANJHCS");
        user44.getPatient().getPatientIdentifier().setUniqueId(user44.getId());
        users.put(user44.getAccessCode(), user44);
        
        MhpUser user45 = new MhpUser();
        
		user45.setAccessCode("usability.staff10");
		user45.setDisplayName("usability staff10");
		user45.setFirstName("usability");
		user45.setLastName("staff10");
		user45.setTitle("Doctor");
		user45.setId("staff040");
		user45.setVistaLocation("565");
		user45.setFacilityName("Fayetteville");
        user45.getPatient().getPatientIdentifier().setUniqueId(user45.getId());
        users.put(user45.getAccessCode(), user45);
        
        MhpUser user46 = new MhpUser();
        
		user46.setAccessCode("usability.staff11");
		user46.setDisplayName("usability staff11");
		user46.setFirstName("usability");
		user46.setLastName("staff11");
		user46.setTitle("Doctor");
		user46.setId("staff041");
		user46.setVistaLocation("554");
		user46.setFacilityName("Denver");
        user46.getPatient().getPatientIdentifier().setUniqueId(user46.getId());
        users.put(user46.getAccessCode(), user46);
        
        MhpUser user47 = new MhpUser();
        
		user47.setAccessCode("usability.staff12");
		user47.setDisplayName("usability staff12");
		user47.setFirstName("usability");
		user47.setLastName("staff12");
		user47.setTitle("Doctor");
		user47.setId("staff042");
		user47.setVistaLocation("691");
		user47.setFacilityName("Greater Los Angeles");
        user47.getPatient().getPatientIdentifier().setUniqueId(user47.getId());
        users.put(user47.getAccessCode(), user47);
        
        MhpUser user48 = new MhpUser();
        
		user48.setAccessCode("usability.staff13");
		user48.setDisplayName("usability staff13");
		user48.setFirstName("usability");
		user48.setLastName("staff13");
		user48.setTitle("Doctor");
		user48.setId("staff043");
		user48.setVistaLocation("659");
		user48.setFacilityName("Salisbury");
        user48.getPatient().getPatientIdentifier().setUniqueId(user48.getId());
        users.put(user48.getAccessCode(), user48);
        
        MhpUser user49 = new MhpUser();
        
		user49.setAccessCode("usability.staff14");
		user49.setDisplayName("usability staff14");
		user49.setFirstName("usability");
		user49.setLastName("staff14");
		user49.setTitle("Doctor");
		user49.setId("staff044");
		user49.setVistaLocation("589");
		user49.setFacilityName("Columbia");
        user49.getPatient().getPatientIdentifier().setUniqueId(user49.getId());
        users.put(user49.getAccessCode(), user49);
        
        MhpUser user50 = new MhpUser();
        
		user50.setAccessCode("usability.staff15");
		user50.setDisplayName("usability staff15");
		user50.setFirstName("usability");
		user50.setLastName("staff15");
		user50.setTitle("Doctor");
		user50.setId("staff045");
		user50.setVistaLocation("549");
		user50.setFacilityName("Polk");
        user50.getPatient().getPatientIdentifier().setUniqueId(user50.getId());
        users.put(user50.getAccessCode(), user50);
        
        MhpUser user51 = new MhpUser();
        
        user51.setAccessCode("zztest.stafftest");
        user51.setDisplayName("zztest stafftest");
        user51.setFirstName("zztest");
        user51.setLastName("stafftest");
        user51.setTitle("Doctor");
        user51.setId("staff046");
        user51.setVistaLocation("500");
        user51.setFacilityName("TEST VAMC");
        user51.getPatient().getPatientIdentifier().setUniqueId(user51.getId());
        users.put(user51.getAccessCode(), user51);

        MhpUser user52 = new MhpUser();

        user52.setAccessCode("zztest.scvtest");
        user52.setDisplayName("zztest scvtest");
        user52.setFirstName("zztest");
        user52.setLastName("scvtest");
        user52.setTitle("Doctor");
        user52.setId("staffscv");
        user52.setVistaLocation("200");
        user52.setFacilityName("TEST VAMC 2");
        user52.getPatient().getPatientIdentifier().setUniqueId(user52.getId());
        users.put(user52.getAccessCode(), user52);

        MhpUser user53 = new MhpUser();

        user53.setAccessCode("zztest.scvtest2");
        user53.setDisplayName("zztest scvtest2");
        user53.setFirstName("zztest");
        user53.setLastName("scvtest2");
        user53.setTitle("Doctor");
        user53.setId("staffscv");
        user53.setVistaLocation("777");
        user53.setFacilityName("TEST VAMC 3");
        user53.getPatient().getPatientIdentifier().setUniqueId(user53.getId());
        users.put(user53.getAccessCode(), user53);

        MhpUser user54 = new MhpUser();
        
        user54.setAccessCode("doc123");
        user54.setDisplayName("PROVIDER,ONE");
        user54.setFirstName("PROVIDER");
        user54.setLastName("ONE");
        user54.setTitle("Doctor");
        user54.setId("983");
        user54.setVistaLocation("500");
        user54.setFacilityName("TEST VAMC");
        user54.getPatient().getPatientIdentifier().setUniqueId(user54.getId());

        users.put(user54.getAccessCode(), user54);
        
        MhpUser user55 = new MhpUser();

        user55.setAccessCode("cprs1234");
        user55.setDisplayName("cprs1234");
        user55.setFirstName("cprs1234");
        user55.setLastName("cprs1234");
        user55.setTitle("Doctor");
        user55.setId("1");
        user55.setVistaLocation("777");
        user55.setFacilityName("TEST VAMC 3");
        user55.getPatient().getPatientIdentifier().setUniqueId(user55.getId());
        users.put(user55.getAccessCode(), user55);

        MhpUser user56 = new MhpUser();

        user56.setAccessCode("prov3456");
        user56.setDisplayName("PROVIDER, THIRTYNINE");
        user56.setFirstName("PROVIDER");
        user56.setLastName("THIRTYNINE");
        user56.setTitle("Doctor");
        user56.setId("1252");
        user56.setVistaLocation("777");
        user56.setFacilityName("TEST VAMC 3");
        user56.getPatient().getPatientIdentifier().setUniqueId(user56.getId());
        users.put(user56.getAccessCode(), user56);

        MhpUser user57 = new MhpUser();
        user57.setAccessCode("clerk0987");
        user57.setDisplayName("CLINICCLERK,TWO");
        user57.setFirstName("CLINICCLERK");
        user57.setLastName("TWO");
        user57.setTitle("Doctor");
        user57.setId("11341");
        user57.setVistaLocation("777");
        user57.setFacilityName("TEST VAMC 3");
        user57.getPatient().getPatientIdentifier().setUniqueId(user57.getId());
        users.put(user57.getAccessCode(), user57);

        MhpUser user58 = new MhpUser();
        user58.setAccessCode("clerk3434");
        user58.setDisplayName("CLINICCLERK,TWENTY");
        user58.setFirstName("CLINICCLERK");
        user58.setLastName("TWENTY");
        user58.setTitle("Doctor");
        user58.setId("11359");
        user58.setVistaLocation("777");
        user58.setFacilityName("TEST VAMC 3");
        user58.getPatient().getPatientIdentifier().setUniqueId(user58.getId());
        users.put(user58.getAccessCode(), user58);

        MhpUser user59 = new MhpUser();
        user59.setAccessCode("clerk6767");
        user59.setDisplayName("CLINICCLERK,THREE");
        user59.setFirstName("CLINICCLERK");
        user59.setLastName("THREE");
        user59.setTitle("Doctor");
        user59.setId("11342");
        user59.setVistaLocation("777");
        user59.setFacilityName("TEST VAMC 3");
        user59.getPatient().getPatientIdentifier().setUniqueId(user59.getId());
        users.put(user59.getAccessCode(), user59);

        return users;
	}
}
