package com.agilex.healthcare.mobilehealthplatform.authservicescdw.datalayer;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

import com.agilex.healthcare.mobilehealthplatform.authservicescdw.Transformable;
import com.agilex.healthcare.mobilehealthplatform.domain.Facility;
import com.thoughtworks.xstream.annotations.XStreamAlias;

@Entity
@Table(name = "App.AllInstitutionsAuthService")
@XStreamAlias("Facility")
public class FacilityPo implements Transformable<Facility>, Serializable {
	private static final long serialVersionUID = -4851381663810098943L;
	public static final String TABLE_NAME = "App.AllInstitutionsAuthService";
	
	private String facilityCode;
	private String name;
	private String type;
	private String state;
	private String city;
	private String address;

	public FacilityPo() {
	}

    public FacilityPo(String code) {
    	setId(code);
    }
	   
	public FacilityPo(Facility dto) {
		setId(dto.getFacilityCode());
	}

	@Id
	@Column(name = "Sta3n")
	public String getId() {
		return this.facilityCode;
	}

	public void setId(String code) {
		this.facilityCode = code;
	}

	@Column(name = "InstitutionName")
	public String getName() {
		return this.name;
	}

	public void setName(String name) {
		this.name = name;
	}

	@Column(name = "FacilityType")
	public String getType() {
		return this.type;
	}

	public void setType(String type) {
		this.type = type;
	}

	@Column(name = "StateAbbrev")
	public String getState() {
		return this.state;
	}

	public void setState(String state) {
		this.state = state;
	}

	@Column(name = "City")
	public String getCity() {
		return this.city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	@Column(name = "StreetAddress1")
	public String getAddress() {
		return this.address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	public Facility create() {
		Facility facility = new Facility();

		facility.setFacilityCode(this.getId());
		facility.setName(this.getName());
		facility.setType(this.getType());
		facility.setState(this.getState());
		facility.setCity(this.getCity());
		facility.setAddress(this.getAddress());
		
		return facility;
	}
}
