package com.agilex.healthcare.mobilehealthplatform.authservicescdw.datalayer;

import java.util.ArrayList;
import java.util.List;

import javax.persistence.Query;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Repository;

import com.agilex.healthcare.mobilehealthplatform.authservicescdw.AbstractDao;
import com.agilex.healthcare.mobilehealthplatform.authservicescdw.Mapper;
import com.agilex.healthcare.mobilehealthplatform.authservicescdw.Transformable;
import com.agilex.healthcare.mobilehealthplatform.domain.DomainTransferObject;
import com.agilex.healthcare.mobilehealthplatform.domain.Facilities;

@Repository
public class FacilityDao extends AbstractDao {
	private static final Log logger = LogFactory.getLog(FacilityDao.class);

	final String AUTHSERVICES_FACILITIES = "SELECT InstitutionName, Sta3n, InstitutionCode, StreetAddress1,City,StateAbbrev,Zip,FacilityType,InstitutionSID " +
	                                      "FROM app.AllInstitutionsAuthService " +
			                              "WHERE InstitutionName like :name " +
	                                      "ORDER BY InstitutionName";
	
	
	
	//final String AUTHSERVICES_FACILITIES = "{call APP.AUTHSERVICES_FACILITIES(:name)}";

	public Facilities fetchFacilities(String term) {
			
		Query query = this.cdwEntityManager
				.createNativeQuery(
						AUTHSERVICES_FACILITIES,
						FacilityPo.class);
		
		query.setParameter("name", "%"+term+"%");
		List<FacilityPo> results = query.getResultList();

		List<Transformable<? extends DomainTransferObject>> transformableList = createTransformableFacilityList(results);

		Facilities facilities = new Facilities();
		Mapper.add(transformableList, facilities);

		return facilities;
	}

	private List<Transformable<? extends DomainTransferObject>> createTransformableFacilityList(List<FacilityPo> results) {
		List<Transformable<? extends DomainTransferObject>> transformableList = new ArrayList<Transformable<? extends DomainTransferObject>>();
		
		for (FacilityPo facility : results) {
				transformableList.add(facility);
		}

		return transformableList;
	}
}
