package com.agilex.healthcare.mobilehealthplatform.authorization;

import java.util.Date;

import javax.annotation.Resource;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

import com.agilex.healthcare.utility.DateHelper;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

import com.agilex.healthcare.mobilehealthplatform.domain.MhpUser;
import com.agilex.healthcare.mobilehealthplatform.security.MhpUserFactory;

@Path("/resourceLastAccessedTime")
@Service
@Scope("request")
public class ResourceLastAccessedTimeResource {
	
	@Resource
	private ResourceLastAccessedTimeDAO resourceLastAccessedTimeDAO;
    @Resource(name = "sessionTimeOutInSeconds")
    private int sessionTimeOutInSeconds = 900;

	@GET
	@Produces({ "application/xml", "application/json" })
	public ResourceLastAccessedTime getResourceLastAccessedTime(){
		MhpUser mhpUser = getCurrentUser();
		ResourceLastAccessedTime resourceLastAccessedTime = resourceLastAccessedTimeDAO.fetchResourceLastAccessedTime(mhpUser.getUserIdentifier().toString());
        resourceLastAccessedTime.setTimeToExpireInSeconds(
                sessionTimeOutInSeconds  - (DateHelper.calculateDeltaInSeconds(resourceLastAccessedTime.getLastAccessedTime(), new Date())));
        return resourceLastAccessedTime;
	}

	@POST
	@Produces({ "application/xml", "application/json" })
	public ResourceLastAccessedTime updateResourceLastAccessedTime(){
		MhpUser mhpUser = getCurrentUser();
		ResourceLastAccessedTime resourceLastAccessedTime = new ResourceLastAccessedTime();
		resourceLastAccessedTime.setLastAccessedTime(new Date());
		resourceLastAccessedTime.setUserId(mhpUser.getUserIdentifier().toString());
		resourceLastAccessedTime = resourceLastAccessedTimeDAO.saveResourceLastAccessedTime(resourceLastAccessedTime);
		
		return 	resourceLastAccessedTime;
	}
	
	private MhpUser getCurrentUser(){
		return MhpUserFactory.createFromSecurityContext();
	}
}
