package com.agilex.healthcare.mobilehealthplatform.authorization;

import java.util.Date;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;


@Repository(value="resourceLastAccessedTimeDAO")
public class ResourceLastAccessedTimeDAOImpl implements ResourceLastAccessedTimeDAO {

	@PersistenceContext(unitName ="authdbPU")
	protected EntityManager entityManager;
	
	@Override
	public ResourceLastAccessedTime fetchResourceLastAccessedTime(String userId) {
		ResourceLastAccessedTimePo po =  this.entityManager.find(ResourceLastAccessedTimePo.class, userId);
		return toDto(po);
	}

	@Override
	@Transactional(propagation = Propagation.REQUIRED)
	public ResourceLastAccessedTime saveResourceLastAccessedTime(ResourceLastAccessedTime dto) {
		
		//Save only if the last accessed time is greater than the previously saved value
		ResourceLastAccessedTimePo latestPo = toPo(dto);
		ResourceLastAccessedTimePo existingPo =  this.entityManager.find(ResourceLastAccessedTimePo.class, latestPo.getUserId());

		// Set Last Login Time to the existing value if it is not set
		if(existingPo == null){
			if(latestPo.getLastLoginTime() == null){
				latestPo.setLastLoginTime(new Date());
			}
			existingPo =  this.entityManager.merge(latestPo);
		}else if (existingPo.getLastAccessedTime().before(latestPo.getLastAccessedTime())){
			if(latestPo.getLastLoginTime() == null){
				latestPo.setLastLoginTime(existingPo.getLastLoginTime());
			}
			existingPo =  this.entityManager.merge(latestPo);
		}
		
		return toDto(existingPo);
	}

	private ResourceLastAccessedTimePo toPo(ResourceLastAccessedTime dto){
		ResourceLastAccessedTimePo po = new ResourceLastAccessedTimePo();
		po.setUserId(dto.getUserId());
		po.setLastAccessedTime(dto.getLastAccessedTime());
		po.setLastLoginTime(dto.getLastLoginTime());
		
		return po;
	}

	private ResourceLastAccessedTime toDto(ResourceLastAccessedTimePo po){
		if(po == null){
			return null;
		}
		
		ResourceLastAccessedTime dto = new ResourceLastAccessedTime();
		dto.setUserId(po.getUserId());
		dto.setLastAccessedTime(po.getLastAccessedTime());
		dto.setLastLoginTime(po.getLastLoginTime());
		
		return dto;
	}
}
