package com.agilex.healthcare.mobilehealthplatform.authorization;

import java.util.Date;
import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.provider.auth.LoginLogoutUser;


@Repository(value="LoginLogoutUserDAO")
public class LoginLogoutUserDAOImpl implements LoginLogoutUserDAO {

	private static final Log logger = LogFactory.getLog(LoginLogoutUserDAOImpl.class);
	
	@PersistenceContext(unitName ="authdbPU")
	protected EntityManager entityManager;
	
	private static final String USER_SESSION_SQL = "SELECT usr FROM LoginLogoutUserPo usr where usr.userId = :userId";
	
	@Override
	public boolean isUserLoggedOut(String userId) {
		LoginLogoutUser loginLogoutUser = retrieveLoginLogoutUser(userId);
		return loginLogoutUser.isLogout();
	}

	private LoginLogoutUser retrieveLoginLogoutUser(String userId) {
		Query query =  this.entityManager.createQuery(USER_SESSION_SQL);
		query.setParameter("userId", userId);
		
		List<LoginLogoutUserPo> elementList = query.getResultList();
		if (elementList.isEmpty()) {
	        return null;
	    }		
		LoginLogoutUser loginLogoutUser = toDto(elementList.get(0));
		return loginLogoutUser;
	}

	@Override
	@Transactional(propagation = Propagation.REQUIRED)
	public LoginLogoutUser saveLoginLogoutUser(LoginLogoutUser dto) {
		
		LoginLogoutUserPo latestPo = toPo(dto);
		LoginLogoutUserPo existingPo =  this.entityManager.merge(latestPo);
		if (!existingPo.isLogout()) {
			logger.info("User logged in");
		} else {
			logger.info("User logged out");
		}
		return toDto(existingPo);
	}

	private LoginLogoutUserPo toPo(LoginLogoutUser dto){
		LoginLogoutUserPo po = new LoginLogoutUserPo();
		po.setUserId(dto.getUserId());
		po.setLogout(dto.isLogout());
		po.setUpdateDateTime(new Date());
		
		return po;
	}

	private LoginLogoutUser toDto(LoginLogoutUserPo po){
		if(po == null){
			return null;
		}
		LoginLogoutUser dto = new LoginLogoutUser();
		dto.setUserId(po.getUserId());
		dto.setLogout(po.isLogout());
		dto.setUpdateDateTime(po.getUpdateDateTime());
		
		return dto;
	}

	@Override
	public LoginLogoutUser fetchLoginLogoutUser(PatientIdentifier patientIdentifier) {
		LoginLogoutUser loginLogoutUser = retrieveLoginLogoutUser(patientIdentifier.toString());
		return loginLogoutUser;
	}

}
