package com.agilex.healthcare.mobilehealthplatform.auth.provider.mdws;

import java.util.Map;

import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.transport.http.Cookie;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

import com.agilex.healthcare.mobilehealthplatform.domain.MhpUser;
import com.agilex.healthcare.mobilehealthplatform.mdws.MdwsResponseException;
import com.agilex.healthcare.mobilehealthplatform.mdws.MdwsResponseException.UserMessages;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.EmrSvcSoap;
import com.agilex.healthcare.mobilehealthplatform.security.AppUser;

public class MdwsAppAuthenticatorUtil {
//	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(MdwsAppAuthenticatorUtil.class);
	
	public static MhpUser getMhpUser(){
        SecurityContext ctx = SecurityContextHolder.getContext();
        if (ctx == null)
        	throw new MdwsResponseException(MdwsResponseException.UserMessages.GENERIC_ERROR, "Unable to get Spring Context");
        if (ctx.getAuthentication() == null)
        	throw new MdwsResponseException(MdwsResponseException.UserMessages.GENERIC_ERROR, "Unable to get Spring Authentication");
        if (ctx.getAuthentication().getPrincipal() == null)
        	throw new MdwsResponseException(MdwsResponseException.UserMessages.GENERIC_ERROR, "Unable to get Spring Principal");
        if (((AppUser)ctx.getAuthentication().getPrincipal()).getMhpUser() == null)
        	throw new MdwsResponseException(MdwsResponseException.UserMessages.GENERIC_ERROR, "Unable to get Spring MhpUser");
        
        
        AppUser appUser = (AppUser) ctx.getAuthentication().getPrincipal();
        MhpUser mhpUser = appUser.getMhpUser();
        if (mhpUser == null)
			throw new MdwsResponseException(UserMessages.CONNECTION_ERROR, "mhpUser was null for getMhpUser");
		mhpUser.setUserName(appUser.getUsername());

        return mhpUser;
	}
	
	public static String getMdwsBaseUrl() {
		MhpUser mhpUser = MdwsAppAuthenticatorUtil.getMhpUser();
		if (mhpUser.getMdwsInfo() == null)
			throw new MdwsResponseException(UserMessages.CONNECTION_ERROR, "mhpUser.getMdwsInfo() was null for getMdwsBaseUrl");
		String mdwsBaseUrl = mhpUser.getMdwsInfo().getBaseUrl();
		return mdwsBaseUrl;
	}
	
//--------------------------------------BEGIN Internal Methods----------------------------------------------------------
	private static String getPortSessionIdInternal(Object o) {
		Client client = ClientProxy.getClient(o);
		HTTPConduit httpConduit = (HTTPConduit)client.getConduit();
		
		Map<String, Cookie> cookies = httpConduit.getCookies();
		String sessionId = cookies.get("ASP.NET_SessionId").getValue();
		return sessionId;
	}
	
	public static void setMdwsSessionIdInternal(Object o) {
		MhpUser mhpUser = MdwsAppAuthenticatorUtil.getMhpUser();
		if (mhpUser.getMdwsInfo() == null)
			throw new MdwsResponseException(UserMessages.CONNECTION_ERROR, "mhpUser.getMdwsInfo() was null for setMdwsSessionIdInternal");
		String sessionId = mhpUser.getMdwsInfo().getSessionId();
		MdwsAppAuthenticatorUtil.setPortSessionIdInternal(sessionId, o);
	}
	
	private static void setPortSessionIdInternal(String sessionId, Object o) {
		Client client = ClientProxy.getClient(o);

		HTTPClientPolicy policy = new HTTPClientPolicy();
		HTTPConduit httpConduit = (HTTPConduit)client.getConduit();
		
		policy.setCookie("ASP.NET_SessionId=" + sessionId);
		
		httpConduit.setClient(policy);
	}
	
//----------------------------------------END Internal Methods----------------------------------------------------------
	
//--------------------------------------BEGIN EmrSvcSoap Methods--------------------------------------------------------
	
	public static String getPortSessionId(EmrSvcSoap port) {
		return MdwsAppAuthenticatorUtil.getPortSessionIdInternal(port);
	}
	
	public static void setMdwsSessionId(EmrSvcSoap port) {
		MdwsAppAuthenticatorUtil.setMdwsSessionIdInternal(port);
	}
	
	public static void setPortSessionId(String sessionId, EmrSvcSoap port) {
		MdwsAppAuthenticatorUtil.setPortSessionIdInternal(sessionId, port);
	}
}
