package com.agilex.healthcare.mobilehealthplatform.auth.provider.mdws;

import java.util.Iterator;

import com.agilex.healthcare.mobilehealthplatform.domain.MdwsKey;
import com.agilex.healthcare.mobilehealthplatform.domain.MdwsKeys;
import com.agilex.healthcare.mobilehealthplatform.domain.MhpUser;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.mdws.MdwsInfo;
import com.agilex.healthcare.mobilehealthplatform.mdws.MdwsResponseException;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.UserSecurityKeyArray;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.UserSecurityKeyTO;
import com.agilex.healthcare.utility.NullChecker;

public class MdwsAppAuthenticatorMhpUserUtil {
	public static void updateMhpUser(MhpUser mhpUser, com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.UserTO mdwsUser,
			String sessionId, String baseMdwsUrl, MdwsKeys mdwsKeys) {
		
		updateMhpUserBio(mhpUser, mdwsUser);
		
		updateMhpInfo(mhpUser, sessionId, baseMdwsUrl, mdwsKeys);
	}

	private static void updateMhpUserBio(MhpUser mhpUser, com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.UserTO mdwsUser) {
		if (NullChecker.isNullish(mhpUser.getDisplayName()))
			mhpUser.setDisplayName(mdwsUser.getName());
		if (mhpUser.getUserIdentifier() == null)
			mhpUser.setUserIdentifier(new PatientIdentifier("default", mdwsUser.getDUZ()));
		if (NullChecker.isNullish(mhpUser.getUserIdentifier().getAssigningAuthority()))
			mhpUser.getUserIdentifier().setAssigningAuthority("default");
		if (NullChecker.isNullish(mhpUser.getUserIdentifier().getUniqueId()))
			mhpUser.getUserIdentifier().setUniqueId(mdwsUser.getDUZ());
		if (NullChecker.isNullish(mhpUser.getTitle()))
			mhpUser.setTitle(mdwsUser.getTitle());
		if (NullChecker.isNullish(mhpUser.getFirstName()))
			parseAndSetNames(mhpUser, mdwsUser);
	}
	
	public static void updateMhpInfo(MhpUser mhpUser, String sessionId, String baseUrl, MdwsKeys keys) {
		String userId = mhpUser.getUserIdentifier().toString();
		String username = mhpUser.getAccessCode();
		
		MdwsInfo mdwsInfo = new MdwsInfo();
		mdwsInfo.setUserId(userId);
		mdwsInfo.setUsername(username);
		mdwsInfo.setBaseUrl(baseUrl);
		mdwsInfo.setSessionId(sessionId);
		mdwsInfo.setKeys(keys);
		
		mhpUser.setMdwsInfo(mdwsInfo);
	}
	
	private static void parseAndSetNames(MhpUser mhpUser, com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.UserTO mdwsUser) {
		// Assuming "LAST,FIRST MIDDLE" Syntax
		String name = mdwsUser.getName();
		if (NullChecker.isNullish(mhpUser.getAccessCode()))
			mhpUser.setAccessCode(mdwsUser.getUsername());
		if (NullChecker.isNotNullish(name)) {
			String[] splitNames = name.trim().split(",");
			if (NullChecker.isNullish(mhpUser.getLastName()))
				mhpUser.setLastName(splitNames[0]);
			String[] firstAndMiddle = splitNames[1].toString().trim().split(" ");
			switch (firstAndMiddle.length) {
                case 1:
                	if (NullChecker.isNullish(mhpUser.getFirstName()))
                		mhpUser.setFirstName(firstAndMiddle[0]);
                    break;
                case 2:
                	if (NullChecker.isNullish(mhpUser.getFirstName()))
                		mhpUser.setFirstName(firstAndMiddle[0]);
                	if (NullChecker.isNullish(mhpUser.getMiddleInitials()))
                		mhpUser.setMiddleInitials(firstAndMiddle[1]);
                    break;
                default:
                	if (NullChecker.isNullish(mhpUser.getFirstName()))
                		mhpUser.setFirstName(firstAndMiddle[0]);
            }
		}
	}
	
	public static MdwsKeys getMdwsKeys(UserSecurityKeyArray mdwsKeys) {
		MdwsKeys keys = new MdwsKeys();
		
		if (mdwsKeys == null)
			return keys;
		if (mdwsKeys.getFault() != null)
			throw new MdwsResponseException(MdwsResponseException.UserMessages.CONNECTION_ERROR, mdwsKeys.getFault());
		if (mdwsKeys.getKeys() == null)
			return keys;
		if (mdwsKeys.getKeys().getUserSecurityKeyTO() == null)
			return keys;
		
		Iterator<UserSecurityKeyTO> it = mdwsKeys.getKeys().getUserSecurityKeyTO().iterator();
		
		while (it.hasNext()) {
			UserSecurityKeyTO mdwsKey = it.next();
			if (mdwsKey.getFault() != null)
				throw new MdwsResponseException(MdwsResponseException.UserMessages.CONNECTION_ERROR, mdwsKey.getFault());
			
			String id = mdwsKey.getId();
			String name = mdwsKey.getName();
			
			MdwsKey key = new MdwsKey();
			key.setId(id);
			key.setName(name);
			keys.add(key);
		}
		
		return keys;
	}
}
